/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.table;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.AbstractCollectionFactoryImpl;
import com.streamscape.ds.schema.collection.tspace.table.TableColumn;
import com.streamscape.ds.schema.collection.tspace.table.TableFactory;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import java.util.ArrayList;
import java.util.List;

public class TableFactoryImpl
extends AbstractCollectionFactoryImpl {
    protected List<String> primaryKeys = new ArrayList<String>();
    protected List<TableColumn> columns = new ArrayList<TableColumn>();

    public TableFactoryImpl() {
        super(CollectionType.TABLE);
    }

    protected TableFactoryImpl(CollectionType type) {
        super(type);
    }

    public void setColumns(Session session, List<TableColumn> columns) {
        this.columns.clear();
        this.primaryKeys.clear();
        for (TableColumn column : columns) {
            this.addColumn(session, column);
        }
    }

    public void addColumn(Session session, TableColumn column) {
        if (this.containsColumn(session, column.getName())) {
            throw new DataspaceException("Column with name '" + column.getName() + "' already exists.");
        }
        this.columns.add(column);
    }

    public boolean containsColumn(Session session, String name) {
        for (TableColumn column : this.columns) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public TableColumn lookupColumn(Session session, String columnName) {
        for (TableColumn column : this.columns) {
            if (!column.getName().equalsIgnoreCase(columnName)) continue;
            return column;
        }
        return null;
    }

    public List<String> listColumns(Session session) {
        ArrayList<String> names = new ArrayList<String>();
        for (TableColumn column : this.columns) {
            names.add(column.getName());
        }
        return names;
    }

    public List<TableColumn> getColumns(Session session) {
        return this.columns;
    }

    public void setPrimaryKeyColumns(Session session, List<String> columns) {
        for (String name : columns) {
            TableColumn column = this.lookupColumn(session, name);
            if (column != null) continue;
            throw new DataspaceException("Column " + String.valueOf(column) + " doesn't exist.");
        }
        this.primaryKeys.addAll(columns);
    }

    public List<String> getPrimaryKeyColumns(Session session) {
        return this.primaryKeys;
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new TableFactory();
    }

    @Override
    public String getCreateSql(Session session, String name) {
        for (TableColumn column : this.columns) {
            if (column.getSemanticTypeName() == null || DataspaceManager.getContext().getSemanticTypeFactory().existsSemanticType(column.getSemanticTypeName())) continue;
            throw new DataspaceException("Semantic type " + column.getSemanticTypeName() + " doesn't exist.");
        }
        StringBuilder SQL = new StringBuilder();
        SQL.append("create ");
        if (this.collectionType == CollectionType.FILE_TABLE) {
            SQL.append(" file");
        } else if (this.collectionType == CollectionType.JOURNAL_FILE_TABLE) {
            SQL.append(" journal file");
        } else {
            SQL.append(this.getMemoryModel(session).name());
        }
        SQL.append(" table ").append(name).append(" (\n");
        for (TableColumn column : this.columns) {
            SQL.append(column.getName()).append(" ");
            if (column.getType() == SQLType.OTHER) {
                String semanticType = column.getSemanticTypeName();
                if (semanticType != null) {
                    SQL.append(semanticType);
                } else {
                    SQL.append(" other ");
                }
            } else if (column.getType() == SQLType.ARRAY) {
                if (column.getArrayType() == null) {
                    SQL.append(" object ");
                } else {
                    SQL.append(column.getArrayType().getTypeName());
                }
                SQL.append(" array ");
                if (column.getLength() != 0) {
                    SQL.append("[").append(column.getLength()).append("]");
                }
            } else if (column.getType() == SQLType.SQLTIME) {
                SQL.append(" sqltime ");
            } else if (column.getType() == SQLType.SQLDATE) {
                SQL.append(" sqldate ");
            } else if (column.getType() == SQLType.SQLTIMESTAMP) {
                SQL.append(" sqltimestamp ");
            } else if (column.getType() != null) {
                SQL.append(column.getType().getTypeName());
                if (column.getPrecision() != 0) {
                    SQL.append("(").append(column.getPrecision());
                    if (column.getScale() != 0) {
                        SQL.append(",").append(column.getScale());
                    }
                    SQL.append(")");
                }
            } else {
                SQL.append(column.getSqlTypeString());
            }
            if (!column.isNullable()) {
                SQL.append(" not  null");
            }
            SQL.append(",\n");
        }
        if (this.primaryKeys.size() > 0) {
            SQL.append("primary key(");
            for (String key : this.primaryKeys) {
                SQL.append(key).append(", ");
            }
            SQL.setLength(SQL.length() - 2);
            SQL.append(")");
        } else if (this.columns.size() > 0) {
            SQL.setLength(SQL.length() - 2);
        }
        SQL.append(")");
        return SQL.toString();
    }
}

