/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.table;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.AbstractCollectionFactory;
import com.streamscape.ds.schema.collection.tspace.table.TableColumn;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TableFactory
extends AbstractCollectionFactory {
    public void initFromResultSet(ResultSet resultSet) {
        try {
            if (resultSet instanceof RowSet) {
                this.initFromRowSet((RowSet)resultSet);
                return;
            }
            ResultSetMetaData metaData = resultSet.getMetaData();
            if (metaData == null) {
                throw new DataspaceException("Result set meta data is null.");
            }
            ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                TableColumn column = new TableColumn(metaData.getColumnName(i), SQLType.typeForId(metaData.getColumnType(i), metaData.getColumnTypeName(i), metaData.getColumnClassName(i)));
                column.setNullable(metaData.isNullable(i) == 1);
                SQLTypeToken typeToken = SQLTypeToken.getTypeById(column.getType().getType());
                if (typeToken != null && typeToken.allowPrecision()) {
                    column.setPrecision(metaData.getPrecision(i));
                    column.setScale(metaData.getScale(i));
                } else if (typeToken.allowLength() && metaData.getPrecision(i) != 0) {
                    column.setLength(metaData.getPrecision(i));
                }
                columns.add(column);
            }
            this.setColumns(columns);
        }
        catch (SQLException error) {
            throw new DataspaceException(error, error.getMessage(), "00000", 458);
        }
    }

    public void initFromRowSet(RowSet rowSet) {
        try {
            RowMetaData metaData = rowSet.getMeta();
            if (metaData == null) {
                throw new DataspaceException("Row set meta data is null.");
            }
            ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                TableColumn column = new TableColumn(metaData.getColumnName(i), SQLType.typeForId(metaData.getColumnSQLType(i)));
                columns.add(column);
            }
            this.setColumns(columns);
        }
        catch (MetaDataException error) {
            throw new DataspaceException(error, error.getMessage(), "00000", 458);
        }
    }

    public void setColumns(List<TableColumn> columns) {
        this.invokeCollectionsMethod("setColumns", columns);
    }

    public void addColumns(List<TableColumn> columns) {
        this.invokeCollectionsMethod("addColumns", columns);
    }

    public void addColumn(TableColumn column) {
        this.invokeCollectionsMethod("addColumn", column);
    }

    public TableColumn lookupColumn(String columnName) {
        return this.invokeCollectionsMethodWithReturn("lookupColumn", TableColumn.class, columnName);
    }

    public boolean containsColumn(String columnName) {
        return this.invokeCollectionsMethodWithReturn("containsColumn", Boolean.class, columnName);
    }

    public List<String> listColumns() {
        return this.invokeCollectionsMethodWithReturn("listColumns", List.class, new Object[0]);
    }

    public List<TableColumn> getColumns() {
        return this.invokeCollectionsMethodWithReturn("getColumns", List.class, new Object[0]);
    }

    public void setPrimaryKeyColumns(String ... columns) {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (String column : columns) {
            primaryKeys.add(column);
        }
        this.setPrimaryKeyColumns(primaryKeys);
    }

    public void setPrimaryKeyColumns(List<String> columns) {
        if (columns != null && !(columns instanceof ArrayList)) {
            columns = new ArrayList<String>(columns);
        }
        this.invokeCollectionsMethod("setPrimaryKeyColumns", columns);
    }

    public List<String> getPrimaryKeyColumns() {
        return this.invokeCollectionsMethodWithReturn("getPrimaryKeyColumns", List.class, new Object[0]);
    }
}

