/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.table;

import com.streamscape.ds.DataspaceException;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.sql.enums.SQLTypeToken;

public class TableColumn {
    private String name;
    private SQLType type;
    private String sqlTypeString;
    private String semanticTypeName;
    private SQLType arrayType;
    private boolean isNullable;
    private int precision = 0;
    private int scale = 0;

    public TableColumn(String name, SQLType type) {
        this.name = name;
        this.type = type;
    }

    public TableColumn(String name, SQLType type, String semanticTypeName) {
        this(name, type);
        this.setSemanticTypeName(semanticTypeName);
    }

    public TableColumn(String name, SQLType type, SQLType arrayType) {
        this(name, type);
        this.setArrayType(arrayType);
    }

    public TableColumn(String name, SQLType type, SQLType arrayType, int length) {
        this(name, type);
        this.setLength(length);
        this.setArrayType(arrayType);
    }

    public TableColumn(String name, SQLType type, boolean isNullable) {
        this(name, type);
        this.setNullable(isNullable);
    }

    public TableColumn(String name, SQLType type, int length) {
        this(name, type);
        this.setLength(length);
    }

    public TableColumn(String name, SQLType type, int length, boolean isNullable) {
        this(name, type, length);
        this.setNullable(isNullable);
    }

    public TableColumn(String name, SQLType type, int precision, int scale) {
        this(name, type);
        this.setPrecision(precision);
        this.setScale(scale);
    }

    public TableColumn(String name, SQLType type, int precision, int scale, boolean isNullable) {
        this(name, type, precision, scale);
        this.setNullable(isNullable);
    }

    public TableColumn(String name, String sqlTypeString) {
        this.name = name;
        this.sqlTypeString = sqlTypeString;
    }

    public String getName() {
        return this.name;
    }

    public SQLType getType() {
        return this.type;
    }

    public String getSqlTypeString() {
        return this.sqlTypeString;
    }

    public String getSemanticTypeName() {
        return this.semanticTypeName;
    }

    public void setSemanticTypeName(String semanticTypeName) throws DataspaceException {
        this.checkSqlTypeStringNotSet();
        if (this.type != SQLType.OTHER) {
            throw new DataspaceException("Semantic type can be set for OTHER type only, and not for " + String.valueOf((Object)this.type));
        }
        this.semanticTypeName = semanticTypeName;
    }

    public SQLType getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(SQLType arrayType) {
        this.checkSqlTypeStringNotSet();
        if (this.type != SQLType.ARRAY) {
            throw new DataspaceException("Array type can be set for ARRAY type only, and not for " + String.valueOf((Object)this.type));
        }
        this.arrayType = arrayType;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public int getLength() {
        return this.precision;
    }

    public void setLength(int length) {
        this.checkSqlTypeStringNotSet();
        SQLTypeToken typeToken = SQLTypeToken.getTypeById(this.type.getType());
        if (typeToken == null || !typeToken.allowLength() || this.type == SQLType.STRING || this.type == SQLType.CATEGORY) {
            throw new DataspaceException("Length is not allowed for " + String.valueOf((Object)this.type) + " type.");
        }
        this.precision = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.checkSqlTypeStringNotSet();
        SQLTypeToken typeToken = SQLTypeToken.getTypeById(this.type.getType());
        if (typeToken == null || !typeToken.allowPrecision()) {
            throw new DataspaceException("Precision is not allowed for " + String.valueOf((Object)this.type) + " type.");
        }
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.checkSqlTypeStringNotSet();
        SQLTypeToken typeToken = SQLTypeToken.getTypeById(this.type.getType());
        if (typeToken == null || !typeToken.allowScale()) {
            throw new DataspaceException("Scale is not allowed for " + String.valueOf((Object)this.type) + " type.");
        }
        this.scale = scale;
    }

    private void checkSqlTypeStringNotSet() {
        if (this.sqlTypeString != null) {
            throw new DataspaceException("Failed to set properties when sql type string specified.");
        }
    }
}

