/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.table;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.collection.qspace.AbstractQueueCollection;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueCollection;
import com.streamscape.ds.schema.collection.tspace.map.MapCollection;
import com.streamscape.ds.schema.collection.tspace.table.TableProxy;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.ds.utils.RowSetFactoryForDSResult;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.sdo.rowset.DataRow;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.service.osf.config.ActiveEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class TableCollection
extends AbstractCollection
implements AccessibleObject {
    protected String[] columnNames = null;
    protected Statement insertStat = null;

    protected TableCollection(DataspaceStore database, NameManager.ObjectName name, CollectionType collectionType, MemoryModel memoryModel, int tableType) {
        super(database, name, collectionType, memoryModel);
        NameManager.ObjectName tableName = database.nameManager.newObjectName(name.name, name.isNameQuoted, 3);
        tableName.schema = name.schema;
        this.doCreateTable(database, tableName, tableType);
    }

    protected TableCollection(DataspaceStore database, NameManager.ObjectName name, CollectionType collectionType, MemoryModel memoryModel) {
        this(database, name, collectionType, memoryModel, memoryModel == MemoryModel.PERSISTENT ? 6 : (memoryModel == MemoryModel.LOGGED ? 5 : 4));
    }

    public TableCollection(DataspaceStore database, NameManager.ObjectName name, MemoryModel memoryModel, int tableType) {
        this(database, name, CollectionType.TABLE, memoryModel, tableType);
    }

    public TableCollection(DataspaceStore database, NameManager.ObjectName name, MemoryModel memoryModel) {
        this(database, name, CollectionType.TABLE, memoryModel);
    }

    protected void doCreateTable(DataspaceStore database, NameManager.ObjectName tableName, int tableType) {
        this.table = new Table(database, tableName, tableType);
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        this.table.compile(session, parentObject);
        this.compileColumnNames();
    }

    public void compileColumnNames() {
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            ColumnSchema column = this.table.getColumn(i);
            if (column.isGenerated() || column.isIdentity()) continue;
            temp.add(column.getObjectName().getStatementName());
        }
        String[] values = new String[temp.size()];
        this.columnNames = temp.toArray(values);
    }

    @Override
    public void compileInternalStatements(Session session) {
        this.compileInsertStatement(session);
    }

    private void compileInsertStatement(Session session) {
        String columnNames = this.getColumnNamesAsOneString();
        String columnParameters = this.getColumnParameters();
        if (columnNames.length() == 0 || columnParameters.length() == 0 || this instanceof FileTableCollection && (((FileTableCollection)this).getFileTable().getDataSource() == null || ((FileTableCollection)this).getFileTable().getDataSource().length() == 0)) {
            return;
        }
        String SQL = null;
        SQL = "insert into " + this.name.getSchemaQualifiedStatementName() + "(" + columnNames + ")values (" + columnParameters + ")";
        this.insertStat = session.compileStatement(SQL);
    }

    private String getColumnNamesAsOneString() {
        boolean first = true;
        StringBuilder buffer = new StringBuilder();
        for (String columnName : this.columnNames) {
            if (!first) {
                buffer.append(',');
            } else {
                first = false;
            }
            if (!columnName.startsWith("[") && !columnName.startsWith("\"")) {
                buffer.append('[').append(columnName).append(']');
                continue;
            }
            buffer.append(columnName);
        }
        return buffer.toString();
    }

    private String getColumnParameters() {
        boolean first = true;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (!first) {
                buffer.append(',');
            } else {
                first = false;
            }
            buffer.append("?");
        }
        return buffer.toString();
    }

    protected String[] setToArray(OrderedHashSet set) {
        String[] result = new String[set.size()];
        com.streamscape.ds.lib.Iterator iter = set.iterator();
        int index = -1;
        while (iter.hasNext()) {
            result[++index] = ((NameManager.ObjectName)iter.next()).name;
        }
        return result;
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new TableProxy();
    }

    @Override
    public String getSQL() {
        return this.table.getSQL();
    }

    @Override
    public String getSQL(String name, boolean forReplication) {
        return this.table.getSQL(name);
    }

    @Override
    public String getSQLForReplication(String replicaName) {
        return this.table.getSQL(replicaName);
    }

    public void clear(Session session) {
        this.clear(session, false);
    }

    public void clear(Session session, Boolean force) {
        Result result = session.executeDirectStatement("truncate table " + this.name.getStatementName());
        TableCollection.checkResultNotError(result);
    }

    public void deleteAll(Session session) {
        Result result = session.executeDirectStatement("delete from " + this.name.getStatementName());
        TableCollection.checkResultNotError(result);
    }

    public boolean containsPrimarykey(Session session, String key) {
        int[] primaryKeyColumns;
        int columnIndex = this.table.findColumn(key);
        if (columnIndex == -1) {
            return false;
        }
        for (int keyIndex : primaryKeyColumns = this.table.getPrimaryKey()) {
            if (keyIndex != columnIndex) continue;
            return true;
        }
        return false;
    }

    public void delete(Session session, String selector) {
        Result result = session.executeDirectStatement("delete from " + this.name.getStatementName() + " where " + selector);
        TableCollection.checkResultNotError(result);
    }

    public void delete(Session session, int rowId) {
        throw new UnsupportedOperationException("Feature has not yet implemented.");
    }

    public com.streamscape.sdo.rowset.Row getRow(Session session, String rowId) {
        throw new UnsupportedOperationException("Feature has not yet implemented.");
    }

    public boolean hasForeignKey(Session session) {
        return this.table.hasForeignKey();
    }

    public boolean hasPrimaryKey(Session session) {
        return this.table.hasPrimaryKey();
    }

    public void insert(Session session, Object[] rowData) {
        if (rowData == null) {
            throw new DataspaceException("Provided row data is NULL.");
        }
        if (rowData.length != this.columnNames.length) {
            throw new DataspaceException("Provided row does not match columns count.");
        }
        if (this.insertStat == null) {
            this.compileInsertStatement(session);
        }
        rowData = SqlUtils.prepareDataForInsert(session, this.insertStat, rowData);
        Result result = session.executeCompiledStatement(this.insertStat, rowData);
        TableCollection.checkResultNotError(result);
    }

    public void insert(Session session, com.streamscape.sdo.rowset.Row row) {
        if (row == null) {
            throw new DataspaceException("Provided row is NULL.");
        }
        if (row.getMeta().getColumnCount() != this.columnNames.length) {
            throw new DataspaceException("Provided row does not match columns count.");
        }
        Object[] rowData = new Object[this.columnNames.length];
        int index = -1;
        for (String columnName : this.columnNames) {
            try {
                rowData[++index] = row.getColumn(columnName);
            }
            catch (RowException error) {
                throw new DataspaceException("Unable to set " + index + " column. " + error.getMessage());
            }
        }
        if (this.insertStat == null) {
            this.compileInsertStatement(session);
        }
        rowData = SqlUtils.prepareDataForInsert(session, this.insertStat, rowData);
        Result result = session.executeCompiledStatement(this.insertStat, rowData);
        TableCollection.checkResultNotError(result);
    }

    public void insert(Session session, RowArray rowArray) {
        try {
            if (rowArray.getMeta().getColumnCount() != this.columnNames.length) {
                throw new DataspaceException("Provided row does not match columns count.");
            }
            Iterator<DataRow> rows = rowArray.iteratorByEntry();
            while (rows.hasNext()) {
                DataRow row = rows.next();
                Object[] data = new Object[this.columnNames.length];
                for (int i = 0; i < this.columnNames.length; ++i) {
                    data[i] = row.getColumn(i + 1);
                }
                if (this.insertStat == null) {
                    this.compileInsertStatement(session);
                }
                data = SqlUtils.prepareDataForInsert(session, this.insertStat, data);
                Result result = session.executeCompiledStatement(this.insertStat, data);
                TableCollection.checkResultNotError(result);
            }
        }
        catch (Exception error) {
            throw new DataspaceException("Unable to insert data from RowArray. " + error.getMessage());
        }
    }

    public void insert(Session session, RowSet rowSet) {
        try {
            if (rowSet.getRowMetaData().getColumnCount() != this.columnNames.length) {
                throw new DataspaceException("Provided row does not match columns count.");
            }
            rowSet.beforeFirst();
            while (rowSet.next()) {
                Object[] data = new Object[this.columnNames.length];
                for (int i = 0; i < this.columnNames.length; ++i) {
                    data[i] = rowSet.getObject(i + 1);
                }
                if (this.insertStat == null) {
                    this.compileInsertStatement(session);
                }
                data = SqlUtils.prepareDataForInsert(session, this.insertStat, data);
                Result result = session.executeCompiledStatement(this.insertStat, data);
                TableCollection.checkResultNotError(result);
            }
        }
        catch (Exception error) {
            throw new DataspaceException("Unable to insert data from RowArray. " + error.getMessage());
        }
    }

    public void insertAll(Session session, TableCollection table) {
        try {
            this.insertAll(session, "select * from " + table.getObjectName().getSchemaQualifiedStatementName());
        }
        catch (DataspaceException error) {
            throw new DataspaceException("Unable to insert data from '" + table.getObjectName().getStatementName() + "' table.");
        }
    }

    public void insertAll(Session session, String select) {
        Result result = session.executeDirectStatement("insert into " + this.name.getStatementName() + " (" + select + ")");
        TableCollection.checkResultNotError(result);
    }

    public boolean isEmpty(Session session) {
        return this.size(session) == 0L;
    }

    public Set<String> primaryKeySet(Session session) {
        int[] primaryKeyColumns;
        HashSet<String> result = new HashSet<String>();
        for (int keyIndex : primaryKeyColumns = this.table.getPrimaryKey()) {
            ColumnSchema column = this.table.getColumn(keyIndex);
            result.add(column.getNameString());
        }
        return result;
    }

    public RowSet rowSet(Session session) {
        return this.select(session, null);
    }

    public RowSet select(Session session, String whereClause) {
        String operation = "select * from " + this.name.getStatementName() + (String)(whereClause == null || whereClause.length() == 0 ? "" : " where " + whereClause);
        Result result = session.executeDirectStatement(operation);
        TableCollection.checkResultNotError(result);
        if (!result.isError() && result.isData()) {
            List<RowSet> results = ((RowSetFactoryForDSResult)new RowSetFactoryForDSResult().setWithBlobs(true)).createRowSets(session, result);
            if (results.size() != 1) {
                return null;
            }
            return results.get(0);
        }
        return null;
    }

    public long size(Session session) {
        Result result = session.executeDirectStatement("select count(*) from " + this.name.getStatementName());
        if (!result.isError() && result.isData()) {
            if (result.navigator.first()) {
                Long size = (Long)result.navigator.getCurrent(0);
                return size;
            }
            throw new DataspaceException("Unable to retrive table size.");
        }
        throw result.getException();
    }

    public void update(Session session, int rowId, com.streamscape.sdo.rowset.Row row) {
        throw new UnsupportedOperationException("Feature has not yet implemented.");
    }

    public void update(Session session, String rowId, Object[] rowData) {
        throw new UnsupportedOperationException("Feature has not yet implemented.");
    }

    public void update(Session session, String selector, com.streamscape.sdo.rowset.Row row) {
        try {
            Object[] rowData = new Object[row.getColumnCount()];
            StringBuilder buffer = new StringBuilder();
            int index = -1;
            boolean first = true;
            for (String columnName : row.getMeta().getColumnNames()) {
                try {
                    if (!first) {
                        buffer.append(',');
                    } else {
                        first = false;
                    }
                    buffer.append(columnName).append(" = ?");
                    rowData[++index] = row.getColumn(columnName);
                }
                catch (RowException error) {
                    throw new DataspaceException("Unable to set " + index + " column. " + error.getMessage());
                }
            }
            Statement stat = session.compileStatement("update " + this.name.getStatementName() + " set " + buffer.toString() + " where " + selector);
            rowData = SqlUtils.prepareDataForInsert(session, stat, rowData);
            Result result = session.executeCompiledStatement(stat, rowData);
            TableCollection.checkResultNotError(result);
        }
        catch (RowException error) {
            throw new DataspaceException(error);
        }
    }

    public void upsert(Session session, com.streamscape.sdo.rowset.Row row) {
        try {
            if (row.getColumnCount() != this.table.getColumnCount()) {
                throw new DataspaceException("Invalid values count provided, table has " + this.table.getColumnCount() + ", but provided " + row.getColumnCount() + " values.");
            }
            Object[] rowData = new Object[row.getColumnCount()];
            RowMetaData rowMetaData = row.getMeta();
            for (int i = 1; i <= row.getColumnCount(); ++i) {
                String columnName = rowMetaData.getColumnName(i);
                int index = this.table.getColumnIndex(columnName);
                rowData[index] = row.getColumn(i);
            }
            this.upsert(session, rowData);
        }
        catch (RowException error) {
            throw new DataspaceException(error);
        }
        catch (MetaDataException error) {
            throw new DataspaceException(error);
        }
    }

    public void upsert(Session session, Object[] rowData) {
        Object[] primaryKeyValues;
        int i;
        int[] primaryKeyColumns;
        if (rowData.length != this.table.getColumnCount()) {
            throw new DataspaceException("Invalid values count provided, table has " + this.table.getColumnCount() + ", but provided " + rowData.length + " values.");
        }
        StringBuilder whereSqlBuilder = new StringBuilder();
        if (!this.table.hasPrimaryKey()) {
            primaryKeyColumns = new int[this.table.getColumnCount()];
            for (i = 0; i < primaryKeyColumns.length; ++i) {
                primaryKeyColumns[i] = i;
            }
            primaryKeyValues = rowData;
        } else {
            primaryKeyColumns = this.table.getPrimaryKey();
            primaryKeyValues = new Object[primaryKeyColumns.length];
        }
        for (i = 0; i < primaryKeyColumns.length; ++i) {
            if (i > 0) {
                whereSqlBuilder.append(" AND ");
            }
            whereSqlBuilder.append(this.table.getColumn(primaryKeyColumns[i]).getNameString()).append(" = ?");
            primaryKeyValues[i] = rowData[primaryKeyColumns[i]];
        }
        Statement stat = session.compileStatement("SELECT TRUE FROM " + this.name.getStatementName() + " WHERE " + whereSqlBuilder.toString());
        primaryKeyValues = SqlUtils.prepareDataForInsert(session, stat, primaryKeyValues);
        Result result = session.executeCompiledStatement(stat, primaryKeyValues);
        TableCollection.checkResultNotError(result);
        TableCollection.checkResultIsData(result);
        if (result.isData() && result.getNavigator().next()) {
            if (this.table.hasPrimaryKey() && primaryKeyColumns.length < this.table.getColumnCount()) {
                StringBuilder setSqlBuilder = new StringBuilder();
                Object[] setValues = new Object[rowData.length];
                int setValuesIndex = 0;
                for (int i2 = 0; i2 < rowData.length; ++i2) {
                    if (this.contains(primaryKeyColumns, i2)) continue;
                    if (setSqlBuilder.length() > 0) {
                        setSqlBuilder.append(", ");
                    }
                    setSqlBuilder.append(this.table.getColumn(i2).getNameString()).append(" = ").append("?");
                    setValues[setValuesIndex++] = rowData[i2];
                }
                for (int i3 : primaryKeyColumns) {
                    setValues[setValuesIndex++] = rowData[i3];
                }
                stat = session.compileStatement("UPDATE " + this.name.getStatementName() + " SET " + setSqlBuilder.toString() + " WHERE " + whereSqlBuilder.toString());
                setValues = SqlUtils.prepareDataForInsert(session, stat, setValues);
                result = session.executeCompiledStatement(stat, setValues);
                TableCollection.checkResultNotError(result);
            }
        } else {
            this.insert(session, rowData);
        }
    }

    private boolean contains(int[] array, int key) {
        for (int i : array) {
            if (i != key) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ActiveEvent> getEvents() {
        List<ActiveEvent> result = super.getEvents();
        return result;
    }

    protected void addActionableEvent(String eventId, List<ActiveEvent> events) {
        ActiveEvent event = new ActiveEvent(eventId);
        event.setType(ActiveEvent.ActiveEventType.Actionable);
        event.setEventScope(EventScope.LOCAL);
        event.setEventModel(SqlUtils.resolveEventModel(this.runtimeCtx, eventId));
        events.add(event);
    }

    public RowSet toRowSet(Session session) {
        RowMetaData meta = SqlUtils.getCollectionMeta(this);
        RowSet rowSet = new RowSet(meta);
        Type[] columnTypes = this.table.colTypes;
        int columnCount = this.table.getColumnCount();
        RowIterator it = this.table.rowIteratorClustered(session);
        try {
            while (it.hasNext()) {
                Object[] data = new Object[columnCount];
                Row row = it.getNextRow();
                Object[] currentData = row.getData();
                for (int i = 0; i < columnCount; ++i) {
                    if (columnTypes[i].isLobType()) {
                        if (!(currentData[i] instanceof BlobDataID)) continue;
                        try {
                            data[i] = SqlUtils.extractBlob(session, (BlobDataID)currentData[i]);
                        }
                        catch (Exception error) {
                            Trace.logError(this, "Unable to extract LOB object. " + error.getMessage());
                        }
                        continue;
                    }
                    data[i] = columnTypes[i].convertSQLToJava(session, currentData[i]);
                }
                rowSet.addToRowSet(data);
            }
        }
        catch (SQLException error) {
            throw new DataspaceException("Unable to convert collection to RowSet. " + error.getMessage());
        }
        finally {
            if (it != null) {
                it.release();
            }
        }
        return rowSet;
    }

    public void fromRowSet(Session session, RowSet rowSet) {
        try {
            rowSet.beforeFirst();
        }
        catch (Exception error) {
            throw new DataspaceException("Unable to scroll to the begining of rowset.");
        }
        if (rowSet.getMeta().getColumnCount() != this.table.getColumnCount()) {
            Trace.logError(this, "Number of columns in rowset " + rowSet.getMeta().getColumnCount() + " does not match number of columns " + this.table.getColumnCount() + " in transient table.");
            return;
        }
        Type[] rowSetTypes = new Type[rowSet.getMeta().getColumnCount()];
        for (int i = 0; i < rowSet.getMeta().getColumnCount(); ++i) {
            String columnName = null;
            try {
                columnName = rowSet.getMeta().getColumnName(i + 1);
                rowSetTypes[i] = Types.getParameterSQLType(session, rowSet.getMeta().getColumnTypeClass(i + 1));
            }
            catch (Exception error) {
                throw new DataspaceException("Unable to resolve data type for rowset column " + String.valueOf(columnName == null ? Integer.valueOf(i) : columnName) + ".");
            }
            if (rowSetTypes[i] != null) continue;
            throw new DataspaceException("Unable to resolve data type for rowset column " + String.valueOf(columnName == null ? Integer.valueOf(i) : columnName) + ".");
        }
        PersistentStore store = this.table.getRowStore(session);
        Type[] tableTypes = this.table.getColumnTypes();
        try {
            while (rowSet.next()) {
                Object[] rowData = SqlUtils.getDataForInsert(session, this.table, rowSet.getCurrentRow().getRawData(), tableTypes, rowSetTypes);
                this.table.insertSingleRow(session, store, rowData, null);
            }
        }
        catch (SQLException error) {
            Trace.logError(this, "Unable to load data from rowset into transient table. " + error.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<?> toQueue(Session session) {
        LinkedList<Object> queue;
        block11: {
            queue = new LinkedList<Object>();
            RowIterator it = null;
            int columnCount = this.table.getColumnCount();
            Type[] columnTypes = this.table.colTypes;
            Object[] data = null;
            try {
                it = this.table.rowIteratorClustered(session);
                if (columnCount == 1) {
                    try {
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                            queue.add(data[0]);
                        }
                        break block11;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Queue. " + error.getMessage());
                    }
                }
                RowMetaData meta = SqlUtils.getCollectionMeta(this);
                try {
                    while (it.hasNext()) {
                        com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                        Row row = it.getNextRow();
                        data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                        newRow.setRawData(data);
                        queue.add(newRow);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to convert collection to Queue. " + error.getMessage());
                }
            }
            finally {
                if (it != null) {
                    it.release();
                    it = null;
                }
            }
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromQueue(Session session, Queue<?> queue) {
        if (this.table.getColumnCount() > 2) {
            Trace.logError(this, "Table could not be loaded from queue. Number of columns mismatch (one or two columns expected).");
            throw new DataspaceException("Number of columns mismatch. One or two columns expected.");
        }
        if (queue instanceof AbstractQueueCollection) {
            Table table = ((AbstractQueueCollection)((Object)queue)).getBaseTable();
            PersistentStore tableStore = this.table.getRowStore(session);
            RowIterator iter = table.rowIteratorClustered(session);
            try {
                while (iter.hasNext()) {
                    Object[] data = iter.getNext();
                    this.table.insertSingleRow(session, tableStore, data, null);
                }
            }
            finally {
                if (iter != null) {
                    iter.release();
                    iter = null;
                }
            }
        } else {
            int columnCount = this.table.getColumnCount();
            Type[] queueTypes = new Type[columnCount];
            Class<?> elemClass = null;
            PersistentStore store = this.table.getRowStore(session);
            Type[] tableTypes = this.table.getColumnTypes();
            if (columnCount == 2) {
                queueTypes[0] = tableTypes[0];
            }
            int elemIndex = columnCount - 1;
            for (Object element : queue) {
                if (queueTypes[elemIndex] == null || element.getClass() != elemClass) {
                    queueTypes[elemIndex] = this.resolveType(session, element);
                    elemClass = element.getClass();
                }
                Object[] rowData = new Object[columnCount];
                rowData[elemIndex] = element;
                rowData = SqlUtils.getDataForInsert(session, this.table, rowData, tableTypes, queueTypes);
                this.table.insertSingleRow(session, store, rowData, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainFromQueue(Session session, Queue<?> queue) {
        this.fromQueue(session, queue);
        if (queue instanceof AbstractQueueCollection) {
            AbstractQueueCollection queueCollection = (AbstractQueueCollection)((Object)queue);
            PersistentStore store = queueCollection.getBaseTable().getRowStore(session);
            RowIterator it = queueCollection.getBaseTable().getPrimaryIndex().firstRow(store);
            try {
                while (it.hasNext()) {
                    Row row = it.getNextRow();
                    session.addDeleteAction((Table)row.getTable(), row, null);
                }
            }
            finally {
                it.release();
            }
        } else {
            queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<?, ?> toMap(Session session) {
        HashMap<Object, Object> map;
        block15: {
            map = new HashMap<Object, Object>();
            RowIterator it = null;
            int columnCount = this.table.getColumnCount();
            Type[] columnTypes = this.table.colTypes;
            Object[] data = null;
            try {
                it = this.table.rowIteratorClustered(session);
                if (columnCount == 2) {
                    try {
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                            map.put(data[0], data[1]);
                        }
                        break block15;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map. " + error.getMessage());
                    }
                }
                RowMetaData meta = SqlUtils.getCollectionMeta(this);
                if (this.table.getPrimaryKey().length == 1) {
                    Object key = null;
                    try {
                        while (it.hasNext()) {
                            com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                            Row row = it.getNextRow();
                            data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                            newRow.setRawData(data);
                            key = data[this.table.getPrimaryKey()[0]];
                            map.put(key, newRow);
                        }
                        break block15;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map. " + error.getMessage());
                    }
                }
                long sequence = -1L;
                try {
                    while (it.hasNext()) {
                        com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                        Row row = it.getNextRow();
                        data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                        newRow.setRawData(data);
                        map.put(++sequence, newRow);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to convert collection to Map. " + error.getMessage());
                }
            }
            finally {
                if (it != null) {
                    it.release();
                    it = null;
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromMap(Session session, Map<?, ?> map) {
        if (this.table.getColumnCount() != 2) {
            Trace.logError(this, "Table could not be loaded from map. Number of columns mismatch (two columns expected).");
            throw new DataspaceException("Number of columns mismatch. Two columns expected.");
        }
        if (map instanceof MapCollection) {
            Table table = ((MapCollection)((Object)map)).getBaseTable();
            PersistentStore tableStore = this.table.getRowStore(session);
            RowIterator iter = table.rowIteratorClustered(session);
            try {
                while (iter.hasNext()) {
                    Object[] data = iter.getNext();
                    this.table.insertSingleRow(session, tableStore, data, null);
                }
            }
            finally {
                if (iter != null) {
                    iter.release();
                    iter = null;
                }
            }
        } else {
            Type[] mapDsTypes = new Type[2];
            Class[] mapTypes = new Class[2];
            PersistentStore store = this.table.getRowStore(session);
            Type[] tableTypes = this.table.getColumnTypes();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (mapDsTypes[0] == null || entry.getKey().getClass() != mapTypes[0]) {
                    mapDsTypes[0] = this.resolveType(session, entry.getKey());
                    mapTypes[0] = entry.getKey().getClass();
                }
                if (mapDsTypes[1] == null || entry.getValue().getClass() != mapTypes[1]) {
                    mapDsTypes[1] = this.resolveType(session, entry.getValue());
                    mapTypes[1] = entry.getValue().getClass();
                }
                Object[] rowData = SqlUtils.getDataForInsert(session, this.table, new Object[]{entry.getKey(), entry.getValue()}, tableTypes, mapDsTypes);
                this.table.insertSingleRow(session, store, rowData, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCollection toTableCollection(Session session) {
        NameManager.ObjectName name = this.store.nameManager.newObjectName("TEMP_TABLE_" + System.currentTimeMillis(), false, 4);
        name.schema = SqlInvariants.MODULE_NAME;
        TableCollection collection = new TableCollection(this.store, name, MemoryModel.MEMORY, 12);
        Table baseTable = collection.getBaseTable();
        Table newBaseTable = collection.getBaseTable();
        for (int i = 0; i < baseTable.getColumnCount(); ++i) {
            newBaseTable.addColumn(baseTable.getColumn(i));
        }
        newBaseTable.createPrimaryKey();
        session.sessionContext.addSessionCollection(collection);
        collection.compile(session, null);
        collection.compileInternalStatements(session);
        int columnCount = this.table.getColumnCount();
        RowIterator it = this.table.rowIteratorClustered(session);
        PersistentStore tableStore = collection.getBaseTable().getRowStore(session);
        try {
            while (it.hasNext()) {
                Object[] data = new Object[columnCount];
                Row row = it.getNextRow();
                Object[] currentData = row.getData();
                System.arraycopy(currentData, 0, data, 0, columnCount);
                collection.getBaseTable().insertSingleRow(session, tableStore, data, null);
            }
        }
        finally {
            if (it != null) {
                it.release();
            }
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromTable(Session session, TableCollection table) {
        if (table.getBaseTable().getColumnCount() != this.table.getColumnCount()) {
            Trace.logError(this, "Number of columns in provided table " + table.getBaseTable().getColumnCount() + " does not match number of columns " + this.table.getColumnCount() + " in current table.");
            throw new DataspaceException("Number of columns mismatch.");
        }
        PersistentStore tableStore = this.table.getRowStore(session);
        RowIterator iter = table.getBaseTable().rowIteratorClustered(session);
        try {
            while (iter.hasNext()) {
                Object[] data = iter.getNext();
                this.table.insertSingleRow(session, tableStore, data, null);
            }
        }
        finally {
            if (iter != null) {
                iter.release();
                iter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapCollection toMapCollection(Session session) {
        MapCollection collection;
        block17: {
            NameManager.ObjectName name = this.store.nameManager.newObjectName("TEMP_MAP_" + System.currentTimeMillis(), false, 4);
            name.schema = SqlInvariants.MODULE_NAME;
            collection = new MapCollection(session.dataspaceStore, name, MemoryModel.MEMORY);
            session.sessionContext.addSessionCollection(collection);
            RowIterator it = null;
            int columnCount = this.table.getColumnCount();
            Type[] columnTypes = this.table.colTypes;
            Object[] data = null;
            try {
                it = this.table.rowIteratorClustered(session);
                if (columnCount == 2) {
                    collection.defineKeyColumn(columnTypes[0], columnTypes[0].getNameString());
                    collection.defineValueColumn(columnTypes[1], columnTypes[1].getNameString());
                    collection.compile(session, null);
                    collection.compileInternalStatements(session);
                    try {
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                            collection.getBaseTable().insertSingleRow(session, collection.getBaseTable().getRowStore(session), row.getData(), null);
                        }
                        break block17;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map collection. " + error.getMessage());
                    }
                }
                RowMetaData meta = SqlUtils.getCollectionMeta(this);
                if (this.table.getPrimaryKey().length == 1) {
                    Type columnType = columnTypes[this.table.getPrimaryKey()[0]];
                    collection.defineKeyColumn(columnType, columnType.getNameString());
                } else {
                    collection.defineKeyColumn(Type.LONG, Type.LONG.getNameString());
                }
                Type valueType = Types.getParameterSQLType(session, com.streamscape.sdo.rowset.Row.class);
                collection.defineValueColumn(valueType, valueType.getNameString());
                collection.compile(session, null);
                collection.compileInternalStatements(session);
                if (this.table.getPrimaryKey().length == 1) {
                    Object key = null;
                    try {
                        while (it.hasNext()) {
                            com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                            Row row = it.getNextRow();
                            data = row.getData();
                            newRow.setRawData(data);
                            key = data[this.table.getPrimaryKey()[0]];
                            Object[] currentRow = new Object[]{key, new OtherTypeWrapper(newRow)};
                            collection.getBaseTable().insertSingleRow(session, collection.getBaseTable().getRowStore(session), currentRow, null);
                        }
                        break block17;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map collection. " + error.getMessage());
                    }
                }
                long sequence = -1L;
                try {
                    while (it.hasNext()) {
                        com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                        Row row = it.getNextRow();
                        data = row.getData();
                        newRow.setRawData(data);
                        Object[] currentRow = new Object[]{++sequence, new OtherTypeWrapper(newRow)};
                        collection.getBaseTable().insertSingleRow(session, collection.getBaseTable().getRowStore(session), currentRow, null);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to convert collection to Map collection. " + error.getMessage());
                }
            }
            finally {
                if (it != null) {
                    it.release();
                    it = null;
                }
            }
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockingQueueCollection toQueueCollection(Session session) {
        BlockingQueueCollection collection;
        block11: {
            NameManager.ObjectName name = this.store.nameManager.newObjectName("TEMP_QUEUE_" + System.currentTimeMillis(), false, 4);
            name.schema = SqlInvariants.MODULE_NAME;
            collection = new BlockingQueueCollection(session.dataspaceStore, name, MemoryModel.MEMORY);
            Type queueElementType = null;
            session.sessionContext.addSessionCollection(collection);
            RowIterator it = null;
            int columnCount = this.table.getColumnCount();
            Type[] columnTypes = this.table.colTypes;
            Object[] data = null;
            queueElementType = columnCount == 1 ? columnTypes[0] : Types.getParameterSQLType(session, com.streamscape.sdo.rowset.Row.class);
            collection.setConstraint(queueElementType);
            collection.compile(session, null);
            collection.compileInternalStatements(session);
            try {
                it = this.table.rowIteratorClustered(session);
                if (columnCount == 1) {
                    try {
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            collection.add(session, row.getData()[0]);
                        }
                        break block11;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Queue collection. " + error.getMessage());
                    }
                }
                RowMetaData meta = SqlUtils.getCollectionMeta(this);
                try {
                    while (it.hasNext()) {
                        com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                        Row row = it.getNextRow();
                        data = row.getData();
                        newRow.setRawData(data);
                        collection.add(session, newRow);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to convert collection to Queue collection. " + error.getMessage());
                }
            }
            finally {
                if (it != null) {
                    it.release();
                    it = null;
                }
            }
        }
        return collection;
    }
}

