/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.table;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.snapshot.IndexSnapshot;
import com.streamscape.ds.persist.snapshot.RowSnapshot;
import com.streamscape.ds.persist.snapshot.RowStoreSnapshot;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.stable.index.SIndex;
import com.streamscape.ds.stable.table.StorageManager;
import com.streamscape.ds.stable.table.TableMetadata;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.event.RowEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventSelectorFormatException;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.slex.file.SLFileSessionContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class SnapshotCollection
extends TableCollection
implements FabricEventListener {
    private String fileDescriptorName;
    private FileDescriptor fileDescriptor;
    private boolean fromExistingTable = false;
    private String constrainedEventId;
    private boolean asyncConsumer;
    private EventScope eventScope = EventScope.INHERITED;
    private String eventWhenClause;
    private List<String> primaryKeyColumns;
    private boolean started = false;
    private EventConsumer consumer;
    private Statement insertStatement;
    private Session internalSession;
    private final Object internalSessionMutex = new Object();
    private boolean isLinked = false;
    private String linkFilepath = null;
    private boolean linkToDelimited = false;
    private Exception linkException = null;
    private Exception snapshotException = null;
    private String snapshotDirectory;
    private long autosaveInterval;
    private TimeUnit autosaveIntervalTimeUnit;
    private int autosaveGeneration;
    private long lastAutosaveTime;
    private ScheduledExecutorService autosaveScheduledExecutor;
    public final ReentrantLock autosaveLock = new ReentrantLock();
    private boolean wasSuccessfullyLoaded = false;

    public SnapshotCollection(DataspaceStore database, NameManager.ObjectName name, MemoryModel memoryModel) {
        super(database, name, CollectionType.SNAPSHOT_TABLE, memoryModel, 16);
    }

    @Override
    protected void doCreateTable(DataspaceStore database, NameManager.ObjectName tableName, int tableType) {
        this.table = new SnapshotDataspaceTable(database, tableName, this);
    }

    @Override
    public void open(Session session) {
        super.open(session);
        try {
            if (!this.wasSuccessfullyLoaded && !session.isCreatingDataspaceLike) {
                this.loadSnapshotCollectionOrThrowException(session);
            }
            this.startAutosaveAndConsumer();
        }
        catch (Exception e) {
            Trace.logError(this, "Failed to open snapshot collection: " + this.getObjectName().getSchemaQualifiedStatementName());
        }
    }

    public void startAutosaveAndConsumer() {
        Trace.logInfo(this, "Starting snapshot collection: " + this.getObjectName().getSchemaQualifiedStatementName());
        this.startAutosave();
        if (this.started) {
            this.doStart();
        }
    }

    @Override
    public void close() {
        this.wasSuccessfullyLoaded = false;
        this.stopAutosave();
        this.doStop();
        super.close();
    }

    private void doStart() {
        if (this.consumer == null) {
            try {
                if (this.asyncConsumer) {
                    this.consumer = this.dataspace.createEventAsyncConsumer(this.dataspace.getDataspaceType().toString() + "_" + this.dataspace.getName() + "_" + this.name.name + "_ASYNC_LISTENER", this, this.constrainedEventId, this.eventWhenClause, this.eventScope, false);
                    ((EventAsyncConsumer)this.consumer).start();
                    this.dataspace.addSinkEventFlow(EventFlowEntity.DATASPACE_SNAPSHOT_TABLE, this.name.name, this.consumer);
                } else {
                    this.consumer = this.dataspace.createEventConsumer(this.dataspace.getDataspaceType().toString() + "_" + this.dataspace.getName() + "_" + this.name.name + "_LISTENER", this, this.constrainedEventId, this.eventWhenClause, this.eventScope, false);
                    this.dataspace.addSinkEventFlow(EventFlowEntity.DATASPACE_SNAPSHOT_TABLE, this.name.name, this.consumer);
                }
            }
            catch (Exception exception) {
                throw new DataspaceException("Failed to create consumer.", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStop() {
        if (this.consumer != null) {
            try {
                this.dataspace.dropConsumer(this.consumer.getName());
                this.consumer = null;
            }
            catch (FabricEventDispatcherException exception) {
                throw new DataspaceException("Failed to drop consumer.", exception);
            }
        }
        Object object = this.internalSessionMutex;
        synchronized (object) {
            if (this.internalSession != null) {
                this.internalSession.close();
                this.internalSession = null;
            }
        }
    }

    public void start(Session session) {
        this.started = true;
        this.doStart();
    }

    public void stop(Session session) {
        this.started = false;
        this.doStop();
    }

    @Override
    public void destroy(Session session) {
        super.destroy(session);
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        if (fileDescriptor != null) {
            if (fileDescriptor.getRecords().size() != 1) {
                throw new DataspaceException("File Descriptor contains Multiple Record Types. Can only be used with TYPE ONLY file tables or with specified record type.");
            }
            FileDescriptorRecord record = fileDescriptor.getRecords().get(0);
            FileTableCollection.handleRecordTypeDefinition(session, record, (field, type) -> this.addColumn(this.table, field.getFieldName(), (Type)type, field.isNullable()));
            NameManager.ObjectName indexName = session.dataspaceStore.nameManager.newAutoName("IDX", null, this.table.getSchemaName(), this.table.getObjectName(), 21);
            this.table.createPrimaryKey(indexName, null, true);
            this.table.setColumnStructures();
        }
        if (this.constrainedEventId != null) {
            EventDatagram event;
            Prototype prototype = DataspaceStore.getContext().getDatagramPrototypeFactory().lookupPrototype(this.constrainedEventId);
            if (prototype == null) {
                throw new DataspaceException("Event prototype [" + this.constrainedEventId + "] doesn't exist.");
            }
            try {
                event = DataspaceStore.getContext().getEventDatagramFactory().createEvent(prototype);
            }
            catch (DatagramFactoryException exception) {
                throw new DataspaceException("Failed to create instance of event [" + this.constrainedEventId + "].", exception);
            }
            if (event instanceof MapEvent) {
                if (this.table.getColumnCount() == 0) {
                    throw new DataspaceException("Snapshot table definition is not specified.");
                }
            } else if (event instanceof RowEvent) {
                try {
                    Row row = ((RowEvent)event).getRow();
                    if (row == null) {
                        throw new DataspaceException("Row in row event prototype [" + this.constrainedEventId + "] is null.");
                    }
                    RowMetaData metadata = row.getMeta();
                    if (metadata == null) {
                        throw new DataspaceException("Metadata in row event prototype [" + this.constrainedEventId + "] is null.");
                    }
                    if (this.table.getColumnCount() == 0) {
                        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                            ColumnDescriptor columnDescriptor = metadata.getColumnDescriptor(i);
                            Type columnType = Type.getDefaultType(columnDescriptor);
                            if (columnType.isObjectType()) {
                                throw new DataspaceException("Snapshot table support only primitive types.");
                            }
                            this.addColumn(this.table, columnDescriptor.getName(), columnType, columnDescriptor.isNullable());
                        }
                        NameManager.ObjectName indexName = session.dataspaceStore.nameManager.newAutoName("IDX", null, this.table.getSchemaName(), this.table.getObjectName(), 21);
                        if (this.primaryKeyColumns != null && this.primaryKeyColumns.size() > 0) {
                            int[] primaryKeyColumnsIndexes = new int[this.primaryKeyColumns.size()];
                            for (int i = 0; i < primaryKeyColumnsIndexes.length; ++i) {
                                primaryKeyColumnsIndexes[i] = this.table.getColumnIndex(this.primaryKeyColumns.get(i));
                            }
                            this.table.createPrimaryKeyConstraint(indexName, primaryKeyColumnsIndexes, true);
                        } else {
                            this.table.createPrimaryKey(indexName, null, true);
                        }
                        this.table.setColumnStructures();
                    }
                    if (this.primaryKeyColumns != null && this.primaryKeyColumns.size() > 0) {
                        throw new DataspaceException("Primary key can only be specified if table definition is not specified.");
                    }
                    for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                        ColumnDescriptor columnDescriptor = metadata.getColumnDescriptor(i);
                        Type columnType = Type.getDefaultType(columnDescriptor.getType().getType(), columnDescriptor.getPrecision(), columnDescriptor.getScale());
                        ColumnSchema column = this.table.getColumn(columnDescriptor.getName());
                        if (column == null) {
                            throw new DataspaceException("RowEvent prototype [" + this.constrainedEventId + "] and table definition mismatch. Column '" + columnDescriptor.getName() + "' doesn't exist.");
                        }
                        if (column.getDataType().typeComparisonGroup == columnType.typeComparisonGroup) continue;
                        throw new DataspaceException("RowEvent prototype [" + this.constrainedEventId + "] and table definition mismatch. Column '" + columnDescriptor.getName() + "' type mismatch '" + column.getDataType().getNameString() + "' and '" + columnType.getNameString() + "'.");
                    }
                }
                catch (SecurityViolationException exception) {
                    throw new DataspaceException("Failed to get row from RowEvent.", exception);
                }
            } else {
                throw new DataspaceException("Snapshot table can be constrained by MapEvent or RowEvent.");
            }
        }
        super.compile(session, parentObject);
        if (this.store.getStoreState().isStarted()) {
            this.open(session);
        }
    }

    @Override
    public void compileInternalStatements(Session session) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(this.getObjectName().getStatementName()).append(" VALUES(");
        for (int i = 0; i < this.table.columnCount; ++i) {
            builder.append("?");
            if (i == this.table.columnCount - 1) continue;
            builder.append(",");
        }
        builder.append(")");
        this.insertStatement = session.compileStatement(builder.toString());
    }

    public void materializeFrom(Session session, String filepath, boolean fromDelimitedFile, boolean force, boolean merge) {
        ((SnapshotDataspaceTable)this.table).materializeFrom(session, filepath, fromDelimitedFile, force, merge);
    }

    public void rebuildPrimaryKeyIfNeeded() {
        Index primaryIndex = this.getBaseTable().getPrimaryIndex();
        if (primaryIndex != null && !primaryIndex.isBuilt()) {
            SIndex sPrimaryIndex = ((IndexSnapshot)primaryIndex).getSIndex();
            if (sPrimaryIndex.isValid()) {
                Trace.logInfo(this, "Rebuilding primary key {} for snapshot {}.", sPrimaryIndex.getName(), this.getCollectionName());
                sPrimaryIndex.reset();
                sPrimaryIndex.build(((IndexSnapshot)primaryIndex).getTable().getSTable().getSelection());
            } else {
                Trace.logInfo(this, "Primary key {} for snapshot {} is not valid.", sPrimaryIndex.getName(), this.getCollectionName());
            }
        }
    }

    public void materializeFrom(Session session, Collection collection) {
        ((SnapshotDataspaceTable)this.table).materializeFrom(session, collection);
    }

    public void materializeTo(Session session, String filepath) {
        ((SnapshotDataspaceTable)this.table).materializeTo(session, filepath, Objects.equals(filepath, this.snapshotDirectory) && this.autosaveGeneration != 0 ? this.autosaveGeneration : 0);
    }

    public void setFileDescriptorName(String fileDescriptorName) {
        this.fileDescriptorName = fileDescriptorName;
    }

    public String getFileDescriptorName() {
        return this.fileDescriptorName;
    }

    public FileDescriptor getFileDescriptor() {
        if (this.fileDescriptorName == null) {
            return null;
        }
        if (this.fileDescriptor != null) {
            return this.fileDescriptor;
        }
        try {
            this.fileDescriptor = FileDescriptorRepositoryUtils.lookupFileDescriptor(this.fileDescriptorName);
            if (this.fileDescriptor == null) {
                throw new DataspaceException("File descriptor '" + this.fileDescriptorName + "' doesn't exist.");
            }
            return this.fileDescriptor;
        }
        catch (ObjectConfigurationException exception) {
            throw new DataspaceException("Failed to access repository. Cause: " + exception.getMessage());
        }
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.name.getSchemaQualifiedStatementName());
    }

    @Override
    public String getSQL(String name) {
        StringBuilder builder = new StringBuilder();
        if (this.fileDescriptorName != null) {
            builder.append("CREATE").append(' ').append("SNAPSHOT").append(' ').append("TABLE").append(' ');
            builder.append(name).append(' ');
            builder.append("FROM").append(' ').append("FILE").append(' ').append("DESCRIPTOR").append(" '").append(this.fileDescriptorName).append("'");
            return builder.toString();
        }
        builder.append(super.getSQL(name));
        if (this.snapshotDirectory != null) {
            builder.append(" snapshot at '").append(this.snapshotDirectory).append("'");
            if (this.autosaveInterval > 0L) {
                builder.append(" autosave ").append(this.autosaveInterval).append(" ").append(SqlUtils.timeUnitToString(this.autosaveIntervalTimeUnit));
                builder.append(" generation ").append(this.autosaveGeneration);
            }
        }
        if (this.constrainedEventId != null) {
            builder.append(" CONSTRAINED BY ").append(StringUtils.wrapEventId(this.constrainedEventId));
            if (this.asyncConsumer) {
                builder.append(" ASYNC CONSUMER ");
            }
            if (this.eventScope != null) {
                builder.append(" EVENT SCOPE ").append(this.eventScope.toString());
            }
            if (this.eventWhenClause != null && this.eventWhenClause.length() > 0) {
                builder.append(" WHEN(").append(this.eventWhenClause).append(")");
            }
            if (this.started) {
                builder.append(" START");
            }
        }
        return builder.toString();
    }

    public boolean isFromExistingTable() {
        return this.fromExistingTable;
    }

    public void setFromExistingTable(boolean fromExistingTable) {
        this.fromExistingTable = fromExistingTable;
    }

    @Override
    public Result getCollectionProperties(Session session) {
        Result result = super.getCollectionProperties(session);
        result.navigator.add(new Object[]{"File Descriptor", this.fileDescriptorName != null ? this.fileDescriptorName : "none"});
        result.navigator.add(new Object[]{"Last Loaded From", ((SnapshotDataspaceTable)this.table).getLastLoadedFrom() != null ? ((SnapshotDataspaceTable)this.table).getLastLoadedFrom() : "none"});
        result.navigator.add(new Object[]{"Last Saved To", ((SnapshotDataspaceTable)this.table).getLastSavedTo() != null ? ((SnapshotDataspaceTable)this.table).getLastSavedTo() : "none"});
        result.navigator.add(new Object[]{"Constrained By", StringUtils.wrapEventId(this.constrainedEventId)});
        Object[] objectArray = new Object[2];
        objectArray[0] = "Consumer Type";
        objectArray[1] = this.constrainedEventId != null ? (this.asyncConsumer ? "ASYNC" : "SYNC") : "none";
        result.navigator.add(objectArray);
        result.navigator.add(new Object[]{"Event Scope", this.constrainedEventId != null && this.eventScope != null ? this.eventScope.toString() : "none"});
        result.navigator.add(new Object[]{"When Clause", this.constrainedEventId != null && this.eventWhenClause != null ? this.eventWhenClause : "none"});
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "State";
        objectArray2[1] = this.constrainedEventId != null ? (this.started ? "STARTED" : "STOPPED") : "none";
        result.navigator.add(objectArray2);
        result.navigator.add(new Object[]{"Snapshot Directory", Optional.ofNullable(this.snapshotDirectory).orElse("")});
        result.navigator.add(new Object[]{"Auto Save Interval", this.autosaveInterval != 0L ? Long.valueOf(this.autosaveInterval) : ""});
        result.navigator.add(new Object[]{"Auto Save Interval Unit", this.autosaveIntervalTimeUnit != null ? SqlUtils.timeUnitToString(this.autosaveIntervalTimeUnit).toLowerCase() : ""});
        result.navigator.add(new Object[]{"Auto Save Generation", this.autosaveGeneration});
        result.navigator.add(new Object[]{"Last Autosave Time", this.lastAutosaveTime > 0L ? DataspaceDateTime.formatTimestamp(session, this.lastAutosaveTime) : "n/a"});
        String snapshotExceptionString = "";
        if (this.snapshotException != null) {
            StringWriter stringWriter = new StringWriter();
            this.snapshotException.printStackTrace(new PrintWriter(stringWriter));
            snapshotExceptionString = stringWriter.toString();
        }
        result.navigator.add(new Object[]{"Last Auto Save Exception", snapshotExceptionString});
        return result;
    }

    @Override
    protected void onAggregateOthers(DataspaceStateHolder holder) {
        for (Index index : this.table.getIndexList()) {
            if (!index.isBuilt()) {
                holder.setSuspectState(DataspaceStateHolder.index(index.getObjectName()), "not built");
            }
            if (index.isValid()) continue;
            holder.setSuspectState(DataspaceStateHolder.index(index.getObjectName()), "not valid");
        }
        if (this.linkException != null) {
            holder.setSuspectState(DataspaceStateHolder.invalid, Utils.formatExceptionWithUnrepeatedCauses(this.linkException));
        } else if (this.snapshotException != null) {
            holder.setSuspectState(DataspaceStateHolder.invalid, Utils.formatExceptionWithUnrepeatedCauses(this.snapshotException) + " Run snapshot manually to fix metadata. All data on disk will be lost");
        } else if (this.autosaveInterval > 0L && this.autosaveScheduledExecutor == null && this.dataspace != null && this.dataspace.isOnline()) {
            holder.setSuspectState(DataspaceStateHolder.invalid, "Autosave thread is not started. It can be because dataspace is in recovery failed state or problem with snapshot metadata. Collection: " + this.getObjectName().getSchemaQualifiedStatementName());
        }
    }

    public void setConstrainedEventId(String constrainedEventId) {
        this.constrainedEventId = constrainedEventId;
    }

    public String getConstrainedEventId() {
        return this.constrainedEventId;
    }

    public void setAsyncConsumer(boolean asyncConsumer) {
        this.asyncConsumer = asyncConsumer;
    }

    public boolean isAsyncConsumer() {
        return this.asyncConsumer;
    }

    public void setEventScope(EventScope eventScope) {
        this.eventScope = eventScope;
    }

    public EventScope getEventScope() {
        return this.eventScope;
    }

    public void setEventWhenClause(String eventWhenClause) {
        this.eventWhenClause = eventWhenClause;
    }

    public String getEventWhenClause() {
        return this.eventWhenClause;
    }

    public void setPrimaryKeyColumns(List<String> primaryKeyColumns) {
        this.primaryKeyColumns = primaryKeyColumns;
    }

    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
        Object object = this.internalSessionMutex;
        synchronized (object) {
            if (this.internalSession == null || this.internalSession.isClosed()) {
                this.internalSession = this.dataspace.createSession();
            }
            this.insertEvent(event);
        }
    }

    private void insertEvent(ImmutableEventDatagram event) throws FabricEventException {
        Object[] values = new Object[this.table.columnCount];
        for (int i = 0; i < this.table.columnCount; ++i) {
            ColumnSchema columnSchema = this.table.getColumn(i);
            String columnName = columnSchema.getNameString();
            if (event instanceof MapEvent) {
                try {
                    if (((MapEvent)event).itemExists(columnName)) {
                        values[i] = ((MapEvent)event).getObject(columnSchema.getNameString());
                        continue;
                    }
                    values[i] = columnSchema.getDefaultValue(this.internalSession);
                    continue;
                }
                catch (SDOException | SecurityViolationException exception) {
                    throw new FabricEventException("Failed to get item '" + columnName + "' from MapEvent.", (Throwable)exception);
                }
            }
            if (event instanceof RowEvent) {
                try {
                    Row row = ((RowEvent)event).getRow();
                    if (row.findColumn(columnName) != -1) {
                        values[i] = row.getColumn(columnName);
                        continue;
                    }
                    values[i] = columnSchema.getDefaultValue(this.internalSession);
                    continue;
                }
                catch (SecurityViolationException | RowException exception) {
                    throw new FabricEventException("Failed to get row from MapEvent.", (Throwable)exception);
                }
            }
            throw new FabricEventException("Invalid event model '" + event.getClass().getSimpleName() + "'.");
        }
        this.insertDirect(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertDirect(Object[] values) throws FabricEventException {
        RowStoreSnapshot rowStoreSnapshot = (RowStoreSnapshot)this.table.getRowStore(this.internalSession);
        rowStoreSnapshot.writeLock();
        try {
            try {
                rowStoreSnapshot.appendRowDataNoLock(this.internalSession, values);
            }
            catch (DataspaceException exception) {
                this.upsertDirect(rowStoreSnapshot, values, exception, new ArrayList<String>());
            }
        }
        finally {
            rowStoreSnapshot.writeUnlock();
        }
    }

    private void upsertDirect(RowStoreSnapshot rowStoreSnapshot, Object[] values, DataspaceException exception, List<String> processedIndexes) {
        if (exception.getErrorCode() == -104) {
            String indexName = exception.getMessage();
            int pos = indexName.lastIndexOf("violation: ");
            if (pos == -1) {
                throw exception;
            }
            pos = indexName.indexOf(":", pos);
            indexName = indexName.substring(pos + 1);
            if (processedIndexes.contains(indexName = indexName.trim())) {
                throw exception;
            }
            Index brokenIndex = null;
            for (Index index : this.table.getIndexList()) {
                if (!indexName.equals(index.getObjectName().name)) continue;
                brokenIndex = index;
                break;
            }
            if (brokenIndex == null) {
                Trace.logError(this, "SIndex '" + indexName + "' not found for table '" + this.getObjectName().getStatementName() + "'.");
                throw exception;
            }
            processedIndexes.add(indexName);
            RowIterator rowIterator = brokenIndex.findFirstRow(this.internalSession, rowStoreSnapshot, values);
            RowSnapshot nextRow = (RowSnapshot)rowIterator.getNextRow();
            if (nextRow == null) {
                throw exception;
            }
            int rowIndex = nextRow.getRowIndex();
            int[] indexesMap = new int[values.length];
            for (int i = 0; i < indexesMap.length; ++i) {
                indexesMap[i] = i;
            }
            try {
                rowStoreSnapshot.setRowValuesNoLock(rowIndex, indexesMap, values);
            }
            catch (DataspaceException exception1) {
                this.upsertDirect(rowStoreSnapshot, values, exception, processedIndexes);
            }
        } else {
            throw exception;
        }
    }

    private void insertWithStatement(Object[] values) throws FabricEventException {
        if (this.insertStatement == null) {
            throw new FabricEventException("Insert statement is null.");
        }
        Result result = this.internalSession.executeCompiledStatement(this.insertStatement, values);
        if (result.isError()) {
            throw new DataspaceException(result);
        }
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public SnapshotCollection setLinked(boolean linked) {
        this.isLinked = linked;
        return this;
    }

    public String getLinkFilepath() {
        return this.linkFilepath;
    }

    public SnapshotCollection setLinkFilepath(String linkFilepath) {
        this.linkFilepath = linkFilepath;
        return this;
    }

    public boolean isLinkToDelimited() {
        return this.linkToDelimited;
    }

    public SnapshotCollection setLinkToDelimited(boolean linkToDelimited) {
        this.linkToDelimited = linkToDelimited;
        return this;
    }

    public Exception getLinkException() {
        return this.linkException;
    }

    public SnapshotCollection setLinkException(Exception linkException) {
        this.linkException = linkException;
        return this;
    }

    public String getDataSourceDDL() {
        if (this.isLinked) {
            StringBuilder builder = new StringBuilder(128);
            builder.append("LINK").append(' ').append("SNAPSHOT").append(' ');
            builder.append(this.getObjectName().getSchemaQualifiedStatementName());
            builder.append(' ').append("TO").append(' ').append('\'');
            if (this.linkToDelimited) {
                builder.append(" delimited file ");
            } else {
                builder.append(" snap ");
            }
            builder.append('\'').append(this.linkFilepath).append('\'');
            if (this.getBaseTable().isReadOnly()) {
                builder.append(" read only ");
            }
            return builder.toString();
        }
        return null;
    }

    public void setSnapshotDirectory(String snapshotDirectory) {
        this.snapshotDirectory = snapshotDirectory;
    }

    public String getSnapshotDirectory() {
        return this.snapshotDirectory;
    }

    public void setAutosaveInterval(long autosaveInterval) {
        this.autosaveInterval = autosaveInterval;
    }

    public long getAutosaveInterval() {
        return this.autosaveInterval;
    }

    public void setAutosaveGeneration(int autosaveGeneration) {
        this.autosaveGeneration = autosaveGeneration;
    }

    public int getAutosaveGeneration() {
        return this.autosaveGeneration;
    }

    public void setAutosaveIntervalTimeUnit(TimeUnit autosaveIntervalTimeUnit) {
        this.autosaveIntervalTimeUnit = autosaveIntervalTimeUnit;
    }

    public TimeUnit getAutosaveIntervalTimeUnit() {
        return this.autosaveIntervalTimeUnit;
    }

    public Exception getSnapshotException() {
        return this.snapshotException;
    }

    public SnapshotCollection setSnapshotException(Exception snapshotException) {
        this.snapshotException = snapshotException;
        return this;
    }

    private void startAutosave() {
        if (this.autosaveInterval > 0L && this.autosaveScheduledExecutor == null) {
            this.autosaveScheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            Trace.logInfo(this, "Scheduling next autosave for snapshot table {} in {} {}", this.getObjectName().getSchemaQualifiedStatementName(), this.autosaveInterval, this.autosaveIntervalTimeUnit.name());
            this.autosaveScheduledExecutor.schedule(new AutosaveRunnable(), this.autosaveInterval, this.autosaveIntervalTimeUnit);
        }
    }

    private void stopAutosave() {
        if (this.autosaveScheduledExecutor != null) {
            this.autosaveScheduledExecutor.shutdown();
            this.autosaveScheduledExecutor = null;
        }
    }

    public void updateWhenClause(String whenClause) {
        if (this.constrainedEventId == null) {
            throw new DataspaceException("Cannot update when clause, snapshot collection is not constrained by event ID.");
        }
        if (this.consumer != null) {
            try {
                this.consumer.setEventSelector(whenClause);
            }
            catch (EventSelectorFormatException exception) {
                throw new DataspaceException("Invalid when clause.", exception);
            }
        }
        this.eventWhenClause = whenClause;
    }

    public void checkConstrainedEvent(String eventId) {
        EventDatagram event;
        Prototype prototype = DataspaceStore.getContext().getDatagramPrototypeFactory().lookupPrototype(eventId);
        if (prototype == null) {
            throw new DataspaceException("Event prototype [" + eventId + "] doesn't exist.");
        }
        try {
            event = DataspaceStore.getContext().getEventDatagramFactory().createEvent(prototype);
        }
        catch (DatagramFactoryException exception) {
            throw new DataspaceException("Failed to create instance of event [" + eventId + "].", exception);
        }
        if (!(event instanceof MapEvent)) {
            if (event instanceof RowEvent) {
                try {
                    Row row = ((RowEvent)event).getRow();
                    if (row == null) {
                        throw new DataspaceException("Row in row event prototype [" + eventId + "] is null.");
                    }
                    RowMetaData metadata = row.getMeta();
                    if (metadata == null) {
                        throw new DataspaceException("Metadata in row event prototype [" + eventId + "] is null.");
                    }
                    for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                        ColumnDescriptor columnDescriptor = metadata.getColumnDescriptor(i);
                        Type columnType = Type.getDefaultType(columnDescriptor.getType().getType(), columnDescriptor.getPrecision(), columnDescriptor.getScale());
                        ColumnSchema column = this.table.getColumn(columnDescriptor.getName());
                        if (column == null) {
                            throw new DataspaceException("RowEvent prototype [" + eventId + "] and table definition mismatch. Column '" + columnDescriptor.getName() + "' doesn't exist.");
                        }
                        if (column.getDataType().typeComparisonGroup == columnType.typeComparisonGroup) continue;
                        throw new DataspaceException("RowEvent prototype [" + eventId + "] and table definition mismatch. Column '" + columnDescriptor.getName() + "' type mismatch '" + column.getDataType().getNameString() + "' and '" + columnType.getNameString() + "'.");
                    }
                }
                catch (SecurityViolationException exception) {
                    throw new DataspaceException("Failed to get row from RowEvent.", exception);
                }
            } else {
                throw new DataspaceException("Snapshot table can be constrained by MapEvent or RowEvent.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyDataToAnotherCollection(Session session, SnapshotCollection newSnapshotCollection) {
        String filepath = null;
        String[] filepathTmp = new String[]{this.getSnapshotDirectory()};
        try (FileSystem fileSystem = SessionData.createFileSystem(session, filepathTmp);){
            filepath = filepathTmp[0];
            String directoryPath = StorageManager.buildDirectoryPath(fileSystem, filepath, ((SnapshotDataspaceTable)this.table).getSTable().name());
            String newDirectoryPath = StorageManager.buildDirectoryPath(fileSystem, filepath, ((SnapshotDataspaceTable)newSnapshotCollection.getBaseTable()).getSTable().name());
            this.autosaveLock.lock();
            newSnapshotCollection.autosaveLock.lock();
            try {
                if (fileSystem.exists(newDirectoryPath)) {
                    fileSystem.delete(newDirectoryPath, true);
                }
                FileIOUtils.copyDirectory(fileSystem, directoryPath, newDirectoryPath);
                TableMetadata newMetadata = StorageManager.readTableMetadata(fileSystem, newDirectoryPath);
                newMetadata.setName(((SnapshotDataspaceTable)newSnapshotCollection.getBaseTable()).getSTable().name());
                StorageManager.writeTableMetadata(fileSystem, newDirectoryPath, newMetadata);
            }
            finally {
                newSnapshotCollection.autosaveLock.unlock();
                this.autosaveLock.unlock();
            }
        }
        catch (IOException exception) {
            throw new DataspaceException("Failed copy store snap data from table " + this.getObjectName().getSchemaQualifiedStatementName() + " to table " + newSnapshotCollection.getObjectName().getSchemaQualifiedStatementName() + " at " + filepath, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSnapshotCollectionOrThrowException(Session session) {
        if (this.getMemoryModel() == MemoryModel.PERSISTENT && this.getSnapshotDirectory() != null) {
            Trace.logInfo(this, "Loading snapshot collection: " + this.getObjectName().getSchemaQualifiedStatementName());
            try {
                SLFileSessionContext slFileSessionContext = session.getSLFileSessionContext();
                session.setSLFileSessionContext(SLFileSessionContext.SERVER);
                try {
                    String[] filepathTmp = new String[]{this.getSnapshotDirectory()};
                    try (FileSystem fileSystem = SessionData.createFileSystem(session, filepathTmp);){
                        if (!fileSystem.exists(filepathTmp[0]) || !fileSystem.isDirectory(filepathTmp[0])) {
                            throw new DataspaceException("Specified snapshot directory " + this.getSnapshotDirectory() + " doesn't exist.");
                        }
                        String filepathDirectory = StorageManager.buildDirectoryPath(fileSystem, filepathTmp[0], ((SnapshotDataspaceTable)this.getBaseTable()).getSTable().name());
                        String metadataPath = StorageManager.getMetadataFilePath(fileSystem, filepathDirectory);
                        if (fileSystem.exists(metadataPath)) {
                            this.materializeFrom(session, this.getSnapshotDirectory(), false, false, false);
                            this.rebuildPrimaryKeyIfNeeded();
                        }
                    }
                }
                finally {
                    session.setSLFileSessionContext(slFileSessionContext);
                }
                this.rebuildPrimaryKeyIfNeeded();
                this.wasSuccessfullyLoaded = true;
            }
            catch (Exception exception) {
                this.setSnapshotException(exception);
                throw exception instanceof DataspaceException ? (DataspaceException)exception : new DataspaceException(exception);
            }
        }
    }

    private class AutosaveRunnable
    implements Runnable {
        private AutosaveRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            try (Session session = SnapshotCollection.this.dataspace.createSession();){
                SnapshotCollection.this.getBaseTable().store.readLock();
                SnapshotCollection.this.autosaveLock.lock();
                try {
                    ((SnapshotDataspaceTable)SnapshotCollection.this.table).materializeTo(session, SnapshotCollection.this.snapshotDirectory, SnapshotCollection.this.autosaveGeneration);
                    SnapshotCollection.this.lastAutosaveTime = System.currentTimeMillis();
                    SnapshotCollection.this.snapshotException = null;
                    Trace.logDebug(this, "Autosave snapshot table {} to {}, duration: {} ms", SnapshotCollection.this.getObjectName().getSchemaQualifiedStatementName(), SnapshotCollection.this.snapshotDirectory, SnapshotCollection.this.lastAutosaveTime - startTime);
                }
                finally {
                    SnapshotCollection.this.autosaveLock.unlock();
                    SnapshotCollection.this.getBaseTable().store.readUnlock();
                }
            }
            try {
                Trace.logDebug(this, "Scheduling next autosave for snapshot table {} in {} {}", SnapshotCollection.this.getObjectName().getSchemaQualifiedStatementName(), SnapshotCollection.this.autosaveInterval, SnapshotCollection.this.autosaveIntervalTimeUnit.name());
                SnapshotCollection.this.autosaveScheduledExecutor.schedule(new AutosaveRunnable(), SnapshotCollection.this.autosaveInterval, SnapshotCollection.this.autosaveIntervalTimeUnit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

