/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.map;

import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.tspace.map.MapCollection;
import com.streamscape.ds.schema.collection.tspace.map.ValueIterator;
import com.streamscape.ds.schema.collection.tspace.map.ValuesCollectionProxy;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import java.util.ArrayList;
import java.util.Collection;

public class ValuesCollection
implements AccessibleObject {
    protected MapCollection map = null;
    protected static String removeByValueSql = "DELETE FROM %s WHERE [Value]=?";
    protected Statement removeByValue = null;

    ValuesCollection(MapCollection map) {
        this.map = map;
    }

    public int size(Session session) {
        return (int)this.map.size(session);
    }

    public boolean isEmpty(Session session) {
        return this.map.isEmpty(session);
    }

    public boolean contains(Session session, Object value) {
        return this.map.containsValue(session, value);
    }

    public ValueIterator iterator(Session session) {
        return new ValueIterator(this.map, session);
    }

    public Object[] toArray(Session session) {
        ArrayList<Object> result = new ArrayList<Object>();
        ValueIterator iterator = this.iterator(session);
        while (iterator.hasNext(session)) {
            result.add(iterator.next(session));
        }
        return result.toArray();
    }

    public boolean remove(Session session, Object o) {
        if (this.removeByValue == null) {
            this.removeByValue = session.compileStatement(String.format(removeByValueSql, this.map.getObjectName().getSchemaQualifiedStatementName()), 0);
        }
        Result result = session.executeCompiledStatement(this.removeByValue, new Object[]{o});
        MapCollection.checkResultNotError(result);
        return result.isUpdateCount() && result.getUpdateCount() > 0;
    }

    public boolean containsAll(Session session, Collection c) {
        for (Object o : c) {
            if (this.contains(session, o)) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Session session, Collection c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(session, o);
        }
        return modified;
    }

    public boolean retainAll(Session session, Collection c) {
        boolean modified = false;
        ValueIterator iterator = this.iterator(session);
        while (iterator.hasNext(session)) {
            Object value = iterator.next(session);
            if (c.contains(value)) continue;
            iterator.remove(session);
            modified = true;
        }
        return modified;
    }

    public void clear(Session session) {
        this.map.clear(session);
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new ValuesCollectionProxy();
    }

    public boolean add(Session session, Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Session session, Collection c) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray(Session session, Object[] a) {
        return null;
    }
}

