/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.map;

import com.streamscape.Trace;
import com.streamscape.cli.ds.collection.Queue;
import com.streamscape.cli.ds.collection.Table;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.AbstractDataCollectionProxy;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractAccessibleObjectForCollectionsProxy;
import com.streamscape.sef.dispatcher.AccessibleObjectComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MapProxy
extends AbstractDataCollectionProxy
implements com.streamscape.cli.ds.collection.Map {
    @Override
    public Object take(Object key) {
        this.checkKeyNotNull("containsKey", key);
        return this.waitToTake(key, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object waitToTake(Object key) {
        this.checkKeyNotNull("containsKey", key);
        return this.waitToTake(key, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object waitToTake(Object key, long timeout, TimeUnit unit) {
        this.checkKeyNotNull("containsKey", key);
        return this.invokeCollectionsMethodWithReturn("waitToTake", Object.class, new Object[]{key, timeout, unit});
    }

    @Override
    public int size() {
        return this.invokeCollectionsMethodWithReturn("size", Long.class, new Object[0]).intValue();
    }

    @Override
    public boolean isEmpty() {
        return this.invokeCollectionsMethodWithReturn("isEmpty", Boolean.class, new Object[0]);
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkKeyNotNull("containsKey", key);
        return this.invokeCollectionsMethodWithReturn("containsKey", Boolean.class, key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.invokeCollectionsMethodWithReturn("containsValue", Boolean.class, value);
    }

    public Object get(Object key) {
        this.checkKeyNotNull("get", key);
        return this.invokeCollectionsMethodWithReturn("get", Object.class, key);
    }

    public Object put(Object key, Object value) {
        this.checkKeyNotNull("put", key);
        return this.invokeCollectionsMethodWithReturn("put", Object.class, key, value);
    }

    public Object remove(Object key) {
        this.checkKeyNotNull("remove", key);
        return this.invokeCollectionsMethodWithReturn("remove", Object.class, key);
    }

    @Override
    public void putAll(Map t) {
        this.checkArgumentNotNull("putAll", t);
        final Map ft = t;
        AbstractAccessibleObjectForCollectionsProxy.RemoteRequestExecutor<Integer> executor = new AbstractAccessibleObjectForCollectionsProxy.RemoteRequestExecutor<Integer>(){
            private Map map;
            {
                this.map = ft;
            }

            @Override
            public Integer objectNotProxy() {
                MapProxy.this.invokeCollectionsMethod("putAll", new Object[]{this.map});
                return 0;
            }

            @Override
            public Integer objectTheSame() {
                throw new DataspaceException("Specified map is the same.");
            }

            @Override
            public Integer objectInTheSameAccessor() {
                if (this.map instanceof MapProxy) {
                    this.objectInTheSameNode(((AccessibleObjectComponent)MapProxy.this.accessor).getComponentType(), ((AccessibleObjectComponent)MapProxy.this.accessor).getComponentName(), ((MapProxy)this.map).getCollectionName());
                } else {
                    this.objectNotProxy();
                }
                return 0;
            }

            @Override
            public Integer objectInTheSameNode(String componentType, String componentName, String collectionName) {
                return this.objectInTheSameSysplex("", componentType, componentName, collectionName);
            }

            @Override
            public Integer objectInTheSameSysplex(String nodeName, String componentType, String componentName, String collectionName) {
                MapProxy.this.invokeCollectionsMethod("putAll", new Object[]{nodeName, componentType, componentName, collectionName});
                return 0;
            }

            @Override
            public Integer objectInOtherSysplex(String nodeName, String componentType, String componentName, String collectionName) {
                Trace.logInfo(this, "Map '" + collectionName + "' passed to putAll method is not in current sysplex. Data will be transfered thru client.");
                this.map = new HashMap(this.map);
                return this.objectNotProxy();
            }
        };
        this.executeRemoteRequest(t, executor);
    }

    @Override
    public void clear() {
        this.invokeCollectionsMethod("clear", new Object[0]);
    }

    public Set<Object> keySet() {
        return this.invokeCollectionsMethodWithReturn("keySet", Set.class, new Object[0]);
    }

    public Collection<Object> values() {
        return this.invokeCollectionsMethodWithReturn("values", Collection.class, new Object[0]);
    }

    public Set<Map.Entry> entrySet() {
        return this.invokeCollectionsMethodWithReturn("entrySet", Set.class, new Object[0]);
    }

    @Override
    public RowSet toRowSet() {
        return this.invokeCollectionsMethodWithReturn("toRowSet", RowSet.class, new Object[0]);
    }

    @Override
    public Map<?, ?> toMap() {
        return this.invokeCollectionsMethodWithReturn("toMap", com.streamscape.cli.ds.collection.Map.class, new Object[0]);
    }

    @Override
    public java.util.Queue<?> toQueue() {
        return this.invokeCollectionsMethodWithReturn("toQueue", java.util.Queue.class, new Object[0]);
    }

    @Override
    public void fromRowSet(RowSet rowSet) {
        this.invokeCollectionsMethod("fromRowSet", rowSet);
    }

    @Override
    public void fromQueue(java.util.Queue<?> queue) {
        this.invokeCollectionsMethod("fromQueue", queue);
    }

    @Override
    public void drainFromQueue(java.util.Queue<?> queue) {
        this.invokeCollectionsMethod("drainFromQueue", queue);
    }

    @Override
    public void fromMap(Map<?, ?> map) {
        this.invokeCollectionsMethod("fromMap", map);
    }

    @Override
    public Table toTableCollection() {
        return this.invokeCollectionsMethodWithReturn("toTableCollection", Table.class, new Object[0]);
    }

    @Override
    public com.streamscape.cli.ds.collection.Map toMapCollection() {
        return this.invokeCollectionsMethodWithReturn("toMapCollection", com.streamscape.cli.ds.collection.Map.class, new Object[0]);
    }

    @Override
    public Queue toQueueCollection() {
        return this.invokeCollectionsMethodWithReturn("toQueueCollection", Queue.class, new Object[0]);
    }

    private void checkKeyNotNull(String operation, Object key) {
        if (key == null) {
            throw new DataspaceException("Null key not allowed in map, operaton '" + operation + "'.");
        }
    }
}

