/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.map;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.qspace.AbstractQueueCollection;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueCollection;
import com.streamscape.ds.schema.collection.tspace.map.EntrySet;
import com.streamscape.ds.schema.collection.tspace.map.KeySet;
import com.streamscape.ds.schema.collection.tspace.map.MapProxy;
import com.streamscape.ds.schema.collection.tspace.map.ValuesCollection;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class MapCollection
extends AbstractCollection
implements AccessibleObject {
    public static final String KEY_COLUMN = "Key";
    public static final String VALUE_COLUMN = "Value";
    protected Type keyColumnType = null;
    protected String keyColumnTypeName = null;
    protected String keyColumnName = null;
    protected Type valueColumnType = null;
    protected String valueColumnTypeName = null;
    protected String valueColumnName = null;
    protected Statement putValue = null;
    protected Statement updateValue = null;
    protected Statement getValue = null;
    protected Statement containsValue = null;
    protected Statement containsKey = null;
    protected Statement querySize = null;
    protected Statement invokeClear = null;
    protected Statement remove = null;
    protected Statement keyValues = null;
    protected String putValueSql = "INSERT INTO %s VALUES(?,?)";
    protected String updateValueSql = "UPDATE %s SET [Value] = ? WHERE [Key] = ?";
    protected String getValueSql = "SELECT [Value] FROM %s WHERE [Key] = ?";
    protected String containsKeySql = "SELECT TRUE FROM %s WHERE [Key] = ?";
    protected String containsValueSql = "SELECT TRUE FROM %s WHERE [Value] = ?";
    protected String querySizeSql = "SELECT COUNT(*) AS SIZE FROM %s";
    protected String invokeClearSql = "TRUNCATE COLLECTION %s";
    protected String removeSql = "DELETE FROM %s WHERE [Key] = ?";
    protected String keyValuesSql = "SELECT [Key] FROM %s";

    public MapCollection(DataspaceStore database, NameManager.ObjectName name, MemoryModel memoryModel) {
        super(database, name, CollectionType.MAP, memoryModel);
    }

    @Override
    public String getCollectionSQL(boolean forReplication) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (this.keyColumnType != null) {
            sb.append(this.keyColumnType.getTypeDefinition());
        } else {
            sb.append(this.keyColumnTypeName);
        }
        sb.append(",");
        if (this.valueColumnType != null) {
            sb.append(this.valueColumnType.getTypeDefinition());
        } else {
            sb.append(this.valueColumnTypeName);
        }
        sb.append(")");
        return sb.toString();
    }

    public void defineKeyColumn(Type columnType, String typeName) {
        this.keyColumnName = KEY_COLUMN;
        this.keyColumnType = columnType;
        this.keyColumnTypeName = typeName;
    }

    public void defineValueColumn(Type columnType, String typeName) {
        this.valueColumnName = VALUE_COLUMN;
        this.valueColumnType = columnType;
        this.valueColumnTypeName = typeName;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        NameManager.ObjectName internalTableName = this.store.nameManager.newObjectName(this.name.name, this.name.isNameQuoted, 3);
        internalTableName.schema = this.name.schema;
        this.table = TableUtil.newTable(this.store, this.getInternalTableType(this.memoryModel), internalTableName);
        this.addColumn(this.table, this.keyColumnName, this.keyColumnType, false);
        this.addColumn(this.table, this.valueColumnName, this.valueColumnType);
        NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(internalTableName.name, internalTableName.isNameQuoted, 21);
        this.table.createPrimaryKeyConstraint(name, new int[]{0}, false);
        this.table.compile(session, parentObject);
    }

    @Override
    public void compileInternalStatements(Session session) {
        String SQL = null;
        SQL = String.format(this.putValueSql, this.table.getObjectName().getSchemaQualifiedStatementName());
        this.putValue = session.compileStatement(SQL, 0);
        SQL = String.format(this.getValueSql, this.table.getObjectName().getSchemaQualifiedStatementName());
        this.getValue = session.compileStatement(SQL, 0);
        SQL = String.format(this.updateValueSql, this.table.getObjectName().getSchemaQualifiedStatementName());
        this.updateValue = session.compileStatement(SQL, 0);
        SQL = String.format(this.querySizeSql, this.table.getObjectName().getSchemaQualifiedStatementName());
        this.querySize = session.compileStatement(SQL, 0);
        SQL = String.format(this.invokeClearSql, this.table.getObjectName().getSchemaQualifiedStatementName());
        this.invokeClear = session.compileStatement(SQL, 0);
        SQL = String.format(this.containsKeySql, this.table.getObjectName().getSchemaQualifiedStatementName());
        this.containsKey = session.compileStatement(SQL, 0);
        SQL = String.format(this.containsValueSql, this.table.getObjectName().getSchemaQualifiedStatementName());
        this.containsValue = session.compileStatement(SQL, 0);
        SQL = String.format(this.removeSql, this.table.getObjectName().getSchemaQualifiedStatementName());
        this.remove = session.compileStatement(SQL, 0);
        SQL = String.format(this.keyValuesSql, this.table.getObjectName().getSchemaQualifiedStatementName());
        this.keyValues = session.compileStatement(SQL, 0);
    }

    public Result put(Session session, PersistentStore store, Object[] data) {
        Result result = this.putInsert(session, data);
        if (result.isError() && result.getErrorCode() == -104) {
            result = this.putUpdate(session, data);
        }
        return result;
    }

    private Result putInsert(Session session, Object[] data) {
        data = SqlUtils.prepareDataForInsert(session, this.putValue, data);
        return session.executeCompiledStatement(this.putValue, data);
    }

    private Result putUpdate(Session session, Object[] data) {
        Object[] updateData = new Object[data.length];
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            updateData[i] = data[length - i - 1];
        }
        Result result = session.executeCompiledStatement(this.updateValue, updateData);
        if (!result.isError() && this.table.triggerLists[Trigger.Type.INSERT_AFTER_ROW.ordinal()].length > 0) {
            this.table.fireTriggers(session, Trigger.Type.INSERT_AFTER_ROW, null, data, null);
        }
        return result;
    }

    public Object put(Session session, Object key, Object value) {
        Object[] resultValues;
        Object[] data = SqlUtils.prepareDataForInsert(session, this.getValue, new Object[]{key});
        Result result = session.executeCompiledStatement(this.getValue, data);
        MapCollection.checkResultNotError(result);
        if (result.isData() && result.navigator.first() && (resultValues = SqlUtils.processDataFromQuery(session, result, result.navigator.getCurrent())) != null && resultValues.length > 0) {
            result = this.putUpdate(session, new Object[]{key, value});
            MapCollection.checkResultNotError(result);
            MapCollection.checkUpdateCountIs(result, 1);
            return resultValues[0];
        }
        result = this.putInsert(session, new Object[]{key, value});
        MapCollection.checkResultNotError(result);
        MapCollection.checkUpdateCountIs(result, 1);
        return null;
    }

    public Object get(Session session, Object key) {
        Object[] resultValues;
        Object[] data = SqlUtils.prepareDataForInsert(session, this.getValue, new Object[]{key});
        Result result = session.executeCompiledStatement(this.getValue, data);
        MapCollection.checkResultNotError(result);
        if (result.isData() && result.navigator.first() && (resultValues = SqlUtils.processDataFromQuery(session, result, result.navigator.getCurrent())) != null && resultValues.length > 0) {
            return resultValues[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Session session, Object key) {
        boolean manualCommit = false;
        if (session.isAutoCommit()) {
            session.setAutoCommit(false);
            manualCommit = true;
        }
        try {
            if (!this.containsKey(session, key).booleanValue()) {
                Object var4_4 = null;
                return var4_4;
            }
            Object currentObject = this.get(session, key);
            Result result = session.executeCompiledStatement(this.remove, new Object[]{key});
            MapCollection.checkResultNotError(result);
            if (!result.isError() && result.getUpdateCount() > 0) {
                Object object = currentObject;
                return object;
            }
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            if (manualCommit) {
                session.commit(false);
                session.setAutoCommit(true);
            }
        }
    }

    public long size(Session session) {
        Result result = session.executeCompiledStatement(this.querySize, new Object[0]);
        MapCollection.checkResultNotError(result);
        if (result.isData() && result.navigator.first()) {
            return (Long)result.navigator.getCurrent(0);
        }
        throw new DataspaceException("Failed to get map size, size query returned no data.");
    }

    public Result valuesWithResultSet(Session session) {
        ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.OTHER});
        metaData.columnLabels = new String[]{"VALUES"};
        metaData.columns = new ColumnBase[1];
        ColumnBase column = new ColumnBase("", "", "", "");
        column.setType(Type.STRING);
        metaData.columns[0] = column;
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        Result response = Result.newDataResult(metaData);
        response.setNavigator(navigator);
        response.getNavigator().add(new Object[]{new OtherTypeWrapper(new ValuesCollection(this))});
        return response;
    }

    public ValuesCollection values(Session session) {
        return new ValuesCollection(this);
    }

    public Result keySetWithResult(Session session) {
        ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.OTHER});
        metaData.columnLabels = new String[]{"KEY_SET"};
        metaData.columns = new ColumnBase[1];
        ColumnBase column = new ColumnBase("", "", "", "");
        column.setType(Type.STRING);
        metaData.columns[0] = column;
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        Result response = Result.newDataResult(metaData);
        response.setNavigator(navigator);
        response.getNavigator().add(new Object[]{new OtherTypeWrapper(new KeySet(this))});
        return response;
    }

    public KeySet keySet(Session session) {
        return new KeySet(this);
    }

    public Result entrySetWithResult(Session session) {
        ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.OTHER});
        metaData.columnLabels = new String[]{"ENTRY_SET"};
        metaData.columns = new ColumnBase[1];
        ColumnBase column = new ColumnBase("", "", "", "");
        column.setType(Type.STRING);
        metaData.columns[0] = column;
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        Result response = Result.newDataResult(metaData);
        response.setNavigator(navigator);
        response.getNavigator().add(new Object[]{new OtherTypeWrapper(new EntrySet(this))});
        return response;
    }

    public EntrySet entrySet(Session session) {
        return new EntrySet(this);
    }

    public Result hashCode(Session session) {
        return Result.updateZeroResult;
    }

    public void putAll(Session session, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(session, entry.getKey(), entry.getValue());
        }
    }

    public void putAll(final Session session, String nodeName, String componentType, String componentName, String collectionName) {
        AbstractCollection.CollectionDelegate<Boolean, Map> delegate = new AbstractCollection.CollectionDelegate<Boolean, Map>(){

            @Override
            public Boolean delegate(Map collection, DataspaceAccessor accessor) throws DataspaceComponentException {
                MapCollection.this.putAll(session, collection);
                return true;
            }
        };
        this.executeWithRemoteCollection(nodeName, componentType, componentName, collectionName, delegate, Map.class);
    }

    public Result clearWithResult(Session session) {
        return session.executeCompiledStatement(this.invokeClear, new Object[0]);
    }

    public void clear(Session session) {
        Result result = this.clearWithResult(session);
        MapCollection.checkResultNotError(result);
    }

    public boolean isEmpty(Session session) {
        return this.size(session) == 0L;
    }

    public Result equals(Session session, Object[] params) {
        return Result.updateZeroResult;
    }

    public Result containsKeyWithResult(Session session, Object[] params) {
        ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_BOOLEAN});
        metaData.columnLabels = new String[]{"CONTAINS"};
        metaData.columns = new ColumnBase[1];
        ColumnBase column = new ColumnBase("", "", "", "");
        column.setType(Type.STRING);
        metaData.columns[0] = column;
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        Result response = Result.newDataResult(metaData);
        response.setNavigator(navigator);
        response.getNavigator().add(new Object[]{this.containsKey(session, params[0])});
        return response;
    }

    public Boolean containsKey(Session session, Object key) {
        Result result = session.executeCompiledStatement(this.containsKey, new Object[]{key});
        MapCollection.checkResultNotError(result);
        if (result.navigator != null && !result.isError()) {
            return result.navigator.next();
        }
        return Boolean.FALSE;
    }

    public Result containsValueWithResult(Session session, Object[] params) {
        ResultMetaData metaData = ResultMetaData.newSimpleResultMetaData(new Type[]{Type.SQL_BOOLEAN});
        metaData.columnLabels = new String[]{"CONTAINS"};
        metaData.columns = new ColumnBase[1];
        ColumnBase column = new ColumnBase("", "", "", "");
        column.setType(Type.STRING);
        metaData.columns[0] = column;
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        Result response = Result.newDataResult(metaData);
        response.setNavigator(navigator);
        response.getNavigator().add(new Object[]{this.containsValue(session, params[0])});
        return response;
    }

    public Boolean containsValue(Session session, Object value) {
        Result result = session.executeCompiledStatement(this.containsValue, new Object[]{value});
        MapCollection.checkResultNotError(result);
        if (result.navigator != null && !result.isError()) {
            return result.navigator.next();
        }
        return Boolean.FALSE;
    }

    public Object[] keyArray(Session session) {
        Result result = session.executeCompiledStatement(this.keyValues, new Object[0]);
        MapCollection.checkResultNotError(result);
        if (result.isData()) {
            ArrayList<Object> resultCollection = new ArrayList<Object>();
            while (result.navigator.next()) {
                Object[] resultValues = SqlUtils.processDataFromQuery(session, result, result.navigator.getCurrent());
                resultCollection.add(resultValues[0]);
            }
            return resultCollection.toArray();
        }
        throw new DataspaceException("Failed to get map keys, keys query returned no data.");
    }

    public Object waitToTake(Session session, Object key, long timeout, TimeUnit unit) {
        String dfetchSql = this.makeDfetchSql(VALUE_COLUMN, "Key = ?", "delete row", "", timeout, unit);
        Statement dfetchStat = session.compileStatement(dfetchSql);
        Object[] data = SqlUtils.prepareDataForInsert(session, dfetchStat, new Object[]{key});
        Result result = session.executeCompiledStatement(dfetchStat, data);
        MapCollection.checkResultNotError(result);
        MapCollection.checkResultIsData(result);
        RowSetNavigator rowSet = result.navigator;
        if (rowSet.next()) {
            return rowSet.getCurrent(0);
        }
        return null;
    }

    public RowSet toRowSet(Session session) {
        RowMetaData meta = SqlUtils.getCollectionMeta(this);
        RowSet rowSet = new RowSet(meta);
        Type[] columnTypes = this.table.colTypes;
        int columnCount = this.table.getColumnCount();
        RowIterator it = this.table.rowIteratorClustered(session);
        try {
            while (it.hasNext()) {
                Object[] data = new Object[columnCount];
                Row row = it.getNextRow();
                Object[] currentData = row.getData();
                for (int i = 0; i < columnCount; ++i) {
                    if (columnTypes[i].isLobType()) {
                        if (!(currentData[i] instanceof BlobDataID)) continue;
                        try {
                            data[i] = SqlUtils.extractBlob(session, (BlobDataID)currentData[i]);
                        }
                        catch (Exception error) {
                            Trace.logError(this, "Unable to extract LOB object. " + error.getMessage());
                        }
                        continue;
                    }
                    data[i] = columnTypes[i].convertSQLToJava(session, currentData[i]);
                }
                rowSet.addToRowSet(data);
            }
        }
        catch (SQLException error) {
            throw new DataspaceException("Unable to convert collection to RowSet. " + error.getMessage());
        }
        finally {
            if (it != null) {
                it.release();
            }
        }
        return rowSet;
    }

    public void fromRowSet(Session session, RowSet rowSet) {
        try {
            rowSet.beforeFirst();
        }
        catch (Exception error) {
            throw new DataspaceException("Unable to scroll to the begining of rowset.");
        }
        if (rowSet.getMeta().getColumnCount() != this.table.getColumnCount()) {
            Trace.logError(this, "Number of columns in rowset " + rowSet.getMeta().getColumnCount() + " does not match number of columns " + this.table.getColumnCount() + " in transient table.");
            return;
        }
        Type[] rowSetTypes = new Type[rowSet.getMeta().getColumnCount()];
        for (int i = 0; i < rowSet.getMeta().getColumnCount(); ++i) {
            String columnName = null;
            try {
                columnName = rowSet.getMeta().getColumnName(i + 1);
                rowSetTypes[i] = Types.getParameterSQLType(session, rowSet.getMeta().getColumnTypeClass(i + 1));
            }
            catch (Exception error) {
                throw new DataspaceException("Unable to resolve data type for rowset column " + String.valueOf(columnName == null ? Integer.valueOf(i) : columnName) + ".");
            }
            if (rowSetTypes[i] != null) continue;
            throw new DataspaceException("Unable to resolve data type for rowset column " + String.valueOf(columnName == null ? Integer.valueOf(i) : columnName) + ".");
        }
        PersistentStore store = this.table.getRowStore(session);
        Type[] tableTypes = this.table.getColumnTypes();
        try {
            while (rowSet.next()) {
                Object[] rowData = SqlUtils.getDataForInsert(session, this.table, rowSet.getCurrentRow().getRawData(), tableTypes, rowSetTypes);
                this.table.insertSingleRow(session, store, rowData, null);
            }
        }
        catch (SQLException error) {
            Trace.logError(this, "Unable to load data from rowset into transient table. " + error.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<?> toQueue(Session session) {
        LinkedList<Object> queue;
        block11: {
            queue = new LinkedList<Object>();
            RowIterator it = null;
            int columnCount = this.table.getColumnCount();
            Type[] columnTypes = this.table.colTypes;
            Object[] data = null;
            try {
                it = this.table.rowIteratorClustered(session);
                if (columnCount == 1) {
                    try {
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                            queue.add(data[0]);
                        }
                        break block11;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Queue. " + error.getMessage());
                    }
                }
                RowMetaData meta = SqlUtils.getCollectionMeta(this);
                try {
                    while (it.hasNext()) {
                        com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                        Row row = it.getNextRow();
                        data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                        newRow.setRawData(data);
                        queue.add(newRow);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to convert collection to Queue. " + error.getMessage());
                }
            }
            finally {
                if (it != null) {
                    it.release();
                    it = null;
                }
            }
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromQueue(Session session, Queue<?> queue) {
        if (this.table.getColumnCount() > 2) {
            Trace.logError(this, "Table could not be loaded from queue. Number of columns mismatch (one or two columns expected).");
            throw new DataspaceException("Number of columns mismatch. One or two columns expected.");
        }
        if (queue instanceof AbstractQueueCollection) {
            Table table = ((AbstractQueueCollection)((Object)queue)).getBaseTable();
            PersistentStore tableStore = this.table.getRowStore(session);
            RowIterator iter = table.rowIteratorClustered(session);
            try {
                while (iter.hasNext()) {
                    Object[] data = iter.getNext();
                    this.table.insertSingleRow(session, tableStore, data, null);
                }
            }
            finally {
                if (iter != null) {
                    iter.release();
                    iter = null;
                }
            }
        } else {
            int columnCount = this.table.getColumnCount();
            Type[] queueTypes = new Type[columnCount];
            Class<?> elemClass = null;
            PersistentStore store = this.table.getRowStore(session);
            Type[] tableTypes = this.table.getColumnTypes();
            if (columnCount == 2) {
                queueTypes[0] = tableTypes[0];
            }
            int elemIndex = columnCount - 1;
            for (Object element : queue) {
                if (queueTypes[elemIndex] == null || element.getClass() != elemClass) {
                    queueTypes[elemIndex] = this.resolveType(session, session);
                    elemClass = element.getClass();
                }
                Object[] rowData = new Object[columnCount];
                rowData[elemIndex] = element;
                rowData = SqlUtils.getDataForInsert(session, this.table, rowData, tableTypes, queueTypes);
                this.table.insertSingleRow(session, store, rowData, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainFromQueue(Session session, Queue<?> queue) {
        this.fromQueue(session, queue);
        if (queue instanceof AbstractQueueCollection) {
            AbstractQueueCollection queueCollection = (AbstractQueueCollection)((Object)queue);
            PersistentStore store = queueCollection.getBaseTable().getRowStore(session);
            RowIterator it = queueCollection.getBaseTable().getPrimaryIndex().firstRow(store);
            try {
                while (it.hasNext()) {
                    Row row = it.getNextRow();
                    session.addDeleteAction((Table)row.getTable(), row, null);
                }
            }
            finally {
                it.release();
            }
        } else {
            queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<?, ?> toMap(Session session) {
        HashMap<Object, Object> map;
        block15: {
            map = new HashMap<Object, Object>();
            RowIterator it = null;
            int columnCount = this.table.getColumnCount();
            Type[] columnTypes = this.table.colTypes;
            Object[] data = null;
            try {
                it = this.table.rowIteratorClustered(session);
                if (columnCount == 2) {
                    try {
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                            map.put(data[0], data[1]);
                        }
                        break block15;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map. " + error.getMessage());
                    }
                }
                RowMetaData meta = SqlUtils.getCollectionMeta(this);
                if (this.table.getPrimaryKey().length == 1) {
                    Object key = null;
                    try {
                        while (it.hasNext()) {
                            com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                            Row row = it.getNextRow();
                            data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                            newRow.setRawData(data);
                            key = data[this.table.getPrimaryKey()[0]];
                            map.put(key, newRow);
                        }
                        break block15;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map. " + error.getMessage());
                    }
                }
                long sequence = -1L;
                try {
                    while (it.hasNext()) {
                        com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                        Row row = it.getNextRow();
                        data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                        newRow.setRawData(data);
                        map.put(++sequence, newRow);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to convert collection to Map. " + error.getMessage());
                }
            }
            finally {
                if (it != null) {
                    it.release();
                    it = null;
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromMap(Session session, Map<?, ?> map) {
        if (this.table.getColumnCount() != 2) {
            Trace.logError(this, "Table could not be loaded from map. Number of columns mismatch (two columns expected).");
            throw new DataspaceException("Number of columns mismatch. Two columns expected.");
        }
        if (map instanceof MapCollection) {
            Table table = ((MapCollection)((Object)map)).getBaseTable();
            PersistentStore tableStore = this.table.getRowStore(session);
            RowIterator iter = table.rowIteratorClustered(session);
            try {
                while (iter.hasNext()) {
                    Object[] data = iter.getNext();
                    this.table.insertSingleRow(session, tableStore, data, null);
                }
            }
            finally {
                if (iter != null) {
                    iter.release();
                    iter = null;
                }
            }
        } else {
            Type[] mapDsTypes = new Type[2];
            Class[] mapTypes = new Class[2];
            PersistentStore store = this.table.getRowStore(session);
            Type[] tableTypes = this.table.getColumnTypes();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (mapDsTypes[0] == null || entry.getKey().getClass() != mapTypes[0]) {
                    mapDsTypes[0] = this.resolveType(session, entry.getKey());
                    mapTypes[0] = entry.getKey().getClass();
                }
                if (mapDsTypes[1] == null || entry.getValue().getClass() != mapTypes[1]) {
                    mapDsTypes[1] = this.resolveType(session, entry.getValue());
                    mapTypes[1] = entry.getValue().getClass();
                }
                Object[] rowData = SqlUtils.getDataForInsert(session, this.table, new Object[]{entry.getKey(), entry.getValue()}, tableTypes, mapDsTypes);
                this.table.insertSingleRow(session, store, rowData, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCollection toTableCollection(Session session) {
        NameManager.ObjectName name = this.store.nameManager.newObjectName("TEMP_TABLE_" + System.currentTimeMillis(), false, 4);
        name.schema = SqlInvariants.MODULE_NAME;
        TableCollection collection = new TableCollection(this.store, name, MemoryModel.MEMORY, 12);
        Table baseTable = collection.getBaseTable();
        Table newBaseTable = collection.getBaseTable();
        for (int i = 0; i < baseTable.getColumnCount(); ++i) {
            newBaseTable.addColumn(baseTable.getColumn(i));
        }
        newBaseTable.createPrimaryKey();
        session.sessionContext.addSessionCollection(collection);
        collection.compile(session, null);
        collection.compileInternalStatements(session);
        int columnCount = this.table.getColumnCount();
        RowIterator it = this.table.rowIteratorClustered(session);
        PersistentStore tableStore = collection.getBaseTable().getRowStore(session);
        try {
            while (it.hasNext()) {
                Object[] data = new Object[columnCount];
                Row row = it.getNextRow();
                Object[] currentData = row.getData();
                System.arraycopy(currentData, 0, data, 0, columnCount);
                collection.getBaseTable().insertSingleRow(session, tableStore, data, null);
            }
        }
        finally {
            if (it != null) {
                it.release();
            }
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromTable(Session session, TableCollection table) {
        if (table.getBaseTable().getColumnCount() != this.table.getColumnCount()) {
            Trace.logError(this, "Number of columns in provided table " + table.getBaseTable().getColumnCount() + " does not match number of columns " + this.table.getColumnCount() + " in current table.");
            throw new DataspaceException("Number of columns mismatch.");
        }
        PersistentStore tableStore = this.table.getRowStore(session);
        RowIterator iter = table.getBaseTable().rowIteratorClustered(session);
        try {
            while (iter.hasNext()) {
                Object[] data = iter.getNext();
                this.table.insertSingleRow(session, tableStore, data, null);
            }
        }
        finally {
            if (iter != null) {
                iter.release();
                iter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapCollection toMapCollection(Session session) {
        MapCollection collection;
        block17: {
            NameManager.ObjectName name = this.store.nameManager.newObjectName("TEMP_MAP_" + System.currentTimeMillis(), false, 4);
            name.schema = SqlInvariants.MODULE_NAME;
            collection = new MapCollection(session.dataspaceStore, name, MemoryModel.MEMORY);
            session.sessionContext.addSessionCollection(collection);
            RowIterator it = null;
            int columnCount = this.table.getColumnCount();
            Type[] columnTypes = this.table.colTypes;
            Object[] data = null;
            try {
                it = this.table.rowIteratorClustered(session);
                if (columnCount == 2) {
                    collection.defineKeyColumn(columnTypes[0], columnTypes[0].getNameString());
                    collection.defineValueColumn(columnTypes[1], columnTypes[1].getNameString());
                    collection.compile(session, null);
                    collection.compileInternalStatements(session);
                    try {
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                            collection.getBaseTable().insertSingleRow(session, collection.getBaseTable().getRowStore(session), row.getData(), null);
                        }
                        break block17;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map collection. " + error.getMessage());
                    }
                }
                RowMetaData meta = SqlUtils.getCollectionMeta(this);
                if (this.table.getPrimaryKey().length == 1) {
                    Type columnType = columnTypes[this.table.getPrimaryKey()[0]];
                    collection.defineKeyColumn(columnType, columnType.getNameString());
                } else {
                    collection.defineKeyColumn(Type.LONG, Type.LONG.getNameString());
                }
                Type valueType = Types.getParameterSQLType(session, com.streamscape.sdo.rowset.Row.class);
                collection.defineValueColumn(valueType, valueType.getNameString());
                collection.compile(session, null);
                collection.compileInternalStatements(session);
                if (this.table.getPrimaryKey().length == 1) {
                    Object key = null;
                    try {
                        while (it.hasNext()) {
                            com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                            Row row = it.getNextRow();
                            data = row.getData();
                            newRow.setRawData(data);
                            key = data[this.table.getPrimaryKey()[0]];
                            Object[] currentRow = new Object[]{key, new OtherTypeWrapper(newRow)};
                            collection.getBaseTable().insertSingleRow(session, collection.getBaseTable().getRowStore(session), currentRow, null);
                        }
                        break block17;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map collection. " + error.getMessage());
                    }
                }
                long sequence = -1L;
                try {
                    while (it.hasNext()) {
                        com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                        Row row = it.getNextRow();
                        data = row.getData();
                        newRow.setRawData(data);
                        Object[] currentRow = new Object[]{++sequence, new OtherTypeWrapper(newRow)};
                        collection.getBaseTable().insertSingleRow(session, collection.getBaseTable().getRowStore(session), currentRow, null);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to convert collection to Map collection. " + error.getMessage());
                }
            }
            finally {
                if (it != null) {
                    it.release();
                    it = null;
                }
            }
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockingQueueCollection toQueueCollection(Session session) {
        BlockingQueueCollection collection;
        block11: {
            NameManager.ObjectName name = this.store.nameManager.newObjectName("TEMP_QUEUE_" + System.currentTimeMillis(), false, 4);
            name.schema = SqlInvariants.MODULE_NAME;
            collection = new BlockingQueueCollection(session.dataspaceStore, name, MemoryModel.MEMORY);
            Type queueElementType = null;
            session.sessionContext.addSessionCollection(collection);
            RowIterator it = null;
            int columnCount = this.table.getColumnCount();
            Type[] columnTypes = this.table.colTypes;
            Object[] data = null;
            queueElementType = columnCount == 1 ? columnTypes[0] : Types.getParameterSQLType(session, com.streamscape.sdo.rowset.Row.class);
            collection.setConstraint(queueElementType);
            collection.compile(session, null);
            collection.compileInternalStatements(session);
            try {
                it = this.table.rowIteratorClustered(session);
                if (columnCount == 1) {
                    try {
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            collection.add(session, row.getData()[0]);
                        }
                        break block11;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Queue collection. " + error.getMessage());
                    }
                }
                RowMetaData meta = SqlUtils.getCollectionMeta(this);
                try {
                    while (it.hasNext()) {
                        com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                        Row row = it.getNextRow();
                        data = row.getData();
                        newRow.setRawData(data);
                        collection.add(session, newRow);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to convert collection to Queue collection. " + error.getMessage());
                }
            }
            finally {
                if (it != null) {
                    it.release();
                    it = null;
                }
            }
        }
        return collection;
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new MapProxy();
    }

    public long getSerialVersionUID() {
        return 0L;
    }

    public static enum QueryOperation {
        ENTRY_SET,
        HASH_CODE,
        KEY_SET,
        VALUES,
        SIZE;

    }

    public static enum InvokeOperation {
        CLEAR,
        CONTAINS_KEY,
        CONTAINS_VALUE,
        EQUALS,
        IS_EMPTY,
        PUT_ALL,
        REMOVE;

    }
}

