/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.map;

import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.tspace.map.Entry;
import com.streamscape.ds.schema.collection.tspace.map.EntryIterator;
import com.streamscape.ds.schema.collection.tspace.map.EntrySetProxy;
import com.streamscape.ds.schema.collection.tspace.map.MapCollection;
import com.streamscape.ds.schema.collection.tspace.map.MapEntry;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import java.util.Collection;
import java.util.Map;

public class EntrySet
implements AccessibleObject {
    protected MapCollection map = null;
    protected Statement containsEntry = null;
    protected Statement removeEntry = null;
    protected static String containsEntrySql = "SELECT TRUE FROM %s WHERE [Key]=? AND [Value]=?";
    protected static String removeEntrySql = "DELETE FROM %s WHERE [Key]=? AND [Value]=?";

    EntrySet(MapCollection map) {
        this.map = map;
    }

    public int size(Session session) {
        return (int)this.map.size(session);
    }

    public boolean isEmpty(Session session) {
        return this.map.isEmpty(session);
    }

    public boolean contains(Session session, Object o) {
        if (o instanceof Entry) {
            o = new MapEntry(((Entry)o).key, ((Entry)o).value);
        }
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)o;
        if (this.containsEntry == null) {
            this.containsEntry = session.compileStatement(String.format(containsEntrySql, this.map.getObjectName().getSchemaQualifiedStatementName()), 0);
        }
        Result result = session.executeCompiledStatement(this.containsEntry, new Object[]{entry.getKey(), entry.getValue()});
        MapCollection.checkResultNotError(result);
        if (result.navigator != null && !result.isError()) {
            return result.navigator.next();
        }
        return Boolean.FALSE;
    }

    public EntryIterator iterator(Session session) {
        return new EntryIterator(this.map, session);
    }

    public Object[] toArray(Session session) {
        Object[] result = new Object[this.size(session)];
        EntryIterator iterator = this.iterator(session);
        int i = 0;
        while (iterator.hasNext(session)) {
            result[i++] = iterator.next(session);
        }
        return result;
    }

    public boolean add(Session session, Map.Entry o) {
        if (this.contains(session, o)) {
            return false;
        }
        this.map.put(session, o.getKey(), o.getValue());
        return true;
    }

    public boolean remove(Session session, Object o) {
        if (o instanceof Entry) {
            o = new MapEntry(((Entry)o).key, ((Entry)o).value);
        }
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)o;
        if (this.removeEntry == null) {
            this.removeEntry = session.compileStatement(String.format(removeEntrySql, this.map.getObjectName().getSchemaQualifiedStatementName()), 0);
        }
        Result result = session.executeCompiledStatement(this.removeEntry, new Object[]{entry.getKey(), entry.getValue()});
        MapCollection.checkResultNotError(result);
        return result.isUpdateCount() && result.getUpdateCount() > 0;
    }

    public boolean containsAll(Session session, Collection<?> c) {
        for (Object o : c) {
            if (this.contains(session, o)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Session session, Collection<? extends Map.Entry> c) {
        boolean modified = false;
        for (Map.Entry entry : c) {
            if (!(entry instanceof Map.Entry)) continue;
            modified |= this.add(session, entry);
        }
        return modified;
    }

    public boolean removeAll(Session session, Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            if (!(o instanceof Map.Entry)) continue;
            modified |= this.remove(session, (Map.Entry)o);
        }
        return modified;
    }

    public void clear(Session session) {
        this.map.clear(session);
    }

    public boolean retainAll(Session session, Collection<?> c) {
        boolean modified = false;
        EntryIterator iterator = this.iterator(session);
        while (iterator.hasNext(session)) {
            Entry entry = iterator.next(session);
            if (c.contains(entry)) continue;
            modified |= this.remove(session, entry);
        }
        return modified;
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new EntrySetProxy();
    }

    public <T> T[] toArray(Session session, T[] a) {
        throw new UnsupportedOperationException();
    }
}

