/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.map;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.tspace.map.EntryProxy;
import com.streamscape.ds.schema.collection.tspace.map.MapCollection;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import java.util.Map;

public class Entry
implements AccessibleObject {
    protected Object key = null;
    protected Object value = null;
    private MapCollection map;

    Entry(MapCollection map, Object key, Object value) {
        this.map = map;
        this.key = key;
        this.value = value;
    }

    Entry(MapCollection map, Object[] row) {
        this(map, row[0], row[1]);
    }

    public Object getKey(Session session) {
        return this.key;
    }

    public Object getValue(Session session) {
        return this.value;
    }

    public Object setValue(Session session, Object value) {
        if (!this.map.containsKey(session, this.key).booleanValue()) {
            throw new DataspaceException("Entry with key '" + String.valueOf(this.key) + "' doesn't exist.");
        }
        Object oldValue = this.map.put(session, this.key, value);
        this.value = value;
        return oldValue;
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new EntryProxy();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)o;
        return (entry.getKey() == this.key || entry.getKey() != null && this.key != null && entry.getKey().equals(this.key)) && (entry.getValue() == this.value || entry.getValue() != null && this.value != null && entry.getValue().equals(this.value));
    }

    public int hashCode() {
        return (this.key != null ? this.key.hashCode() : 0) ^ (this.value != null ? this.value.hashCode() : 0);
    }

    public final String toString() {
        return String.valueOf(this.key) + "=" + String.valueOf(this.value);
    }

    public int hashCode(Session session) {
        return this.hashCode();
    }

    public final String toString(Session session) {
        return this.toString();
    }
}

