/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.etable;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.schema.collection.AbstractCollectionFactoryImpl;
import com.streamscape.ds.schema.collection.tspace.etable.EventTableFactory;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.enums.EventScope;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class EventTableFactoryImpl
extends AbstractCollectionFactoryImpl {
    public static final String CONSTRAINT_PROPERTY = "Constraint";
    public static final String EXCLUDE_PROPERTY_LIST = "ExcludePropertyList";
    public static final String INCLUDE_PROPERTY_LIST = "IncludePropertyList";
    public static final String WITH_SOURCE_EVENT = "WithSourceEvent";
    public static final String SOURCE_EVENT_AS_BLOB = "SourceEventAsBlob";
    public static final String CONSUMER = "Consumer";
    public static final String SELECTOR = "Selector";
    public static final String ASYNC_CONSUMER = "IsConsumerAsync";
    public static final String EVENT_SCOPE = "EventScope";
    public static final String PRIMARY_KEY_COLUMNS = "PrimaryKeyColumns";
    public static final String WINDOW_TYPE = "WindowType";
    public static final String WINDOW_SIZE = "WindowSize";
    public static final String TIME_WINDOW_UNIT = "TimeWindowUnit";
    public static final String WINDOW_CHECK_INTERVAL = "WindowCheckInterval";
    public static final String WINDOW_CHECK_INTERVAL_UNIT = "WindowCheckIntervalUnit";

    public EventTableFactoryImpl() {
        super(CollectionType.EVENT_TABLE);
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new EventTableFactory();
    }

    public void setConstraint(Session session, String eventId) {
        this.properties.put(CONSTRAINT_PROPERTY, eventId);
    }

    public String getConstraint(Session session) {
        return (String)this.properties.get(CONSTRAINT_PROPERTY);
    }

    public void setEventScope(Session session, EventScope eventScope) {
        this.properties.put(EVENT_SCOPE, eventScope.toString());
    }

    public EventScope getEventScope(Session session) {
        try {
            return EventScope.valueOf((String)this.properties.get(EVENT_SCOPE));
        }
        catch (Exception exception) {
            return EventScope.OBSERVABLE;
        }
    }

    public String getSelector(Session session) {
        return (String)this.properties.get(SELECTOR);
    }

    public void setSelector(Session session, String selector) {
        this.properties.put(SELECTOR, selector);
    }

    public boolean isConsumer(Session session) {
        return Boolean.parseBoolean((String)this.properties.get(CONSUMER));
    }

    public void setIsConsumer(Session session, boolean isConsumer) {
        this.properties.put(CONSUMER, "" + isConsumer);
    }

    public boolean isConsumerAsync(Session session) {
        return Boolean.parseBoolean((String)this.properties.get(ASYNC_CONSUMER));
    }

    public void setIsConsumerAsync(Session session, boolean isConsumerAsync) {
        if (isConsumerAsync) {
            this.setIsConsumer(session, true);
        }
        this.properties.put(ASYNC_CONSUMER, "" + isConsumerAsync);
    }

    public void setExcludedProperties(Session session, List<String> eventProps) {
        StringBuilder buffer = new StringBuilder();
        if (eventProps != null) {
            boolean first = true;
            for (String property : eventProps) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(property);
            }
        }
        this.properties.put(EXCLUDE_PROPERTY_LIST, buffer.toString());
    }

    public List<String> getExcludedProperties(Session session) {
        ArrayList<String> result = new ArrayList<String>();
        String props = (String)this.properties.get(EXCLUDE_PROPERTY_LIST);
        if (props != null) {
            for (String prop : props.split(",")) {
                if (prop.trim().length() <= 0) continue;
                result.add(prop);
            }
        }
        return result;
    }

    public void setIncludedProperties(Session session, List<String> eventProps) {
        StringBuilder buffer = new StringBuilder();
        if (eventProps != null) {
            boolean first = true;
            for (String property : eventProps) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(property);
            }
        }
        this.properties.put(INCLUDE_PROPERTY_LIST, buffer.toString());
    }

    public List<String> getIncludedProperties(Session session) {
        ArrayList<String> result = new ArrayList<String>();
        String props = (String)this.properties.get(INCLUDE_PROPERTY_LIST);
        if (props != null) {
            for (String prop : props.split(",")) {
                if (prop.trim().length() <= 0) continue;
                result.add(prop);
            }
        }
        return result;
    }

    public void setPrimaryKeyColumns(Session session, List<String> columns) {
        StringBuilder buffer = new StringBuilder();
        if (columns != null) {
            boolean first = true;
            for (String column : columns) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(column);
            }
        }
        this.properties.put(PRIMARY_KEY_COLUMNS, buffer.toString());
    }

    public List<String> getPrimaryKeyColumns(Session session) {
        ArrayList<String> result = new ArrayList<String>();
        String columns = (String)this.properties.get(PRIMARY_KEY_COLUMNS);
        if (columns != null) {
            for (String prop : columns.split(",")) {
                if (prop.trim().length() <= 0) continue;
                result.add(prop);
            }
        }
        return result;
    }

    public boolean isSourceEventIncluded(Session session) {
        return Boolean.parseBoolean((String)this.properties.get(WITH_SOURCE_EVENT));
    }

    public void setSourceEventIncluded(Session session, boolean include) {
        this.properties.put(WITH_SOURCE_EVENT, "" + include);
    }

    public void setSourceEventAsBlob(Session session, boolean sourceEventAsBlob) {
        this.properties.put(SOURCE_EVENT_AS_BLOB, "" + sourceEventAsBlob);
    }

    public boolean isSourceEventAsBlob(Session session) {
        return Boolean.parseBoolean((String)this.properties.get(SOURCE_EVENT_AS_BLOB));
    }

    public CollectionWindowType getWindowType(Session session) {
        return this.properties.get(WINDOW_TYPE) != null ? CollectionWindowType.valueOf((String)this.properties.get(WINDOW_TYPE)) : null;
    }

    public void setWindowType(Session session, CollectionWindowType type) {
        this.properties.put(WINDOW_TYPE, type.name());
        if (type == CollectionWindowType.BATCH_SIZE_WINDOW || type == CollectionWindowType.SLIDING_SIZE_WINDOW) {
            this.properties.put(TIME_WINDOW_UNIT, null);
        }
    }

    public long getWindowSize(Session session) {
        return this.properties.get(WINDOW_SIZE) != null ? Long.valueOf((String)this.properties.get(WINDOW_SIZE)) : 0L;
    }

    public void setWindowSize(Session session, long size) {
        this.properties.put(WINDOW_SIZE, Long.toString(size));
    }

    public TimeUnit getTimeWindowUnit(Session session) {
        return this.properties.get(TIME_WINDOW_UNIT) != null ? TimeUnit.valueOf((String)this.properties.get(TIME_WINDOW_UNIT)) : null;
    }

    public void setTimeWindowUnit(Session session, TimeUnit unit) {
        this.properties.put(TIME_WINDOW_UNIT, unit.name());
    }

    public long getWindowCheckInterval(Session session) {
        return this.properties.get(WINDOW_CHECK_INTERVAL) != null ? Long.valueOf((String)this.properties.get(WINDOW_CHECK_INTERVAL)) : 0L;
    }

    public void setWindowCheckInterval(Session session, long interval) {
        this.properties.put(WINDOW_CHECK_INTERVAL, Long.toString(interval));
    }

    public TimeUnit getWindowCheckIntervalUnit(Session session) {
        return this.properties.get(WINDOW_CHECK_INTERVAL_UNIT) != null ? TimeUnit.valueOf((String)this.properties.get(WINDOW_CHECK_INTERVAL_UNIT)) : null;
    }

    public void setWindowCheckIntervalUnit(Session session, TimeUnit unit) {
        this.properties.put(WINDOW_CHECK_INTERVAL_UNIT, unit.name());
    }

    @Override
    public String getCreateSql(Session session, String name) {
        CollectionWindowType collectionWindowType;
        List<String> primaryKeyColumns;
        List<String> excludeProperties;
        StringBuilder operation = new StringBuilder();
        operation.append("create ").append(this.getMemoryModel(session).name());
        operation.append(" event table [").append(name).append(']');
        operation.append(" constrained by [").append(this.getConstraint(session)).append(']');
        List<String> includeProperties = this.getIncludedProperties(session);
        if (includeProperties != null && includeProperties.size() > 0) {
            operation.append(' ').append("INCLUDE").append(' ').append("PROPERTIES").append(' ');
            operation.append("(");
            boolean first = true;
            for (String string : includeProperties) {
                if (!first) {
                    operation.append(",");
                } else {
                    first = false;
                }
                operation.append(string);
            }
            operation.append(")");
        }
        if ((excludeProperties = this.getExcludedProperties(session)) != null && excludeProperties.size() > 0) {
            operation.append(' ').append("EXCLUDE").append(' ').append("PROPERTIES").append(' ');
            operation.append("(");
            boolean first = true;
            for (String string : excludeProperties) {
                if (!first) {
                    operation.append(",");
                } else {
                    first = false;
                }
                operation.append(string);
            }
            operation.append(")");
        }
        if ((primaryKeyColumns = this.getPrimaryKeyColumns(session)) != null && primaryKeyColumns.size() > 0) {
            operation.append(' ').append("PRIMARY").append(' ').append("KEY").append(' ');
            operation.append("(");
            boolean bl = true;
            for (String key : primaryKeyColumns) {
                boolean bl2;
                if (!bl2) {
                    operation.append(",");
                } else {
                    bl2 = false;
                }
                operation.append(key);
            }
            operation.append(")");
        }
        if (this.isSourceEventIncluded(session)) {
            operation.append(" with source event");
            if (this.isSourceEventAsBlob(session)) {
                operation.append(" as blob");
            }
        }
        if (this.isConsumer(session)) {
            if (this.isConsumerAsync(session)) {
                operation.append(" async");
            }
            operation.append(" consumer");
            if (this.getEventScope(session) != null) {
                operation.append(" event scope ").append(this.getEventScope(session).toString());
            }
            if (this.getSelector(session) != null && !this.getSelector(session).isEmpty()) {
                operation.append(" when (").append(this.getSelector(session)).append(")");
            }
        }
        if ((collectionWindowType = this.getWindowType(session)) != null) {
            operation.append(" ");
            switch (collectionWindowType) {
                case SLIDING_SIZE_WINDOW: {
                    operation.append(' ').append("SLIDING");
                    operation.append(' ').append("SIZE");
                    break;
                }
                case SLIDING_TIME_WINDOW: {
                    operation.append(' ').append("SLIDING");
                    operation.append(' ').append("TIME");
                    break;
                }
                case BATCH_SIZE_WINDOW: {
                    operation.append(' ').append("BATCH");
                    operation.append(' ').append("SIZE");
                    break;
                }
                case BATCH_TIME_WINDOW: {
                    operation.append(' ').append("BATCH");
                    operation.append(' ').append("TIME");
                }
            }
            operation.append(" window ").append(this.getWindowSize(session));
            TimeUnit timeUnit = this.getTimeWindowUnit(session);
            if (timeUnit != null) {
                operation.append(" ");
                SqlUtils.timeUnitToString(operation, timeUnit);
            }
            long windowCheckInterval = this.getWindowCheckInterval(session);
            if (collectionWindowType == CollectionWindowType.SLIDING_TIME_WINDOW && windowCheckInterval > 0L) {
                operation.append(' ').append("CHECK").append(' ').append("INTERVAL");
                operation.append(' ').append(this.getWindowCheckInterval(session));
                TimeUnit unit = this.getWindowCheckIntervalUnit(session);
                if (unit != null) {
                    operation.append(" ");
                    SqlUtils.timeUnitToString(operation, unit);
                }
            }
        }
        return operation.toString();
    }
}

