/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.tspace.etable;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.collection.tspace.etable.EventTableProxy;
import com.streamscape.ds.schema.collection.tspace.etable.FabricEventSinkFactoryImpl;
import com.streamscape.ds.schema.collection.tspace.etable.FabricEventSourceFactoryImpl;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.schema.table.TableWorks;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.trigger.window.BatchSizeTableWindowTrigger;
import com.streamscape.ds.trigger.window.BatchTimeTableWindowTrigger;
import com.streamscape.ds.trigger.window.CollectionWindowTrigger;
import com.streamscape.ds.trigger.window.SlidingSizeTableWindowTrigger;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.EventPropertiesMapper;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.ds.utils.TableSlidingTimeWindowChecker;
import com.streamscape.ds.utils.WindowCollection;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricEventSinkException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.IllegalConsumerStateException;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.service.osf.config.ActiveEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class EventTableCollection
extends TableCollection
implements FabricEventListener,
WindowCollection {
    protected EventPropertiesMapper eventPropertiesMapper = null;
    protected String eventId = null;
    protected String selector = null;
    protected boolean withSourceEvent = false;
    protected boolean isSourceEventBlob = false;
    protected boolean isConsumer = false;
    protected boolean isConsumerAsync = false;
    protected EventScope eventScope = EventScope.OBSERVABLE;
    protected Session internalSession = null;
    protected List<String> includeProps = null;
    protected List<String> excludeProps = null;
    protected List<String> primaryKeyColumns = null;
    protected boolean isStarted = false;
    protected TriggerDef windowTrigger = null;
    protected CollectionWindowType windowType = null;
    protected long windowSize = 0L;
    protected TimeUnit timeWindowUnit = null;
    protected long windowCheckInterval = 1000L;
    protected TimeUnit windowCheckIntervalUnit = null;
    protected FabricThread<?> windowCheckThread = null;
    protected JSerializer serializer;
    protected Statement pushElementStat = null;
    protected Statement updateElementStat = null;
    protected Statement deleteElementStat = null;
    protected Statement checkForExistence = null;
    protected Statement readElementNoSelectorStat = null;
    private long nextSlidingTimeWindowCheckerTime;
    private int lastSlidingTimeWindowDeletedRows;
    private long lastSlidingTimeWindowCheckerTime;
    private int consumerMaxDepth;
    private EventConsumer consumer;
    private List<AdditionalColumn> additionalColumns;

    public EventTableCollection(DataspaceStore database, NameManager.ObjectName name, MemoryModel memoryModel, String eventId, String selector, List<String> includeProps, List<String> excludeProps, boolean withSourceEvent, boolean isSourceEventBlob, boolean isConsumer, boolean isConsumerAsync, int consumerMaxDepth, List<String> primaryKeyColumns) {
        super(database, name, CollectionType.EVENT_TABLE, memoryModel);
        this.eventId = eventId;
        this.selector = selector;
        this.includeProps = includeProps;
        this.excludeProps = excludeProps;
        this.primaryKeyColumns = primaryKeyColumns;
        this.isConsumer = isConsumer;
        this.isConsumerAsync = isConsumerAsync;
        this.withSourceEvent = withSourceEvent;
        this.isSourceEventBlob = isSourceEventBlob;
        this.consumerMaxDepth = consumerMaxDepth;
        try {
            JSerializerFactory serializerFactory = this.runtimeCtx.getJSerializerFactory();
            this.serializer = serializerFactory.createSerializer("EventTable" + name.name + "Serializer");
        }
        catch (Exception error) {
            Trace.logException(EventTableCollection.class, error, true);
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setEventScope(EventScope eventScope) {
        this.eventScope = eventScope;
    }

    public EventScope getEventScope() {
        return this.eventScope;
    }

    @Override
    public CollectionWindowType getWindowType() {
        return this.windowType;
    }

    public void setWindowType(CollectionWindowType windowType) {
        this.windowType = windowType;
    }

    @Override
    public long getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(long windowSize) {
        this.windowSize = windowSize;
    }

    @Override
    public TimeUnit getTimeWindowUnit() {
        return this.timeWindowUnit;
    }

    public void setTimeWindowUnit(TimeUnit timeWindowUnit) {
        this.timeWindowUnit = timeWindowUnit;
    }

    public long getWindowCheckInterval() {
        return this.windowCheckInterval;
    }

    public void setWindowCheckInterval(long interval) {
        this.windowCheckInterval = interval;
    }

    public TimeUnit getWindowCheckIntervalUnit() {
        return this.windowCheckIntervalUnit;
    }

    public void setWindowCheckIntervalUnit(TimeUnit unit) {
        this.windowCheckIntervalUnit = unit;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        this.initEventMapper();
        NameManager.ObjectName internalTableName = this.store.nameManager.newObjectName(this.name.name, this.name.isNameQuoted, 3);
        internalTableName.schema = this.name.schema;
        this.table = TableUtil.newTable(this.store, this.getInternalTableType(this.memoryModel), internalTableName);
        this.addIdentityColumn(this.table, "SeqId", Type.SQL_INTEGER);
        this.eventPropertiesMapper.addPropertyColumns(this.table);
        this.addColumn(this.table, "Created", Type.SQL_TIMESTAMP);
        if (this.withSourceEvent) {
            if (this.isSourceEventBlob) {
                this.addColumn(this.table, "Event", Type.SQL_BLOB);
            } else {
                this.addColumn(this.table, "Event", Type.EVENT);
            }
        }
        if (this.additionalColumns != null && this.additionalColumns.size() > 0) {
            for (AdditionalColumn additionalColumn : this.additionalColumns) {
                this.addColumn(this.table, additionalColumn.columnName, additionalColumn.columnType, true, additionalColumn.defaultExpr);
            }
        }
        NameManager.ObjectName primaryKeyName = NameManager.newInfoSchemaObjectName(internalTableName.name, internalTableName.isNameQuoted, 21);
        this.table.createPrimaryKeyConstraint(primaryKeyName, new int[]{0}, false);
        this.table.compile(session, parentObject);
        if (this.primaryKeyColumns != null && !session.isProcessingLog()) {
            NameManager.ObjectName primaryKeyUniqueIndexName = this.store.nameManager.newAutoName(this.getPrimaryKeyIndexNamePrefix(), this.table.getObjectName().schema, this.table.getObjectName(), 21);
            TableWorks tableWorks = new TableWorks(session, this.table);
            tableWorks.addIndex(this.eventPropertiesMapper.getPrimaryKeyColumnIndices(1), primaryKeyUniqueIndexName, true, null);
        }
        if (this.windowType != null) {
            this.activateWindow(session, internalTableName);
        }
    }

    private String getPrimaryKeyIndexNamePrefix() {
        return this.table.getObjectName().name + "_UI";
    }

    public void updatePrimaryKeyColumns(Session session, List<String> primaryKeyColumnsNew) {
        if (!session.isProcessingLog()) {
            if (primaryKeyColumnsNew != null) {
                for (String pkCol : primaryKeyColumnsNew) {
                    if (this.table.findColumn(pkCol) != -1) continue;
                    throw new DataspaceException("Primary key column '" + pkCol + "' doesn't exist in table.");
                }
            }
            TableWorks tableWorks = new TableWorks(session, this.table);
            Index primaryKeyIndex = Arrays.stream(this.table.getIndexList()).filter(i -> i.getObjectName().name.startsWith(NameManager.escapeNewAutoNamePrefix(this.getPrimaryKeyIndexNamePrefix()))).findAny().orElse(null);
            if (primaryKeyIndex != null) {
                tableWorks.dropIndex(primaryKeyIndex.getObjectName().name);
            }
            this.primaryKeyColumns = primaryKeyColumnsNew != null ? new ArrayList<String>(primaryKeyColumnsNew) : null;
            this.initEventMapper();
            if (primaryKeyColumnsNew != null) {
                NameManager.ObjectName primaryKeyUniqueIndexName = this.store.nameManager.newAutoName(this.getPrimaryKeyIndexNamePrefix(), this.table.getObjectName().schema, this.table.getObjectName(), 21);
                tableWorks.addIndex(this.eventPropertiesMapper.getPrimaryKeyColumnIndices(1), primaryKeyUniqueIndexName, true, null);
            }
            this.compileInternalStatements(session);
        }
    }

    @Override
    public void compileInternalStatements(Session session) {
        String SQL = null;
        SQL = "insert into " + this.name.getSchemaQualifiedStatementName() + "(" + this.eventPropertiesMapper.getColumnsNames() + "  Created" + (this.withSourceEvent ? ",Event" : "") + ")values (" + this.eventPropertiesMapper.getParamsList() + (this.withSourceEvent ? "?," : "") + "?)";
        this.pushElementStat = session.compileStatement(SQL);
        if (this.primaryKeyColumns != null) {
            SQL = "update " + this.name.getSchemaQualifiedStatementName() + " set " + this.eventPropertiesMapper.getNotPrimaryKeyColumnNamesWithParams() + (this.withSourceEvent ? ",Event=?" : "") + " where " + this.eventPropertiesMapper.getPrimaryKeyColumnNamesWithParams().replaceAll(",", " AND ");
            this.updateElementStat = session.compileStatement(SQL);
            SQL = "select 1 from " + this.name.getSchemaQualifiedStatementName() + " where " + this.eventPropertiesMapper.getPrimaryKeyColumnNamesWithParams().replaceAll(",", " AND ");
            this.checkForExistence = session.compileStatement(SQL);
        }
        String primaryKeyColumnsWithParams = this.eventPropertiesMapper.getPrimaryKeyColumnNamesWithParams().replaceAll(",", " AND ");
        String notPrimaryKeyColumnsWithParams = this.eventPropertiesMapper.getNotPrimaryKeyColumnNamesWithParams().replaceAll(",", " AND ");
        Object allColumnsWithParams = null;
        if (primaryKeyColumnsWithParams != null && primaryKeyColumnsWithParams.length() > 0) {
            allColumnsWithParams = primaryKeyColumnsWithParams;
        }
        if (notPrimaryKeyColumnsWithParams != null && notPrimaryKeyColumnsWithParams.length() > 0) {
            allColumnsWithParams = allColumnsWithParams == null ? notPrimaryKeyColumnsWithParams : (String)allColumnsWithParams + " and " + notPrimaryKeyColumnsWithParams;
        }
        if (primaryKeyColumnsWithParams != null && primaryKeyColumnsWithParams.length() > 0) {
            SQL = "delete from " + this.name.getSchemaQualifiedStatementName() + " where " + primaryKeyColumnsWithParams;
            this.deleteElementStat = session.compileStatement(SQL);
        } else if (allColumnsWithParams != null) {
            SQL = "delete from " + this.name.getSchemaQualifiedStatementName() + " where " + (String)allColumnsWithParams;
            this.deleteElementStat = session.compileStatement(SQL);
        } else if (this.withSourceEvent) {
            SQL = this.isSourceEventBlob ? "delete from " + this.name.getSchemaQualifiedStatementName() + " where fromBinary(Event) = ?" : "delete from " + this.name.getSchemaQualifiedStatementName() + " where Event = ?";
            this.deleteElementStat = session.compileStatement(SQL);
        }
        if (this.withSourceEvent) {
            SQL = "select top 1 SeqId, Event from " + this.name.getSchemaQualifiedStatementName();
            this.readElementNoSelectorStat = session.compileStatement(SQL);
        }
        if (this.store.getStoreState().isStarted()) {
            this.open(session);
        }
    }

    @Override
    public void open(Session session) {
        super.open(session);
        if (this.isConsumer && !this.isStarted) {
            try {
                if (this.isConsumerAsync) {
                    EventAsyncConsumer consumer = this.dataspace.createEventAsyncConsumer("TSPACE_" + this.name.name + "_ASYNC_LISTENER", this, this.eventId, this.selector, this.eventScope, false);
                    if (this.consumerMaxDepth > 0) {
                        consumer.setMaxDepth(this.consumerMaxDepth);
                    }
                    consumer.start();
                    this.dataspace.addSinkEventFlow(EventFlowEntity.DATASPACE_EVENT_TABLE, this.name.name, consumer);
                    this.consumer = consumer;
                } else {
                    EventConsumer consumer = this.dataspace.createEventConsumer("TSPACE_" + this.name.name + "_LISTENER", this, this.eventId, this.selector, this.eventScope, false);
                    this.dataspace.addSinkEventFlow(EventFlowEntity.DATASPACE_EVENT_TABLE, this.name.name, consumer);
                    this.consumer = consumer;
                }
                Trace.logDebug(this, "Event Table '" + this.name.name + "' has been registered as consumer of '" + this.eventId + "' events.");
            }
            catch (FabricEventDispatcherException | IllegalConsumerStateException error) {
                throw new DataspaceException("Unable to register '" + this.name.name + "' table as consumer.", error);
            }
            this.isStarted = true;
        }
        if (this.windowCheckThread != null) {
            this.windowCheckThread.start();
        }
    }

    public void start(Session session) {
        this.open(session);
    }

    public void stop(Session session) {
        this.close();
    }

    protected void initEventMapper() {
        this.eventPropertiesMapper = new EventPropertiesMapper(this.eventId, this.includeProps, this.excludeProps, this);
        this.eventPropertiesMapper.setPrimaryKeyColumns(this.primaryKeyColumns);
        this.eventPropertiesMapper.compile(this);
    }

    public void activateWindow(Session session, NameManager.ObjectName internalTableName) {
        NameManager.ObjectName windowTriggerName = NameManager.newInfoSchemaObjectName(internalTableName.name + "_window", internalTableName.isNameQuoted, 9);
        switch (this.windowType) {
            case SLIDING_SIZE_WINDOW: {
                this.windowTrigger = new SlidingSizeTableWindowTrigger(windowTriggerName, this, this.windowSize);
                break;
            }
            case SLIDING_TIME_WINDOW: {
                TableSlidingTimeWindowChecker checker = new TableSlidingTimeWindowChecker(this.dataspace, this, SqlUtils.getTimeIntervalInMillis(this.windowSize, this.timeWindowUnit), SqlUtils.getTimeIntervalInMillis(this.windowCheckInterval, this.windowCheckIntervalUnit), this.windowType);
                this.windowCheckThread = FabricThreadManager.getInstance().createThread(this.name.name + "WindowCheck", "Time Window check thread.", checker);
                break;
            }
            case BATCH_SIZE_WINDOW: {
                this.windowTrigger = new BatchSizeTableWindowTrigger(windowTriggerName, this, this.windowSize);
                break;
            }
            case BATCH_TIME_WINDOW: {
                this.windowTrigger = new BatchTimeTableWindowTrigger(windowTriggerName, this, SqlUtils.getTimeIntervalInMillis(this.windowSize, this.timeWindowUnit));
            }
        }
        if (this.windowTrigger != null) {
            this.table.addTrigger(session, this.windowTrigger, windowTriggerName, 0);
            this.windowTrigger.compile(session, this);
        }
    }

    public void startWindow() {
        if (this.windowCheckThread != null) {
            this.windowCheckThread.start();
        }
    }

    public boolean removeWindow() {
        if (this.windowType != null) {
            if (this.windowCheckThread != null) {
                this.windowCheckThread.stop();
                this.windowCheckThread = null;
            }
            if (this.windowTrigger != null) {
                this.table.removeTrigger(this.windowTrigger);
                ((CollectionWindowTrigger)this.windowTrigger).destroy();
                this.windowTrigger = null;
            }
            return true;
        }
        return false;
    }

    protected void checkIncommingEventMatchesContstraint(ImmutableEventDatagram event) {
        if (this.eventId == null || this.eventId.length() == 0) {
            return;
        }
        if (event.getEventId() == null || !event.getEventId().equalsIgnoreCase(this.eventId)) {
            throw new DataspaceException("Incompatible event types. Table constrained by [" + this.eventId + "], while given event with id [" + event.getEventId() + "].");
        }
    }

    protected void putEventIntoTable(Session session, ImmutableEventDatagram element) {
        this.checkIncommingEventMatchesContstraint(element);
        try {
            int columnCount = 0;
            ++columnCount;
            if (this.withSourceEvent) {
                ++columnCount;
            }
            Object[] params = new Object[columnCount += this.eventPropertiesMapper.getColumnsCount()];
            int index = -1;
            index = this.eventPropertiesMapper.setColumnValues(session, element, params, index, this.dataspace);
            params[++index] = session.getCurrentSqlTimestamp();
            try {
                if (this.withSourceEvent) {
                    if (this.isSourceEventBlob) {
                        byte[] serializedBlob = this.serializer.serialize(element);
                        params[++index] = SqlUtils.allocateBlob(session, serializedBlob);
                    } else {
                        params[++index] = new OtherTypeWrapper(element);
                    }
                }
            }
            catch (IAbstractExceptionEvent error) {
                Trace.logException(this, error, true);
                throw new DataspaceException("Unable to set event column. " + error.getMessage());
            }
            ImmutableEventDatagram current = session.sessionContext.currentCollectionEventForTrigger;
            session.sessionContext.currentCollectionEventForTrigger = element;
            Result result = session.executeCompiledStatement(this.pushElementStat, params);
            session.sessionContext.currentCollectionEventForTrigger = current;
            EventTableCollection.checkResultNotError(result);
            EventTableCollection.checkUpdateCountIs(result, 1);
        }
        catch (SQLException error) {
            Trace.logException(EventTableCollection.class, error, true);
            throw new DataspaceException(error.getMessage());
        }
    }

    protected boolean updateEventInTable(Session session, ImmutableEventDatagram element) {
        this.checkIncommingEventMatchesContstraint(element);
        try {
            int columnCount = 0;
            columnCount += this.eventPropertiesMapper.getNotPrimaryKeyColumnsCount();
            if (this.withSourceEvent) {
                ++columnCount;
            }
            Object[] params = new Object[columnCount += this.eventPropertiesMapper.getPrimaryKeyColumnsCount()];
            int index = -1;
            index = this.eventPropertiesMapper.setNotPrimaryKeyColumnValues(session, element, params, index, this.dataspace);
            try {
                if (this.withSourceEvent) {
                    if (this.isSourceEventBlob) {
                        byte[] serializedBlob = this.serializer.serialize(element);
                        params[++index] = SqlUtils.allocateBlob(session, serializedBlob);
                    } else {
                        params[++index] = new OtherTypeWrapper(element);
                    }
                }
            }
            catch (IAbstractExceptionEvent error) {
                Trace.logException(this, error, true);
                throw new DataspaceException("Unable to set event column. " + error.getMessage());
            }
            index = this.eventPropertiesMapper.setPrimaryKeyColumnValues(session, element, params, index, this.dataspace);
            ImmutableEventDatagram current = session.sessionContext.currentCollectionEventForTrigger;
            session.sessionContext.currentCollectionEventForTrigger = element;
            Result result = session.executeCompiledStatement(this.updateElementStat, params);
            session.sessionContext.currentCollectionEventForTrigger = current;
            EventTableCollection.checkResultNotError(result);
            return result.getUpdateCount() == 1;
        }
        catch (SQLException error) {
            Trace.logException(EventTableCollection.class, error, true);
            throw new DataspaceException(error.getMessage());
        }
    }

    protected boolean deleteEventFromTable(Session session, ImmutableEventDatagram element) {
        if (this.deleteElementStat == null) {
            throw new DataspaceException("Delete operations allowed if at least one event property, or primary key or with event source specified.");
        }
        try {
            boolean wholeEvent = false;
            int columnCount = 0;
            columnCount = this.eventPropertiesMapper.getPrimaryKeyColumnsCount() > 0 ? (columnCount += this.eventPropertiesMapper.getPrimaryKeyColumnsCount()) : (columnCount += this.eventPropertiesMapper.getNotPrimaryKeyColumnsCount());
            if (columnCount == 0 && this.withSourceEvent) {
                wholeEvent = true;
                ++columnCount;
            }
            Object[] params = new Object[columnCount];
            int index = -1;
            if (!wholeEvent) {
                index = this.eventPropertiesMapper.getPrimaryKeyColumnsCount() > 0 ? this.eventPropertiesMapper.setPrimaryKeyColumnValues(session, element, params, index, this.dataspace) : this.eventPropertiesMapper.setNotPrimaryKeyColumnValues(session, element, params, index, this.dataspace);
            } else if (this.withSourceEvent) {
                params[++index] = new OtherTypeWrapper(element);
            }
            Result result = session.executeCompiledStatement(this.deleteElementStat, params);
            EventTableCollection.checkResultNotError(result);
            return result.getUpdateCount() != 1;
        }
        catch (Exception error) {
            Trace.logException(EventTableCollection.class, error, true);
            throw new DataspaceException(error.getMessage());
        }
    }

    protected boolean checkEventExistenceInTable(Session session, ImmutableEventDatagram element) {
        if (this.primaryKeyColumns == null || this.primaryKeyColumns.size() <= 0) {
            return false;
        }
        try {
            int columnCount = this.eventPropertiesMapper.getPrimaryKeyColumnsCount();
            Object[] params = new Object[columnCount];
            int index = -1;
            index = this.eventPropertiesMapper.setPrimaryKeyColumnValues(session, element, params, index, this.dataspace);
            Result result = session.executeCompiledStatement(this.checkForExistence, params);
            if (result.isError()) {
                return false;
            }
            if (result.isData() && result.navigator.first()) {
                return true;
            }
        }
        catch (SQLException error) {
            Trace.logException(EventTableCollection.class, error, true);
        }
        catch (Throwable error) {
            error.printStackTrace();
        }
        return false;
    }

    @Override
    public synchronized void onEvent(ImmutableEventDatagram event) throws FabricEventException {
        if (this.internalSession == null || this.internalSession.isClosed()) {
            this.internalSession = this.dataspace.createSession();
        }
        try {
            this.putEventIntoTableOrUpdate(this.internalSession, event);
        }
        catch (DataspaceException error) {
            throw new FabricEventException(error.getMessage());
        }
    }

    protected void putEventIntoTableOrUpdate(Session session, ImmutableEventDatagram event) {
        if (this.checkEventExistenceInTable(session, event)) {
            Trace.logDebug(EventTableCollection.class, "Existing event is updating in the table...");
            this.updateEventInTable(session, event);
            Trace.logDebug(EventTableCollection.class, "Event updated");
        } else {
            Trace.logDebug(EventTableCollection.class, "New event is inserted into the table...");
            this.putEventIntoTable(session, event);
            Trace.logDebug(EventTableCollection.class, "Event inserted.");
        }
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new EventTableProxy();
    }

    @Override
    public void destroy(Session session) {
        this.close();
    }

    @Override
    public void close() {
        if (this.windowCheckThread != null) {
            this.windowCheckThread.stop();
            this.windowCheckThread = null;
        }
        if (this.windowTrigger != null) {
            ((CollectionWindowTrigger)this.windowTrigger).destroy();
        }
        if (this.isConsumer && this.isStarted) {
            try {
                if (this.isConsumerAsync) {
                    this.dataspace.dropConsumer("TSPACE_" + this.name.name + "_ASYNC_LISTENER");
                } else {
                    this.dataspace.dropConsumer("TSPACE_" + this.name.name + "_LISTENER");
                }
                Trace.logDebug(this, "Event table '" + this.name.name + "' has been unregistered as consumer of '" + this.eventId + "' events.");
            }
            catch (FabricEventDispatcherException error) {
                throw new DataspaceException("Unable to unregister '" + this.name.name + "' queue as consumer. " + error.getMessage());
            }
            this.isStarted = false;
        }
    }

    @Override
    public String getSQLForReplication(String replicaName) {
        return this.getSQL(replicaName, true);
    }

    @Override
    public String getSQL() {
        return this.getSQL(this.getObjectName().getSchemaQualifiedStatementName(), false);
    }

    @Override
    public String getSQL(String name, boolean forReplication) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE").append(' ');
        builder.append(this.memoryModel.name()).append(' ');
        builder.append(EventTableCollection.getCollectionTypeName(this.getCollectionType()));
        builder.append(' ');
        builder.append(name);
        builder.append(' ');
        builder.append(this.getCollectionSQL(forReplication));
        return builder.toString();
    }

    @Override
    public String getCollectionSQL(boolean forReplication) {
        boolean first;
        StringBuilder buffer = new StringBuilder();
        buffer.append("CONSTRAINED").append(' ').append("BY").append(' ');
        buffer.append('\"').append(this.eventId).append('\"');
        if (this.includeProps != null && this.includeProps.size() > 0) {
            buffer.append(' ').append("INCLUDE").append(' ').append("PROPERTIES").append(' ');
            buffer.append("(");
            first = true;
            for (String prop : this.includeProps) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(prop);
            }
            buffer.append(")");
        }
        if (this.excludeProps != null && this.excludeProps.size() > 0) {
            buffer.append(' ').append("EXCLUDE").append(' ').append("PROPERTIES").append(' ');
            buffer.append("(");
            first = true;
            for (String prop : this.excludeProps) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(prop);
            }
            buffer.append(")");
        }
        if (this.primaryKeyColumns != null && this.primaryKeyColumns.size() > 0) {
            buffer.append(' ').append("PRIMARY").append(' ').append("KEY").append(' ');
            buffer.append("(");
            first = true;
            for (String key : this.primaryKeyColumns) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(key);
            }
            buffer.append(")");
        }
        if (this.withSourceEvent) {
            buffer.append(' ').append("WITH");
            buffer.append(' ').append("SOURCE");
            buffer.append(' ').append("EVENT");
            if (this.isSourceEventBlob) {
                buffer.append(' ').append("AS");
                buffer.append(' ').append("BLOB");
            }
        }
        if (this.isConsumer && !forReplication) {
            if (this.isConsumerAsync) {
                buffer.append(' ').append("ASYNC");
            }
            buffer.append(' ').append("CONSUMER");
            if (this.isConsumerAsync && this.consumerMaxDepth > 0) {
                buffer.append(' ').append("(").append(this.consumerMaxDepth).append(")");
            }
            if (this.eventScope != null && this.eventScope != EventScope.OBSERVABLE) {
                buffer.append(' ').append("EVENT").append(' ').append("SCOPE").append(' ').append(this.eventScope.toString());
            }
            if (this.selector != null) {
                buffer.append(' ').append("WHEN").append("(");
                buffer.append(this.selector).append(")");
            }
        }
        if (!forReplication) {
            this.appendWindowInformation(buffer);
        }
        if (this.additionalColumns != null && this.additionalColumns.size() > 0) {
            buffer.append(' ').append("ADD").append(' ').append("COLUMNS").append(' ');
            buffer.append("(");
            first = true;
            for (AdditionalColumn additionalColumn : this.additionalColumns) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append('[').append(additionalColumn.columnName).append(']').append(' ').append(additionalColumn.columnType.getTypeDefinition());
                if (additionalColumn.defaultExpr == null) continue;
                buffer.append(' ').append("DEFAULT").append(' ').append(additionalColumn.defaultExpr.getSQL());
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected void appendWindowInformation(StringBuilder buffer) {
        if (this.windowType != null) {
            switch (this.windowType) {
                case SLIDING_SIZE_WINDOW: {
                    buffer.append(' ').append("SLIDING");
                    buffer.append(' ').append("SIZE");
                    break;
                }
                case SLIDING_TIME_WINDOW: {
                    buffer.append(' ').append("SLIDING");
                    buffer.append(' ').append("TIME");
                    break;
                }
                case BATCH_SIZE_WINDOW: {
                    buffer.append(' ').append("BATCH");
                    buffer.append(' ').append("SIZE");
                    break;
                }
                case BATCH_TIME_WINDOW: {
                    buffer.append(' ').append("BATCH");
                    buffer.append(' ').append("TIME");
                }
            }
            buffer.append(' ').append("WINDOW");
            buffer.append(' ').append(this.windowSize);
            if (this.timeWindowUnit != null) {
                buffer.append(' ');
                SqlUtils.timeUnitToString(buffer, this.timeWindowUnit);
            }
            if (this.windowType == CollectionWindowType.SLIDING_TIME_WINDOW) {
                buffer.append(' ').append("CHECK").append(' ').append("INTERVAL").append(' ').append(this.windowCheckInterval);
                if (this.windowCheckIntervalUnit != null) {
                    buffer.append(' ');
                    SqlUtils.timeUnitToString(buffer, this.windowCheckIntervalUnit);
                }
            }
        }
    }

    @Override
    public ImmutableEventDatagram getEventForTrigger(Session session, Object[] oldData, Object[] newData, int when, int triggerType) {
        ImmutableEventDatagram event = null;
        if (!this.withSourceEvent) {
            return null;
        }
        try {
            int indexOfEventData = this.table.getColumnIndex("Event");
            if (triggerType == 50 && newData != null) {
                if (!this.isSourceEventBlob) {
                    event = (ImmutableEventDatagram)((OtherTypeWrapper)newData[indexOfEventData]).getObject();
                } else {
                    byte[] eventData = null;
                    BlobDataID blobId = (BlobDataID)newData[indexOfEventData];
                    eventData = SqlUtils.extractBlob(session, blobId);
                    event = (EventDatagram)this.serializer.deserialize(eventData);
                }
            } else if (triggerType == 82 && newData != null) {
                if (!this.isSourceEventBlob) {
                    event = (ImmutableEventDatagram)((OtherTypeWrapper)newData[indexOfEventData]).getObject();
                } else {
                    byte[] eventData = null;
                    BlobDataID blobId = (BlobDataID)newData[indexOfEventData];
                    eventData = SqlUtils.extractBlob(session, blobId);
                    event = (EventDatagram)this.serializer.deserialize(eventData);
                }
            } else if (triggerType == 19 && oldData != null) {
                if (!this.isSourceEventBlob) {
                    event = (ImmutableEventDatagram)((OtherTypeWrapper)oldData[indexOfEventData]).getObject();
                } else {
                    byte[] eventData = null;
                    BlobDataID blobId = (BlobDataID)oldData[indexOfEventData];
                    eventData = SqlUtils.extractBlob(session, blobId);
                    event = (EventDatagram)this.serializer.deserialize(eventData);
                }
            }
        }
        catch (JSerializerException error) {
            Trace.logError(EventTableCollection.class, error.getMessage());
        }
        catch (SQLException error) {
            Trace.logError(EventTableCollection.class, error.getMessage());
        }
        if (event != null) {
            this.prepareEventForOffer(event, this.eventId);
        }
        return event;
    }

    protected void prepareEventForOffer(ImmutableEventDatagram event, String eventId) {
        try {
            FabricEventSinkFactoryImpl.reset(event);
        }
        catch (FabricEventSinkException error) {
            Trace.logException(EventTableCollection.class, error, true);
        }
        if (event instanceof AbstractMutableEvent) {
            try {
                FabricEventSourceFactoryImpl.setEventId(event, eventId);
            }
            catch (SDOException error) {
                Trace.logException(EventTableCollection.class, error, true);
            }
            catch (FabricEventSourceException error) {
                Trace.logException(EventTableCollection.class, error, true);
            }
        }
    }

    public void delete(Session session, ImmutableEventDatagram event) {
        this.deleteEventFromTable(session, event);
    }

    public void insert(Session session, ImmutableEventDatagram event) {
        Trace.logDebug(EventTableCollection.class, "New event is going to be inserted into the table...");
        this.putEventIntoTable(session, event);
        Trace.logDebug(EventTableCollection.class, "Event inserted.");
    }

    public void upsert(Session session, ImmutableEventDatagram event) {
        this.putEventIntoTableOrUpdate(session, event);
    }

    @Override
    public Result getCollectionProperties(Session session) {
        Result result = super.getCollectionProperties(session);
        result.navigator.add(new Object[]{"State", this.isStarted ? "STARTED" : "STOPPED"});
        result.navigator.add(new Object[]{"Event", StringUtils.wrapEventId(this.eventId) + (String)(this.selector != null ? " when (" + this.selector + ")" : "")});
        result.navigator.add(new Object[]{"Consumer", this.isConsumer ? "TRUE" : "FALSE"});
        if (this.isConsumer) {
            result.navigator.add(new Object[]{"Consumer Type", this.isConsumerAsync ? "ASYNC" : "DIRECT"});
            if (this.isConsumerAsync && this.consumer != null && this.consumer instanceof EventAsyncConsumer) {
                result.navigator.add(new Object[]{"Consumer Max Depth", ((EventAsyncConsumer)this.consumer).getMaxDepth()});
                result.navigator.add(new Object[]{"Consumer Depth", ((EventAsyncConsumer)this.consumer).getCurrentDepth()});
            }
            result.navigator.add(new Object[]{"Event Scope", this.eventScope != null ? this.eventScope.toString() : "n/a"});
            result.navigator.add(new Object[]{"With Source Event", this.withSourceEvent ? "TRUE" : "FALSE"});
            if (this.withSourceEvent) {
                result.navigator.add(new Object[]{"Source Event Type", this.isSourceEventBlob ? "BLOB" : "EVENT"});
            }
        }
        result.navigator.add(new Object[]{"Primary Key Columns", this.primaryKeyColumns != null ? this.primaryKeyColumns : "[]"});
        if (this.windowType != null) {
            result.navigator.add(new Object[]{"Window Type", this.windowType.toString()});
            if (this.windowType == CollectionWindowType.BATCH_SIZE_WINDOW || this.windowType == CollectionWindowType.SLIDING_SIZE_WINDOW) {
                result.navigator.add(new Object[]{"Window Size", this.windowSize});
            } else {
                result.navigator.add(new Object[]{"Time Window", this.windowSize + " " + (this.timeWindowUnit != null ? ParserDQL.timeUnitToString(this.timeWindowUnit) : "sec")});
            }
            if (this.windowType == CollectionWindowType.SLIDING_TIME_WINDOW) {
                result.navigator.add(new Object[]{"Window Check Interval", this.windowCheckInterval + " " + (this.windowCheckIntervalUnit != null ? ParserDQL.timeUnitToString(this.windowCheckIntervalUnit) : "sec")});
                result.navigator.add(new Object[]{"Next Check Time", this.nextSlidingTimeWindowCheckerTime != 0L ? DataspaceDateTime.getSqlTimestampString(this.nextSlidingTimeWindowCheckerTime, session.getTimeZone()) : "n/a"});
                result.navigator.add(new Object[]{"Last Check Time", this.lastSlidingTimeWindowCheckerTime != 0L ? DataspaceDateTime.getSqlTimestampString(this.lastSlidingTimeWindowCheckerTime, session.getTimeZone()) : "n/a"});
                result.navigator.add(new Object[]{"Last Deleted Rows", this.lastSlidingTimeWindowDeletedRows});
            }
        }
        result.navigator.add(new Object[]{"Window Triggers", this.getWindowTriggers().stream().map(t -> t.getObjectName().name).collect(Collectors.joining(","))});
        return result;
    }

    @Override
    public String getTriggerEventId(int whenType, int operationType) {
        return this.eventId;
    }

    @Override
    public boolean isTriggerEventAutogenerated() {
        return false;
    }

    @Override
    public Object wrapEvent(Session session, ImmutableEventDatagram event) {
        try {
            if (this.isSourceEventBlob) {
                byte[] serializedBlob = this.serializer.serialize(event);
                return SqlUtils.allocateBlob(session, serializedBlob);
            }
            return new OtherTypeWrapper(event);
        }
        catch (Exception error) {
            throw new DataspaceException(error);
        }
    }

    @Override
    public ImmutableEventDatagram unwrapEvent(Session session, Object data) {
        if (data == null) {
            return null;
        }
        ImmutableEventDatagram event = null;
        if (this.isSourceEventBlob && data instanceof BlobDataID) {
            byte[] eventData = null;
            try {
                BlobDataID blobId = (BlobDataID)data;
                eventData = SqlUtils.extractBlob(session, blobId);
                event = (ImmutableEventDatagram)this.serializer.deserialize(eventData);
            }
            catch (Exception exception) {
                Trace.logException(EventTableCollection.class, exception, true);
                throw new DataspaceException("Unable to extract Event data from collection. Cause: " + exception.getMessage());
            }
        } else if (data instanceof OtherTypeWrapper) {
            event = (ImmutableEventDatagram)OtherTypeWrapper.unwrap(data);
        } else {
            throw new DataspaceException("Unable to extract Event data from collection.");
        }
        return event;
    }

    public ImmutableEventDatagram waitToTake(Session session, String selector, long timeout, TimeUnit unit) {
        return this.waitToTake(session, selector, timeout, unit, false);
    }

    public ImmutableEventDatagram waitToTakeLast(Session session, String selector, long timeout, TimeUnit unit) {
        return this.waitToTake(session, selector, timeout, unit, true);
    }

    public ImmutableEventDatagram waitToTake(Session session, String selector, long timeout, TimeUnit unit, boolean isLast) {
        if (!this.withSourceEvent) {
            throw new DataspaceException("take/waitToTake event operation allowed for table with source event only.");
        }
        return this.dfetchEvent(session, selector, "delete row", timeout, unit, isLast);
    }

    public ImmutableEventDatagram waitToRead(Session session, String selector, long timeout, TimeUnit unit) {
        return this.waitToRead(session, selector, timeout, unit, false);
    }

    public ImmutableEventDatagram waitToReadLast(Session session, String selector, long timeout, TimeUnit unit) {
        return this.waitToRead(session, selector, timeout, unit, true);
    }

    public ImmutableEventDatagram waitToRead(Session session, String selector, long timeout, TimeUnit unit, boolean isLast) {
        if (!this.withSourceEvent) {
            throw new DataspaceException("read/waitToRead event operation allowed for table with source event only.");
        }
        if (timeout == -1L && (selector == null || selector.length() == 0)) {
            Result result = session.executeCompiledStatement(this.readElementNoSelectorStat, new Object[0]);
            return this.extractEventFromResult(session, result);
        }
        return this.dfetchEvent(session, selector, "", timeout, unit, isLast);
    }

    protected ImmutableEventDatagram dfetchEvent(Session session, String selector, String updater, long timeout, TimeUnit unit, boolean isLast) {
        try {
            if (this.isSourceEventBlob) {
                session.setAutoCommit(false);
            }
            String dfetchSql = this.makeDfetchSql("SeqId, Event", selector, updater, isLast ? "order by SeqId desc" : null, timeout, unit);
            Statement dfetchStat = session.compileStatement(dfetchSql);
            Result result = session.executeCompiledStatement(dfetchStat, new Object[0]);
            ImmutableEventDatagram immutableEventDatagram = this.extractEventFromResult(session, result);
            return immutableEventDatagram;
        }
        catch (DataspaceException exception) {
            if (this.isSourceEventBlob) {
                session.rollback(true);
            }
            throw exception;
        }
        finally {
            if (this.isSourceEventBlob) {
                session.commit(true);
                session.setAutoCommit(true);
            }
        }
    }

    private ImmutableEventDatagram extractEventFromResult(Session session, Result result) {
        EventTableCollection.checkResultNotError(result);
        EventTableCollection.checkResultIsData(result);
        RowSetNavigator rowSet = result.navigator;
        if (rowSet.next()) {
            return this.unwrapEvent(session, rowSet.getCurrent(1));
        }
        return null;
    }

    @Override
    public List<ActiveEvent> getEvents() {
        List<ActiveEvent> events = super.getEvents();
        ActiveEvent event = new ActiveEvent(this.eventId);
        event.setType(ActiveEvent.ActiveEventType.Sink);
        event.setEventScope(this.dataspace.getEventScope());
        event.setEventModel(SqlUtils.resolveEventModel(this.runtimeCtx, this.eventId));
        events.add(event);
        String actionableEventId = this.getTriggerEventId(8, 50);
        event = new ActiveEvent(actionableEventId);
        event.setType(ActiveEvent.ActiveEventType.Actionable);
        event.setEventScope(EventScope.LOCAL);
        event.setEventModel(SqlUtils.resolveEventModel(this.runtimeCtx, actionableEventId));
        events.add(event);
        return events;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = super.getReferences();
        if (this.eventId != null && this.eventId.length() > 0) {
            set.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetEventPrototypeObjectName(this.eventId));
        }
        return set;
    }

    @Override
    protected void onAggregateOthers(DataspaceStateHolder holder) {
        if (this.eventId != null && this.eventId.length() > 0 && PrototypeFactory.existsPrototype(this.eventId)) {
            try {
                new EventPropertiesMapper(this.eventId, this.includeProps, this.excludeProps, this).compile(this);
            }
            catch (Exception exception) {
                holder.setSuspectState(DataspaceStateHolder.prototype(this.eventId), exception.getMessage());
            }
        }
    }

    @Override
    public void setNextSlidingTimeWindowCheckerTime(long nextSlidingTimeWindowCheckerTime) {
        this.nextSlidingTimeWindowCheckerTime = nextSlidingTimeWindowCheckerTime;
    }

    @Override
    public void setLastSlidingTimeWindowDeletedRows(int lastSlidingTimeWindowDeletedRows) {
        this.lastSlidingTimeWindowDeletedRows = lastSlidingTimeWindowDeletedRows;
    }

    @Override
    public void setLastSlidingTimeWindowCheckerTime(long lastSlidingTimeWindowCheckerTime) {
        this.lastSlidingTimeWindowCheckerTime = lastSlidingTimeWindowCheckerTime;
    }

    public EventTableCollection setAdditionalColumns(List<AdditionalColumn> additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    public void addAdditionalColumn(AdditionalColumn additionalColumn) {
        if (this.additionalColumns == null) {
            this.additionalColumns = new ArrayList<AdditionalColumn>();
        }
        this.additionalColumns.add(additionalColumn);
    }

    public void dropAdditionalColumn(String name) {
        if (this.additionalColumns != null) {
            this.additionalColumns.removeIf(a -> a.columnName.equals(name));
        }
    }

    public void checkDropColumnAllowed(String name) {
        if (this.additionalColumns == null || !this.additionalColumns.stream().filter(additionalColumn -> additionalColumn.columnName.equals(name)).findAny().isPresent()) {
            throw new DataspaceException("Column '" + name + "' cannot be dropped.");
        }
    }

    public void setAdditionalColumnDefault(String nameString, Expression e) {
        if (this.additionalColumns != null) {
            for (AdditionalColumn additionalColumn : this.additionalColumns) {
                if (!additionalColumn.columnName.equals(nameString)) continue;
                additionalColumn.defaultExpr = e;
                return;
            }
        }
    }

    public static class AdditionalColumn {
        String columnName;
        Type columnType;
        Expression defaultExpr;

        public AdditionalColumn(String columnName, Type columnType, Expression defaultExpr) {
            this.columnName = columnName;
            this.columnType = columnType;
            this.defaultExpr = defaultExpr;
        }
    }
}

