/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.stream;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.AbstractCollectionFactoryImpl;
import com.streamscape.ds.schema.collection.stream.SourceStreamFactory;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.dii.AccessibleObjectProxy;

public class SourceStreamFactoryImpl
extends AbstractCollectionFactoryImpl {
    private SourceStreamFactory.SourceStreamSource source;
    private String expression;
    private String eventId;
    private long interval = -1L;
    private String streamStateEventId;
    private boolean isWithIndex = false;
    private int numberOfThreads = -1;

    public SourceStreamFactoryImpl() {
        super(CollectionType.SOURCE_STREAM);
    }

    public void setSource(Session session, SourceStreamFactory.SourceStreamSource source) {
        this.source = source;
    }

    public SourceStreamFactory.SourceStreamSource getSource(Session session) {
        return this.source;
    }

    public void setQueryExpression(Session session, String expression) {
        this.expression = expression;
    }

    public String getQueryExpression(Session session) {
        return this.expression;
    }

    public void setRaiseEventId(Session session, String eventId) {
        this.eventId = eventId;
    }

    public String getRaiseEventId(Session session) {
        return this.eventId;
    }

    public void setRaiseInterval(Session session, long interval) {
        this.interval = interval;
    }

    public long getRaiseInterval(Session session) {
        return this.interval;
    }

    public void setRaiseStreamStateEventId(Session session, String eventId) {
        this.streamStateEventId = eventId;
    }

    public String getRaiseStreamStateEventId(Session session) {
        return this.streamStateEventId;
    }

    public void setWithIndex(Session session, boolean isWithIndex) {
        this.isWithIndex = isWithIndex;
    }

    public Boolean isWithIndex(Session session) {
        return this.isWithIndex;
    }

    public void setParallelDegree(Session session, int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public int getParallelDegree(Session session) {
        return this.numberOfThreads;
    }

    @Override
    public String getCreateSql(Session session, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("create source stream ").append(name).append(" from ");
        if (this.source == null) {
            throw new DataspaceException("Source stream source table or event not set.");
        }
        if (this.source == SourceStreamFactory.SourceStreamSource.TABLE) {
            builder.append("table ");
        } else if (this.source == SourceStreamFactory.SourceStreamSource.EVENT) {
            builder.append(" event ");
        } else if (this.source == SourceStreamFactory.SourceStreamSource.FILE_DESCRIPTOR) {
            builder.append(" file descriptor ");
        }
        if (this.expression == null) {
            throw new DataspaceException("Source stream query expression not set.");
        }
        builder.append(" as (").append(this.expression).append(")");
        if (this.source != SourceStreamFactory.SourceStreamSource.FILE_DESCRIPTOR) {
            if (this.eventId == null) {
                throw new DataspaceException("Source stream rase event id not set.");
            }
            builder.append(" raise event on [").append(this.eventId).append("]");
        }
        if (this.interval != -1L) {
            builder.append(" at interval ").append(this.interval);
        }
        if (this.streamStateEventId != null) {
            builder.append(" raise stream state event on [").append(this.streamStateEventId).append("]");
        }
        if (this.isWithIndex) {
            builder.append(" with index ");
        }
        if (this.numberOfThreads != -1) {
            builder.append(" parallel degree ").append(this.numberOfThreads);
        }
        return builder.toString();
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new SourceStreamFactory();
    }
}

