/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.stream;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataCollection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.io.rowio.RowInputTextFileDescriptorTypesOnly;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.collection.stream.FabricEventSinkFactoryImpl;
import com.streamscape.ds.schema.collection.stream.FabricEventSourceFactoryImpl;
import com.streamscape.ds.schema.collection.stream.SourceStreamProvider;
import com.streamscape.ds.schema.collection.stream.SourceStreamProxy;
import com.streamscape.ds.schema.collection.stream.SourceStreamState;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.View;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.FabricThreadPool;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.StreamState;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.RowEvent;
import com.streamscape.sdo.event.StreamStateEvent;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.service.osf.config.ActiveEvent;
import java.util.HashMap;
import java.util.List;

public class SourceStreamCollection
extends AbstractCollection
implements AccessibleObject,
SourceEventFlowData {
    private CollectionReader reader = null;
    private long interval = 0L;
    private boolean isEvent = false;
    private String eventId = null;
    private String streamStateEventId = null;
    private String sql = null;
    private Session session = null;
    private SourceStreamState state = SourceStreamState.STOPPED;
    private String lastError = null;
    private long processedEvents = 0L;
    private long lastLogTime = 0L;
    private long startTime = 0L;
    private long elapsedTime = 0L;
    private boolean withIndex = false;
    private int parallelDegree = 1;
    private boolean fromFileDescriptor = false;
    private boolean isAllColumns = true;
    private int[] colMap = null;

    public SourceStreamCollection(DataspaceStore database, NameManager.ObjectName name, String eventId, long interval, boolean isEvent, String streamStateEventId, boolean withIndex, int parallelDegree, boolean fromFileDescriptor) {
        super(database, name, CollectionType.SOURCE_STREAM, MemoryModel.MEMORY);
        this.eventId = eventId;
        this.interval = interval;
        this.streamStateEventId = streamStateEventId;
        this.isEvent = isEvent;
        this.withIndex = withIndex;
        this.parallelDegree = parallelDegree;
        this.fromFileDescriptor = fromFileDescriptor;
        NameManager.ObjectName viewName = database.nameManager.newObjectName(name.name, name.isNameQuoted, 5);
        viewName.schema = name.schema;
        this.table = new View(database, viewName, null, 0);
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        this.table.compile(session, parentObject);
    }

    @Override
    public void compileInternalStatements(Session session) {
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public View getView() {
        return (View)this.table;
    }

    @Override
    public void destroy(Session session) {
        if (this.reader != null && (this.reader.isStarted() || this.reader.isSleeping())) {
            this.stop(null);
        }
        super.destroy(session);
    }

    public Result start(Session s) throws DataspaceException {
        try {
            block18: {
                try {
                    if (this.eventId != null) {
                        try {
                            EventDatagram eventDatagram = EventDatagramFactory.getInstance().createEvent(this.eventId);
                        }
                        catch (Exception exception) {
                            throw new DataspaceException("Failed to created event [" + this.eventId + "]: " + exception.getMessage());
                        }
                        this.dataspace.bindProducerFor(this.eventId, this);
                    }
                    if (this.streamStateEventId == null) break block18;
                    try {
                        EventDatagram event = EventDatagramFactory.getInstance().createEvent(this.streamStateEventId);
                        if (!(event instanceof StreamStateEvent)) {
                            throw new Exception("Should be of model StreamStateEvent.");
                        }
                    }
                    catch (Exception exception) {
                        throw new DataspaceException("Failed to created stream state event [" + this.streamStateEventId + "]: " + exception.getMessage());
                    }
                    this.dataspace.bindProducerFor(this.streamStateEventId, this);
                }
                catch (FabricEventDispatcherException error) {
                    throw new DataspaceException(error);
                }
            }
            if (this.session == null) {
                this.session = this.dataspace.createSession();
            }
            if (this.reader == null || !this.reader.isStarted()) {
                Trace.logDebug(this, "Starting source stream...");
                this.raiseStreamStateEvent(StreamState.OPEN);
                this.startTime = System.currentTimeMillis();
                this.processedEvents = 0L;
                this.elapsedTime = 0L;
                Table baseTable = ((View)this.table).getBaseTable();
                DataCollection collection = this.dataspace.lookupCollection(baseTable.getObjectName().name);
                if (this.fromFileDescriptor) {
                    this.reader = new SourceStreamProviderFromFileDescriptorReader((SourceStreamProvider)((Object)collection), this.interval);
                } else if (collection instanceof SourceStreamProvider && !this.withIndex) {
                    this.reader = new SourceStreamProviderReader((SourceStreamProvider)((Object)collection), this.interval);
                } else {
                    RowIterator it = ((View)this.table).getBaseTable().rowIteratorClustered(this.session);
                    this.reader = this.isEvent ? new CollectionReaderForEvent(it, this.interval) : new CollectionReader(it, this.interval);
                }
                if (this.parallelDegree > 1) {
                    this.reader.setParallelDegree(this.parallelDegree);
                }
                class StreamInitializer
                extends SingleTaskWorker {
                    protected StreamInitializer() {
                        super("DSYS:Source.Stream:Initializer", "Prepares all internal structures for stream start.");
                    }

                    @Override
                    protected void doExecute() throws FabricException {
                        SourceStreamCollection.this.state = SourceStreamState.INITIALIZING;
                        SourceStreamCollection.this.reader.init();
                        SourceStreamCollection.this.reader.start();
                        SourceStreamCollection.this.state = SourceStreamState.STARTED;
                    }
                }
                new StreamInitializer().start();
                Trace.logDebug(this, "Source stream started.");
            } else {
                Trace.logDebug(this, "Attempt to start already started stream. Skipping...");
            }
        }
        catch (Exception error) {
            this.state = SourceStreamState.STOPPED;
            return Result.newErrorResult(error);
        }
        return Result.updateNoResult;
    }

    public void stop(Session s) {
        if (this.reader != null && (this.reader.isStarted() || this.reader.isSleeping())) {
            Trace.logDebug(this, "Stopping source stream...");
            this.reader.stop();
            this.reader = null;
            if (this.state == SourceStreamState.STARTED) {
                this.elapsedTime += System.currentTimeMillis() - this.startTime;
            }
            this.state = SourceStreamState.STOPPED;
            this.raiseStreamStateEvent(StreamState.CLOSE);
            Trace.logDebug(this, "Source stream stopped.");
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.dataspace != null) {
            if (this.eventId != null) {
                this.dataspace.unbindProducerFor(this.eventId, this);
            }
            if (this.streamStateEventId != null) {
                this.dataspace.unbindProducerFor(this.streamStateEventId, this);
            }
        }
    }

    public void suspend(Session s) {
        if (this.reader != null && !this.reader.isSleeping()) {
            Trace.logDebug(this, "Suspending source stream...");
            this.reader.sleep();
            this.elapsedTime += System.currentTimeMillis() - this.startTime;
            this.state = SourceStreamState.SUSPENDED;
            Trace.logDebug(this, "Source stream suspended.");
        }
    }

    public void resume(Session s) {
        if (this.reader != null && this.reader.isSleeping()) {
            Trace.logDebug(this, "Resuming source stream...");
            this.reader.wakeUp();
            this.startTime = System.currentTimeMillis();
            this.state = SourceStreamState.STARTED;
            Trace.logDebug(this, "Source stream resumed.");
        }
    }

    public long getNumberOfProcessedEvents() {
        return this.processedEvents;
    }

    public long getElapsedTime() {
        return this.elapsedTime + (this.state == SourceStreamState.STARTED ? System.currentTimeMillis() - this.startTime : 0L);
    }

    @Override
    public Result getCollectionProperties(Session session) {
        Result result = super.getCollectionProperties(session);
        result.navigator.add(new Object[]{"Event", StringUtils.wrapEventId(this.eventId)});
        result.navigator.add(new Object[]{"Raise Stream State Event", StringUtils.wrapEventId(this.streamStateEventId)});
        result.navigator.add(new Object[]{"Interval", this.interval});
        result.navigator.add(new Object[]{"Stream State", this.getState()});
        result.navigator.add(new Object[]{"Processed Events", this.getNumberOfProcessedEvents()});
        result.navigator.add(new Object[]{"Elapsed Time", SourceStreamCollection.convertMillisToIntervals(this.getElapsedTime())});
        result.navigator.add(new Object[]{"Source DSQL Query", this.sql != null ? this.sql : ""});
        if (this.lastError != null) {
            result.navigator.add(new Object[]{"Last Error", this.lastError});
        }
        return result;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = super.getReferences();
        if (this.eventId != null && this.eventId.length() > 0) {
            set.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetEventPrototypeObjectName(this.eventId));
        }
        if (this.streamStateEventId != null && this.streamStateEventId.length() > 0) {
            set.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetEventPrototypeObjectName(this.streamStateEventId));
        }
        return set;
    }

    private void raiseStreamStateEvent(StreamState state) {
        if (this.streamStateEventId != null) {
            try {
                StreamStateEvent event = (StreamStateEvent)EventDatagramFactory.getInstance().createEvent(this.streamStateEventId);
                event.setStreamState(state);
                event.setStreamPosition(this.processedEvents);
                event.setStateMessage("Source stream '" + this.name.getSchemaQualifiedStatementName() + "' state changed to " + state.name() + ".");
                this.dataspace.raiseEvent(event, 0L);
            }
            catch (Exception error) {
                Trace.logError(this, "Unable to send stream state " + state.name() + " for '" + this.name.getSchemaQualifiedStatementName() + "' source stream.");
                Trace.logException(this, error, false);
            }
        }
    }

    public String getState() {
        return this.state.name();
    }

    public long getInterval() {
        return this.interval;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getLastError() {
        return this.lastError;
    }

    public static String convertMillisToIntervals(long millis) {
        StringBuilder buffer = new StringBuilder();
        long sec = millis / 1000L;
        if (sec > 0L) {
            millis %= 1000L;
            long min = sec / 60L;
            if (min > 0L) {
                sec %= 60L;
                long hour = min / 60L;
                if (hour > 0L) {
                    min %= 60L;
                    long days = hour / 24L;
                    if (days > 0L) {
                        hour %= 24L;
                        buffer.append(days).append(" days ");
                    }
                    buffer.append(hour).append(" hr ");
                }
                buffer.append(min).append(" min ");
            }
            buffer.append(sec).append(" sec ");
        }
        buffer.append(millis).append(" ms ");
        return buffer.toString();
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ');
        sb.append(SourceStreamCollection.getCollectionTypeName(this.getCollectionType()));
        sb.append(' ');
        sb.append(this.getObjectName().getSchemaQualifiedStatementName());
        sb.append(' ');
        sb.append("FROM").append(' ');
        if (this.isEvent) {
            sb.append("EVENT").append(' ');
        } else {
            sb.append("TABLE").append(' ');
        }
        sb.append(' ').append("AS").append(' ').append('(');
        sb.append(this.sql).append(')').append(' ');
        sb.append("RAISE").append(' ').append("EVENT").append(' ');
        sb.append("ON").append(" [").append(this.eventId).append("] ");
        sb.append("AT").append(' ').append("INTERVAL").append(' ').append(this.interval);
        if (this.streamStateEventId != null) {
            sb.append(' ').append("RAISE").append(' ').append("STREAM").append(' ').append("STATE").append(' ').append("EVENT").append(' ');
            sb.append("ON").append(" [").append(this.streamStateEventId).append("] ");
        }
        if (this.withIndex) {
            sb.append(" ").append("WITH").append(" ").append("INDEX");
        }
        if (this.parallelDegree > 1) {
            sb.append(" ").append("PARALLEL").append(" ").append("DEGREE").append(" ").append(this.parallelDegree);
        }
        return sb.toString();
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new SourceStreamProxy();
    }

    @Override
    public List<ActiveEvent> getEvents() {
        List<ActiveEvent> events = super.getEvents();
        if (this.eventId != null) {
            ActiveEvent event = new ActiveEvent(this.eventId);
            event.setType(ActiveEvent.ActiveEventType.Source);
            event.setEventScope(this.dataspace.getEventScope());
            event.setEventModel(SqlUtils.resolveEventModel(this.runtimeCtx, this.eventId));
            events.add(event);
        }
        return events;
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_SOURCE_STREAM;
    }

    @Override
    public String getEntityName() {
        return this.name.name;
    }

    @Override
    public EventScope getEntityScope() {
        return null;
    }

    @Override
    public HashMap<String, String> getEntityParameters() {
        return null;
    }

    private class CollectionReader
    implements Runnable {
        SpecificRangeIterator iterator = null;
        RowIterator rowIterator = null;
        Expression checkExpression = null;
        int colCount = -1;
        int parallelDegree = -1;
        long timeout = 0L;
        RowProcessor rowProcessor = null;
        boolean isRunning = false;
        Thread executor = null;

        protected CollectionReader(RowIterator iterator, long timeout) throws FabricException, FabricConnectionException, FabricComponentAccessorException {
            this.timeout = timeout;
            this.iterator = new SpecificRangeIterator(SourceStreamCollection.this);
            this.rowIterator = iterator;
            this.iterator.setRowIterator(iterator);
        }

        @Override
        public void run() {
            try {
                while (this.isRunning) {
                    if (this.timeout > 0L) {
                        Thread.sleep(this.timeout);
                    }
                    this.doExecute();
                }
            }
            catch (Throwable error) {
                Trace.logException(this, error, true);
            }
        }

        public synchronized void start() {
            this.isRunning = true;
            this.executor.start();
        }

        public boolean isStarted() {
            return this.isRunning;
        }

        public boolean isSleeping() {
            return !this.isRunning;
        }

        public void stop() {
            this.isRunning = false;
        }

        public void sleep() {
            this.isRunning = false;
        }

        public void wakeUp() {
            this.isRunning = true;
            this.executor = new Thread(this);
            this.executor.start();
        }

        protected void init() throws FabricException {
            this.executor = new Thread(this);
            this.analyzeColumns();
            this.checkExpression = ((View)((SourceStreamCollection)SourceStreamCollection.this).table).queryExpression.getCheckCondition();
            if (this.checkExpression != null) {
                for (RangeVariable rangeVar : ((View)((SourceStreamCollection)SourceStreamCollection.this).table).queryExpression.compileContext.getRangeVariables()) {
                    SourceStreamCollection.this.session.sessionContext.rangeIterators[rangeVar.rangePosition] = this.iterator;
                }
            }
            this.rowProcessor = this.parallelDegree > 0 ? new RowProcessor(){
                FabricThreadPool threadPool;
                RowProcessorTask[] tasks;
                {
                    this.tasks = new RowProcessorTask[CollectionReader.this.parallelDegree];
                }

                @Override
                void init() {
                    this.threadPool = FabricThreadManager.getInstance().createDaemonThreadPool(ThreadPoolType.FIXED, "DSYS:SourceStream.Reader", "Reads and processes the data to be streamed by source stream.", CollectionReader.this.parallelDegree);
                    for (int i = 0; i < CollectionReader.this.parallelDegree; ++i) {
                        this.tasks[i] = new RowProcessorTask(null);
                        this.tasks[i].rowParser = CollectionReader.this.createRowParser();
                    }
                }

                @Override
                void submitRow(Object row) throws Exception {
                    block0: while (true) {
                        RowProcessorTask[] rowProcessorTaskArray = this.tasks;
                        int n = rowProcessorTaskArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block0;
                            RowProcessorTask task = rowProcessorTaskArray[n2];
                            if (task.row == null) {
                                CollectionReader.this.assignRowForProcessing(task, row);
                                this.threadPool.addTask(task);
                                return;
                            }
                            ++n2;
                        }
                        break;
                    }
                }

                @Override
                void destroy() {
                    this.threadPool.stop();
                    this.threadPool = null;
                }
            } : new RowProcessor(){

                @Override
                void init() {
                }

                @Override
                void submitRow(Object row) throws Exception {
                    CollectionReader.this.processRow(row, row);
                }
            };
            this.rowProcessor.init();
        }

        void assignRowForProcessing(RowProcessorTask task, Object row) {
            task.row = row;
        }

        Object createRowParser() {
            return null;
        }

        void setParallelDegree(int degree) {
            this.parallelDegree = degree;
        }

        protected void doExecute() throws FabricException {
            try {
                if (this.checkForStreamEnd()) {
                    this.closeReader();
                    return;
                }
                this.rowProcessor.submitRow(this.getCurrentRow());
            }
            catch (Exception error) {
                Trace.logException(this, error, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processRow(Object rowParser, Object row) throws Exception {
            if (row == null) {
                return;
            }
            Object[] data = this.getDataForRow(rowParser, row);
            if (this.checkExpression != null) {
                this.setCurrentDataToIterator(data);
                if (!this.checkExpression.getValue(SourceStreamCollection.this.session).equals(Boolean.TRUE)) {
                    return;
                }
            }
            if (!SourceStreamCollection.this.isAllColumns) {
                Object[] newData = new Object[this.colCount];
                for (int i = 0; i < this.colCount; ++i) {
                    newData[i] = data[SourceStreamCollection.this.colMap[i]];
                }
                data = newData;
            }
            for (int i = 0; i < data.length; ++i) {
                data[i] = OtherTypeWrapper.unwrap(data[i]);
            }
            this.sendEvent(data, row);
            SourceStreamCollection sourceStreamCollection = SourceStreamCollection.this;
            synchronized (sourceStreamCollection) {
                ++SourceStreamCollection.this.processedEvents;
                if (SourceStreamCollection.this.processedEvents % 50000L == 0L) {
                    long throughput = SourceStreamCollection.this.lastLogTime != 0L ? 50000000L / (System.currentTimeMillis() - SourceStreamCollection.this.lastLogTime) : 0L;
                    Trace.logDebug(this, SourceStreamCollection.this.getEntityName() + ": processed events count: " + SourceStreamCollection.this.processedEvents, "througput: " + throughput + " events/sec");
                    SourceStreamCollection.this.lastLogTime = System.currentTimeMillis();
                }
            }
        }

        protected void setCurrentDataToIterator(Object[] data) {
        }

        protected boolean checkForStreamEnd() {
            return !this.iterator.next();
        }

        protected Object getCurrentRow() {
            return this.iterator.getCurrentRow();
        }

        protected Object[] getDataForRow(Object rowParser, Object row) {
            return ((Row)row).getData();
        }

        protected void closeReader() {
            this.rowProcessor.destroy();
            this.rowProcessor = null;
            this.rowIterator.release();
            this.rowIterator = null;
            SourceStreamCollection.this.stop(null);
        }

        protected void sendEvent(Object[] data, Object row) throws Exception {
            RowEvent event = (RowEvent)EventDatagramFactory.getInstance().createEvent(SourceStreamCollection.this.eventId);
            event.getRow().setRawData(data);
            if (SourceStreamCollection.this.dataspace != null) {
                SourceStreamCollection.this.dataspace.raiseEvent(event, 0L);
            }
        }

        private void analyzeColumns() {
            SourceStreamCollection.this.isAllColumns = true;
            Table baseTable = ((View)SourceStreamCollection.this.table).getBaseTable();
            HashMappedList columns = ((View)((SourceStreamCollection)SourceStreamCollection.this).table).queryExpression.getColumns();
            HashMappedList sourceColumns = baseTable.columnList;
            Iterator keyIter = ((View)((SourceStreamCollection)SourceStreamCollection.this).table).queryExpression.getColumns().keySet().iterator();
            this.colCount = columns.size();
            int currentColumnPos = 0;
            SourceStreamCollection.this.colMap = new int[this.colCount];
            while (keyIter.hasNext()) {
                String columnName = (String)keyIter.next();
                int sourceColumnPos = sourceColumns.getIndex(columnName);
                if (currentColumnPos != sourceColumnPos) {
                    SourceStreamCollection.this.isAllColumns = false;
                }
                SourceStreamCollection.this.colMap[currentColumnPos++] = sourceColumnPos;
            }
            if (SourceStreamCollection.this.colMap.length != sourceColumns.size()) {
                SourceStreamCollection.this.isAllColumns = false;
            }
        }

        abstract class RowProcessor {
            RowProcessor(CollectionReader this$1) {
            }

            void init() {
            }

            void destroy() {
            }

            abstract void submitRow(Object var1) throws Exception;
        }

        class RowProcessorTask
        implements Runnable {
            Object row = null;
            Object rowParser = null;

            RowProcessorTask(Object row) {
                this.row = row;
            }

            @Override
            public void run() {
                try {
                    CollectionReader.this.processRow(this.rowParser, this.row);
                    this.row = null;
                }
                catch (Exception error) {
                    Trace.logException(this, error, true);
                }
            }
        }
    }

    class SourceStreamProviderFromFileDescriptorReader
    extends SourceStreamProviderReader {
        protected SourceStreamProviderFromFileDescriptorReader(SourceStreamProvider provider, long timeout) throws FabricException, FabricConnectionException, FabricComponentAccessorException {
            super(provider, timeout);
        }

        @Override
        protected void init() throws FabricException {
            FileDescriptor descriptor = ((FileTableCollection)this.provider).getFileTable().getFileDescriptor();
            for (FileDescriptorRecord record : descriptor.getRecords()) {
                if (!(record instanceof RecordTypeDefinition)) {
                    throw new DataspaceException("If source stream created in file table constrained by file descriptor involved file descriptor should contain simple record definitions only.");
                }
                RecordTypeDefinition recordTypeDefinition = (RecordTypeDefinition)record;
                if (!StringUtils.validateEventId(recordTypeDefinition.getEventId())) {
                    throw new DataspaceException("Invalid EventId [" + recordTypeDefinition.getEventId() + "] for record '" + record.getTypeKey() + "'.");
                }
                if (!PrototypeFactory.existsPrototype(recordTypeDefinition.getEventId())) {
                    throw new DataspaceException("EventId [" + recordTypeDefinition.getEventId() + "] for record '" + record.getTypeKey() + "' doesn't exist.");
                }
                try {
                    SourceStreamCollection.this.dataspace.bindProducerFor(recordTypeDefinition.getEventId(), SourceStreamCollection.this);
                }
                catch (Exception exception) {
                    throw new DataspaceException(exception.getMessage());
                }
            }
            super.init();
        }

        @Override
        protected void sendEvent(Object[] data, Object row) throws Exception {
            RecordTypeDefinition recordTypeDefinition = ((RowInputTextFileDescriptorTypesOnly)row).getLastRecordTypeDefinition();
            if (recordTypeDefinition instanceof RecordTypeDefinition) {
                DataEvent event = (DataEvent)EventDatagramFactory.getInstance().createEvent(recordTypeDefinition.getEventId());
                event.setData(data.length == 2 ? data[1] : data[0]);
                if (SourceStreamCollection.this.dataspace != null) {
                    SourceStreamCollection.this.dataspace.raiseEvent(event, 0L);
                }
            }
        }

        @Override
        protected void closeReader() {
            FileDescriptor descriptor = ((FileTableCollection)this.provider).getFileTable().getFileDescriptor();
            if (descriptor != null) {
                for (FileDescriptorRecord record : descriptor.getRecords()) {
                    if (!(record instanceof RecordTypeDefinition)) continue;
                    SourceStreamCollection.this.dataspace.unbindProducerFor(((RecordTypeDefinition)record).getEventId(), SourceStreamCollection.this);
                }
            }
            super.closeReader();
        }
    }

    class SourceStreamProviderReader
    extends CollectionReader {
        Object currentRow;
        SourceStreamProvider provider;

        protected SourceStreamProviderReader(SourceStreamProvider provider, long timeout) throws FabricException, FabricConnectionException, FabricComponentAccessorException {
            super(null, timeout);
            this.currentRow = null;
            this.provider = null;
            this.provider = provider;
        }

        @Override
        protected void init() throws FabricException {
            this.provider.initForStreaming();
            super.init();
        }

        @Override
        protected boolean checkForStreamEnd() {
            this.currentRow = this.provider.getNextRowForStream();
            return this.currentRow == null;
        }

        @Override
        public Object getCurrentRow() {
            return this.currentRow;
        }

        @Override
        protected Object[] getDataForRow(Object rowParser, Object row) {
            return this.provider.materializeRowForStream(SourceStreamCollection.this.session, rowParser, row);
        }

        @Override
        Object createRowParser() {
            return this.provider.createRowParser();
        }

        @Override
        void assignRowForProcessing(CollectionReader.RowProcessorTask task, Object row) {
            task.row = row;
            this.provider.initParserWithRow(task.rowParser, row);
        }

        @Override
        protected void setCurrentDataToIterator(Object[] data) {
            this.iterator.setCurrent(data);
        }

        @Override
        protected void closeReader() {
            SourceStreamCollection.this.stop(null);
        }
    }

    private class CollectionReaderForEvent
    extends CollectionReader {
        protected CollectionReaderForEvent(RowIterator iterator, long timeout) throws FabricException, FabricConnectionException, FabricComponentAccessorException {
            super(iterator, timeout);
        }

        @Override
        protected void sendEvent(Object[] data, Object row) throws Exception {
            if (data != null && data.length == 1 && data[0] instanceof ImmutableEventDatagram) {
                ImmutableEventDatagram event = (ImmutableEventDatagram)data[0];
                FabricEventSinkFactoryImpl.reset(event);
                FabricEventSourceFactoryImpl.setEventId(event, SourceStreamCollection.this.eventId);
                SourceStreamCollection.this.dataspace.raiseEvent(event, 0L);
            }
        }
    }

    class SpecificRangeIterator
    extends RangeVariable.RangeIteratorBase {
        SpecificRangeIterator(SourceStreamCollection this$0) {
        }

        void setRowIterator(RowIterator iter) {
            this.it = iter;
        }

        @Override
        public boolean next() {
            if (this.isBeforeFirst) {
                this.isBeforeFirst = false;
            } else if (this.it == null) {
                return false;
            }
            this.currentRow = this.it.getNextRow();
            return this.currentRow != null;
        }

        @Override
        public Object[] getCurrent() {
            return this.currentRow.getData();
        }
    }
}

