/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.queue;

import com.streamscape.Trace;
import com.streamscape.cli.ds.collection.BlockingQueue;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.qspace.AbstractQueueProxy;
import com.streamscape.sef.dispatcher.AbstractAccessibleObjectForCollectionsProxy;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class BlockingQueueProxy
extends AbstractQueueProxy
implements BlockingQueue {
    @Override
    public boolean offer(Object o, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkArgumentNotNull("offer", o);
        try {
            return this.invokeCollectionsMethodWithReturn("offer", Boolean.class, new Object[]{o, timeout, unit});
        }
        catch (DataspaceException exception) {
            throw this.unwrapDataspaceExceptionTo(exception, InterruptedException.class);
        }
    }

    @Override
    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            return this.invokeCollectionsMethodWithReturn("poll", Object.class, new Object[]{timeout, unit});
        }
        catch (DataspaceException exception) {
            throw this.unwrapDataspaceExceptionTo(exception, InterruptedException.class);
        }
    }

    @Override
    public Object pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            return this.invokeCollectionsMethodWithReturn("pollLast", Object.class, new Object[]{timeout, unit});
        }
        catch (DataspaceException exception) {
            throw this.unwrapDataspaceExceptionTo(exception, InterruptedException.class);
        }
    }

    @Override
    public Object take() throws InterruptedException {
        try {
            return this.invokeCollectionsMethodWithReturn("take", Object.class, new Object[0]);
        }
        catch (DataspaceException exception) {
            throw this.unwrapDataspaceExceptionTo(exception, InterruptedException.class);
        }
    }

    @Override
    public Object takeLast() throws InterruptedException {
        try {
            return this.invokeCollectionsMethodWithReturn("takeLast", Object.class, new Object[0]);
        }
        catch (DataspaceException exception) {
            throw this.unwrapDataspaceExceptionTo(exception, InterruptedException.class);
        }
    }

    @Override
    public void put(Object o) throws InterruptedException {
        this.checkArgumentNotNull("put", o);
        try {
            this.invokeCollectionsMethod("put", o);
        }
        catch (DataspaceException exception) {
            throw this.unwrapDataspaceExceptionTo(exception, InterruptedException.class);
        }
    }

    @Override
    public int remainingCapacity() {
        return this.invokeCollectionsMethodWithReturn("remainingCapacity", Integer.class, new Object[0]);
    }

    @Override
    public int drainTo(Collection<? super Object> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super Object> c, int maxElements) {
        return this.drainToImpl(c, maxElements, "");
    }

    protected int drainToImpl(final Collection<? super Object> c, final int maxElements, final String selector) {
        this.checkArgumentNotNull("drainTo", c);
        AbstractAccessibleObjectForCollectionsProxy.RemoteRequestExecutor<Integer> executor = new AbstractAccessibleObjectForCollectionsProxy.RemoteRequestExecutor<Integer>(){

            @Override
            public Integer objectNotProxy() {
                List elements = (List)BlockingQueueProxy.this.invokeCollectionsMethodWithReturn("drain", List.class, new Object[]{maxElements, selector});
                c.addAll(elements);
                return elements.size();
            }

            @Override
            public Integer objectTheSame() {
                throw new DataspaceException("Specified collection is the same.");
            }

            @Override
            public Integer objectInTheSameAccessor() {
                return (Integer)BlockingQueueProxy.this.invokeCollectionsMethodWithReturn("drainTo", Integer.class, new Object[]{c, maxElements, selector});
            }

            @Override
            public Integer objectInTheSameNode(String componentType, String componentName, String collectionName) {
                return this.objectInTheSameSysplex("", componentType, componentName, collectionName);
            }

            @Override
            public Integer objectInTheSameSysplex(String nodeName, String componentType, String componentName, String collectionName) {
                return (Integer)BlockingQueueProxy.this.invokeCollectionsMethodWithReturn("drainTo", Integer.class, new Object[]{nodeName, componentType, componentName, collectionName, maxElements, selector});
            }

            @Override
            public Integer objectInOtherSysplex(String nodeName, String componentType, String componentName, String collectionName) {
                Trace.logInfo(this, "Collection '" + collectionName + "' passed to drainTo method is not in current sysplex. Data will be transfered thru client.");
                return this.objectNotProxy();
            }
        };
        return this.executeRemoteRequest(c, executor);
    }
}

