/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.queue;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.AbstractIterator;
import com.streamscape.ds.schema.collection.Tuple;
import com.streamscape.ds.schema.collection.qspace.AbstractQueueCollection;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueIterator;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueProxy;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class BlockingQueueCollection
extends AbstractQueueCollection {
    protected Type dataType = null;
    protected Statement pushElementStat = null;
    protected Statement removeElementStat = null;
    protected Statement removeElementByKeyStat = null;
    protected Statement getElementStat = null;
    protected Statement getElementLastStat = null;
    protected String dfetchNonBlockingStatSql = null;
    protected String dfetchLastNonBlockingStatSql = null;

    public BlockingQueueCollection(DataspaceStore store, NameManager.ObjectName name, MemoryModel memoryModel) {
        super(store, name, CollectionType.BLOCKING_QUEUE, memoryModel);
    }

    protected BlockingQueueCollection(DataspaceStore store, NameManager.ObjectName name, CollectionType collectionType, MemoryModel memoryModel) {
        super(store, name, collectionType, memoryModel);
    }

    public void setConstraint(Type dataType) {
        this.dataType = dataType;
    }

    public Type getDataType() {
        return this.dataType;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        NameManager.ObjectName internalTableName = this.store.nameManager.newObjectName(this.name.name, this.name.isNameQuoted, 3);
        internalTableName.schema = this.name.schema;
        this.table = TableUtil.newTable(this.store, this.getInternalTableType(this.memoryModel), internalTableName);
        this.addIdentityColumn(this.table, "SeqId", Type.SQL_INTEGER);
        this.addColumn(this.table, "Object", this.dataType, false);
        NameManager.ObjectName name = NameManager.newInfoSchemaObjectName(internalTableName.name, internalTableName.isNameQuoted, 21);
        this.table.createPrimaryKeyConstraint(name, new int[]{0}, false);
        this.table.compile(session, parentObject);
    }

    @Override
    public void compileInternalStatements(Session session) {
        String SQL = null;
        SQL = "insert into " + this.name.getSchemaQualifiedStatementName() + "(Object) VALUES(?)";
        this.pushElementStat = session.compileStatement(SQL);
        SQL = "delete from " + this.name.getSchemaQualifiedStatementName() + " where Object = ?";
        this.removeElementStat = session.compileStatement(SQL);
        SQL = "delete from " + this.name.getSchemaQualifiedStatementName() + " where SeqId = ?";
        this.removeElementByKeyStat = session.compileStatement(SQL);
        SQL = "select top 1 SeqId, Object from " + this.name.getSchemaQualifiedStatementName();
        this.getElementStat = session.compileStatement(SQL);
        SQL = "select top 1 SeqId, Object from " + this.name.getSchemaQualifiedStatementName() + " order by SeqId desc";
        this.getElementLastStat = session.compileStatement(SQL);
        SQL = "truncate collection " + this.name.getSchemaQualifiedStatementName();
        this.clearQueueStat = session.compileStatement(SQL);
        SQL = "select count(SeqId) from " + this.name.getSchemaQualifiedStatementName();
        this.querySizeStat = session.compileStatement(SQL);
        SQL = "select true from " + this.name.getSchemaQualifiedStatementName() + " where Object = ?";
        this.containsStat = session.compileStatement(SQL);
        this.dfetchNonBlockingStatSql = "dfetch SeqId, Object from " + this.name.getSchemaQualifiedStatementName() + " (delete row)";
        this.dfetchLastNonBlockingStatSql = "dfetch SeqId, Object from " + this.name.getSchemaQualifiedStatementName() + " order by SeqId desc (delete row)";
        session.compileStatement(this.dfetchNonBlockingStatSql);
        session.compileStatement(this.dfetchLastNonBlockingStatSql);
    }

    @Override
    public String getCollectionSQL(boolean forReplication) {
        StringBuilder sb = new StringBuilder();
        sb.append("CONSTRAINED").append(' ').append("BY").append(' ');
        sb.append(this.dataType.getTypeDefinition());
        return sb.toString();
    }

    @Override
    public Result getCollectionProperties(Session session) {
        Result result = super.getCollectionProperties(session);
        result.navigator.add(new Object[]{"Model", Tuple.getTypeName(this.dataType)});
        return result;
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new BlockingQueueProxy();
    }

    @Override
    protected boolean pushElement(Session session, Object element) {
        this.checkOperationIsSupported(this.pushElementStat, "pushElement");
        Result result = session.executeCompiledStatement(this.pushElementStat, new Object[]{this.dataType.convertJavaToSQL(session, element)});
        BlockingQueueCollection.checkResultNotError(result);
        return result.getUpdateCount() == 1;
    }

    @Override
    protected AbstractQueueCollection.KeyValue getElement(Session session, boolean isLast) {
        this.checkOperationIsSupported(this.getElementStat, "getElement");
        Result result = session.executeCompiledStatement(isLast ? this.getElementLastStat : this.getElementStat, new Object[0]);
        return this.extractKeyValue(result);
    }

    @Override
    protected AbstractQueueCollection.KeyValue dfetchElement(Session session, String selector, String updater, long timeout, TimeUnit unit, boolean isLast) {
        Statement dfetchStat;
        this.checkOperationIsSupported(this.dfetchNonBlockingStatSql, "dfetchElement");
        this.checkOperationIsSupported(this.dfetchLastNonBlockingStatSql, "dfetchElement");
        if (selector == null && timeout == -1L && updater != null && updater.equals("delete row")) {
            dfetchStat = session.compileStatement(isLast ? this.dfetchLastNonBlockingStatSql : this.dfetchNonBlockingStatSql);
        } else {
            String dfetchSql = this.makeDfetchSql("SeqId, Object", selector, updater, isLast ? "order by SeqId desc" : null, timeout, unit);
            dfetchStat = session.compileStatement(dfetchSql);
        }
        Result result = session.executeCompiledStatement(dfetchStat, new Object[0]);
        return this.extractKeyValue(result);
    }

    @Override
    protected boolean removeElement(Session session, Object element) {
        this.checkOperationIsSupported(this.removeElementStat, "removeElement");
        Result result = session.executeCompiledStatement(this.removeElementStat, new Object[]{this.dataType.convertJavaToSQL(session, element)});
        BlockingQueueCollection.checkResultNotError(result);
        return result.getUpdateCount() > 0;
    }

    @Override
    protected boolean removeElementByKey(Session session, Object key) {
        this.checkOperationIsSupported(this.removeElementByKeyStat, "removeElementByKey");
        Result result = session.executeCompiledStatement(this.removeElementByKeyStat, new Object[]{key});
        BlockingQueueCollection.checkResultNotError(result);
        return result.getUpdateCount() > 0;
    }

    private AbstractQueueCollection.KeyValue extractKeyValue(Result result) {
        BlockingQueueCollection.checkResultNotError(result);
        BlockingQueueCollection.checkResultIsData(result);
        RowSetNavigator rowSet = result.navigator;
        if (rowSet.next()) {
            Object data = rowSet.getCurrent(1);
            data = OtherTypeWrapper.unwrap(data);
            return new AbstractQueueCollection.KeyValue(rowSet.getCurrent(0), data);
        }
        return null;
    }

    public boolean offer(Session session, Object o, long timeout, TimeUnit unit) throws InterruptedException {
        return this.pushElement(session, o);
    }

    public Object poll(Session session, long timeout, TimeUnit unit) throws InterruptedException {
        return this.poll(session, timeout, unit, false);
    }

    public Object pollLast(Session session, long timeout, TimeUnit unit) throws InterruptedException {
        return this.poll(session, timeout, unit, true);
    }

    public Object poll(Session session, long timeout, TimeUnit unit, boolean isLast) throws InterruptedException {
        AbstractQueueCollection.KeyValue keyValue = this.dfetchElement(session, null, timeout, unit, isLast);
        if (keyValue == null) {
            return null;
        }
        return keyValue.value;
    }

    public Object take(Session session) throws InterruptedException {
        return this.take(session, false);
    }

    public Object takeLast(Session session) throws InterruptedException {
        return this.take(session, true);
    }

    public Object take(Session session, boolean isLast) throws InterruptedException {
        AbstractQueueCollection.KeyValue keyValue = this.dfetchElement(session, null, 0L, TimeUnit.MILLISECONDS, isLast);
        if (keyValue == null) {
            return null;
        }
        return keyValue.value;
    }

    public void put(Session session, Object o) throws InterruptedException {
        this.offer(session, o, 0L, TimeUnit.MILLISECONDS);
    }

    public int remainingCapacity(Session session) {
        return Integer.MAX_VALUE - (int)this.size(session);
    }

    protected Object pollForDrain(Session session, String selector) {
        return this.poll(session);
    }

    public int drainTo(Session session, BlockingQueueCollection c, int maxElements) {
        return this.drainTo(session, c, maxElements, "");
    }

    public int drainTo(Session session, BlockingQueueCollection c, int maxElements, String selector) {
        int count = 0;
        while (count < maxElements) {
            boolean isAutoCommit = session.isAutoCommit();
            try {
                session.setAutoCommit(false);
                session.startTransaction();
                Object element = this.pollForDrain(session, selector);
                if (element == null) break;
                c.add(session, element);
                ++count;
            }
            catch (Throwable error) {
                session.rollback(true);
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new DataspaceException(error);
            }
            finally {
                session.commit(true);
                session.setAutoCommit(isAutoCommit);
            }
        }
        return count;
    }

    public int drainTo(final Session session, String nodeName, String componentType, String componentName, String collectionName, final int maxElements, final String selector) {
        AbstractCollection.CollectionDelegate<Integer, Collection> delegate = new AbstractCollection.CollectionDelegate<Integer, Collection>(){

            @Override
            public Integer delegate(Collection collection, DataspaceAccessor accessor) throws DataspaceComponentException {
                int count = 0;
                while (count < maxElements) {
                    boolean isAutoCommit = session.isAutoCommit();
                    boolean isAutoCommit1 = accessor.getAutoCommit();
                    try {
                        session.setAutoCommit(false);
                        session.startTransaction();
                        accessor.setAutoCommit(false);
                        Object element = BlockingQueueCollection.this.pollForDrain(session, selector);
                        if (element == null) break;
                        collection.add(element);
                        ++count;
                    }
                    catch (Throwable error) {
                        session.rollback(true);
                        accessor.rollback();
                        if (error instanceof RuntimeException) {
                            throw (RuntimeException)error;
                        }
                        throw new DataspaceException(error);
                    }
                    finally {
                        session.commit(true);
                        session.setAutoCommit(isAutoCommit);
                        accessor.commit();
                        accessor.setAutoCommit(isAutoCommit1);
                    }
                }
                return count;
            }
        };
        return this.executeWithRemoteCollection(nodeName, componentType, componentName, collectionName, delegate, Collection.class);
    }

    public List<Object> drain(Session session, int maxElements, String selector) {
        Object element = null;
        ArrayList<Object> result = new ArrayList<Object>();
        for (int count = 0; count < maxElements && (element = this.pollForDrain(session, selector)) != null; ++count) {
            result.add(element);
        }
        return result;
    }

    @Override
    public AbstractIterator iterator(Session session) {
        return new BlockingQueueIterator(this, session);
    }
}

