/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue.consumer;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessState;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.AbstractRegisteredConsumersPool;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.ProcessQueueEventWrapper;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.ProcessQueuePoller;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.RConsumer;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class RegisteredConsumersPoolImpl
extends AbstractRegisteredConsumersPool {
    private List<FabricThread<?>> threads = new ArrayList();
    private ProcessQueueEventWrapper ongoingEvent;
    private final ReentrantLock ongoingEventPutLock = new ReentrantLock();
    private final ReentrantLock ongoingEventTakeLock = new ReentrantLock();
    private final Condition ongoingEventNull = this.ongoingEventPutLock.newCondition();
    private final Condition ongoingEventNotNull = this.ongoingEventTakeLock.newCondition();

    RegisteredConsumersPoolImpl(ProcessQueuePoller poller, Logger logger) {
        super(poller);
        for (int i = 0; i < poller.getQueue().getPollerConfiguration().parallelDegree; ++i) {
            this.threads.add(FabricThreadManager.getInstance().createThread("DSYS:ProcessQueueRegisteredConsumer:" + poller.getQueue().getName() + "_" + i, "Processes messages from queue and offers them to recipients.", new RConsumer(this, i + 1, logger)));
        }
    }

    @Override
    public void start() {
        this.poller.log(null, "Starting registered consumer threads...", Trace.Level.INFO);
        for (FabricThread<?> thread : this.threads) {
            thread.start();
        }
    }

    @Override
    public void stop(Session session) {
        this.poller.log(null, "Stopping registered consumer threads...", Trace.Level.INFO);
        for (FabricThread<?> thread : this.threads) {
            thread.stop();
        }
        for (FabricThread<?> thread : this.threads) {
            thread.join(1000L);
        }
        if (this.ongoingEvent != null) {
            try {
                this.updateProcessState(session, this.ongoingEvent, ProcessState.ENQUEUED);
            }
            catch (Exception exception) {
                this.poller.log(this.ongoingEvent, exception.getMessage(), Trace.Level.ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(Session session, ProcessQueueEventWrapper wrapper) {
        this.ongoingEventPutLock.lock();
        try {
            while (this.ongoingEvent != null) {
                try {
                    this.ongoingEventNull.await();
                }
                catch (InterruptedException e) {
                    this.ongoingEventPutLock.unlock();
                    return;
                }
            }
            this.lockEvent(session, wrapper);
            this.ongoingEvent = wrapper;
        }
        finally {
            this.ongoingEventPutLock.unlock();
        }
        this.ongoingEventTakeLock.lock();
        try {
            this.ongoingEventNotNull.signal();
        }
        finally {
            this.ongoingEventTakeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessQueueEventWrapper takeOngoingEvent() {
        this.ongoingEventTakeLock.lock();
        try {
            while (this.ongoingEvent == null) {
                try {
                    this.ongoingEventNotNull.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    ProcessQueueEventWrapper processQueueEventWrapper = null;
                    this.ongoingEvent = null;
                    this.sleepForOfferInterval();
                    this.ongoingEventTakeLock.unlock();
                    this.ongoingEventPutLock.lock();
                    try {
                        this.ongoingEventNull.signal();
                    }
                    finally {
                        this.ongoingEventPutLock.unlock();
                    }
                    return processQueueEventWrapper;
                }
            }
            ProcessQueueEventWrapper processQueueEventWrapper = this.ongoingEvent;
            return processQueueEventWrapper;
        }
        finally {
            this.ongoingEvent = null;
            this.sleepForOfferInterval();
            this.ongoingEventTakeLock.unlock();
            this.ongoingEventPutLock.lock();
            try {
                this.ongoingEventNull.signal();
            }
            finally {
                this.ongoingEventPutLock.unlock();
            }
        }
    }
}

