/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue.consumer;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.DeliveryState;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.FabricEventSinkFactoryImpl;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.FabricEventSourceFactoryImpl;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.ProcessQueueEventWrapper;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.RConsumer;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.selector.parser.SelectorParser;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sef.FabricEventSinkException;
import com.streamscape.sef.FabricEventSourceException;

public class Recipient {
    protected String name = null;
    protected String subscriptionRule = null;
    protected SelectorExpression selector = null;
    protected String eventId = null;
    protected boolean enabled = true;
    protected AbstractDataspace dataspace = null;
    private static LongNumberAllocatorSimple replyIndex = new LongNumberAllocatorSimple();

    public Recipient(AbstractDataspace dataspace, String name, String subscriptionRule, String eventId, boolean enabled) {
        this.dataspace = dataspace;
        this.name = name;
        this.subscriptionRule = subscriptionRule;
        this.eventId = eventId;
        this.enabled = enabled;
        try {
            this.selector = SelectorParser.parse(subscriptionRule);
        }
        catch (SelectorFormatException selectorFormatException) {
            // empty catch block
        }
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getName() {
        return this.name;
    }

    public SelectorExpression getSelector() {
        return this.selector;
    }

    public synchronized boolean matches(EventDatagram process) {
        return this.selector == null || this.selector.matches(process);
    }

    public String getSubscriptionRule() {
        return this.subscriptionRule;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    public void onEvent(RConsumer consumer, ProcessQueueEventWrapper wrapper, long timeout) {
        try {
            this.prepareEventForOffer(wrapper.event);
            AcknowledgementEvent ack = this.dataspace.raiseSystemRequest(wrapper.event, RequestDistributionStrategy.AUCTION, ReplyMatchStrategy.REPLY_WITH_CORRELATION_ID, timeout);
            if (ack != null && ack instanceof AcknowledgementEvent) {
                this.processAck(consumer, wrapper, ack);
            } else {
                this.updatedProcessState(consumer, wrapper, DeliveryState.UNACKNOWLEDGED);
            }
        }
        catch (Throwable exception) {
            consumer.log(wrapper, "Recipient '" + this.name + "' not acknowledged. Cause: " + exception.getMessage(), Trace.Level.ERROR);
            Trace.logException(this, exception, !(exception instanceof IAbstractExceptionEvent));
            this.updatedProcessState(consumer, wrapper, DeliveryState.UNACKNOWLEDGED);
        }
    }

    protected void prepareEventForOffer(EventDatagram event) throws FabricEventSinkException, FabricEventSourceException, SDOException {
        FabricEventSinkFactoryImpl.reset(event, true);
        FabricEventSourceFactoryImpl.setEventId(event, this.eventId);
        if (event.existsEventProperty("Recipient")) {
            event.setEventStringProperty("Recipient", this.name);
        }
        event.setReplyTo("e.sys.reply." + replyIndex.getNumber());
    }

    protected void processAck(RConsumer consumer, ProcessQueueEventWrapper wrapper, AcknowledgementEvent ack) throws SDOException, SecurityViolationException {
        consumer.log(wrapper, "Recipient '" + this.name + "': acknowledgement with '" + ack.getAction().name() + "' ack action received for.", Trace.Level.DEBUG);
        DeliveryState state = DeliveryState.UNACKNOWLEDGED;
        long expiration = -1L;
        if (ack != null) {
            switch (ack.getAction()) {
                case ACKNOWLEDGE: {
                    state = DeliveryState.ACKNOWLEDGED;
                    break;
                }
                case ACKNOWLEDGE_UNDELIVERED: {
                    state = DeliveryState.UNDELIVERED;
                    break;
                }
                case ACKNOWLEDGE_AND_EXPIRE: {
                    state = DeliveryState.EXPIRATION_REQUESTED;
                    expiration = ack.getCorrelationEventExpiration();
                    break;
                }
                case ACKNOWLEDGE_AND_SUSPEND: {
                    state = DeliveryState.SUSPEND_REQUESTED;
                    break;
                }
                case ACKNOWLEDGE_AND_RETRY: {
                    state = DeliveryState.RETRY_REQUESTED;
                    break;
                }
            }
        }
        this.updatedProcessState(consumer, wrapper, state, expiration);
    }

    protected void updatedProcessState(RConsumer consumer, ProcessQueueEventWrapper wrapper, DeliveryState state) {
        this.updatedProcessState(consumer, wrapper, state, -1L);
    }

    protected void updatedProcessState(RConsumer consumer, ProcessQueueEventWrapper wrapper, DeliveryState state, long expiration) {
        wrapper.receipts.updateReceipt(this.name, state);
        if (expiration != -1L) {
            consumer.setProcessExpiration(wrapper.event.getCorrelationId(), expiration);
        }
    }
}

