/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue.consumer;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.qspace.QueueState;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueCollection;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessState;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.AbstractRegisteredConsumersPool;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.AcknowledgementList;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.DeliveryState;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.ProcessQueueEventWrapper;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.Recipient;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.FabricThreadPool;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.advisory.StateAdvisory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class RConsumer
implements Runnable {
    private AbstractRegisteredConsumersPool pool;
    private ProcessQueueCollection queue;
    private int consumerId;
    protected List<Recipient> recipients = new ArrayList<Recipient>();
    private FabricThreadPool recipientsThreadPool = null;
    protected JSerializer serializer = null;
    protected Session session;
    protected ProcessQueueCollection.PollerConfiguration pollerConfiguration;
    protected Logger logger = null;

    RConsumer(AbstractRegisteredConsumersPool pool, int consumerId, Logger logger) {
        this.pool = pool;
        this.queue = pool.getPoller().getQueue();
        this.consumerId = consumerId;
        this.logger = logger;
        try {
            this.serializer = JSerializerFactory.getInstance().createSerializer("RegisteredConsumer." + this.queue.getName() + this.getName() + ".CloneSupport");
        }
        catch (Exception exception) {
            this.log(null, "Failed to create serializer. Cause: " + exception.getMessage(), Trace.Level.ERROR);
        }
    }

    public ProcessQueueCollection getQueue() {
        return this.queue;
    }

    public String getName() {
        return "#" + this.consumerId;
    }

    public void destroy() {
        this.deallocateRecipientsThreadPool();
        if (this.serializer != null) {
            try {
                JSerializerFactory.getInstance().discardSerializer(this.serializer.getName());
            }
            catch (FactoryManagerException exception) {
                this.log(null, "Failed to discard serializer. Cause: " + exception.getMessage(), Trace.Level.ERROR);
            }
        }
    }

    @Override
    public void run() {
        Session session = this.pool.getPoller().getDataspace().createSession();
        if (session == null || session.isClosed()) {
            this.log(null, "Unable to open session to parent QSPACE. Suspending...", Trace.Level.ERROR);
            this.queue.suspend(null);
            return;
        }
        this.log(null, "Registered consumer thread started.", Trace.Level.INFO);
        try {
            while (this.pool.getPoller().isRunning()) {
                this.run(session, this.pool.takeOngoingEvent());
            }
        }
        finally {
            this.log(null, "Registered consumer thread finished.", Trace.Level.INFO);
            if (session != null) {
                session.close();
            }
            this.destroy();
        }
    }

    public void run(Session session, ProcessQueueEventWrapper wrapper) {
        this.log(wrapper, "Run message...", Trace.Level.DEBUG);
        if (wrapper == null) {
            return;
        }
        this.pollerConfiguration = this.queue.getPollerConfiguration();
        if (this.pollerConfiguration == null) {
            return;
        }
        this.session = session;
        this.allocateRecipientsThreadPool();
        if (!this.existEnabledRecipients() || this.queue.getQueueState(session) != QueueState.RUNNING) {
            try {
                this.pool.updateProcessState(session, wrapper, ProcessState.ENQUEUED);
            }
            catch (Exception e) {
                this.log(wrapper, "Failed to update process state to UNKNOWN. Cause: " + e.getMessage(), Trace.Level.ERROR);
            }
            return;
        }
        this.handleEvent(wrapper);
    }

    private void handleEvent(ProcessQueueEventWrapper wrapper) {
        try {
            this.applyMetasets(this.session, wrapper);
            this.offerToRecipients(wrapper);
            this.processRecipientStates(wrapper);
        }
        catch (Throwable exception) {
            this.log(wrapper, "Failed to handle process. Cause: " + exception.getMessage(), Trace.Level.ERROR);
            try {
                this.pool.updateProcessState(this.session, wrapper, ProcessState.UNKNOWN);
            }
            catch (Exception e) {
                this.log(wrapper, "Failed to update process state to UNKNOWN. Cause: " + e.getMessage(), Trace.Level.ERROR);
            }
        }
    }

    void log(ProcessQueueEventWrapper wrapper, String message, Trace.Level level) {
        if (this.pool.getPoller().isLogEnabled(level)) {
            message = this.getLogPrefix(wrapper) + ". " + (String)message;
            this.pool.getPoller().log(wrapper, (String)message, level);
        }
    }

    private String getLogPrefix(ProcessQueueEventWrapper wrapper) {
        return "Registered Consumer '" + this.getName() + "'";
    }

    private void offerToRecipients(ProcessQueueEventWrapper wrapper) throws Exception {
        this.log(wrapper, "Applying message to recipients.", Trace.Level.DEBUG);
        if (wrapper.receipts == null) {
            wrapper.receipts = new AcknowledgementList(this.recipients);
        }
        final CountDownLatch[] countDownLatch = new CountDownLatch[1];
        ArrayList<1> runnables = new ArrayList<1>();
        for (final Recipient recipient : this.recipients) {
            if (wrapper.receipts.getReceipt(recipient.getName()) == DeliveryState.ACKNOWLEDGED) continue;
            if (recipient.isEnabled() && recipient.matches(wrapper.event)) {
                final ProcessQueueEventWrapper processQueueEventWrapper = runnables.size() > 0 ? this.cloneEventWrapper(wrapper) : wrapper;
                runnables.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RConsumer.this.log(processQueueEventWrapper, "Offered to '" + recipient.getName() + "' recipient.", Trace.Level.DEBUG);
                            recipient.onEvent(RConsumer.this, processQueueEventWrapper, RConsumer.this.pollerConfiguration.recipientTimeout);
                        }
                        finally {
                            countDownLatch[0].countDown();
                        }
                    }
                });
                wrapper.receipts.updateReceipt(recipient.getName(), DeliveryState.SENT);
                continue;
            }
            wrapper.receipts.updateReceipt(recipient.getName(), DeliveryState.NOT_INTERESTED);
        }
        countDownLatch[0] = new CountDownLatch(runnables.size());
        this.queue.updateReceipts(this.session, wrapper);
        if (runnables.size() > 1) {
            ArrayList futures = new ArrayList();
            for (Runnable runnable : runnables) {
                futures.add(this.recipientsThreadPool.addTask(runnable));
            }
            try {
                if (countDownLatch[0].await(this.pollerConfiguration.recipientTimeout + 10000L, TimeUnit.MILLISECONDS)) {
                    this.log(wrapper, "Acks from all recipients received.", Trace.Level.DEBUG);
                } else {
                    this.log(wrapper, "Not all recipients finished. Canceling by timeout. Acks " + countDownLatch[0].getCount() + " from " + futures.size() + " not received.", Trace.Level.ERROR);
                }
            }
            catch (InterruptedException interruptedException) {
                this.log(wrapper, "RConsumer thread is interrupted.", Trace.Level.ERROR);
                this.log(wrapper, "Acks " + countDownLatch[0].getCount() + " from " + futures.size() + " not recieved.", Trace.Level.ERROR);
                Thread.currentThread().interrupt();
            }
            for (Future future : futures) {
                if (!future.isDone()) {
                    future.cancel(true);
                }
                try {
                    future.get();
                }
                catch (Exception exception) {
                    this.log(wrapper, "Recipient thrown exception: " + exception.getMessage(), Trace.Level.ERROR);
                }
            }
        } else if (runnables.size() == 1) {
            ((Runnable)runnables.get(0)).run();
        }
        this.queue.updateReceipts(this.session, wrapper);
    }

    private void processRecipientStates(ProcessQueueEventWrapper wrapper) throws Exception {
        this.log(wrapper, "Processing recipient states.", Trace.Level.DEBUG);
        boolean suspendRequested = false;
        boolean reofferIsRequired = false;
        boolean acknowledged = true;
        ProcessState newState = null;
        for (String recipient : wrapper.receipts.getRecipientNames()) {
            DeliveryState state = wrapper.receipts.getReceipt(recipient);
            if (state == DeliveryState.UNDELIVERED) {
                newState = ProcessState.SKIPPED;
                acknowledged = false;
                break;
            }
            if (state == DeliveryState.NOT_INTERESTED) {
                newState = ProcessState.UNACKNOWLEDGED;
                acknowledged = false;
                continue;
            }
            if (state == DeliveryState.EXPIRATION_REQUESTED) {
                newState = ProcessState.PENDING;
                acknowledged = false;
                break;
            }
            if (state == DeliveryState.UNACKNOWLEDGED || state == DeliveryState.SENT) {
                newState = ProcessState.UNACKNOWLEDGED;
                acknowledged = false;
                reofferIsRequired = true;
                break;
            }
            if (state == DeliveryState.SUSPEND_REQUESTED) {
                newState = ProcessState.UNDELIVERED;
                acknowledged = false;
                suspendRequested = true;
                break;
            }
            if (state != DeliveryState.RETRY_REQUESTED) continue;
            newState = ProcessState.LOCKED_FOR_OFFER;
            acknowledged = false;
            reofferIsRequired = true;
            break;
        }
        this.log(wrapper, "After recipient states processing newState : " + String.valueOf(newState) + ", acknowledged: " + acknowledged + ", suspendRequested: " + suspendRequested + ", reofferIsRequired: " + reofferIsRequired, Trace.Level.DEBUG);
        if (newState != null) {
            this.pool.updateProcessState(this.session, wrapper, newState);
        }
        if (acknowledged) {
            this.queue.acknowledge(this.session, wrapper.event.getCorrelationId());
            this.log(wrapper, "Process has been acknowledged.", Trace.Level.DEBUG);
        } else if (suspendRequested && this.pollerConfiguration.suspendOnFailure) {
            this.suspendOffer(wrapper);
        } else if (reofferIsRequired) {
            this.reoffer(wrapper);
        }
    }

    private void suspendOffer(ProcessQueueEventWrapper wrapper) {
        this.queue.suspend(this.session);
        try {
            StateAdvisory advisory = this.pool.getPoller().getDataspace().getAdvisoriesFactory().createAdvisory("qspace.ProcessQueue.ConsumerSuspended");
            advisory.setProperty("dataspace", this.pool.getPoller().getDataspace().getName());
            advisory.setProperty("collection", this.queue.getName());
            advisory.setProperty("consumer", this.getName());
            this.pool.getPoller().getDataspace().raiseSystemAdvisory(advisory);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        this.log(wrapper, "Registered consumer has been suspended.", Trace.Level.DEBUG);
    }

    private void reoffer(ProcessQueueEventWrapper wrapper) throws Exception {
        this.log(wrapper, "Evaluating attempts, offerInterval: " + this.pollerConfiguration.offerInterval, Trace.Level.DEBUG);
        if (wrapper.attempts < this.pollerConfiguration.maxAttempts) {
            try {
                if (this.pollerConfiguration.offerInterval > 0L) {
                    Thread.sleep(this.pollerConfiguration.offerInterval);
                }
            }
            catch (InterruptedException e) {
                this.log(wrapper, "Offer thread has been interrupted.", Trace.Level.ERROR);
                this.pool.updateProcessState(this.session, wrapper, ProcessState.ENQUEUED);
                return;
            }
            this.log(wrapper, "Retrying process, attempt N" + (wrapper.attempts + 1) + " of " + this.pollerConfiguration.maxAttempts, Trace.Level.DEBUG);
            this.queue.lockProcessForOfferAndIncreaseNumberOfAttempts(this.session, wrapper);
            this.handleEvent(wrapper);
            try {
                StateAdvisory advisory = this.pool.getPoller().getDataspace().getAdvisoriesFactory().createAdvisory("qspace.ProcessQueue.ConsumerReoffer");
                advisory.setProperty("dataspace", this.pool.getPoller().getDataspace().getName());
                advisory.setProperty("collection", this.queue.getName());
                advisory.setProperty("consumer", this.getName());
                advisory.setProperty("attempt", "" + wrapper.attempts);
                this.pool.getPoller().getDataspace().raiseSystemAdvisory(advisory);
            }
            catch (Exception exception) {
                this.log(wrapper, "Failed to raise process queue reoffer advisory. Cause: " + exception.getMessage(), Trace.Level.ERROR);
            }
        } else {
            this.log(wrapper, "Maximum number of attempts has been exceeded for process", Trace.Level.DEBUG);
            this.pool.updateProcessState(this.session, wrapper, ProcessState.UNACKNOWLEDGED);
            if (this.pollerConfiguration.suspendOnFailure) {
                this.suspendOffer(wrapper);
            }
        }
    }

    private void applyMetasets(Session session, ProcessQueueEventWrapper wrapper) {
        this.log(wrapper, "Applying metasets to message.", Trace.Level.DEBUG);
        Map<String, Object> metaset = this.pool.getPoller().getQueue().getMetaset(session, wrapper.event.getCorrelationId());
        if (metaset != null) {
            for (Map.Entry<String, Object> metaSetEntry : metaset.entrySet()) {
                try {
                    this.log(wrapper, "Setting process metaset '" + metaSetEntry.getKey() + "' to value '" + String.valueOf(metaSetEntry.getValue()) + "'.", Trace.Level.DEBUG);
                    wrapper.event.setEventObjectProperty(metaSetEntry.getKey(), metaSetEntry.getValue());
                }
                catch (Exception error) {
                    this.log(wrapper, "Unable to set process metaset '" + metaSetEntry.getKey() + "' to value '" + String.valueOf(metaSetEntry.getValue()) + "'.", Trace.Level.ERROR);
                }
            }
        }
    }

    private void deallocateRecipientsThreadPool() {
        if (this.recipientsThreadPool != null) {
            this.recipientsThreadPool.stop();
        }
    }

    private void allocateRecipientsThreadPool() {
        this.recipients = new ArrayList<Recipient>(this.pool.getPoller().getQueue().getRecipients());
        if (this.recipients != null && this.recipients.size() > 1) {
            if (this.recipientsThreadPool != null && this.recipientsThreadPool.getMaximumThreadsNumber() != this.recipients.size()) {
                this.deallocateRecipientsThreadPool();
            }
            if (this.recipientsThreadPool == null) {
                this.recipientsThreadPool = FabricThreadManager.getInstance().createThreadPool(ThreadPoolType.FIXED, "DSYS:ProcessQueueRegisteredConsumer:RecipientThreadPool:" + this.queue.getName(), "Offers event to recipients.", this.recipients.size());
            }
        } else {
            this.deallocateRecipientsThreadPool();
        }
    }

    private boolean existEnabledRecipients() {
        if (this.recipients == null || this.recipients.size() == 0) {
            return false;
        }
        for (Recipient recipient : this.recipients) {
            if (!recipient.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private ProcessQueueEventWrapper cloneEventWrapper(ProcessQueueEventWrapper wrapper) {
        try {
            ProcessQueueEventWrapper newWrapper = new ProcessQueueEventWrapper(wrapper);
            byte[] data = this.serializer.serialize(wrapper.event);
            newWrapper.event = (EventDatagram)this.serializer.deserialize(data);
            return newWrapper;
        }
        catch (Exception exception) {
            this.log(wrapper, "Unable to clone process. Cause: " + exception.getMessage(), Trace.Level.ERROR);
            throw new DataspaceException("Failed to clone process. Cause: " + exception.getMessage());
        }
    }

    protected synchronized void setProcessExpiration(String processId, long expiration) {
        this.queue.setProcessExpiration(this.session, processId, expiration);
    }
}

