/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue.consumer;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.schema.collection.qspace.QueueState;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueCollection;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.ProcessQueueEventWrapper;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.RegisteredConsumerPoolSingleThreadImpl;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.RegisteredConsumersPool;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.RegisteredConsumersPoolImpl;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;

public class ProcessQueuePoller
implements Runnable {
    private FabricThread<?> thread;
    private ProcessQueueCollection queue;
    protected AbstractDataspace dataspace;
    protected Session session;
    protected volatile boolean isRunning;
    protected RegisteredConsumersPool registeredConsumersPool;
    private Object queueStateChangeMutex = new Object();

    public ProcessQueuePoller(ProcessQueueCollection queue, AbstractDataspace dataspace) {
        this.queue = queue;
        this.dataspace = dataspace;
        this.thread = FabricThreadManager.getInstance().createThread("DSYS:ProcessQueuePoller:" + queue.getName(), "Polls messages from the process queue and offers them to registered consumers.", this);
        this.registeredConsumersPool = queue.getPollerConfiguration().parallelDegree == 1 ? new RegisteredConsumerPoolSingleThreadImpl(this, dataspace) : new RegisteredConsumersPoolImpl(this, dataspace);
    }

    public void start() {
        this.log(null, "Starting queue polling thread...", Trace.Level.INFO);
        this.isRunning = true;
        this.thread.start();
    }

    public void stop() {
        this.log(null, "Finishing queue polling thread...", Trace.Level.DEBUG);
        this.isRunning = false;
        this.thread.stop();
        this.thread.join(1000L);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public ProcessQueueCollection getQueue() {
        return this.queue;
    }

    public AbstractDataspace getDataspace() {
        return this.dataspace;
    }

    @Override
    public void run() {
        this.log(null, "Process queue polling thread started.", Trace.Level.INFO);
        this.session = this.dataspace.createSession();
        if (this.session == null || this.session.isClosed()) {
            this.log(null, "Unable to open session to parent QSPACE. Suspending...", Trace.Level.ERROR);
            this.queue.suspend(null);
            return;
        }
        this.registeredConsumersPool.start();
        while (this.isRunning) {
            try {
                if (this.isQueueRunning() && this.queue.existEnabledRecipients()) {
                    this.log(null, "Polling for the new message.", Trace.Level.DEBUG);
                    ProcessQueueEventWrapper wrapper = this.queue.getEventForPoller(this.session);
                    if (wrapper == null || !this.isQueueRunning() || !this.queue.existEnabledRecipients()) continue;
                    this.log(wrapper, "New message polled, handling...", Trace.Level.DEBUG);
                    this.registeredConsumersPool.handleEvent(this.session, wrapper);
                    this.log(wrapper, "Message handled.", Trace.Level.DEBUG);
                    continue;
                }
                this.waitForQueueIsRunning();
            }
            catch (InterruptedException e) {
                this.isRunning = false;
                break;
            }
            catch (Throwable exception) {
                this.log(null, exception.getMessage(), Trace.Level.ERROR);
            }
        }
        this.registeredConsumersPool.stop(this.session);
        if (this.session != null && !this.session.isClosed()) {
            this.session.close();
        }
        this.log(null, "Process queue polling thread finished.", Trace.Level.INFO);
    }

    private boolean isQueueRunning() {
        return this.queue.getQueueState(this.session) == QueueState.RUNNING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForQueueIsRunning() throws InterruptedException {
        this.log(null, "Waiting for queue is running.", Trace.Level.DEBUG);
        if (this.isQueueRunning() && this.queue.existEnabledRecipients()) {
            return true;
        }
        Object object = this.queueStateChangeMutex;
        synchronized (object) {
            if (this.isQueueRunning() && this.queue.existEnabledRecipients()) {
                return true;
            }
            this.queueStateChangeMutex.wait(60000L);
            return this.isQueueRunning() && this.queue.existEnabledRecipients();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueStateChanged() {
        Object object = this.queueStateChangeMutex;
        synchronized (object) {
            this.queueStateChangeMutex.notify();
        }
    }

    protected void log(ProcessQueueEventWrapper wrapper, String message, Trace.Level level) {
        if (!this.isLogEnabled(level)) {
            return;
        }
        message = this.getLogPrefix(wrapper) + (String)message;
        switch (level) {
            case DEBUG: {
                this.dataspace.logDebug(this.queue.getName(), (String)message);
                break;
            }
            case INFO: {
                this.dataspace.logInfo(this.queue.getName(), (String)message);
                break;
            }
            default: {
                this.dataspace.logInfo(this.queue.getName(), (String)message);
            }
        }
    }

    protected boolean isLogEnabled(Trace.Level level) {
        if (this.dataspace.getLogger() != null) {
            return this.dataspace.getLogger().isLogEnabled(level);
        }
        return Trace.isEnabled(this.dataspace.getClass(), level);
    }

    private String getLogPrefix(ProcessQueueEventWrapper wrapper) {
        return wrapper != null ? " [Process Id '" + wrapper.event.getCorrelationId() + "']: " : "";
    }
}

