/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue.consumer;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.ProcessQueueEventWrapper;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.RConsumer;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.Recipient;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sef.FabricEventSinkException;
import com.streamscape.sef.FabricEventSourceException;

public class CertifiedRecipient
extends Recipient {
    protected String token = null;

    public CertifiedRecipient(AbstractDataspace dataspace, String name, String token, String subscriptionRule, String eventId, boolean enabled) {
        super(dataspace, name, subscriptionRule, eventId, enabled);
        this.token = token;
    }

    @Override
    protected void prepareEventForOffer(EventDatagram event) throws FabricEventSinkException, FabricEventSourceException, SDOException {
        super.prepareEventForOffer(event);
        event.setSecurityAssertionToken(this.token);
    }

    @Override
    protected void processAck(RConsumer consumer, ProcessQueueEventWrapper wrapper, AcknowledgementEvent ack) throws SDOException, SecurityViolationException {
        consumer.log(wrapper, "Recipient '" + this.name + "': acknowledgement with '" + ack.getAction().name() + "' ack action received for.", Trace.Level.DEBUG);
        if (!ack.getSecurityAssertionToken().equals(this.token)) {
            consumer.log(wrapper, "Recipient '" + this.name + "': Received acknowledgement from illegal recipient.", Trace.Level.ERROR);
            return;
        }
        super.processAck(consumer, wrapper, ack);
    }

    public String getToken() {
        return this.token;
    }
}

