/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue.consumer;

import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.DeliveryState;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.Recipient;
import java.util.ArrayList;
import java.util.List;

public class AcknowledgementList {
    protected String[] recipientNames = null;
    protected DeliveryState[] states = null;

    public AcknowledgementList(List<Recipient> recipients) {
        this(recipients, DeliveryState.NOT_INTERESTED);
    }

    public AcknowledgementList(List<Recipient> recipients, DeliveryState initialState) {
        int size = recipients.size();
        this.recipientNames = new String[size];
        this.states = new DeliveryState[size];
        for (int i = 0; i < size; ++i) {
            Recipient recipient = recipients.get(i);
            this.recipientNames[i] = recipient.name;
            this.states[i] = recipient.isEnabled() ? initialState : DeliveryState.NOT_INTERESTED;
        }
    }

    public synchronized void updateReceipt(String name, DeliveryState state) {
        int size = this.recipientNames.length;
        for (int i = 0; i < size; ++i) {
            if (!this.recipientNames[i].equals(name)) continue;
            this.states[i] = state;
            break;
        }
    }

    public synchronized DeliveryState getReceipt(String token) {
        int size = this.recipientNames.length;
        for (int i = 0; i < size; ++i) {
            if (!this.recipientNames[i].equals(token)) continue;
            return this.states[i];
        }
        return DeliveryState.NOT_INTERESTED;
    }

    public synchronized List<String> getRecipientNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.recipientNames) {
            names.add(name);
        }
        return names;
    }
}

