/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue.consumer;

import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessState;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.ProcessQueueEventWrapper;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.ProcessQueuePoller;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.RegisteredConsumersPool;
import com.streamscape.ds.session.Session;

abstract class AbstractRegisteredConsumersPool
implements RegisteredConsumersPool {
    protected ProcessQueuePoller poller;
    private long lastEventTime = 0L;

    AbstractRegisteredConsumersPool(ProcessQueuePoller poller) {
        this.poller = poller;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop(Session session) {
    }

    public ProcessQueuePoller getPoller() {
        return this.poller;
    }

    protected void lockEvent(Session session, ProcessQueueEventWrapper wrapper) {
        this.poller.getQueue().lockProcessForOfferAndIncreaseNumberOfAttempts(session, wrapper);
    }

    public ProcessQueueEventWrapper takeOngoingEvent() {
        return null;
    }

    public void updateProcessState(Session session, ProcessQueueEventWrapper wrapper, ProcessState newState) throws Exception {
        if (!this.poller.getQueue().updateProcessState(session, wrapper.event.getCorrelationId(), newState)) {
            throw new Exception("Failed to update process state to " + String.valueOf((Object)newState) + ".");
        }
    }

    protected void sleepForOfferInterval() {
        long offerInterval = this.poller.getQueue().getPollerConfiguration().offerInterval;
        if (offerInterval > 0L) {
            long timeToSleep;
            if (this.lastEventTime > 0L && (timeToSleep = offerInterval - (System.currentTimeMillis() - this.lastEventTime)) > 0L) {
                try {
                    Thread.sleep(timeToSleep);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            this.lastEventTime = System.currentTimeMillis();
        }
    }
}

