/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.qspace.QSpaceSysTablesManager;
import com.streamscape.ds.schema.collection.qspace.QueueState;
import com.streamscape.ds.schema.collection.qspace.pqueue.AbstractProcessQueueTableManager;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;

public class ProcessQueueStateTableManager
extends AbstractProcessQueueTableManager {
    public static String TABLE_NAME = "PROCESS_QUEUE_STATE";
    protected Statement getQueueStateStat;
    protected Statement insertQueueStateStat;
    protected Statement updateQueueStateStat;
    protected Statement removeQueueStateStat;

    public ProcessQueueStateTableManager(QSpaceSysTablesManager manager) {
        super(manager, TABLE_NAME);
    }

    public void initialize(Session session) {
        Table processQueueStateTable = (Table)this.manager.getStore().schemaManager.findSchemaObject(this.getTableName(), this.manager.getQspace().getObjectName().name, 3);
        if (processQueueStateTable == null) {
            NameManager.ObjectName processQueueStateTableName = this.manager.getStore().nameManager.newObjectName(this.getTableName(), false, 3);
            processQueueStateTableName.schema = this.manager.getQspace().getObjectName();
            processQueueStateTable = TableUtil.newTable(this.manager.getStore(), 6, processQueueStateTableName);
            TableUtil.addColumn(processQueueStateTable, "QUEUE_NAME", Type.STRING);
            TableUtil.addColumn(processQueueStateTable, "STATE", Type.STRING);
            NameManager.ObjectName indexName = NameManager.newInfoSchemaObjectName(processQueueStateTableName.name, processQueueStateTableName.isNameQuoted, 21);
            processQueueStateTable.createPrimaryKeyConstraint(indexName, new int[]{0}, true);
            processQueueStateTable.setColumnStructures();
            processQueueStateTable.compile(session, null);
            this.manager.getStore().schemaManager.addSchemaObject(processQueueStateTable);
        }
    }

    public synchronized void updateQueueStateConfiguration(Session session, String queueName, QueueState state) {
        Result result;
        if (this.updateQueueStateStat == null) {
            this.updateQueueStateStat = session.compileStatement("update " + this.getFullTableName() + " set STATE = ? where QUEUE_NAME=?");
        }
        if ((result = session.executeCompiledStatement(this.updateQueueStateStat, new Object[]{state.toString(), queueName})).isError()) {
            throw new DataspaceException("Failed to update process queue state '" + queueName + "'. Cause: " + result.getException().toString());
        }
        if (result.getUpdateCount() == 0) {
            if (this.insertQueueStateStat == null) {
                this.insertQueueStateStat = session.compileStatement("insert into " + this.getFullTableName() + " values(?,?)");
            }
            if ((result = session.executeCompiledStatement(this.insertQueueStateStat, new Object[]{queueName, state.toString()})).isError()) {
                throw new DataspaceException("Failed to insert process queue state '" + queueName + "'. Cause: " + result.getException().toString());
            }
        }
    }

    public synchronized void removeQueueState(Session session, String queueName) {
        Result result;
        if (this.removeQueueStateStat == null) {
            this.removeQueueStateStat = session.compileStatement("delete from " + this.getFullTableName() + " where QUEUE_NAME=?");
        }
        if ((result = session.executeCompiledStatement(this.removeQueueStateStat, new Object[]{queueName})).isError()) {
            Trace.logError(DataspaceStore.class, "Unable to remove queue state for queue '" + queueName + "'.");
        }
    }

    public synchronized QueueState getQueueState(Session session, String queueName) {
        Result result;
        if (this.getQueueStateStat == null) {
            this.getQueueStateStat = session.compileStatement("select STATE from " + this.getFullTableName() + " where QUEUE_NAME=?");
        }
        if ((result = session.executeCompiledStatement(this.getQueueStateStat, new Object[]{queueName})).isError()) {
            throw new DataspaceException("Failed to get process queue state '" + queueName + "' on startup. Cause: " + result.getException().toString());
        }
        QueueState queueState = null;
        if (result.navigator.hasNext()) {
            try {
                result.navigator.next();
                String stringState = (String)result.navigator.getCurrent(0);
                queueState = QueueState.valueOf(stringState.toUpperCase());
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to convert initial queue state to QueueState. Cause: " + exception.getMessage());
            }
        }
        return queueState;
    }

    public void reset() {
        this.getQueueStateStat = null;
        this.insertQueueStateStat = null;
        this.updateQueueStateStat = null;
        this.removeQueueStateStat = null;
    }
}

