/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.qspace.QSpaceSysTablesManager;
import com.streamscape.ds.schema.collection.qspace.pqueue.AbstractProcessQueueTableManager;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.CertifiedRecipient;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.Recipient;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.util.ArrayList;
import java.util.List;

public class ProcessQueueRecipientsTableManager
extends AbstractProcessQueueTableManager {
    public static String TABLE_NAME = "PROCESS_QUEUE_RECIPIENTS";
    private Statement createRecipientStat;
    private Statement removeRecipientStat;
    private Statement getRecipientsStat;

    public ProcessQueueRecipientsTableManager(QSpaceSysTablesManager manager) {
        super(manager, TABLE_NAME);
    }

    public void initialize(Session session) {
        Table recipientsTable = (Table)this.manager.getStore().schemaManager.findSchemaObject(this.getTableName(), this.manager.getQspace().getObjectName().name, 3);
        if (recipientsTable == null) {
            NameManager.ObjectName recipientsTableName = this.manager.getStore().nameManager.newObjectName(this.getTableName(), false, 3);
            recipientsTableName.schema = this.manager.getQspace().getObjectName();
            recipientsTable = TableUtil.newTable(this.manager.getStore(), 6, recipientsTableName);
            TableUtil.addColumn(recipientsTable, "QUEUE_NAME", Type.STRING);
            TableUtil.addColumn(recipientsTable, "RECIPIENT_NAME", Type.STRING);
            TableUtil.addColumn(recipientsTable, "CRTOKEN", Type.STRING);
            TableUtil.addColumn(recipientsTable, "SUBSCRIPTION_RULE", Type.STRING);
            TableUtil.addColumn(recipientsTable, "EVENT_ID", Type.STRING);
            TableUtil.addColumn(recipientsTable, "ENABLED", Type.SQL_BOOLEAN);
            TableUtil.addColumn(recipientsTable, "CERTIFIED", Type.SQL_BOOLEAN);
            NameManager.ObjectName indexName = NameManager.newInfoSchemaObjectName(recipientsTableName.name, recipientsTableName.isNameQuoted, 21);
            recipientsTable.createPrimaryKeyConstraint(indexName, new int[]{0, 1}, true);
            recipientsTable.setColumnStructures();
            recipientsTable.compile(session, null);
            this.manager.getStore().schemaManager.addSchemaObject(recipientsTable);
        }
    }

    public synchronized void createRecipient(Session session, String queueName, Recipient recipient) {
        Result result;
        if (this.createRecipientStat == null) {
            String SQL = "insert into " + this.getFullTableName() + "(  QUEUE_NAME,   RECIPIENT_NAME,   CRTOKEN,   SUBSCRIPTION_RULE,   EVENT_ID,   ENABLED,   CERTIFIED)values (?,?,?,?,?,?,?)";
            this.createRecipientStat = session.compileStatement(SQL);
        }
        String token = null;
        boolean certified = false;
        if (recipient instanceof CertifiedRecipient) {
            certified = true;
            token = ((CertifiedRecipient)recipient).getToken();
        }
        if ((result = session.executeCompiledStatement(this.createRecipientStat, new Object[]{queueName, recipient.getName(), token, recipient.getSubscriptionRule(), recipient.getEventId(), recipient.isEnabled(), certified})).isError()) {
            Trace.logError(this, "Unable to register recipient '" + recipient.getName() + "' for queue '" + queueName + "'.");
            throw new DataspaceException("Failed to create recipient '" + recipient.getName() + "' for queue '" + queueName + "'.");
        }
    }

    public synchronized void removeRecipient(Session session, String queueName, String recipientName) {
        Result result;
        if (this.removeRecipientStat == null) {
            this.removeRecipientStat = session.compileStatement("delete from " + this.getFullTableName() + " where QUEUE_NAME = ? AND RECIPIENT_NAME = ?");
        }
        if ((result = session.executeCompiledStatement(this.removeRecipientStat, new Object[]{queueName, recipientName})).isError()) {
            Trace.logError(this, "Unable to drop recipient '" + recipientName + "'.");
            throw new DataspaceException("Unable to drop recipient '" + recipientName + "' for queue '" + queueName + "'.");
        }
    }

    public synchronized List<RecipientInfo> getRecipients(Session session, String queueName) {
        Result result;
        if (this.getRecipientsStat == null) {
            this.getRecipientsStat = session.compileStatement("select RECIPIENT_NAME,EVENT_ID,CRTOKEN,CERTIFIED,ENABLED,SUBSCRIPTION_RULE from " + this.getFullTableName() + " where QUEUE_NAME = ?");
        }
        if ((result = session.executeCompiledStatement(this.getRecipientsStat, new Object[]{queueName})).isError()) {
            Trace.logError(this, "Unable to get recipients for queue '" + queueName + "'.");
            throw new DataspaceException("Unable to get recipients for queue '" + queueName + "'.");
        }
        ArrayList<RecipientInfo> recipients = new ArrayList<RecipientInfo>();
        RowSetNavigator navigator = result.navigator;
        while (navigator.next()) {
            String recipientName = (String)navigator.getCurrent(0);
            String eventId = (String)navigator.getCurrent(1);
            String crToken = (String)navigator.getCurrent(2);
            Boolean certified = (Boolean)navigator.getCurrent(3);
            Boolean enabled = (Boolean)navigator.getCurrent(4);
            String subscriptionRule = (String)navigator.getCurrent(5);
            recipients.add(new RecipientInfo(recipientName, crToken, subscriptionRule, eventId, enabled, certified));
        }
        return recipients;
    }

    public void reset() {
        this.createRecipientStat = null;
        this.removeRecipientStat = null;
        this.getRecipientsStat = null;
    }

    public static class RecipientInfo {
        private String recipientName;
        private String token;
        private String subscriptionRule;
        private String eventId;
        private boolean enabled;
        private boolean certified;

        public RecipientInfo(String recipientName, String token, String subscriptionRule, String eventId, boolean enabled, boolean certified) {
            this.recipientName = recipientName;
            this.token = token;
            this.subscriptionRule = subscriptionRule;
            this.eventId = eventId;
            this.enabled = enabled;
            this.certified = certified;
        }

        public String getRecipientName() {
            return this.recipientName;
        }

        public String getToken() {
            return this.token;
        }

        public String getSubscriptionRule() {
            return this.subscriptionRule;
        }

        public String getEventId() {
            return this.eventId;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isCertified() {
            return this.certified;
        }
    }
}

