/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue;

import com.streamscape.cli.ds.collection.ProcessQueue;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.qspace.QueueState;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueProxy;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueRecipientsTableManager;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessState;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.enums.AcknowledgeAction;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ProcessQueueProxy
extends EventQueueProxy
implements ProcessQueue {
    @Override
    public void setPollerConfiguration(long offerInterval, long recipientTimeout, int maxAttempts, boolean suspendOnFailure) {
        this.invokeCollectionsMethod("setPollerConfiguration", offerInterval, recipientTimeout, maxAttempts, suspendOnFailure);
    }

    @Override
    public void setMaxAttempts(int maxAttempts) {
        this.invokeCollectionsMethod("setMaxAttempts", maxAttempts);
    }

    @Override
    public int getMaxAttempts() {
        return this.invokeCollectionsMethodWithReturn("getMaxAttempts", Integer.class, new Object[0]);
    }

    @Override
    public void setOfferInterval(long offerInterval) {
        this.invokeCollectionsMethod("setOfferInterval", offerInterval);
    }

    @Override
    public long getOfferInterval() {
        return this.invokeCollectionsMethodWithReturn("getOfferInterval", Long.class, new Object[0]);
    }

    @Override
    public void setRecipientTimeout(long recipientTimeout) {
        this.invokeCollectionsMethod("setRecipientTimeout", recipientTimeout);
    }

    @Override
    public long getRecipientTimeout() {
        return this.invokeCollectionsMethodWithReturn("getRecipientTimeout", Long.class, new Object[0]);
    }

    @Override
    public void setSuspendOnFailure(boolean suspendOnFailure) {
        this.invokeCollectionsMethod("setSuspendOnFailure", suspendOnFailure);
    }

    @Override
    public boolean getSuspendOnFailure() {
        return this.invokeCollectionsMethodWithReturn("getSuspendOnFailure", Boolean.class, new Object[0]);
    }

    @Override
    public void setParallelDegree(int parallelDegree) {
        this.invokeCollectionsMethod("setParallelDegree", parallelDegree);
    }

    @Override
    public int getParallelDegree() {
        return this.invokeCollectionsMethodWithReturn("getParallelDegree", Integer.class, new Object[0]);
    }

    @Override
    public void createCertifiedRecipient(String name, String token, String eventId, String subscriptionRule) {
        this.invokeCollectionsMethod("createCertifiedRecipient", name, token, eventId, subscriptionRule);
    }

    @Override
    public void createRecipient(String name, String eventId, String subscriptionRule) {
        this.invokeCollectionsMethod("createRecipient", name, eventId, subscriptionRule);
    }

    @Override
    public void disableRecipient(String name) {
        this.invokeCollectionsMethod("disableRecipient", name);
    }

    @Override
    public void discardProcess(String processId) {
        this.invokeCollectionsMethod("discardProcess", processId);
    }

    @Override
    public void enableRecipient(String name) {
        this.invokeCollectionsMethod("enableRecipient", name);
    }

    @Override
    public void dropRecipient(String name) {
        this.invokeCollectionsMethod("dropRecipient", name);
    }

    @Override
    public List<String> listRecipients() {
        return this.invokeCollectionsMethodWithReturn("listRecipients", List.class, new Object[0]);
    }

    @Override
    public List<ProcessQueueRecipientsTableManager.RecipientInfo> getRecipients() {
        return this.invokeCollectionsMethodWithReturn("getRecipients", List.class, new Object[0]);
    }

    @Override
    public void retryProcess(String processId) {
        this.invokeCollectionsMethod("retryProcess", processId);
    }

    @Override
    public void setProcessExpiration(String processId, long timeOfExpiration) {
        this.invokeCollectionsMethod("setProcessExpiration", processId, timeOfExpiration);
    }

    @Override
    public void resume() {
        this.invokeCollectionsMethod("resume", new Object[0]);
    }

    @Override
    public void suspend() {
        this.invokeCollectionsMethod("suspend", new Object[0]);
    }

    @Override
    public QueueState getQueueState() {
        return this.invokeCollectionsMethodWithReturn("getQueueState", QueueState.class, new Object[0]);
    }

    @Override
    public EventDatagram takeForLock() {
        return this.takeForLock("");
    }

    @Override
    public EventDatagram takeForLock(String selector) {
        return this.takeForLock(selector, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public EventDatagram takeForLock(long timeout, TimeUnit unit) {
        return this.takeForLock("", timeout, unit);
    }

    @Override
    public EventDatagram takeForLock(String selector, long timeout, TimeUnit unit) {
        return this.takeFor(selector, timeout, unit, ProcessState.LOCKED, false);
    }

    @Override
    public EventDatagram takeLastForLock() {
        return this.takeLastForLock("");
    }

    @Override
    public EventDatagram takeLastForLock(String selector) {
        return this.takeLastForLock(selector, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public EventDatagram takeLastForLock(long timeout, TimeUnit unit) {
        return this.takeLastForLock("", timeout, unit);
    }

    @Override
    public EventDatagram takeLastForLock(String selector, long timeout, TimeUnit unit) {
        return this.takeFor(selector, timeout, unit, ProcessState.LOCKED, true);
    }

    @Override
    public EventDatagram takeForOffer() {
        return this.takeForOffer("");
    }

    @Override
    public EventDatagram takeForOffer(String selector) {
        return this.takeForOffer(selector, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public EventDatagram takeForOffer(long timeout, TimeUnit unit) {
        return this.takeForOffer("", timeout, unit);
    }

    @Override
    public EventDatagram takeForOffer(String selector, long timeout, TimeUnit unit) {
        return this.takeFor(selector, timeout, unit, ProcessState.LOCKED_FOR_OFFER, false);
    }

    @Override
    public EventDatagram takeLastForOffer() {
        return this.takeLastForOffer("");
    }

    @Override
    public EventDatagram takeLastForOffer(String selector) {
        return this.takeLastForOffer(selector, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public EventDatagram takeLastForOffer(long timeout, TimeUnit unit) {
        return this.takeLastForOffer("", timeout, unit);
    }

    @Override
    public EventDatagram takeLastForOffer(String selector, long timeout, TimeUnit unit) {
        return this.takeFor(selector, timeout, unit, ProcessState.LOCKED_FOR_OFFER, true);
    }

    @Override
    public EventDatagram takeForBatch(String batchId) {
        return this.takeForBatch(batchId, "");
    }

    @Override
    public EventDatagram takeForBatch(String batchId, String selector) {
        return this.takeForBatch(batchId, selector, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public EventDatagram takeForBatch(String batchId, long timeout, TimeUnit unit) {
        return this.takeForBatch(batchId, "", timeout, unit);
    }

    @Override
    public EventDatagram takeForBatch(String batchId, String selector, long timeout, TimeUnit unit) {
        this.checkNotNull(batchId, "batchId");
        this.checkNotNull(selector, "selector");
        this.checkNotNull((Object)unit, "unit");
        return this.invokeCollectionsMethodWithReturn("takeForBatch", EventDatagram.class, new Object[]{selector, timeout, unit, batchId});
    }

    @Override
    public EventDatagram takeLastForBatch(String batchId) {
        return this.takeLastForBatch(batchId, "");
    }

    @Override
    public EventDatagram takeLastForBatch(String batchId, String selector) {
        return this.takeLastForBatch(batchId, selector, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public EventDatagram takeLastForBatch(String batchId, long timeout, TimeUnit unit) {
        return this.takeLastForBatch(batchId, "", timeout, unit);
    }

    @Override
    public EventDatagram takeLastForBatch(String batchId, String selector, long timeout, TimeUnit unit) {
        this.checkNotNull(batchId, "batchId");
        this.checkNotNull(selector, "selector");
        this.checkNotNull((Object)unit, "unit");
        return this.invokeCollectionsMethodWithReturn("takeLastForBatch", EventDatagram.class, new Object[]{selector, timeout, unit, batchId});
    }

    @Override
    public ProcessState getState(String processId) {
        ProcessState state = this.invokeCollectionsMethodWithReturn("getProcessState", ProcessState.class, processId);
        if (state == null) {
            throw new DataspaceException("Process with specified processId '" + processId + "' doesn't exist.");
        }
        return state;
    }

    @Override
    public void revert(String processId) {
        this.updateProcessState(processId, ProcessState.ENQUEUED);
    }

    @Override
    public void acknowledge(String processId) {
        this.updateProcessState(processId, ProcessState.ACKNOWLEDGED);
    }

    @Override
    public void fail(String processId) {
        this.updateProcessState(processId, ProcessState.UNDELIVERED);
    }

    @Override
    public void unacknowledge(String processId) {
        this.updateProcessState(processId, ProcessState.UNACKNOWLEDGED);
    }

    @Override
    public void skip(String processId) {
        this.updateProcessState(processId, ProcessState.SKIPPED);
    }

    @Override
    public void pend(String processId) {
        this.updateProcessState(processId, ProcessState.PENDING);
    }

    @Override
    public void expire(String processId) {
        this.updateProcessState(processId, ProcessState.EXPIRED);
    }

    @Override
    public void expire(String processId, ProcessQueue targetQueue) {
        this.updateStateAndPutTo(processId, ProcessState.EXPIRED, targetQueue);
    }

    @Override
    public void discard(String processId) {
        this.updateProcessState(processId, ProcessState.DISCARDED);
    }

    @Override
    public void discard(String processId, ProcessQueue targetQueue) {
        this.updateStateAndPutTo(processId, ProcessState.DISCARDED, targetQueue);
    }

    @Override
    public void acknowledge(String processId, AcknowledgeAction ackAction) {
        this.checkNotNull((Object)ackAction, "ackAction");
        this.invokeCollectionsMethod("acknowledge", new Object[]{processId, ackAction});
    }

    private EventDatagram takeFor(String selector, long timeout, TimeUnit unit, ProcessState newState, boolean isLast) {
        return this.takeFor("", selector, timeout, unit, newState, isLast);
    }

    private EventDatagram takeFor(String processId, String selector, long timeout, TimeUnit unit, ProcessState newState, boolean isLast) {
        this.checkNotNull(processId, "processId");
        this.checkNotNull(selector, "selector");
        this.checkNotNull((Object)unit, "unit");
        this.checkNotNull((Object)newState, "state");
        return this.invokeCollectionsMethodWithReturn(isLast ? "takeLastFor" : "takeFor", EventDatagram.class, new Object[]{processId, selector, timeout, unit, newState});
    }

    private void updateProcessState(String processId, ProcessState newState) {
        this.checkNotNull(processId, "processId");
        this.checkNotNull((Object)newState, "state");
        if (!this.invokeCollectionsMethodWithReturn("updateProcessState", Boolean.class, new Object[]{processId, newState}).booleanValue()) {
            throw new DataspaceException("Process '" + processId + "' doesn't exist.");
        }
    }

    private void updateStateAndPutTo(String processId, ProcessState newState, ProcessQueue targetQueue) {
        EventDatagram event = this.takeFor(processId, "", -1L, TimeUnit.MILLISECONDS, newState, false);
        if (event == null) {
            throw new DataspaceException("Event with specified processId '" + processId + "' doesn't exist.");
        }
        targetQueue.add(event);
    }
}

