/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueFactoryImpl;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueCollection;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueFactory;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessState;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.dii.AccessibleObjectProxy;

public class ProcessQueueFactoryImpl
extends EventQueueFactoryImpl {
    private ProcessState initialProcessState = null;
    private String metaTableName = null;
    private ProcessQueueCollection.PollerConfiguration pollerConfiguration = new ProcessQueueCollection.PollerConfiguration();

    public ProcessQueueFactoryImpl() {
        super(CollectionType.PROCESS_QUEUE);
    }

    public void setInitialProcessState(Session session, ProcessState processState) {
        this.initialProcessState = processState;
    }

    public ProcessState getInitialProcessState(Session session) {
        return this.initialProcessState;
    }

    public void setMetaTableName(Session session, String metaTableName) {
        this.metaTableName = metaTableName;
    }

    public String getMetaTableName(Session session) {
        return this.metaTableName;
    }

    public void setMaxAttempts(Session session, int maxAttempts) {
        this.pollerConfiguration.maxAttempts = maxAttempts;
    }

    public int getMaxAttempts(Session session) {
        return this.pollerConfiguration.maxAttempts;
    }

    public void setOfferInterval(Session session, long offerInterval) {
        this.pollerConfiguration.offerInterval = offerInterval;
    }

    public long getOfferInterval(Session session) {
        return this.pollerConfiguration.offerInterval;
    }

    public void setRecipientTimeout(Session session, long recipientTimeout) {
        this.pollerConfiguration.recipientTimeout = recipientTimeout;
    }

    public long getRecipientTimeout(Session session) {
        return this.pollerConfiguration.recipientTimeout;
    }

    public void setSuspendOnFailure(Session session, boolean suspendOnFailure) {
        this.pollerConfiguration.suspendOnFailure = suspendOnFailure;
    }

    public boolean getSuspendOnFailure(Session session) {
        return this.pollerConfiguration.suspendOnFailure;
    }

    public void setParallelDegree(Session session, int parallelDegree) {
        this.pollerConfiguration.parallelDegree = parallelDegree;
    }

    public int getParallelDegree(Session session) {
        return this.pollerConfiguration.parallelDegree;
    }

    @Override
    public String getCreateSql(Session session, String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("create ").append(this.getMemoryModel(session).name()).append(" process queue ").append(name);
        buffer.append(" constrained by [").append(this.getConstraint(session)).append("]");
        this.appendConsumerInfo(session, buffer);
        if (this.initialProcessState != null) {
            buffer.append(" initial process state ").append(this.initialProcessState.toString());
        }
        if (this.metaTableName != null && this.metaTableName.length() > 0) {
            buffer.append(" with metaset ").append(this.metaTableName);
        }
        this.appendWindowInformation(session, buffer);
        buffer.append(" max attempts ").append(this.pollerConfiguration.maxAttempts);
        buffer.append(" offer interval ").append(this.pollerConfiguration.offerInterval);
        buffer.append(" recipient timeout ").append(this.pollerConfiguration.recipientTimeout);
        buffer.append(" suspend on fail ").append(this.pollerConfiguration.suspendOnFailure);
        buffer.append(" parallel degree ").append(this.pollerConfiguration.parallelDegree);
        return buffer.toString();
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new ProcessQueueFactory();
    }
}

