/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.pqueue;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataCollection;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.LogRecordType;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.qspace.AbstractQueueCollection;
import com.streamscape.ds.schema.collection.qspace.QueueState;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueCollection;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueException;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueProxy;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueRecipientsTableManager;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessState;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessStateChange;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.AcknowledgementList;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.CertifiedRecipient;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.ProcessQueueEventWrapper;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.ProcessQueuePoller;
import com.streamscape.ds.schema.collection.qspace.pqueue.consumer.Recipient;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.schema.table.TableWorks;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.EventPropertiesMapper;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.advisory.StateAdvisory;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sdo.utils.EventPrototypeComparator;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.service.osf.config.ActiveEvent;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;

public class ProcessQueueCollection
extends EventQueueCollection
implements DataCollection,
AccessibleObject {
    public static final String META_KEY = "MetaKey";
    public static final String META_VALUE = "MetaValue";
    public static final int INITIAL_BLOB_SIZE = 1024;
    protected List<Recipient> recipients = null;
    protected QueueState state = QueueState.STOPPED;
    protected Statement updateReceiptsStat = null;
    protected Statement retryProcessStat = null;
    protected Statement reofferProcessStat = null;
    protected Statement discardProcessStat = null;
    protected Statement getProcessStateStat = null;
    protected Statement setProcessStateStat = null;
    protected Statement setProcessExpirationStat = null;
    protected Statement acknowledgeProcessStat = null;
    protected Statement getElementStat = null;
    protected Statement getLastElementStat = null;
    protected Statement pushElementStat = null;
    protected Statement getElementByIdStat = null;
    protected Statement queueStatisticsStat = null;
    protected Statement getMetaSetStat = null;
    protected Statement setMetaStat = null;
    protected Statement recoverLockedMessagesStat = null;
    protected Statement getEventForPollerStat = null;
    protected Statement lockProcessForOfferAndIncreaseNumberOfAttempts = null;
    protected ProcessState initialProcessState = null;
    protected NameManager.ObjectName metasetTableName = null;
    private PollerConfiguration pollerConfiguration = new PollerConfiguration();
    private ProcessQueuePoller poller;

    public ProcessQueueCollection(DataspaceStore store, NameManager.ObjectName name, MemoryModel memoryModel, boolean isSourceEventBlob, boolean isConsumer, boolean isConsumerAsync) {
        super(store, name, CollectionType.PROCESS_QUEUE, memoryModel, null, null, true, isSourceEventBlob, isConsumer, isConsumerAsync);
        this.recipients = new CopyOnWriteArrayList<Recipient>();
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        Table metaSetTable;
        this.initEventMapper();
        this.intiEventIdFilter();
        NameManager.ObjectName internalTableName = this.store.nameManager.newObjectName(this.name.name, this.name.isNameQuoted, 3);
        internalTableName.schema = this.name.schema;
        this.table = TableUtil.newTable(this.store, this.getInternalTableType(this.memoryModel), internalTableName);
        this.addIdentityColumn(this.table, "SeqId", Type.SQL_INTEGER);
        this.eventPropertiesMapper.addPropertyColumns(this.table);
        this.addColumn(this.table, "Attempt", Type.SQL_INTEGER);
        this.addColumn(this.table, "State", Type.STRING);
        this.addColumn(this.table, "Created", Type.SQL_TIMESTAMP);
        this.addColumn(this.table, "Acknowledged", Type.SQL_TIMESTAMP);
        this.addColumn(this.table, "Expiration", Type.SQL_TIMESTAMP);
        this.addColumn(this.table, "Receipts", Type.SQL_VARBINARY);
        this.initializeDataType(session);
        if (this.isSourceEventBlob) {
            this.addColumn(this.table, "Event", Type.SQL_BLOB);
        } else {
            this.addColumn(this.table, "Event", this.dataType);
        }
        this.addColumn(this.table, "BatchId", Type.STRING);
        NameManager.ObjectName internalTableIndexName = NameManager.newInfoSchemaObjectName(internalTableName.name, internalTableName.isNameQuoted, 21);
        this.table.createPrimaryKeyConstraint(internalTableIndexName, new int[]{this.table.getColumnIndex("ProcessId")}, true);
        if (!session.isProcessingLog()) {
            TableWorks tableWorks = new TableWorks(session, this.table);
            NameManager.ObjectName seqIdUniqueIndexName = this.store.nameManager.newAutoName(this.table.getObjectName().name + "_SeqId", this.table.getObjectName().schema, this.table.getObjectName(), 21);
            tableWorks.addIndex(new int[]{this.table.getColumnIndex("SeqId")}, seqIdUniqueIndexName, true, null);
            NameManager.ObjectName stateIndexName = this.store.nameManager.newAutoName(this.table.getObjectName().name + "_State", this.table.getObjectName().schema, this.table.getObjectName(), 21);
            tableWorks.addIndex(new int[]{this.table.getColumnIndex("State")}, stateIndexName, false, null);
        }
        this.table.setColumnStructures();
        this.table.compile(session, parentObject);
        this.initializeDataType(session);
        if (this.metasetTableName != null && (metaSetTable = (Table)this.store.schemaManager.findSchemaObject(this.metasetTableName.name, this.dataspace.getObjectName().name, 3)) == null) {
            metaSetTable = TableUtil.newTable(this.store, this.getInternalTableType(this.memoryModel), this.metasetTableName);
            this.addColumn(metaSetTable, "ProcessId", Type.STRING);
            this.addColumn(metaSetTable, META_KEY, Type.STRING);
            this.addColumn(metaSetTable, META_VALUE, Type.STRING);
            NameManager.ObjectName indexName = NameManager.newInfoSchemaObjectName(this.metasetTableName.name, this.metasetTableName.isNameQuoted, 21);
            metaSetTable.createPrimaryKeyConstraint(indexName, new int[]{0, 1}, true);
            metaSetTable.setColumnStructures();
            metaSetTable.compile(session, parentObject);
            this.store.schemaManager.addSchemaObject(metaSetTable);
        }
        if (this.windowType != null) {
            this.activateWindow(session, internalTableName);
        }
    }

    @Override
    public void compileInternalStatements(Session session) {
        String SQL = "update " + this.name.getSchemaQualifiedStatementName() + " set                          State = ?,                         Attempt = ? where ProcessId = ? and (State = ? or State = ? or State = ? or State = ?)";
        this.retryProcessStat = session.compileStatement(SQL);
        SQL = "update " + this.name.getSchemaQualifiedStatementName() + " set State = ? where ProcessId = ?";
        this.setProcessStateStat = session.compileStatement(SQL);
        SQL = "update " + this.name.getSchemaQualifiedStatementName() + " set                          State = ?,                         Attempt = ?,                         Receipts = NULL where ProcessId = ? and State = ?";
        this.reofferProcessStat = session.compileStatement(SQL);
        SQL = "update " + this.name.getSchemaQualifiedStatementName() + " set                          State = ?,                         Attempt = ? where ProcessId = ? and (State = ? or State = ? or State = ? or State = ?)";
        this.discardProcessStat = session.compileStatement(SQL);
        SQL = "select State from " + this.name.getSchemaQualifiedStatementName() + " where ProcessId = ?";
        this.getProcessStateStat = session.compileStatement(SQL);
        SQL = "update " + this.name.getSchemaQualifiedStatementName() + " set Expiration = ? where ProcessId = ?";
        this.setProcessExpirationStat = session.compileStatement(SQL);
        SQL = "update " + this.name.getSchemaQualifiedStatementName() + " set State = ?, Acknowledged = ? where ProcessId = ?";
        this.acknowledgeProcessStat = session.compileStatement(SQL);
        SQL = "select Event from " + this.name.getSchemaQualifiedStatementName() + "  where ProcessId = ?";
        this.getElementByIdStat = session.compileStatement(SQL);
        SQL = "select top 1 Event, ProcessId from " + this.name.getSchemaQualifiedStatementName() + "  where State = ? order by SeqId asc";
        this.getElementStat = session.compileStatement(SQL);
        SQL = "select top 1 Event, ProcessId from " + this.name.getSchemaQualifiedStatementName() + "  where State = ? order by SeqId desc";
        this.getElementLastStat = session.compileStatement(SQL);
        SQL = "insert into " + this.name.getSchemaQualifiedStatementName() + "(" + this.eventPropertiesMapper.getColumnsNames() + "  Attempt,   State,   Created,   Receipts,   Event)values (" + this.eventPropertiesMapper.getParamsList() + "?,?,?,?,?)";
        this.pushElementStat = session.compileStatement(SQL);
        SQL = "update " + this.name.getSchemaQualifiedStatementName() + " set Receipts = ? where ProcessId = ?";
        this.updateReceiptsStat = session.compileStatement(SQL);
        SQL = "select State as \"State\",count(SeqId) as \"Count\" from " + this.name.getSchemaQualifiedStatementName() + " group by State";
        this.queueStatisticsStat = session.compileStatement(SQL);
        SQL = "select Event from " + this.name.getSchemaQualifiedStatementName() + " where SeqId = ?";
        this.getSourceEventStat = session.compileStatement(SQL);
        SQL = "select count(*) from " + this.name.getSchemaQualifiedStatementName();
        this.querySizeStat = session.compileStatement(SQL);
        SQL = "truncate collection " + this.name.getSchemaQualifiedStatementName();
        this.clearQueueStat = session.compileStatement(SQL);
        SQL = "update " + this.name.getSchemaQualifiedStatementName() + " set State = '" + String.valueOf((Object)ProcessState.UNDELIVERED) + "' where  State = '" + String.valueOf((Object)ProcessState.LOCKED_FOR_OFFER) + "'";
        this.recoverLockedMessagesStat = session.compileStatement(SQL);
        SQL = "select true from " + this.name.getSchemaQualifiedStatementName() + " where ProcessId = ?";
        this.containsStat = session.compileStatement(SQL);
        SQL = "delete from " + this.name.getSchemaQualifiedStatementName() + " where ProcessId = ?";
        this.removeElementByKeyStat = session.compileStatement(SQL);
        if (this.metasetTableName != null) {
            SQL = "select MetaKey,MetaValue from " + this.metasetTableName.getSchemaQualifiedStatementName() + " where ProcessId = ?";
            this.getMetaSetStat = session.compileStatement(SQL);
            SQL = "insert into " + this.metasetTableName.getSchemaQualifiedStatementName() + " VALUES (?,?,?)";
            this.setMetaStat = session.compileStatement(SQL);
        }
        SQL = "dfetch Event, ProcessId, Attempt, Receipts from " + this.name.getSchemaQualifiedStatementName() + " where State='" + String.valueOf((Object)ProcessState.ENQUEUED) + "' order by SeqId asc wait 50 sec";
        this.getEventForPollerStat = session.compileStatement(SQL);
        SQL = "update " + this.name.getSchemaQualifiedStatementName() + " set State = '" + String.valueOf((Object)ProcessState.LOCKED_FOR_OFFER) + "', Attempt = ? where ProcessId=?";
        this.lockProcessForOfferAndIncreaseNumberOfAttempts = session.compileStatement(SQL);
        if (this.store.getStoreState().isStarted()) {
            this.open(session);
            this.startPoller();
        }
    }

    @Override
    public void open(Session session) {
        super.doOpen(session);
        try {
            this.bindEvents();
        }
        catch (Exception error) {
            Trace.logException(ProcessQueueCollection.class, error, true);
        }
        QueueState initialQueueState = this.getQSpace().getQSpaceSysTablesManager().getPprocessQueueStateTableManager().getQueueState(session, this.getName());
        if (initialQueueState == null) {
            initialQueueState = QueueState.SUSPENDED;
        }
        this.updateQueueState(session, initialQueueState);
        if (this.state != QueueState.STOPPED) {
            this.doStart(session, this.state == QueueState.SUSPENDED);
        } else {
            this.loadRecipients(session);
        }
    }

    @Override
    public void start(Session session) {
        if (this.state == QueueState.STOPPED) {
            this.doStart(session, true);
            this.startPoller();
        }
    }

    private void doStart(Session session, boolean suspend) {
        super.start(session);
        if (suspend) {
            this.updateQueueState(session, QueueState.SUSPENDED);
        } else {
            this.updateQueueState(session, QueueState.RUNNING);
        }
        Result result = session.executeCompiledStatement(this.recoverLockedMessagesStat, new Object[0]);
        if (result.isError()) {
            Trace.logError(this, "Unable to recover locked for offer messages on startup. " + result.getException().toString());
        }
        if (result.getUpdateCount() > 0) {
            this.suspend(session);
        }
        this.loadRecipients(session);
    }

    public void startPoller() {
        if (this.state != QueueState.STOPPED && this.poller == null && this.pollerConfiguration.parallelDegree > 0) {
            this.poller = new ProcessQueuePoller(this, this.dataspace);
            this.poller.start();
        }
    }

    @Override
    public void stop(Session session) {
        super.stop(session);
        this.updateQueueState(session, QueueState.STOPPED);
        if (this.poller != null) {
            this.poller.stop();
            this.poller = null;
        }
    }

    public synchronized void suspend(Session session) {
        if (this.state != QueueState.RUNNING) {
            return;
        }
        if (this.state != QueueState.SUSPENDED) {
            this.updateQueueState(session, QueueState.SUSPENDED);
            try {
                StateAdvisory advisory = this.dataspace.getAdvisoriesFactory().createAdvisory("qspace.ProcessQueue.Suspended");
                advisory.setMessage("Process queue has been suspended. Please retry or discard undelivered messages.");
                advisory.setProperty("dataspace", this.dataspace.getName());
                advisory.setProperty("collection", this.getName());
                advisory.setEventGroupId(this.getCollectionName());
                this.dataspace.raiseSystemAdvisory(advisory);
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
    }

    public synchronized void resume(Session session) {
        if (this.state == QueueState.STOPPED) {
            this.doStart(session, false);
            this.startPoller();
        }
        if (this.state != QueueState.RUNNING) {
            this.updateQueueState(session, QueueState.RUNNING);
            try {
                StateAdvisory advisory = this.dataspace.getAdvisoriesFactory().createAdvisory("qspace.ProcessQueue.Resumed");
                advisory.setMessage("Process queue has resumed. ");
                advisory.setProperty("dataspace", this.dataspace.getName());
                advisory.setProperty("collection", this.getName());
                this.dataspace.raiseSystemAdvisory(advisory);
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
    }

    protected void bindEvents() throws Exception {
        this.bindProducerFor("exception.dataspace.ProcessQueue");
        this.dataspace.addSourceEventFlow("exception.dataspace.ProcessQueue", EventFlowEntity.DATASPACE_EVENT_EXCEPTION, this.getName(), this.getEventScope());
    }

    protected void unbindEvents() throws Exception {
        this.unbindProducerFor("exception.dataspace.ProcessQueue");
        this.dataspace.removeSourceEventFlow("exception.dataspace.ProcessQueue", EventFlowEntity.DATASPACE_EVENT_EXCEPTION, this.getName());
    }

    public void retryProcess(Session session, String processId, String comment) {
        ProcessState state = this.getProcessState(session, processId);
        if (this.state == QueueState.SUSPENDED && state != ProcessState.UNDELIVERED && state != ProcessState.UNACKNOWLEDGED) {
            throw new RuntimeException("Process '" + processId + "' could not be retried because process queue is suspended.");
        }
        Result result = session.executeCompiledStatement(this.retryProcessStat, new Object[]{ProcessState.ENQUEUED.name(), 0, processId, ProcessState.UNDELIVERED.name(), ProcessState.PENDING.name(), ProcessState.EXPIRED.name(), ProcessState.UNACKNOWLEDGED.name()});
        if (result.isError()) {
            Trace.logError(DataspaceStore.class, "Unable to retry process '" + processId + "'.");
        }
        ProcessQueueCollection.checkResultNotError(result);
        try {
            StateAdvisory advisory = this.dataspace.getAdvisoriesFactory().createAdvisory("qspace.ProcessQueue.RequestRetried");
            advisory.setProperty("dataspace", this.dataspace.getName());
            advisory.setProperty("collection", this.getName());
            advisory.setProperty("process_id", processId);
            advisory.setProperty("comment", comment);
            this.dataspace.raiseSystemAdvisory(advisory);
        }
        catch (Exception error) {
            Trace.logError(this, "Failed to raise retried advisory for process '" + processId + "'. Cause: " + error.getMessage());
            error.printStackTrace();
        }
    }

    public void reofferProcess(Session session, String processId, String comment) {
        if (this.state == QueueState.SUSPENDED) {
            throw new RuntimeException("Process '" + processId + "' could not be re-offered while process queue is suspended.");
        }
        Result result = session.executeCompiledStatement(this.reofferProcessStat, new Object[]{ProcessState.ENQUEUED.name(), 0, processId, ProcessState.ACKNOWLEDGED.name()});
        if (result.isError()) {
            Trace.logError(this, "Unable to re-offer process '" + processId + "'.");
        }
        ProcessQueueCollection.checkResultNotError(result);
        try {
            StateAdvisory advisory = this.dataspace.getAdvisoriesFactory().createAdvisory("qspace.ProcessQueue.RequestReoffered");
            advisory.setProperty("dataspace", this.dataspace.getName());
            advisory.setProperty("collection", this.getName());
            advisory.setProperty("process_id", processId);
            advisory.setProperty("comment", comment);
            this.dataspace.raiseSystemAdvisory(advisory);
        }
        catch (Exception error) {
            Trace.logError(this, "Failed to raise re-offered advisory for process '" + processId + "'. Cause: " + error.getMessage());
            error.printStackTrace();
        }
    }

    public void setProcessState(Session session, String processId, ProcessState processState) {
        ProcessState currentState = this.getProcessState(session, processId);
        if (this.state == QueueState.SUSPENDED) {
            throw new RuntimeException("Process '" + processId + "' state could not be changed while process queue is suspended.");
        }
        if (currentState == ProcessState.LOCKED_FOR_OFFER) {
            throw new RuntimeException("Process '" + processId + "' is locked for offer and its state could not be changed.");
        }
        Result result = session.executeCompiledStatement(this.setProcessStateStat, new Object[]{processState.name(), processId});
        if (result.isError()) {
            Trace.logError(this, "Unable to set process '" + processId + "' state to '" + String.valueOf((Object)processState) + "'.");
        }
        ProcessQueueCollection.checkResultNotError(result);
    }

    public void setProcessMeta(Session session, String processId, String key, String value) {
        Result result = session.executeCompiledStatement(this.setMetaStat, new Object[]{processId, key, value});
        if (result.isError()) {
            Trace.logError(DataspaceStore.class, "Unable to set process '" + processId + "' meta '" + key + "'.");
        }
        ProcessQueueCollection.checkResultNotError(result);
    }

    public Map<String, Object> getMetaset(Session session, String processId) {
        if (this.getMetaSetStat != null) {
            Result result = session.executeCompiledStatement(this.getMetaSetStat, new Object[]{processId});
            if (result.isError() || !result.isData()) {
                Trace.logError(DataspaceStore.class, "Unable to retrieve metaset for process '" + processId + "'.");
            }
            ProcessQueueCollection.checkResultNotError(result);
            ProcessQueueCollection.checkResultIsData(result);
            HashMap<String, Object> metaset = new HashMap<String, Object>();
            RowSetNavigator rowSet = result.navigator;
            while (rowSet.next()) {
                metaset.put((String)rowSet.getCurrent(0), rowSet.getCurrent(1));
            }
            return metaset;
        }
        return null;
    }

    public ProcessState getProcessState(Session session, String processId) {
        Result result = session.executeCompiledStatement(this.getProcessStateStat, new Object[]{processId});
        ProcessQueueCollection.checkResultNotError(result);
        ProcessQueueCollection.checkResultIsData(result);
        RowSetNavigator rowSet = result.navigator;
        if (rowSet.next()) {
            return ProcessState.valueOf((String)rowSet.getCurrent(0));
        }
        return null;
    }

    public void discardProcess(Session session, String processId, String comment) {
        ProcessState state = this.getProcessState(session, processId);
        if (this.state == QueueState.SUSPENDED && state != ProcessState.UNDELIVERED && state != ProcessState.UNACKNOWLEDGED) {
            throw new DataspaceException("Process '" + processId + "' could not be discarded because process queue is suspended.");
        }
        Result result = session.executeCompiledStatement(this.discardProcessStat, new Object[]{ProcessState.DISCARDED.name(), 0, processId, ProcessState.UNDELIVERED.name(), ProcessState.PENDING.name(), ProcessState.EXPIRED.name(), ProcessState.UNACKNOWLEDGED.name()});
        if (result.isError()) {
            Trace.logError(DataspaceStore.class, "Unable to discard process '" + processId + "'.");
        }
        ProcessQueueCollection.checkResultNotError(result);
        try {
            StateAdvisory advisory = this.dataspace.getAdvisoriesFactory().createAdvisory("qspace.ProcessQueue.RequestDiscarded");
            advisory.setProperty("dataspace", this.dataspace.getName());
            advisory.setProperty("collection", this.getName());
            advisory.setProperty("process_id", processId);
            advisory.setProperty("comment", comment);
            this.dataspace.raiseSystemAdvisory(advisory);
        }
        catch (Exception error) {
            Trace.logError(this, "Failed to raise discarded advisory for process '" + processId + "'. Cause: " + error.getMessage());
            error.printStackTrace();
        }
    }

    public QueueState getQueueState(Session session) {
        return this.state;
    }

    private synchronized void updateQueueState(Session session, QueueState newState) {
        if (this.state != newState) {
            if (session != null && !session.isProcessingRecoveryLog()) {
                this.getQSpace().getQSpaceSysTablesManager().getPprocessQueueStateTableManager().updateQueueStateConfiguration(session, this.getName(), newState);
            }
            Trace.logInfo(this, "Process queue " + this.getName() + " state changed to " + String.valueOf((Object)newState));
            this.state = newState;
            if (this.poller != null) {
                this.poller.queueStateChanged();
            }
        }
    }

    public boolean updateProcessState(Session session, String processId, ProcessState state) {
        if (state == ProcessState.ACKNOWLEDGED) {
            return this.acknowledge(session, processId);
        }
        Result result = session.executeCompiledStatement(this.setProcessStateStat, new Object[]{state.name(), processId});
        if (result.isError()) {
            Trace.logError(ProcessQueueCollection.class, "Unable to mark process '" + processId + "' as '" + state.name() + "'.");
        }
        ProcessQueueCollection.checkResultNotError(result);
        return result.getUpdateCount() > 0;
    }

    public void setProcessExpiration(Session session, String processId, long expiration) {
        Result result = session.executeCompiledStatement(this.setProcessExpirationStat, new Object[]{session.getSqlTimestamp(expiration), processId});
        if (result.isError()) {
            Trace.logError(ProcessQueueCollection.class, "Unable to set process '" + processId + "' expiration time to '" + String.valueOf(new Timestamp(expiration)) + "'.");
        }
        ProcessQueueCollection.checkResultNotError(result);
        if (result.getUpdateCount() == 1) {
            Trace.logDebug(ProcessQueueCollection.class, "Expiration at '" + new Timestamp(expiration).toString() + "' has been set for '" + processId + "' process.");
        } else {
            Trace.logError(this, "Failed to set expiration at '" + new Timestamp(expiration).toString() + "' for '" + processId + "' process.");
        }
    }

    public boolean acknowledge(Session session, String processId) {
        Result result = session.executeCompiledStatement(this.acknowledgeProcessStat, new Object[]{ProcessState.ACKNOWLEDGED.name(), session.getCurrentSqlTimestamp(), processId});
        if (result.isError()) {
            if (result.getException() != null) {
                Trace.logError(ProcessQueueCollection.class, "Unable to acknowledge process '" + processId + "'. " + result.getException().getMessage());
                result.getException().printStackTrace();
            } else {
                Trace.logError(ProcessQueueCollection.class, "Unable to acknowledge process '" + processId + "'.");
            }
        }
        ProcessQueueCollection.checkResultNotError(result);
        if (result.getUpdateCount() == 1) {
            Trace.logDebug(ProcessQueueCollection.class, "Process '" + processId + "' has been acknowledged.");
        }
        return result.getUpdateCount() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.unregisterQueueAsConsumer();
        if (this.poller != null) {
            this.poller.stop();
            this.poller = null;
        }
        if (this.windowCheckThread != null) {
            this.windowCheckThread.stop();
            this.windowCheckThread = null;
        }
        if (this.internalQueueSession != null) {
            Session session = this.internalQueueSession;
            synchronized (session) {
                this.internalQueueSession.close();
                this.internalQueueSession = null;
            }
        }
    }

    @Override
    public void destroy(Session session) {
        try {
            this.unbindEvents();
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
        if (this.metasetTableName != null && this.store.schemaManager.getSchemaObject(this.metasetTableName) != null) {
            this.store.schemaManager.removeSchemaObject(this.metasetTableName);
            if (!session.isProcessingRecoveryLog() && !session.isProcessingLog()) {
                session.dataspaceStore.dataspaceLogger.writeOtherStatement(session, LogRecordType.DROP_OBJECT, "drop table " + this.metasetTableName.name + " if exists", this.metasetTableName);
            }
        }
        this.getQSpace().getQSpaceSysTablesManager().getPprocessQueueStateTableManager().removeQueueState(session, this.getName());
        for (Recipient recipient : this.recipients) {
            this.getQSpace().getQSpaceSysTablesManager().getProcessQueueRecipientsTableManager().removeRecipient(session, this.getName(), recipient.getName());
        }
        this.recipients.clear();
    }

    @Override
    protected EventFlowEntity getEventFlowEntity() {
        return EventFlowEntity.DATASPACE_PROCESS_QUEUE;
    }

    @Override
    public void clear(Session session) {
        super.clear(session);
    }

    @Override
    public String getName() {
        return this.name.name;
    }

    @Override
    public String getQueueName() throws JMSException {
        return this.getName();
    }

    @Override
    protected boolean pushElement(Session session, Object element) {
        if (!(element instanceof EventDatagram)) {
            throw new DataspaceException("Invalid object type, should be EventDatagram, but passed: " + (element != null ? element.getClass().getName() : null) + " in pushElement.");
        }
        return this.pushElement(session, (EventDatagram)element);
    }

    @Override
    protected boolean pushElement(Session session, ImmutableEventDatagram event) {
        Trace.logDebug(ProcessQueueCollection.class, "New event to be enqueued...");
        this.checkIncomingEventMatchesConstraint(event);
        try {
            int systemColumnCount = 5;
            int paramColumnCount = this.eventPropertiesMapper.getColumnsCount();
            Object[] params = new Object[5 + paramColumnCount];
            int index = -1;
            index = this.eventPropertiesMapper.setColumnValues(session, event, params, index, this.dataspace);
            params[++index] = 0;
            params[++index] = this.initialProcessState != null ? this.initialProcessState.name() : ProcessState.ENQUEUED.name();
            params[++index] = session.getCurrentSqlTimestamp();
            params[++index] = null;
            params[++index] = this.wrapEvent(session, event);
            Result result = session.executeCompiledStatement(this.pushElementStat, params);
            if (result.isError() && result.getException() != null && result.getException().getErrorCode() == -104) {
                Trace.logError(ProcessQueueCollection.class, "Unable to enqueue event. " + result.getException().getMessage());
                this.dataspace.logError("Dataspace Error " + result.getErrorCode() + ": Duplicate process id '" + ((EventDatagram)event).getCorrelationId() + "' in process queue '" + this.getName() + "'.");
                try {
                    ProcessQueueException exception = new ProcessQueueException(2014, "Duplicate process id '" + ((EventDatagram)event).getCorrelationId() + "' in process queue '" + this.dataspace.getName() + ":" + this.getName() + "'.");
                    this.dataspace.raiseException(exception);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                    Trace.logError(this, "Error during 'raiseException()' method invocation.");
                }
                ProcessQueueCollection.checkResultNotError(result);
                return false;
            }
            ProcessQueueCollection.checkResultNotError(result);
            return true;
        }
        catch (SQLException error) {
            throw new DataspaceException("Failed to enqueue event. Cause: " + error.getMessage());
        }
    }

    @Override
    protected AbstractQueueCollection.KeyValue getElement(Session session, boolean isLast) {
        Result result = session.executeCompiledStatement(isLast ? this.getElementLastStat : this.getElementStat, new Object[]{ProcessState.ENQUEUED.name()});
        return this.extractProcessFromResultSet(session, result);
    }

    @Override
    protected boolean removeElement(Session session, EventDatagram event) {
        return this.dropProcess(session, event.getCorrelationId());
    }

    @Override
    protected AbstractQueueCollection.KeyValue dfetchElement(Session session, String selector, String updater, long timeout, TimeUnit unit, boolean isLast) {
        try {
            if (selector == null) {
                selector = "State = '" + ProcessState.ENQUEUED.toString() + "'";
            }
            String dfetchSql = this.makeDfetchSql("Event, ProcessId", (String)selector, updater, isLast ? "order by SeqId desc" : "order by SeqId asc", timeout, unit);
            session.setAutoCommit(false);
            Statement dfetchStat = session.compileStatement(dfetchSql);
            Result result = session.executeCompiledStatement(dfetchStat, new Object[0]);
            AbstractQueueCollection.KeyValue keyValue = this.extractProcessFromResultSet(session, result);
            return keyValue;
        }
        catch (DataspaceException exception) {
            session.rollback(true);
            throw exception;
        }
        finally {
            session.commit(true);
            session.setAutoCommit(true);
        }
    }

    @Override
    protected AbstractQueueCollection.KeyValue getElementWithSelector(Session session, String selector, boolean isLast) {
        if (selector == null || selector.length() == 0) {
            return this.getElement(session, isLast);
        }
        Result result = session.executeDirectStatement("select top 1 Event, ProcessId from " + this.name.getSchemaQualifiedStatementName() + " where " + selector + (isLast ? " order by SeqId desc" : " order by SeqId asc"));
        return this.extractProcessFromResultSet(session, result);
    }

    protected AbstractQueueCollection.KeyValue extractProcessFromResultSet(Session session, Result result) {
        ProcessQueueCollection.checkResultNotError(result);
        ProcessQueueCollection.checkResultIsData(result);
        RowSetNavigator rowSet = result.navigator;
        if (rowSet.next()) {
            try {
                ImmutableEventDatagram eventObject = this.unwrapEvent(session, rowSet.getCurrent(0));
                return new AbstractQueueCollection.KeyValue(rowSet.getCurrent(1), eventObject);
            }
            catch (DataspaceException error) {
                if (Math.abs(error.getErrorCode()) == 3474 && rowSet != null) {
                    Trace.logError(this, "Process '" + rowSet.getCurrent(1).toString() + "' message is corrupted (lob is no valid) and need to be resubmitted from the source.");
                    this.updateProcessState(session, rowSet.getCurrent(1).toString(), ProcessState.UNDELIVERED);
                }
                throw error;
            }
            catch (Exception error) {
                Trace.logException(this, error, true);
                throw new DataspaceException("Failed to get process. Cause: " + error.getMessage());
            }
        }
        return null;
    }

    @Override
    public boolean contains(Session session, Object o) {
        this.checkOperationIsSupported(this.containsStat, "contains");
        if (!(o instanceof EventDatagram)) {
            return false;
        }
        Result result = session.executeCompiledStatement(this.containsStat, new Object[]{((EventDatagram)o).getCorrelationId()});
        ProcessQueueCollection.checkResultNotError(result);
        if (result.navigator != null && result.navigator.next()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean dropProcess(Session session, String processId) {
        Result result = session.executeCompiledStatement(this.removeElementByKeyStat, new Object[]{processId});
        if (result.isError()) {
            Trace.logError(ProcessQueueCollection.class, "Unable to remove process '" + processId + "'.");
        }
        ProcessQueueCollection.checkResultNotError(result);
        if (result.getUpdateCount() > 1) {
            Trace.logError(this, "More then 1 processes '" + processId + "' have been removed.");
        }
        if (result.getUpdateCount() == 1) {
            Trace.logDebug(ProcessQueueCollection.class, "Process '" + processId + "' has been removed.");
        }
        return result.getUpdateCount() > 0;
    }

    private Recipient createRecipient(Session session, String recipientName, String token, boolean certified, String eventId, String subscriptionRule, boolean enabled) {
        if (this.listRecipients(session).contains(recipientName)) {
            throw new DataspaceException("Failed to create recipient with name '" + recipientName + "'. Already exists.");
        }
        try {
            EventPrototypeComparator.compare(this.eventId, eventId);
        }
        catch (UtilitiesException error) {
            throw new DataspaceException("Specified recipient EventId [" + eventId + "] is not equivalent to '" + this.eventId + ". " + error.getMessage());
        }
        Recipient recipient = certified ? new CertifiedRecipient(this.dataspace, recipientName, token, subscriptionRule, eventId, enabled) : new Recipient(this.dataspace, recipientName, subscriptionRule, eventId, enabled);
        try {
            this.bindProducerFor(recipient.getEventId());
            this.dataspace.addSourceEventFlow(recipient.getEventId(), EventFlowEntity.DATASPACE_PROCESS_QUEUE_RECIPIENT, recipient.getName(), this.getEventScope(), Utils.createMap("collection", this.getName()));
        }
        catch (FabricEventDispatcherException error) {
            Trace.logError(ProcessQueueCollection.class, "Unable to bind certified recipient Event Id. " + error.getMessage());
        }
        this.recipients.add(recipient);
        if (this.poller != null) {
            this.poller.queueStateChanged();
        }
        return recipient;
    }

    private void removeRecipient(String recipientName) {
        Recipient recipient = this.getRecipient(recipientName);
        this.recipients.remove(recipient);
        try {
            this.unbindProducerFor(recipient.getEventId());
            this.dataspace.removeSourceEventFlow(this.eventId, this.getEventFlowEntity(), recipient.getName());
        }
        catch (FabricEventDispatcherException error) {
            Trace.logError(ProcessQueueCollection.class, "Unable to unbind recipient Event Id. " + error.getMessage());
        }
        if (this.poller != null) {
            this.poller.queueStateChanged();
        }
    }

    public List<ProcessQueueRecipientsTableManager.RecipientInfo> getRecipients(Session session) {
        return this.getQSpace().getQSpaceSysTablesManager().getProcessQueueRecipientsTableManager().getRecipients(session, this.getName());
    }

    public List<String> listRecipients(Session session) {
        ArrayList<String> result = new ArrayList<String>();
        for (Recipient recipient : this.recipients) {
            result.add(recipient.getName());
        }
        return result;
    }

    @Override
    public Result getCollectionProperties(Session session) {
        Result result = super.getCollectionProperties(session);
        result.navigator.add(new Object[]{"Process Queue State", this.state.name()});
        result.navigator.add(new Object[]{"Size", this.size(session)});
        if (this.pollerConfiguration != null) {
            result.navigator.add(new Object[]{"Poller Max Attempts", this.pollerConfiguration.maxAttempts});
            result.navigator.add(new Object[]{"Poller Offer Interval", this.pollerConfiguration.offerInterval});
            result.navigator.add(new Object[]{"Poller Suspend On Failure", this.pollerConfiguration.suspendOnFailure});
            result.navigator.add(new Object[]{"Poller Recipient Timeout", this.pollerConfiguration.recipientTimeout});
            result.navigator.add(new Object[]{"Poller Parallel Degree", this.pollerConfiguration.parallelDegree});
        }
        ArrayList<String> recipientNames = new ArrayList<String>();
        if (this.recipients != null) {
            for (Recipient recipient : this.recipients) {
                recipientNames.add(recipient.getName());
            }
        }
        result.navigator.add(new Object[]{"Recipients", recipientNames});
        if (this.metasetTableName != null) {
            result.navigator.add(new Object[]{"MetaSet Table Name", this.metasetTableName.name});
        }
        return result;
    }

    protected void loadRecipients(Session session) {
        Trace.logDebug(ProcessQueueCollection.class, "Loading '" + this.getName() + "' process queue recipients...");
        if (this.recipients != null) {
            this.recipients.clear();
        }
        for (ProcessQueueRecipientsTableManager.RecipientInfo recipientInfo : this.getRecipients(session)) {
            this.createRecipient(session, recipientInfo.getRecipientName(), recipientInfo.getToken(), recipientInfo.isCertified(), recipientInfo.getEventId(), recipientInfo.getSubscriptionRule(), recipientInfo.isEnabled());
        }
        Trace.logDebug(ProcessQueueCollection.class, "Recipients loaded.");
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new ProcessQueueProxy();
    }

    @Override
    public boolean isTriggerEventAutogenerated() {
        return false;
    }

    @Override
    public String getTriggerEventId(int whenType, int operationType) {
        if (whenType == 8 && operationType == 82) {
            try {
                String when = TriggerDef.getTimingString(whenType);
                String operation = TriggerDef.getEventTypeString(operationType);
                String eventId = "event." + this.name.schema.name + "." + this.name.name + "." + when + operation;
                if (PrototypeFactory.existsPrototype(eventId)) {
                    return eventId;
                }
                DataEvent dataEvent = (DataEvent)this.runtimeCtx.getEventDatagramFactory().newEventInstance("DataEvent");
                dataEvent.setData(new ProcessStateChange());
                this.runtimeCtx.getDatagramPrototypeFactory().addDataEventPrototype(eventId, dataEvent);
                return eventId;
            }
            catch (Exception error) {
                throw new DataspaceException(error.getMessage());
            }
        }
        return super.getTriggerEventId(whenType, operationType);
    }

    @Override
    public ImmutableEventDatagram getEventForTrigger(Session session, Object[] oldData, Object[] newData, int when, int operationType) {
        if (when == 8 && operationType == 82) {
            int index = this.table.findColumn(EventPropertiesMapper.SystemProperty.ProcessId.name());
            if (index == -1 || !(newData[index] instanceof String)) {
                Trace.logError(ProcessQueueCollection.class, "Unable to extract EventId from the ProcessQueue '" + this.name.name + "'.");
                return null;
            }
            String processId = (String)newData[index];
            index = this.table.findColumn(EventPropertiesMapper.SystemProperty.EventGroupId.name());
            if (index == -1 || !(newData[index] instanceof String)) {
                Trace.logError(ProcessQueueCollection.class, "Unable to extract Process Group from the ProcessQueue '" + this.name.name + "'.");
                return null;
            }
            String processGroup = (String)newData[index];
            index = this.table.findColumn(EventPropertiesMapper.SystemProperty.EventKey.name());
            if (index == -1 || !(newData[index] instanceof String)) {
                Trace.logError(ProcessQueueCollection.class, "Unable to extract Process Step from the ProcessQueue '" + this.name.name + "'.");
                return null;
            }
            String processStep = (String)newData[index];
            index = this.table.findColumn("Attempt");
            if (index == -1 || !(newData[index] instanceof Integer)) {
                Trace.logError(ProcessQueueCollection.class, "Unable to extract Attempt from the ProcessQueue '" + this.name.name + "'.");
                return null;
            }
            int attempt = (Integer)newData[index];
            index = this.table.findColumn("State");
            if (index == -1 || !(newData[index] instanceof String)) {
                Trace.logError(ProcessQueueCollection.class, "Unable to extract State from the ProcessQueue '" + this.name.name + "'.");
                return null;
            }
            String state = (String)newData[index];
            index = this.table.findColumn("Created");
            if (index == -1 || !(newData[index] instanceof TimestampData)) {
                Trace.logError(ProcessQueueCollection.class, "Unable to extract Timestamp Created from the ProcessQueue '" + this.name.name + "'.");
                return null;
            }
            Timestamp ts_created = (Timestamp)SqlUtils.convertSqlToJava(session, (TimestampData)newData[index], Type.SQL_TIMESTAMP);
            Timestamp ts_acknowledged = null;
            index = this.table.findColumn("Acknowledged");
            if (index != -1 && newData[index] instanceof TimestampData) {
                ts_acknowledged = (Timestamp)SqlUtils.convertSqlToJava(session, (TimestampData)newData[index], Type.SQL_TIMESTAMP);
            }
            Timestamp expiration = null;
            index = this.table.findColumn("Expiration");
            if (index != -1 && newData[index] instanceof TimestampData) {
                expiration = (Timestamp)SqlUtils.convertSqlToJava(session, (TimestampData)newData[index], Type.SQL_TIMESTAMP);
            }
            try {
                EventDatagramFactory factory = EventDatagramFactory.getInstance();
                DataEvent event = (DataEvent)factory.createEvent(this.getTriggerEventId(when, operationType));
                ProcessStateChange stateChange = new ProcessStateChange();
                stateChange.setProcessId(processId);
                stateChange.setEventId(this.eventId);
                stateChange.setProcessGroupId(processGroup);
                stateChange.setProcessStep(processStep);
                stateChange.setAttempt(attempt);
                stateChange.setState(state);
                stateChange.setTimestampCreated(ts_created.toString());
                if (ts_acknowledged != null) {
                    stateChange.setTimestampAcknowledged(ts_acknowledged.toString());
                }
                if (expiration != null) {
                    stateChange.setExpiration(expiration.toString());
                }
                event.setCorrelationId(processId);
                event.setEventGroupId(processGroup);
                event.setEventKey(processStep);
                event.setData(stateChange);
                Trace.logDebug(ProcessQueueCollection.class, "New event has been raised by ProcessStateChange trigger. Process '" + processId + "' state changed.");
                return event;
            }
            catch (SecurityViolationException error) {
                Trace.logError(ProcessQueueCollection.class, "Unable to create event with '" + this.eventId + "' EventId. " + error.getMessage());
            }
            catch (DatagramFactoryException error) {
                Trace.logError(ProcessQueueCollection.class, "Unable to create event with '" + this.eventId + "' EventId. " + error.getMessage());
            }
            catch (SDOException error) {
                Trace.logError(ProcessQueueCollection.class, "Unable to create event with '" + this.eventId + "' EventId. " + error.getMessage());
            }
            return null;
        }
        return super.getEventForTrigger(session, oldData, newData, when, operationType);
    }

    public Result getQueueStatistics(Session session) {
        return session.executeCompiledStatement(this.queueStatisticsStat, new Object[0]);
    }

    public synchronized void createCertifiedRecipient(Session session, String name, String token, String eventId, String subscriptionRule) {
        Recipient recipient = this.createRecipient(session, name, token, true, eventId, subscriptionRule, true);
        this.getQSpace().getQSpaceSysTablesManager().getProcessQueueRecipientsTableManager().createRecipient(session, this.getName(), recipient);
    }

    public synchronized void createRecipient(Session session, String name, String eventId, String subscriptionRule) {
        Recipient recipient = this.createRecipient(session, name, null, false, eventId, subscriptionRule, true);
        this.getQSpace().getQSpaceSysTablesManager().getProcessQueueRecipientsTableManager().createRecipient(session, this.getName(), recipient);
    }

    private Recipient getRecipient(String name) {
        if (this.recipients != null) {
            for (Recipient recipient : this.recipients) {
                if (!recipient.getName().equals(name)) continue;
                return recipient;
            }
        }
        throw new DataspaceException("Recipient " + name + "' doesn't exist.");
    }

    public void enableRecipient(Session session, String name) {
        this.getRecipient(name).enable();
        if (this.poller != null) {
            this.poller.queueStateChanged();
        }
    }

    public void disableRecipient(Session session, String name) {
        this.getRecipient(name).disable();
        if (this.poller != null) {
            this.poller.queueStateChanged();
        }
    }

    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    public synchronized void dropRecipient(Session session, String name) {
        this.removeRecipient(name);
        this.getQSpace().getQSpaceSysTablesManager().getProcessQueueRecipientsTableManager().removeRecipient(session, this.getName(), name);
    }

    public void retryProcess(Session session, String processId) {
        this.retryProcess(session, processId, null);
    }

    public void discardProcess(Session session, String processId) {
        this.discardProcess(session, processId, null);
    }

    public void setInitialProcessState(ProcessState state) {
        this.initialProcessState = state;
    }

    public void setMetasetTableName(NameManager.ObjectName name) {
        this.metasetTableName = name;
    }

    @Override
    public String getCollectionSQL(boolean forReplication) {
        boolean first;
        StringBuilder buffer = new StringBuilder();
        buffer.append("CONSTRAINED").append(' ').append("BY").append(' ');
        buffer.append('\"').append(this.eventId).append('\"');
        if (this.includeProps != null && this.includeProps.size() > 0) {
            buffer.append(' ').append("INCLUDE").append(' ').append("PROPERTIES").append(' ');
            buffer.append("(");
            first = true;
            for (String prop : this.includeProps) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(prop);
            }
            buffer.append(")");
        }
        if (this.excludeProps != null && this.excludeProps.size() > 0) {
            buffer.append(' ').append("EXCLUDE").append(' ').append("PROPERTIES").append(' ');
            buffer.append("(");
            first = true;
            for (String prop : this.excludeProps) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(prop);
            }
            buffer.append(")");
        }
        if (this.isSourceEventBlob) {
            buffer.append(' ').append("WITH");
            buffer.append(' ').append("SOURCE");
            buffer.append(' ').append("EVENT");
            buffer.append(' ').append("AS");
            buffer.append(' ').append("BLOB");
        } else {
            buffer.append(' ').append("WITH");
            buffer.append(' ').append("SOURCE");
            buffer.append(' ').append("EVENT");
        }
        if (this.isConsumer && !forReplication) {
            if (this.isConsumerAsync) {
                buffer.append(' ').append("ASYNC");
            }
            buffer.append(' ').append("CONSUMER");
            if (this.eventScope != null && this.eventScope != EventScope.OBSERVABLE) {
                buffer.append(' ').append("EVENT").append(' ').append("SCOPE").append(' ').append(this.eventScope.toString());
            }
            if (this.selector != null && this.selector.length() > 0) {
                buffer.append(' ').append("WHEN").append("(");
                buffer.append(this.selector).append(")");
            }
        }
        if (this.initialProcessState != null) {
            buffer.append(' ').append("INITIAL").append(' ').append("PROCESS").append(' ').append("STATE").append(' ').append(this.initialProcessState.name());
        }
        if (this.metasetTableName != null) {
            buffer.append(' ').append("WITH").append(' ').append("METASET").append(' ').append(this.metasetTableName.name);
        }
        if (!forReplication) {
            this.appendWindowInformation(buffer);
        }
        if (this.pollerConfiguration != null) {
            buffer.append(' ').append("MAX").append(' ').append("ATTEMPTS").append(' ').append(this.pollerConfiguration.maxAttempts);
            buffer.append(' ').append("OFFER").append(' ').append("INTERVAL").append(' ').append(this.pollerConfiguration.offerInterval);
            buffer.append(' ').append("RECIPIENT").append(' ').append("TIMEOUT").append(' ').append(this.pollerConfiguration.recipientTimeout);
            buffer.append(' ').append("SUSPEND").append(' ').append("ON").append(' ').append("FAIL").append(' ').append(this.pollerConfiguration.suspendOnFailure);
            buffer.append(' ').append("PARALLEL").append(' ').append("DEGREE").append(' ').append(this.pollerConfiguration.parallelDegree);
        }
        return buffer.toString();
    }

    public EventDatagram getElement(Session session, String processId) {
        Result result = session.executeCompiledStatement(this.getElementByIdStat, new Object[]{processId});
        ProcessQueueCollection.checkResultNotError(result);
        ProcessQueueCollection.checkResultIsData(result);
        RowSetNavigator rowSet = result.navigator;
        if (rowSet.next()) {
            try {
                BlobDataID blobId = (BlobDataID)rowSet.getCurrent(0);
                byte[] eventData = SqlUtils.extractBlob(session, blobId);
                return (EventDatagram)this.serializer.deserialize(eventData);
            }
            catch (Exception error) {
                Trace.logException(this, error, true);
                throw new DataspaceException("Failed to get process from process queue. Cause: " + error.getMessage());
            }
        }
        return null;
    }

    public boolean acknowledge(Session session, String processId, AcknowledgeAction ackAction) {
        ProcessState newState = null;
        switch (ackAction) {
            case ACKNOWLEDGE: {
                newState = ProcessState.ACKNOWLEDGED;
                break;
            }
            case ACKNOWLEDGE_AND_RETRY: {
                newState = ProcessState.LOCKED_FOR_OFFER;
                break;
            }
            case ACKNOWLEDGE_AND_DISCARD: {
                newState = ProcessState.DISCARDED;
                break;
            }
            case ACKNOWLEDGE_AND_EXPIRE: {
                newState = ProcessState.EXPIRED;
                break;
            }
            case ACKNOWLEDGE_UNDELIVERED: {
                newState = ProcessState.UNDELIVERED;
                break;
            }
            case ACKNOWLEDGE_AND_SUSPEND: {
                this.suspend(session);
                newState = ProcessState.UNDELIVERED;
                break;
            }
            case ACKNOWLEDGE_AND_FORWARD: {
                newState = ProcessState.FORWARDED;
                this.forwardEvent(session, processId);
                break;
            }
            case RESCIND: {
                newState = ProcessState.ENQUEUED;
                break;
            }
            case RESCIND_AND_DISCARD: {
                newState = ProcessState.DISCARDED;
                break;
            }
            case RESCIND_AND_FORWARD: {
                newState = ProcessState.FORWARDED;
                this.forwardEvent(session, processId);
                break;
            }
            default: {
                throw new DataspaceException("Unsupported action " + String.valueOf((Object)ackAction));
            }
        }
        return this.updateProcessState(session, processId, newState);
    }

    private void forwardEvent(Session session, String processId) {
        EventDatagram event = this.getElement(session, processId);
        if (event == null) {
            throw new DataspaceException("Process '" + processId + "' doesn't exist.");
        }
        if (event.getForwardTo() == null || event.getForwardTo().length() == 0) {
            throw new DataspaceException("ForwardTo eventId doesn't set for process '" + processId + "'.");
        }
        this.dataspace.forwardEvent(event);
    }

    public EventDatagram takeForBatch(Session session, String selector, long timeout, TimeUnit unit, String batchId) {
        return this.takeForBatch(session, selector, timeout, unit, batchId, false);
    }

    public EventDatagram takeLastForBatch(Session session, String selector, long timeout, TimeUnit unit, String batchId) {
        return this.takeForBatch(session, selector, timeout, unit, batchId, true);
    }

    public EventDatagram takeForBatch(Session session, String selector, long timeout, TimeUnit unit, String batchId, boolean isLast) {
        return this.takeFor(session, "", selector, timeout, unit, ProcessState.IN_TRANSACTION, "BatchId = '" + batchId + "'", isLast);
    }

    public EventDatagram takeFor(Session session, String processId, String selector, long timeout, TimeUnit unit, ProcessState newState) {
        return this.takeFor(session, processId, selector, timeout, unit, newState, false);
    }

    public EventDatagram takeLastFor(Session session, String processId, String selector, long timeout, TimeUnit unit, ProcessState newState) {
        return this.takeFor(session, processId, selector, timeout, unit, newState, true);
    }

    public EventDatagram takeFor(Session session, String processId, String selector, long timeout, TimeUnit unit, ProcessState newState, boolean isLast) {
        return this.takeFor(session, processId, selector, timeout, unit, newState, "", isLast);
    }

    private EventDatagram takeFor(Session session, String processId, String selector, long timeout, TimeUnit unit, ProcessState newState, String updater, boolean isLast) {
        if (processId != null && processId.length() > 0) {
            String processIdSelector = " ProcessId = '" + processId + "'";
            selector = selector == null || ((String)selector).length() == 0 ? processIdSelector : "(" + (String)selector + ") AND " + processIdSelector;
        } else {
            String stateSelector = "State = '" + String.valueOf((Object)ProcessState.ENQUEUED) + "'";
            selector = selector == null || ((String)selector).length() == 0 ? stateSelector : "(" + (String)selector + ") AND " + stateSelector;
        }
        String stateUpdater = "State = '" + newState.toString() + "'";
        updater = updater == null || ((String)updater).length() == 0 ? stateUpdater : (String)updater + ", " + stateUpdater;
        updater = "update row set " + (String)updater;
        AbstractQueueCollection.KeyValue keyValue = this.dfetchElement(session, (String)selector, (String)updater, timeout, unit, isLast);
        if (keyValue == null) {
            return null;
        }
        return (EventDatagram)keyValue.value;
    }

    public boolean existEnabledRecipients() {
        if (this.recipients == null || this.recipients.size() == 0) {
            return false;
        }
        for (Recipient recipient : this.recipients) {
            if (!recipient.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public ProcessQueueEventWrapper getEventForPoller(Session session) {
        Result result = session.executeCompiledStatement(this.getEventForPollerStat, new Object[0]);
        AbstractQueueCollection.KeyValue keyValue = this.extractProcessFromResultSet(session, result);
        if (keyValue == null) {
            return null;
        }
        ProcessQueueEventWrapper wrapper = new ProcessQueueEventWrapper((EventDatagram)keyValue.value);
        wrapper.attempts = (Integer)result.navigator.getCurrent(2);
        Object data = result.navigator.getCurrent(3);
        if (data != null) {
            try {
                byte[] ackListData = (byte[])SqlUtils.convertSqlToJava(session, data, Type.SQL_VARBINARY);
                if (ackListData != null) {
                    wrapper.receipts = (AcknowledgementList)this.serializer.deserialize(ackListData);
                }
            }
            catch (Exception error) {
                Trace.logException(this, error, true);
            }
        }
        return wrapper;
    }

    public void lockProcessForOfferAndIncreaseNumberOfAttempts(Session session, ProcessQueueEventWrapper wrapper) {
        ++wrapper.attempts;
        Result result = session.executeCompiledStatement(this.lockProcessForOfferAndIncreaseNumberOfAttempts, new Object[]{wrapper.attempts, wrapper.event.getCorrelationId()});
        String error = "Unable to lock and update number of attempts for '" + wrapper.event.getCorrelationId() + "' process.";
        if (result.isError()) {
            Trace.logError(this, error);
            if (result.getException() != null) {
                Trace.logException(this, result.getException(), true);
            }
        }
        ProcessQueueCollection.checkResultNotError(result);
        if (result.getUpdateCount() == 0) {
            throw new DataspaceException(error);
        }
    }

    public void updateReceipts(Session session, ProcessQueueEventWrapper wrapper) {
        Object data = null;
        try {
            byte[] ackListData = this.serializer.serialize(wrapper.receipts);
            if (ackListData != null) {
                data = SqlUtils.convertJavaToSql(session, (Object)ackListData, Type.SQL_VARBINARY);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        if (data != null) {
            Result result = session.executeCompiledStatement(this.updateReceiptsStat, new Object[]{data, wrapper.event.getCorrelationId()});
            ProcessQueueCollection.checkResultNotError(result);
            if (result.getUpdateCount() > 0) {
                return;
            }
            throw new DataspaceException("Unable to update recipients in queue '" + this.getName() + "' for process '" + wrapper.event.getCorrelationId() + "'.");
        }
        throw new DataspaceException("Unable to update recipients in queue '" + this.getName() + "' for process '" + wrapper.event.getCorrelationId() + "'. provided data is null.");
    }

    private void checkParallelDegree(int newParallelDegree) {
        if (this.state != QueueState.STOPPED && this.pollerConfiguration.parallelDegree != newParallelDegree) {
            throw new DataspaceException("Altering of process queue parallel degree is not allowed when process queue is not stopped.");
        }
    }

    public PollerConfiguration getPollerConfiguration() {
        return this.pollerConfiguration;
    }

    public void setPollerConfiguration(PollerConfiguration pollerConfiguration) {
        this.checkParallelDegree(pollerConfiguration.parallelDegree);
        this.pollerConfiguration = pollerConfiguration;
    }

    private void setPollerConfiguration(Session session, long offerInterval, long recipientTimeout, int maxAttempts, boolean suspendOnFailure, int parallelDegree) {
        String SQL = "alter process queue " + this.name.getSchemaQualifiedStatementName() + " set max attempts " + maxAttempts + " offer interval " + offerInterval + " recipient timeout " + recipientTimeout + " suspend on fail " + suspendOnFailure + " parallel degree " + parallelDegree;
        Result result = session.executeDirectStatement(SQL);
        ProcessQueueCollection.checkResultNotError(result);
    }

    public void setPollerConfiguration(Session session, long offerInterval, long recipientTimeout, int maxAttempts, boolean suspendOnFailure) {
        this.setPollerConfiguration(session, offerInterval, recipientTimeout, maxAttempts, suspendOnFailure, this.getParallelDegree(session));
    }

    public void setMaxAttempts(Session session, int maxAttempts) {
        this.setPollerConfiguration(session, this.getOfferInterval(session), this.getRecipientTimeout(session), maxAttempts, this.getSuspendOnFailure(session), this.getParallelDegree(session));
    }

    public int getMaxAttempts(Session session) {
        return this.pollerConfiguration.maxAttempts;
    }

    public void setOfferInterval(Session session, long offerInterval) {
        this.setPollerConfiguration(session, offerInterval, this.getRecipientTimeout(session), this.getMaxAttempts(session), this.getSuspendOnFailure(session), this.getParallelDegree(session));
    }

    public long getOfferInterval(Session session) {
        return this.pollerConfiguration.offerInterval;
    }

    public void setRecipientTimeout(Session session, long recipientTimeout) {
        this.setPollerConfiguration(session, this.getOfferInterval(session), recipientTimeout, this.getMaxAttempts(session), this.getSuspendOnFailure(session), this.getParallelDegree(session));
    }

    public long getRecipientTimeout(Session session) {
        return this.pollerConfiguration.recipientTimeout;
    }

    public void setSuspendOnFailure(Session session, boolean suspendOnFailure) {
        this.setPollerConfiguration(session, this.getOfferInterval(session), this.getRecipientTimeout(session), this.getMaxAttempts(session), suspendOnFailure, this.getParallelDegree(session));
    }

    public boolean getSuspendOnFailure(Session session) {
        return this.pollerConfiguration.suspendOnFailure;
    }

    public void setParallelDegree(Session session, int parallelDegree) {
        this.checkParallelDegree(parallelDegree);
        this.setPollerConfiguration(session, this.getOfferInterval(session), this.getRecipientTimeout(session), this.getMaxAttempts(session), this.getSuspendOnFailure(session), parallelDegree);
    }

    public int getParallelDegree(Session session) {
        return this.pollerConfiguration.parallelDegree;
    }

    @Override
    public List<ActiveEvent> getEvents() {
        List<ActiveEvent> events = super.getEvents();
        ActiveEvent event = new ActiveEvent("exception.dataspace.ProcessQueue");
        event.setType(ActiveEvent.ActiveEventType.Source);
        event.setEventScope(this.dataspace.getEventScope());
        event.setEventModel(SqlUtils.resolveEventModel(this.runtimeCtx, event.getEventId()));
        events.add(event);
        event = new ActiveEvent("advisory.ds.notif");
        event.setType(ActiveEvent.ActiveEventType.Source);
        event.setEventScope(this.dataspace.getEventScope());
        event.setEventModel(SqlUtils.resolveEventModel(this.runtimeCtx, event.getEventId()));
        events.add(event);
        return events;
    }

    public static class PollerConfiguration
    extends CloneableDataObject {
        public int maxAttempts = 3;
        public long offerInterval = 0L;
        public boolean suspendOnFailure = false;
        public long recipientTimeout = 5000L;
        public int parallelDegree = 1;
    }
}

