/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.equeue;

import com.streamscape.cli.ds.collection.EventQueue;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueProxy;
import com.streamscape.sdo.ImmutableEventDatagram;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class EventQueueProxy
extends BlockingQueueProxy
implements EventQueue {
    @Override
    public long count(String selector) {
        if (selector == null) {
            throw new DataspaceException("Null selector is not allowed. Use empty string to specify empty selector.");
        }
        return this.invokeCollectionsMethodWithReturn("count", Long.class, selector);
    }

    @Override
    public void start() {
        this.invokeCollectionsMethod("start", new Object[0]);
    }

    @Override
    public void stop() {
        this.invokeCollectionsMethod("stop", new Object[0]);
    }

    @Override
    public ImmutableEventDatagram take(String selector) {
        return this.waitToTake(selector, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ImmutableEventDatagram takeLast(String selector) {
        return this.waitToTakeLast(selector, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ImmutableEventDatagram waitToTake(String selector) {
        return this.waitToTake(selector, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ImmutableEventDatagram waitToTakeLast(String selector) {
        return this.waitToTakeLast(selector, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ImmutableEventDatagram waitToTake(String selector, long timeout, TimeUnit unit) {
        return this.waitToTake(selector, timeout, unit, false);
    }

    @Override
    public ImmutableEventDatagram waitToTakeLast(String selector, long timeout, TimeUnit unit) {
        return this.waitToTake(selector, timeout, unit, true);
    }

    private ImmutableEventDatagram waitToTake(String selector, long timeout, TimeUnit unit, boolean isLast) {
        if (selector == null) {
            throw new DataspaceException("Null selector is not allowed. Use empty string to specify empty selector.");
        }
        return this.invokeCollectionsMethodWithReturn(isLast ? "waitToTakeLast" : "waitToTake", ImmutableEventDatagram.class, new Object[]{selector, timeout, unit});
    }

    @Override
    public ImmutableEventDatagram read(String selector) {
        if (selector == null) {
            throw new DataspaceException("Null selector is not allowed. Use empty string to specify empty selector.");
        }
        return this.invokeCollectionsMethodWithReturn("read", ImmutableEventDatagram.class, selector);
    }

    @Override
    public ImmutableEventDatagram readLast(String selector) {
        if (selector == null) {
            throw new DataspaceException("Null selector is not allowed. Use empty string to specify empty selector.");
        }
        return this.invokeCollectionsMethodWithReturn("readLast", ImmutableEventDatagram.class, selector);
    }

    @Override
    public ImmutableEventDatagram waitToRead(String selector) {
        return this.waitToRead(selector, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ImmutableEventDatagram waitToReadLast(String selector) {
        return this.waitToReadLast(selector, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ImmutableEventDatagram waitToRead(String selector, long timeout, TimeUnit unit) {
        if (selector == null) {
            throw new DataspaceException("Null selector is not allowed. Use empty string to specify empty selector.");
        }
        return this.invokeCollectionsMethodWithReturn("waitToRead", ImmutableEventDatagram.class, new Object[]{selector, timeout, unit});
    }

    @Override
    public ImmutableEventDatagram waitToReadLast(String selector, long timeout, TimeUnit unit) {
        if (selector == null) {
            throw new DataspaceException("Null selector is not allowed. Use empty string to specify empty selector.");
        }
        return this.invokeCollectionsMethodWithReturn("waitToReadLast", ImmutableEventDatagram.class, new Object[]{selector, timeout, unit});
    }

    @Override
    public List<ImmutableEventDatagram> readAll() {
        return this.invokeCollectionsMethodWithReturn("readAll", List.class, new Object[0]);
    }

    @Override
    public int drainTo(Collection<? super Object> c, String selector) {
        return this.drainToImpl(c, Integer.MAX_VALUE, selector);
    }

    @Override
    public int drainTo(Collection<? super Object> c, int maxElements, String selector) {
        return this.drainToImpl(c, maxElements, selector);
    }

    public String getEventId() {
        return this.invokeCollectionsMethodWithReturn("getEventId", String.class, new Object[0]);
    }
}

