/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.equeue;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueFactory;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueFactoryImpl;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.enums.EventScope;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class EventQueueFactoryImpl
extends BlockingQueueFactoryImpl {
    public static final String EXCLUDE_PROPERTY_LIST = "ExcludePropertyList";
    public static final String INCLUDE_PROPERTY_LIST = "IncludePropertyList";
    public static final String WITH_SOURCE_EVENT = "WithSourceEvent";
    public static final String SOURCE_EVENT_AS_BLOB = "SourceEventAsBlob";
    public static final String CONSUMER = "Consumer";
    public static final String SELECTOR = "Selector";
    public static final String ASYNC_CONSUMER = "IsConsumerAsync";
    public static final String EVENT_SCOPE = "EventScope";
    public static final String WINDOW_TYPE = "WindowType";
    public static final String WINDOW_SIZE = "WindowSize";
    public static final String TIME_WINDOW_UNIT = "TimeWindowUnit";
    public static final String WINDOW_CHECK_INTERVAL = "WindowCheckInterval";
    public static final String WINDOW_CHECK_INTERVAL_UNIT = "WindowCheckIntervalUnit";

    public EventQueueFactoryImpl() {
        super(CollectionType.EVENT_QUEUE);
    }

    protected EventQueueFactoryImpl(CollectionType collectionType) {
        super(collectionType);
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new EventQueueFactory();
    }

    public boolean isConsumer(Session session) {
        return Boolean.parseBoolean((String)this.properties.get(CONSUMER));
    }

    public void setIsConsumer(Session session, Boolean isConsumer) {
        this.properties.put(CONSUMER, "" + isConsumer);
    }

    public boolean isConsumerAsync(Session session) {
        return Boolean.parseBoolean((String)this.properties.get(ASYNC_CONSUMER));
    }

    public void setIsConsumerAsync(Session session, Boolean isConsumerAsync) {
        if (isConsumerAsync.booleanValue()) {
            this.setIsConsumer(session, true);
        }
        this.properties.put(ASYNC_CONSUMER, "" + isConsumerAsync);
    }

    public void setEventScope(Session session, EventScope eventScope) {
        this.properties.put(EVENT_SCOPE, eventScope.toString());
    }

    public EventScope getEventScope(Session session) {
        try {
            String name = (String)this.properties.get(EVENT_SCOPE);
            return name != null ? EventScope.valueOf(name) : EventScope.OBSERVABLE;
        }
        catch (Exception exception) {
            return EventScope.OBSERVABLE;
        }
    }

    public String getSelector(Session session) {
        return (String)this.properties.get(SELECTOR);
    }

    public void setSelector(Session session, String selector) {
        this.properties.put(SELECTOR, selector);
    }

    public void setExcludedProperties(Session session, List<String> eventProps) {
        if (eventProps == null) {
            this.properties.remove(EXCLUDE_PROPERTY_LIST);
            return;
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (String property : eventProps) {
            if (!first) {
                buffer.append(",");
            } else {
                first = false;
            }
            buffer.append(property);
        }
        this.properties.put(EXCLUDE_PROPERTY_LIST, buffer.toString());
    }

    public List<String> getExcludedProperties(Session session) {
        String props = (String)this.properties.get(EXCLUDE_PROPERTY_LIST);
        if (props != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String prop : props.split(",")) {
                result.add(prop);
            }
            return result;
        }
        return null;
    }

    public void setIncludedProperties(Session session, List<String> eventProps) {
        if (eventProps == null) {
            this.properties.remove(INCLUDE_PROPERTY_LIST);
            return;
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (String property : eventProps) {
            if (!first) {
                buffer.append(",");
            } else {
                first = false;
            }
            buffer.append(property);
        }
        this.properties.put(INCLUDE_PROPERTY_LIST, buffer.toString());
    }

    public List<String> getIncludedProperties(Session session) {
        String props = (String)this.properties.get(INCLUDE_PROPERTY_LIST);
        if (props != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String prop : props.split(",")) {
                result.add(prop);
            }
            return result;
        }
        return null;
    }

    public void setSourceEventIncluded(Session sesion, Boolean include) {
        this.properties.put(WITH_SOURCE_EVENT, "" + include);
    }

    public void setSourceEventAsBlob(Session session, Boolean sourceEventAsBlob) {
        this.properties.put(SOURCE_EVENT_AS_BLOB, "" + sourceEventAsBlob);
    }

    public boolean isSourceEventIncluded(Session session) {
        return Boolean.parseBoolean((String)this.properties.get(WITH_SOURCE_EVENT));
    }

    public boolean isSourceEventAsBlob(Session session) {
        return Boolean.parseBoolean((String)this.properties.get(SOURCE_EVENT_AS_BLOB));
    }

    public CollectionWindowType getWindowType(Session session) {
        return this.properties.get(WINDOW_TYPE) != null ? CollectionWindowType.valueOf((String)this.properties.get(WINDOW_TYPE)) : null;
    }

    public void setWindowType(Session session, CollectionWindowType type) {
        this.properties.put(WINDOW_TYPE, type.name());
        if (type == CollectionWindowType.BATCH_SIZE_WINDOW || type == CollectionWindowType.SLIDING_SIZE_WINDOW) {
            this.properties.put(TIME_WINDOW_UNIT, null);
            this.properties.put(WINDOW_CHECK_INTERVAL, null);
        }
    }

    public long getWindowSize(Session session) {
        return this.properties.get(WINDOW_SIZE) != null ? Long.valueOf((String)this.properties.get(WINDOW_SIZE)) : 0L;
    }

    public void setWindowSize(Session session, long size) {
        this.properties.put(WINDOW_SIZE, Long.toString(size));
    }

    public TimeUnit getTimeWindowUnit(Session session) {
        return this.properties.get(TIME_WINDOW_UNIT) != null ? TimeUnit.valueOf((String)this.properties.get(TIME_WINDOW_UNIT)) : null;
    }

    public void setTimeWindowUnit(Session session, TimeUnit unit) {
        this.properties.put(TIME_WINDOW_UNIT, unit.name());
    }

    public long getWindowCheckInterval(Session session) {
        return this.properties.get(WINDOW_CHECK_INTERVAL) != null ? Long.valueOf((String)this.properties.get(WINDOW_CHECK_INTERVAL)) : 0L;
    }

    public void setWindowCheckInterval(Session session, long interval) {
        this.properties.put(WINDOW_CHECK_INTERVAL, Long.toString(interval));
    }

    public TimeUnit getWindowCheckIntervalUnit(Session session) {
        return this.properties.get(WINDOW_CHECK_INTERVAL_UNIT) != null ? TimeUnit.valueOf((String)this.properties.get(WINDOW_CHECK_INTERVAL_UNIT)) : null;
    }

    public void setWindowCheckIntervalUnit(Session session, TimeUnit unit) {
        this.properties.put(WINDOW_CHECK_INTERVAL_UNIT, unit.name());
    }

    @Override
    public String getCreateSql(Session session, String name) {
        List<String> excludeProperties;
        StringBuilder buffer = new StringBuilder();
        buffer.append("create ").append(this.getMemoryModel(session).name());
        buffer.append(" event queue [").append(name).append(']');
        buffer.append(" constrained by [").append(this.getConstraint(session)).append(']');
        List<String> includeProperties = this.getIncludedProperties(session);
        if (includeProperties != null) {
            buffer.append(' ').append("INCLUDE").append(' ').append("PROPERTIES").append(' ');
            buffer.append("(");
            boolean first = true;
            for (String prop : includeProperties) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(prop);
            }
            buffer.append(")");
        }
        if ((excludeProperties = this.getExcludedProperties(session)) != null) {
            buffer.append(' ').append("EXCLUDE").append(' ').append("PROPERTIES").append(' ');
            buffer.append("(");
            boolean first = true;
            for (String prop : excludeProperties) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(prop);
            }
            buffer.append(")");
        }
        if (this.isSourceEventIncluded(session)) {
            buffer.append(" with source event");
            if (this.isSourceEventAsBlob(session)) {
                buffer.append(" as blob");
            }
        }
        this.appendConsumerInfo(session, buffer);
        this.appendWindowInformation(session, buffer);
        return buffer.toString();
    }

    protected void appendConsumerInfo(Session session, StringBuilder buffer) {
        if (this.isConsumer(session)) {
            if (this.isConsumerAsync(session)) {
                buffer.append(" async");
            }
            buffer.append(" consumer");
            if (this.getEventScope(session) != null) {
                buffer.append(" event scope ").append(this.getEventScope(session).toString());
            }
            if (this.getSelector(session) != null && !this.getSelector(session).isEmpty()) {
                buffer.append(" when (").append(this.getSelector(session)).append(")");
            }
        }
    }

    protected void appendWindowInformation(Session session, StringBuilder operation) {
        CollectionWindowType windowType = this.getWindowType(session);
        if (windowType != null) {
            operation.append(" ");
            switch (windowType) {
                case SLIDING_SIZE_WINDOW: {
                    operation.append(' ').append("SLIDING");
                    operation.append(' ').append("SIZE");
                    break;
                }
                case SLIDING_TIME_WINDOW: {
                    operation.append(' ').append("SLIDING");
                    operation.append(' ').append("TIME");
                    break;
                }
                case BATCH_SIZE_WINDOW: {
                    operation.append(' ').append("BATCH");
                    operation.append(' ').append("SIZE");
                    break;
                }
                case BATCH_TIME_WINDOW: {
                    operation.append(' ').append("BATCH");
                    operation.append(' ').append("TIME");
                }
            }
            operation.append(" window ").append(this.getWindowSize(session));
            TimeUnit units = this.getTimeWindowUnit(session);
            if (units != null) {
                operation.append(" ");
                SqlUtils.timeUnitToString(operation, units);
            }
            long windowCheckInterval = this.getWindowCheckInterval(session);
            if (windowType == CollectionWindowType.SLIDING_TIME_WINDOW && windowCheckInterval > 0L) {
                operation.append(' ').append("CHECK").append(' ').append("INTERVAL");
                operation.append(' ').append(this.getWindowCheckInterval(session));
                TimeUnit unit = this.getWindowCheckIntervalUnit(session);
                if (unit != null) {
                    operation.append(" ");
                    SqlUtils.timeUnitToString(operation, unit);
                }
            }
        }
    }
}

