/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.equeue;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.collection.AbstractIterator;
import com.streamscape.ds.schema.collection.qspace.AbstractQueueCollection;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueIterator;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueProxy;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueCollection;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueCollection;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.trigger.window.BatchSizeQueueWindowTrigger;
import com.streamscape.ds.trigger.window.BatchTimeQueueWindowTrigger;
import com.streamscape.ds.trigger.window.CollectionWindowTrigger;
import com.streamscape.ds.trigger.window.SlidingSizeQueueWindowTrigger;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.EventPropertiesMapper;
import com.streamscape.ds.utils.QueueSlidingTimeWindowChecker;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.ds.utils.WindowCollection;
import com.streamscape.lib.analyzer.EventAnalyzer;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.filter.FilterUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.IllegalConsumerStateException;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.service.osf.config.ActiveEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class EventQueueCollection
extends BlockingQueueCollection
implements FabricEventListener,
WindowCollection {
    protected JSerializer serializer;
    protected String eventId = null;
    protected CompositeFilter eventIdFilter = null;
    protected String selector = null;
    protected EventPropertiesMapper eventPropertiesMapper = null;
    protected boolean withSourceEvent = false;
    protected boolean isSourceEventBlob = false;
    protected boolean isConsumer = false;
    protected boolean isConsumerAsync = false;
    protected EventScope eventScope = EventScope.OBSERVABLE;
    protected Statement getSourceEventStat = null;
    protected Session internalQueueSession = null;
    protected XSerializer xSerial = null;
    protected List<String> includeProps = null;
    protected List<String> excludeProps = null;
    protected boolean isStarted = false;
    protected TriggerDef windowTrigger = null;
    protected CollectionWindowType windowType = null;
    protected long windowSize = 0L;
    protected TimeUnit timeWindowUnit = null;
    protected long windowCheckInterval = 1000L;
    protected TimeUnit windowCheckIntervalUnit = null;
    protected FabricThread<?> windowCheckThread = null;
    private long nextSlidingTimeWindowCheckerTime;
    private int lastSlidingTimeWindowDeletedRows;
    private long lastSlidingTimeWindowCheckerTime;
    private int consumerMaxDepth;
    private EventConsumer consumer;

    public EventQueueCollection(DataspaceStore store, NameManager.ObjectName name, MemoryModel memoryModel, String constraintEventId, String selector, List<String> includeProps, List<String> excludeProps, boolean withSourceEvent, boolean isSourceEventBlob, boolean isConsumer, boolean isConsumerAsync, int consumerMaxDepth) {
        this(store, name, CollectionType.EVENT_QUEUE, memoryModel, includeProps, excludeProps, withSourceEvent, isSourceEventBlob, isConsumer, isConsumerAsync);
        this.eventId = constraintEventId;
        this.selector = selector;
        this.consumerMaxDepth = consumerMaxDepth;
    }

    protected EventQueueCollection(DataspaceStore store, NameManager.ObjectName name, CollectionType collectionType, MemoryModel memoryModel, List<String> includeProps, List<String> excludeProps, boolean withSourceEvent, boolean isSourceEventBlob, boolean isConsumer, boolean isConsumerAsync) {
        super(store, name, collectionType, memoryModel);
        this.withSourceEvent = withSourceEvent;
        this.isSourceEventBlob = isSourceEventBlob;
        this.isConsumer = isConsumer;
        this.isConsumerAsync = isConsumerAsync;
        this.includeProps = includeProps;
        this.excludeProps = excludeProps;
        try {
            JSerializerFactory serializerFactory = this.runtimeCtx.getJSerializerFactory();
            this.serializer = serializerFactory.createSerializer("Queue" + name.name + "Serializer");
            XSerializerFactory xSerializerFactory = this.runtimeCtx.getXSerializerFactory();
            this.xSerial = xSerializerFactory.createSerializer("ProcessQueue" + name.name + "Serializer");
            this.xSerial.mapAttribute("SemanticType", "class");
        }
        catch (Exception error) {
            Trace.logException(ProcessQueueCollection.class, error, true);
        }
    }

    protected void intiEventIdFilter() {
        if (this.eventId != null) {
            try {
                this.eventIdFilter = new CompositeFilter(this.eventId);
            }
            catch (FilterFormatException exception) {
                Trace.logException(this, exception, false);
                throw new DataspaceException("Failed to create event filter for [" + this.eventId + "]. Cause: " + exception.getMessage());
            }
        }
    }

    protected void initializeDataType(Session session) {
        this.dataType = SqlUtils.getEventDataType(session, this.eventId);
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        this.initEventMapper();
        this.intiEventIdFilter();
        NameManager.ObjectName internalTableName = this.store.nameManager.newObjectName(this.name.name, this.name.isNameQuoted, 3);
        internalTableName.schema = this.name.schema;
        this.table = TableUtil.newTable(this.store, this.getInternalTableType(this.memoryModel), internalTableName);
        this.addIdentityColumn(this.table, "SeqId", Type.SQL_INTEGER);
        this.eventPropertiesMapper.addPropertyColumns(this.table);
        this.addColumn(this.table, "Created", Type.SQL_TIMESTAMP);
        this.initializeDataType(session);
        if (this.withSourceEvent) {
            if (this.isSourceEventBlob) {
                this.addColumn(this.table, "Event", Type.SQL_BLOB);
            } else {
                this.addColumn(this.table, "Event", this.dataType);
            }
        }
        NameManager.ObjectName internalTableIndexName = NameManager.newInfoSchemaObjectName(internalTableName.name, internalTableName.isNameQuoted, 21);
        this.table.createPrimaryKeyConstraint(internalTableIndexName, new int[]{0}, true);
        this.table.setColumnStructures();
        this.table.compile(session, parentObject);
        if (this.windowType != null) {
            this.activateWindow(session, internalTableName);
        }
    }

    @Override
    public void compileInternalStatements(Session session) {
        String SQL = null;
        SQL = "insert into " + this.name.getSchemaQualifiedStatementName() + "(" + this.eventPropertiesMapper.getColumnsNames() + "  Created" + (this.withSourceEvent ? ",Event" : "") + ")values (" + this.eventPropertiesMapper.getParamsList() + (this.withSourceEvent ? "?," : "") + "?)";
        this.pushElementStat = session.compileStatement(SQL);
        SQL = "select count(*) from " + this.name.getSchemaQualifiedStatementName();
        this.querySizeStat = session.compileStatement(SQL);
        SQL = "truncate collection " + this.name.getSchemaQualifiedStatementName();
        this.clearQueueStat = session.compileStatement(SQL);
        SQL = "delete from " + this.name.getSchemaQualifiedStatementName() + " where SeqId = ?";
        this.removeElementByKeyStat = session.compileStatement(SQL);
        if (this.withSourceEvent) {
            SQL = "select top 1 SeqId, Event from " + this.name.getSchemaQualifiedStatementName();
            this.getElementStat = session.compileStatement(SQL);
            SQL = "select top 1 SeqId, Event from " + this.name.getSchemaQualifiedStatementName() + " order by SeqId desc";
            this.getElementLastStat = session.compileStatement(SQL);
            SQL = "select Event from " + this.name.getSchemaQualifiedStatementName() + " where SeqId = ?";
            this.getSourceEventStat = session.compileStatement(SQL);
            SQL = this.isSourceEventBlob ? "select true from " + this.name.getSchemaQualifiedStatementName() + " where fromBinary(Event) = ?" : "select true from " + this.name.getSchemaQualifiedStatementName() + " where Event = ?";
            this.containsStat = session.compileStatement(SQL);
            SQL = this.isSourceEventBlob ? "delete from " + this.name.getSchemaQualifiedStatementName() + " where fromBinary(Event) =?" : "delete from " + this.name.getSchemaQualifiedStatementName() + " where Event =?";
            this.removeElementStat = session.compileStatement(SQL);
            this.dfetchNonBlockingStatSql = "dfetch SeqId, Event from " + this.name.getSchemaQualifiedStatementName() + " (delete row)";
            this.dfetchLastNonBlockingStatSql = "dfetch SeqId, Event from " + this.name.getSchemaQualifiedStatementName() + " order by SeqId desc (delete row)";
        }
        if (this.store.getStoreState().isStarted()) {
            this.open(session);
        }
    }

    public void setConstraintEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getConstraintEventId() {
        return this.eventId;
    }

    public void setEventScope(EventScope eventScope) {
        this.eventScope = eventScope;
    }

    public EventScope getEventScope() {
        return this.eventScope;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getSelector() {
        return this.selector;
    }

    @Override
    public CollectionWindowType getWindowType() {
        return this.windowType;
    }

    public void setWindowType(CollectionWindowType windowType) {
        this.windowType = windowType;
    }

    @Override
    public long getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(long windowSize) {
        this.windowSize = windowSize;
    }

    @Override
    public TimeUnit getTimeWindowUnit() {
        return this.timeWindowUnit;
    }

    public void setTimeWindowUnit(TimeUnit timeWindowUnit) {
        this.timeWindowUnit = timeWindowUnit;
    }

    public long getWindowCheckInterval() {
        return this.windowCheckInterval;
    }

    public void setWindowCheckInterval(long interval) {
        this.windowCheckInterval = interval;
    }

    public TimeUnit getWindowCheckIntervalUnit() {
        return this.windowCheckIntervalUnit;
    }

    public void setWindowCheckIntervalUnit(TimeUnit unit) {
        this.windowCheckIntervalUnit = unit;
    }

    public String getEventId(Session session) {
        return this.eventId;
    }

    public void activateWindow(Session session, NameManager.ObjectName internalTableName) {
        NameManager.ObjectName windowTriggerName = NameManager.newInfoSchemaObjectName(internalTableName.name + "_window", internalTableName.isNameQuoted, 9);
        switch (this.windowType) {
            case SLIDING_SIZE_WINDOW: {
                this.windowTrigger = new SlidingSizeQueueWindowTrigger(windowTriggerName, this, this.windowSize);
                break;
            }
            case SLIDING_TIME_WINDOW: {
                QueueSlidingTimeWindowChecker checker = new QueueSlidingTimeWindowChecker(this.dataspace, this, SqlUtils.getTimeIntervalInMillis(this.windowSize, this.timeWindowUnit), SqlUtils.getTimeIntervalInMillis(this.windowCheckInterval, this.windowCheckIntervalUnit), this.windowType);
                this.windowCheckThread = FabricThreadManager.getInstance().createThread(this.name.name + "WindowCheck", "Time Window check thread.", checker);
                break;
            }
            case BATCH_SIZE_WINDOW: {
                this.windowTrigger = new BatchSizeQueueWindowTrigger(windowTriggerName, this, this.windowSize);
                break;
            }
            case BATCH_TIME_WINDOW: {
                this.windowTrigger = new BatchTimeQueueWindowTrigger(windowTriggerName, this, SqlUtils.getTimeIntervalInMillis(this.windowSize, this.timeWindowUnit));
            }
        }
        if (this.windowTrigger != null) {
            this.table.addTrigger(session, this.windowTrigger, windowTriggerName, 0);
            this.windowTrigger.compile(session, this);
        }
    }

    public void startWindow() {
        if (this.windowCheckThread != null) {
            this.windowCheckThread.start();
        }
    }

    public boolean removeWindow() {
        if (this.windowType != null) {
            if (this.windowCheckThread != null) {
                this.windowCheckThread.stop();
                this.windowCheckThread = null;
                this.windowType = null;
            }
            if (this.windowTrigger != null) {
                this.table.removeTrigger(this.windowTrigger);
                ((CollectionWindowTrigger)this.windowTrigger).destroy();
                this.windowTrigger = null;
            }
            return true;
        }
        return false;
    }

    public boolean isConsumer() {
        return this.isConsumer;
    }

    @Override
    public String getTriggerEventId(int whenType, int operationType) {
        return this.eventId;
    }

    @Override
    public boolean isTriggerEventAutogenerated() {
        return false;
    }

    protected void initEventMapper() {
        this.eventPropertiesMapper = new EventPropertiesMapper(this.eventId, this.includeProps, this.excludeProps, this);
        this.eventPropertiesMapper.compile(this);
    }

    @Override
    public void open(Session session) {
        this.doOpen(session);
        this.start(session);
    }

    protected void doOpen(Session session) {
        this.table.updateTriggersOrderAndRemoveNulls();
        if (this.windowCheckThread != null) {
            this.windowCheckThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.windowCheckThread != null) {
            this.windowCheckThread.stop();
            this.windowCheckThread = null;
        }
        if (this.windowTrigger != null) {
            ((CollectionWindowTrigger)this.windowTrigger).destroy();
        }
        this.unregisterQueueAsConsumer();
        if (this.internalQueueSession != null) {
            Session session = this.internalQueueSession;
            synchronized (session) {
                if (this.internalQueueSession != null) {
                    this.internalQueueSession.close();
                    this.internalQueueSession = null;
                }
            }
        }
    }

    @Override
    public void destroy(Session session) {
        this.close();
    }

    protected void unregisterQueueAsConsumer() {
        if (this.isConsumer && this.isStarted) {
            try {
                if (this.isConsumerAsync) {
                    this.dataspace.dropConsumer("QSPACE_" + this.name.name + "_ASYNC_LISTENER");
                } else {
                    this.dataspace.dropConsumer("QSPACE_" + this.name.name + "_LISTENER");
                }
                Trace.logDebug(this, "Queue '" + this.name.name + "' has been unregistered as consumer of '" + this.getConstraintEventId() + "' events.");
            }
            catch (FabricEventDispatcherException error) {
                throw new DataspaceException("Unable to unregister '" + this.name.name + "' queue as consumer. " + error.getMessage());
            }
            this.isStarted = false;
        }
    }

    protected EventFlowEntity getEventFlowEntity() {
        return EventFlowEntity.DATASPACE_EVENT_QUEUE;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public Result getCollectionProperties(Session session) {
        String semanticType;
        Result result = super.getCollectionProperties(session);
        try {
            EventDatagram event = PrototypeFactory.getContext().getEventDatagramFactory().createEvent(this.eventId);
            Class payloadClass = new EventAnalyzer(event).getPayLoadClass();
            semanticType = payloadClass != null ? EventAnalyzer.resolveTypeName(payloadClass) : "none";
        }
        catch (Exception e) {
            semanticType = "none";
        }
        result.navigator.add(new Object[]{"Semantic Type", semanticType});
        result.navigator.add(new Object[]{"Event", StringUtils.wrapEventId(this.eventId) + (String)(this.selector != null ? " when (" + this.selector + ")" : "")});
        result.navigator.add(new Object[]{"Consumer", this.isConsumer ? "TRUE" : "FALSE"});
        if (this.isConsumer) {
            result.navigator.add(new Object[]{"Consumer Type", this.isConsumerAsync ? "ASYNC" : "DIRECT"});
            if (this.isConsumerAsync && this.consumer != null && this.consumer instanceof EventAsyncConsumer) {
                result.navigator.add(new Object[]{"Consumer Max Depth", ((EventAsyncConsumer)this.consumer).getMaxDepth()});
                result.navigator.add(new Object[]{"Consumer Depth", ((EventAsyncConsumer)this.consumer).getCurrentDepth()});
            }
            result.navigator.add(new Object[]{"Event Scope", this.eventScope.toString()});
            result.navigator.add(new Object[]{"With Source Event", this.withSourceEvent ? "TRUE" : "FALSE"});
            if (this.withSourceEvent) {
                result.navigator.add(new Object[]{"Source Event Type", this.isSourceEventBlob ? "BLOB" : "EVENT"});
            }
        }
        result.navigator.add(new Object[]{"Consumer State", this.isStarted ? "STARTED" : "STOPPED"});
        if (this.windowType != null) {
            result.navigator.add(new Object[]{"Window Type", this.windowType.toString()});
            if (this.windowType == CollectionWindowType.BATCH_SIZE_WINDOW || this.windowType == CollectionWindowType.SLIDING_SIZE_WINDOW) {
                result.navigator.add(new Object[]{"Window Size", this.windowSize});
            } else {
                result.navigator.add(new Object[]{"Time Window", this.windowSize + " " + (this.timeWindowUnit != null ? ParserDQL.timeUnitToString(this.timeWindowUnit) : "sec")});
            }
            if (this.windowType == CollectionWindowType.SLIDING_TIME_WINDOW) {
                result.navigator.add(new Object[]{"Window Check Interval", this.windowCheckInterval + " " + (this.windowCheckIntervalUnit != null ? ParserDQL.timeUnitToString(this.windowCheckIntervalUnit) : "sec")});
                result.navigator.add(new Object[]{"Next Check Time", this.nextSlidingTimeWindowCheckerTime != 0L ? DataspaceDateTime.getSqlTimestampString(this.nextSlidingTimeWindowCheckerTime, session.getTimeZone()) : "n/a"});
                result.navigator.add(new Object[]{"Last Check Time", this.lastSlidingTimeWindowCheckerTime != 0L ? DataspaceDateTime.getSqlTimestampString(this.lastSlidingTimeWindowCheckerTime, session.getTimeZone()) : "n/a"});
                result.navigator.add(new Object[]{"Last Deleted Rows", this.lastSlidingTimeWindowDeletedRows});
            }
        }
        result.navigator.add(new Object[]{"Window Triggers", this.getWindowTriggers().stream().map(t -> t.getObjectName().name).collect(Collectors.joining(","))});
        return result;
    }

    @Override
    public String getCollectionSQL(boolean forReplication) {
        boolean first;
        StringBuilder buffer = new StringBuilder();
        buffer.append("CONSTRAINED").append(' ').append("BY").append(' ');
        buffer.append('\"').append(this.eventId).append('\"');
        if (this.includeProps != null && this.includeProps.size() > 0) {
            buffer.append(' ').append("INCLUDE").append(' ').append("PROPERTIES").append(' ');
            buffer.append("(");
            first = true;
            for (String prop : this.includeProps) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(prop);
            }
            buffer.append(")");
        }
        if (this.excludeProps != null && this.excludeProps.size() > 0) {
            buffer.append(' ').append("EXCLUDE").append(' ').append("PROPERTIES").append(' ');
            buffer.append("(");
            first = true;
            for (String prop : this.excludeProps) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(prop);
            }
            buffer.append(")");
        }
        if (this.withSourceEvent) {
            buffer.append(' ').append("WITH");
            buffer.append(' ').append("SOURCE");
            buffer.append(' ').append("EVENT");
            if (this.isSourceEventBlob) {
                buffer.append(' ').append("AS");
                buffer.append(' ').append("BLOB");
            }
        }
        if (this.isConsumer && !forReplication) {
            if (this.isConsumerAsync) {
                buffer.append(' ').append("ASYNC");
            }
            buffer.append(' ').append("CONSUMER");
            if (this.isConsumerAsync && this.consumerMaxDepth > 0) {
                buffer.append(' ').append("(").append(this.consumerMaxDepth).append(")");
            }
            if (this.eventScope != null && this.eventScope != EventScope.OBSERVABLE) {
                buffer.append(' ').append("EVENT").append(' ').append("SCOPE").append(' ').append(this.eventScope.toString());
            }
            if (this.selector != null && this.selector.length() > 0) {
                buffer.append(' ').append("WHEN").append("(");
                buffer.append(this.selector).append(")");
            }
        }
        if (!forReplication) {
            this.appendWindowInformation(buffer);
        }
        return buffer.toString();
    }

    protected void appendWindowInformation(StringBuilder buffer) {
        if (this.windowType != null) {
            switch (this.windowType) {
                case SLIDING_SIZE_WINDOW: {
                    buffer.append(' ').append("SLIDING");
                    buffer.append(' ').append("SIZE");
                    break;
                }
                case SLIDING_TIME_WINDOW: {
                    buffer.append(' ').append("SLIDING");
                    buffer.append(' ').append("TIME");
                    break;
                }
                case BATCH_SIZE_WINDOW: {
                    buffer.append(' ').append("BATCH");
                    buffer.append(' ').append("SIZE");
                    break;
                }
                case BATCH_TIME_WINDOW: {
                    buffer.append(' ').append("BATCH");
                    buffer.append(' ').append("TIME");
                }
            }
            buffer.append(' ').append("WINDOW");
            buffer.append(' ').append(this.windowSize);
            if (this.timeWindowUnit != null) {
                buffer.append(' ');
                SqlUtils.timeUnitToString(buffer, this.timeWindowUnit);
            }
            if (this.windowType == CollectionWindowType.SLIDING_TIME_WINDOW) {
                buffer.append(' ').append("CHECK").append(' ').append("INTERVAL").append(' ').append(this.windowCheckInterval);
                if (this.windowCheckIntervalUnit != null) {
                    buffer.append(' ');
                    SqlUtils.timeUnitToString(buffer, this.windowCheckIntervalUnit);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
        if (this.internalQueueSession == null || this.internalQueueSession.isClosed()) {
            this.internalQueueSession = this.dataspace.createSession();
        }
        Session session = this.internalQueueSession;
        synchronized (session) {
            if (this.internalQueueSession == null || this.internalQueueSession.isClosed()) {
                this.internalQueueSession = this.dataspace.createSession();
            }
            try {
                this.pushElement(this.internalQueueSession, event);
            }
            catch (DataspaceException error) {
                throw new FabricEventException(error.getMessage());
            }
        }
    }

    @Override
    public ImmutableEventDatagram getEventForTrigger(Session session, Object[] oldData, Object[] newData, int when, int operationType) {
        ImmutableEventDatagram event = null;
        try {
            int indexOfEventData = this.table.getColumnIndex("Event");
            if (operationType == 3031 && newData != null) {
                event = this.unwrapEvent(session, newData[indexOfEventData]);
            } else if (operationType == 3032 && oldData != null) {
                event = this.unwrapEvent(session, oldData[indexOfEventData]);
            }
        }
        catch (Exception error) {
            Trace.logError(this, error.getMessage());
        }
        return event;
    }

    public Result getSourceEvent(Session session, String seqId) {
        if (!this.withSourceEvent) {
            return Result.newErrorResult(new DataspaceException("Unable to extract source event as queue has been created without this option enabled."));
        }
        Result result = session.executeCompiledStatement(this.getSourceEventStat, new Object[]{Integer.parseInt(seqId)});
        if (result.isData() && result.navigator.next()) {
            try {
                ImmutableEventDatagram event = this.unwrapEvent(session, result.navigator.getCurrent(0));
                String typeName = "datagram";
                if (event instanceof AdvisoryEventDatagram) {
                    typeName = "advisory";
                }
                String serializedEvent = this.xSerial.serialize(typeName, event);
                result = Result.newSingleColumnResult("Event");
                result.navigator.add(new Object[]{serializedEvent});
                return result;
            }
            catch (Exception error) {
                return Result.newErrorResult(error);
            }
        }
        return Result.newErrorResult(new DataspaceException("Unable to get " + seqId + " event."));
    }

    @Override
    public Object wrapEvent(Session session, ImmutableEventDatagram event) {
        try {
            if (this.isSourceEventBlob) {
                byte[] serializedBlob = this.serializer.serialize(event);
                return SqlUtils.allocateBlob(session, serializedBlob);
            }
            return new OtherTypeWrapper(event);
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to wrap event: " + error.getMessage());
            throw new DataspaceException(error);
        }
    }

    @Override
    public ImmutableEventDatagram unwrapEvent(Session session, Object data) {
        if (data == null) {
            return null;
        }
        ImmutableEventDatagram event = null;
        if (this.isSourceEventBlob && data instanceof BlobDataID) {
            byte[] eventData = null;
            try {
                BlobDataID blobId = (BlobDataID)data;
                eventData = SqlUtils.extractBlob(session, blobId);
                event = (ImmutableEventDatagram)this.serializer.deserialize(eventData);
            }
            catch (Exception error) {
                Trace.logError(this, "Unable to unwrap event: " + error.getMessage());
                if (error instanceof DataspaceException) {
                    throw (DataspaceException)error;
                }
                throw new DataspaceException(error);
            }
        } else if (data instanceof OtherTypeWrapper) {
            event = (ImmutableEventDatagram)OtherTypeWrapper.unwrapAndClone(data);
        } else {
            throw new DataspaceException("Unable to extract Event data from collection.");
        }
        return event;
    }

    protected void checkIncomingEventMatchesConstraint(ImmutableEventDatagram event) {
        if (this.eventIdFilter == null) {
            return;
        }
        if (!FilterUtils.matches(event.getEventId(), this.eventIdFilter)) {
            throw new DataspaceException("Incompatible event types. Queue constrained by [" + this.getConstraintEventId() + "], while given event with id [" + event.getEventId() + "].");
        }
    }

    @Override
    protected boolean pushElement(Session session, Object element) {
        if (!(element instanceof ImmutableEventDatagram)) {
            throw new DataspaceException("Invalid object type, should be ImmutableEventDatagram, but passed: " + (element != null ? element.getClass().getName() : null) + " in pushElement.");
        }
        return this.pushElement(session, (ImmutableEventDatagram)element);
    }

    protected boolean pushElement(Session session, ImmutableEventDatagram element) {
        this.checkIncomingEventMatchesConstraint(element);
        try {
            int systemColumnCount = 2;
            int paramColumnCount = this.eventPropertiesMapper.getColumnsCount();
            Object[] params = new Object[2 + paramColumnCount];
            int index = -1;
            index = this.eventPropertiesMapper.setColumnValues(session, element, params, index, this.dataspace);
            params[++index] = session.getCurrentSqlTimestamp();
            if (this.withSourceEvent) {
                params[++index] = this.wrapEvent(session, element);
            }
            ImmutableEventDatagram current = session.sessionContext.currentCollectionEventForTrigger;
            session.sessionContext.currentCollectionEventForTrigger = element;
            Result result = session.executeCompiledStatement(this.pushElementStat, params);
            session.sessionContext.currentCollectionEventForTrigger = current;
            EventQueueCollection.checkResultNotError(result);
            return result.getUpdateCount() == 1;
        }
        catch (SQLException error) {
            Trace.logException(EventQueueCollection.class, error, true);
            throw new DataspaceException(error);
        }
    }

    @Override
    protected AbstractQueueCollection.KeyValue getElement(Session session, boolean isLast) {
        if (!this.withSourceEvent) {
            throw new DataspaceException("Get event operation allowed for event queue with source event only.");
        }
        this.checkOperationIsSupported(this.getElementStat, "getElement");
        Result result = session.executeCompiledStatement(isLast ? this.getElementLastStat : this.getElementStat, new Object[0]);
        return this.extractElementFromResult(session, result);
    }

    @Override
    protected AbstractQueueCollection.KeyValue dfetchElement(Session session, String selector, String updater, long timeout, TimeUnit unit, boolean isLast) {
        this.checkOperationIsSupported(this.dfetchNonBlockingStatSql, "dfetchElement");
        this.checkOperationIsSupported(this.dfetchLastNonBlockingStatSql, "dfetchElement");
        try {
            Statement dfetchStat;
            session.setAutoCommit(false);
            if ((selector == null || selector.length() == 0) && timeout == -1L && updater != null && updater.equals("delete row")) {
                dfetchStat = session.compileStatement(isLast ? this.dfetchLastNonBlockingStatSql : this.dfetchNonBlockingStatSql);
            } else {
                String dfetchSql = this.makeDfetchSql("SeqId, Event", selector, updater, isLast ? "order by SeqId desc" : null, timeout, unit);
                dfetchStat = session.compileStatement(dfetchSql);
            }
            Result result = session.executeCompiledStatement(dfetchStat, new Object[0]);
            AbstractQueueCollection.KeyValue keyValue = this.extractElementFromResult(session, result);
            return keyValue;
        }
        catch (DataspaceException exception) {
            session.rollback(true);
            throw exception;
        }
        finally {
            session.commit(true);
            session.setAutoCommit(true);
        }
    }

    protected AbstractQueueCollection.KeyValue extractElementFromResult(Session session, Result result) {
        EventQueueCollection.checkResultNotError(result);
        EventQueueCollection.checkResultIsData(result);
        RowSetNavigator rowSet = result.navigator;
        if (rowSet.next()) {
            ImmutableEventDatagram eventObject = this.unwrapEvent(session, rowSet.getCurrent(1));
            return new AbstractQueueCollection.KeyValue(rowSet.getCurrent(0), eventObject);
        }
        return null;
    }

    @Override
    protected boolean removeElement(Session session, Object event) {
        if (!(event instanceof EventDatagram)) {
            throw new DataspaceException("Invalid object type, should be EventDatagram, but passed: " + (event != null ? event.getClass().getName() : null) + " in pushElement.");
        }
        return this.removeElement(session, (EventDatagram)event);
    }

    protected boolean removeElement(Session session, EventDatagram event) {
        if (!this.withSourceEvent) {
            throw new DataspaceException("Remove event operation allowed for event queue with source event only.");
        }
        this.checkOperationIsSupported(this.removeElementStat, "removeElement");
        ImmutableEventDatagram current = session.sessionContext.currentCollectionEventForTrigger;
        session.sessionContext.currentCollectionEventForTrigger = event;
        Result result = session.executeCompiledStatement(this.removeElementStat, new Object[]{new OtherTypeWrapper(event)});
        session.sessionContext.currentCollectionEventForTrigger = current;
        EventQueueCollection.checkResultNotError(result);
        return result.getUpdateCount() > 0;
    }

    protected AbstractQueueCollection.KeyValue getElementWithSelector(Session session, String selector, boolean isLast) {
        if (!this.withSourceEvent) {
            throw new DataspaceException("Get event operation allowed for event queue with source event only.");
        }
        if (selector == null || selector.length() == 0) {
            return this.getElement(session, isLast);
        }
        Result result = session.executeDirectStatement("select SeqId, Event from " + this.name.getSchemaQualifiedStatementName() + " where " + selector + (isLast ? " order by SeqId desc" : ""));
        return this.extractElementFromResult(session, result);
    }

    @Override
    public boolean contains(Session session, Object o) {
        if (!this.withSourceEvent) {
            throw new DataspaceException("Contains event operation allowed for event queue with source event only.");
        }
        if (!(o instanceof ImmutableEventDatagram)) {
            return false;
        }
        return super.contains(session, new OtherTypeWrapper(o));
    }

    public long count(Session session, String selector) {
        Result result = session.executeDirectStatement("select count(*) from " + this.name.getSchemaQualifiedStatementName() + " where (" + selector + ")");
        EventQueueCollection.checkResultNotError(result);
        EventQueueCollection.checkResultIsData(result);
        RowSetNavigator navigator = result.getNavigator();
        if (navigator.first()) {
            return ((Number)navigator.getCurrent(0)).longValue();
        }
        throw new DataspaceException("Count query with selector returned no results.");
    }

    public void start(Session session) {
        if (this.isConsumer && !this.isStarted) {
            try {
                if (this.isConsumerAsync) {
                    EventAsyncConsumer consumer = this.dataspace.createEventAsyncConsumer("QSPACE_" + this.name.name + "_ASYNC_LISTENER", this, this.eventId, this.selector, this.eventScope, false);
                    if (this.consumerMaxDepth > 0) {
                        consumer.setMaxDepth(this.consumerMaxDepth);
                    }
                    consumer.start();
                    this.dataspace.addSinkEventFlow(this.getEventFlowEntity(), this.name.name, consumer);
                    this.consumer = consumer;
                } else {
                    EventConsumer consumer = this.dataspace.createEventConsumer("QSPACE_" + this.name.name + "_LISTENER", this, this.getConstraintEventId(), this.selector, this.eventScope, false);
                    this.dataspace.addSinkEventFlow(this.getEventFlowEntity(), this.name.name, consumer);
                    this.consumer = consumer;
                }
                Trace.logDebug(this, "Queue '" + this.name.name + "' has been registered as consumer of '" + this.getConstraintEventId() + "' events.");
            }
            catch (FabricEventDispatcherException | IllegalConsumerStateException error) {
                throw new DataspaceException("Unable to register '" + this.name.name + "' queue as consumer.", error);
            }
            this.isStarted = true;
        }
    }

    public void stop(Session session) {
        this.unregisterQueueAsConsumer();
    }

    public Object waitToTake(Session session, String selector, long timeout, TimeUnit unit) {
        return this.waitToTake(session, selector, timeout, unit, false);
    }

    public Object waitToTakeLast(Session session, String selector, long timeout, TimeUnit unit) {
        return this.waitToTake(session, selector, timeout, unit, true);
    }

    public Object waitToTake(Session session, String selector, long timeout, TimeUnit unit, boolean isLast) {
        if (!this.withSourceEvent && this.getClass() == EventQueueCollection.class) {
            throw new DataspaceException("take/waitToTake event operation allowed for queue with source event only.");
        }
        AbstractQueueCollection.KeyValue keyValue = this.dfetchElement(session, selector, timeout, unit, isLast);
        if (keyValue == null) {
            return null;
        }
        return keyValue.value;
    }

    public Object read(Session session, String selector) {
        return this.read(session, selector, false);
    }

    public Object readLast(Session session, String selector) {
        return this.read(session, selector, true);
    }

    public Object read(Session session, String selector, boolean isLast) {
        if (!this.withSourceEvent && this.getClass() == EventQueueCollection.class) {
            throw new DataspaceException("Read event operation allowed for queue with source event only.");
        }
        AbstractQueueCollection.KeyValue keyValue = this.getElementWithSelector(session, selector, isLast);
        return keyValue != null ? keyValue.value : null;
    }

    public Object waitToRead(Session session, String selector, long timeout, TimeUnit unit) {
        return this.waitToRead(session, selector, timeout, unit, false);
    }

    public Object waitToReadLast(Session session, String selector, long timeout, TimeUnit unit) {
        return this.waitToRead(session, selector, timeout, unit, true);
    }

    public Object waitToRead(Session session, String selector, long timeout, TimeUnit unit, boolean isLast) {
        if (!this.withSourceEvent && this.getClass() == EventQueueCollection.class) {
            throw new DataspaceException("waitToRead event operation allowed for queue with source event only.");
        }
        AbstractQueueCollection.KeyValue keyValue = this.dfetchElement(session, selector, "", timeout, unit, isLast);
        return keyValue != null ? keyValue.value : null;
    }

    public List<Object> readAll(Session session) {
        if (!this.withSourceEvent && this.getClass() == EventQueueCollection.class) {
            throw new DataspaceException("readAll event operation allowed for queue with source event only.");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        AbstractIterator iterator = this.iterator(session);
        while (iterator.hasNext(session)) {
            result.add(iterator.next(session));
        }
        return result;
    }

    @Override
    public AbstractIterator iterator(Session session) {
        if (!this.withSourceEvent && this.getClass() == EventQueueCollection.class) {
            throw new DataspaceException("iterator operation allowed for queue with source event only.");
        }
        return new EventQueueIterator(this, session);
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new EventQueueProxy();
    }

    @Override
    protected Object pollForDrain(Session session, String selector) {
        if (selector != null && selector.length() == 0) {
            selector = null;
        }
        return this.waitToTake(session, selector, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public List<ActiveEvent> getEvents() {
        List<ActiveEvent> events = super.getEvents();
        ActiveEvent event = new ActiveEvent(this.eventId);
        event.setType(ActiveEvent.ActiveEventType.Sink);
        event.setEventScope(this.dataspace.getEventScope());
        event.setEventModel(SqlUtils.resolveEventModel(this.runtimeCtx, this.eventId));
        events.add(event);
        String actionableEventId = this.getTriggerEventId(8, 3001);
        event = new ActiveEvent(actionableEventId);
        event.setType(ActiveEvent.ActiveEventType.Actionable);
        event.setEventScope(EventScope.LOCAL);
        event.setEventModel(SqlUtils.resolveEventModel(this.runtimeCtx, actionableEventId));
        events.add(event);
        return events;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = super.getReferences();
        if (!(this.eventId == null || this.eventId.length() <= 0 || this.eventId.contains("#") || this.eventId.contains("*") || this.eventId.contains("&"))) {
            set.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetEventPrototypeObjectName(this.eventId));
        }
        return set;
    }

    @Override
    protected void onAggregateOthers(DataspaceStateHolder holder) {
        if (this.eventId != null && this.eventId.length() > 0 && PrototypeFactory.existsPrototype(this.eventId)) {
            try {
                new EventPropertiesMapper(this.eventId, this.includeProps, this.excludeProps, this).compile(this);
            }
            catch (Exception exception) {
                holder.setSuspectState(DataspaceStateHolder.prototype(this.eventId), exception.getMessage());
            }
        }
    }

    @Override
    public void setNextSlidingTimeWindowCheckerTime(long nextSlidingTimeWindowCheckerTime) {
        this.nextSlidingTimeWindowCheckerTime = nextSlidingTimeWindowCheckerTime;
    }

    @Override
    public void setLastSlidingTimeWindowDeletedRows(int lastSlidingTimeWindowDeletedRows) {
        this.lastSlidingTimeWindowDeletedRows = lastSlidingTimeWindowDeletedRows;
    }

    @Override
    public void setLastSlidingTimeWindowCheckerTime(long lastSlidingTimeWindowCheckerTime) {
        this.lastSlidingTimeWindowCheckerTime = lastSlidingTimeWindowCheckerTime;
    }
}

