/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace.aqueue;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractIterator;
import com.streamscape.ds.schema.collection.qspace.AbstractQueueCollection;
import com.streamscape.ds.schema.collection.qspace.aqueue.AuditQueueIterator;
import com.streamscape.ds.schema.collection.qspace.aqueue.AuditQueueProxy;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueCollection;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.schema.table.TableWorks;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.window.BatchSizeTableWindowTrigger;
import com.streamscape.ds.trigger.window.BatchTimeTableWindowTrigger;
import com.streamscape.ds.trigger.window.SlidingSizeTableWindowTrigger;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.ds.utils.TableSlidingTimeWindowChecker;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.AuditEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventFlowEntity;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class AuditQueueCollection
extends EventQueueCollection {
    protected Statement removeAuditByProcessIdStat = null;
    protected Statement removeAuditByProcessGroupStat = null;
    protected Statement selectForRetainStat = null;
    protected String storedColumns = null;

    public AuditQueueCollection(DataspaceStore store, NameManager.ObjectName name, MemoryModel memoryModel, boolean isConsumer, boolean isConsumerAsync) {
        super(store, name, CollectionType.AUDIT_QUEUE, memoryModel, null, null, false, false, isConsumer, isConsumerAsync);
    }

    public String getModel() {
        return "AuditQueue";
    }

    @Override
    protected EventFlowEntity getEventFlowEntity() {
        return EventFlowEntity.DATASPACE_AUDIT_QUEUE;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        this.initEventMapper();
        this.intiEventIdFilter();
        NameManager.ObjectName internalTableName = this.store.nameManager.newObjectName(this.name.name, this.name.isNameQuoted, 3);
        internalTableName.schema = this.name.schema;
        this.table = TableUtil.newTable(this.store, this.getInternalTableType(this.memoryModel), internalTableName);
        this.addIdentityColumn(this.table, "SeqId", Type.SQL_INTEGER);
        this.eventPropertiesMapper.addPropertyColumns(this.table);
        this.addColumn(this.table, "Source", Type.STRING);
        this.addColumn(this.table, "Message", Type.STRING);
        this.addColumn(this.table, "Created", Type.SQL_TIMESTAMP);
        NameManager.ObjectName internalTableIndexName = NameManager.newInfoSchemaObjectName(internalTableName.name, false, 21);
        this.table.createPrimaryKeyConstraint(internalTableIndexName, new int[]{0}, true);
        if (!session.isProcessingLog()) {
            TableWorks tableWorks = new TableWorks(session, this.table);
            NameManager.ObjectName complexIndexName = this.store.nameManager.newAutoName(this.table.getObjectName().name + "_index", this.table.getObjectName().schema, this.table.getObjectName(), 21);
            tableWorks.addIndex(new int[]{this.table.getColumnIndex("CorrelationId"), this.table.getColumnIndex("EventGroupId"), this.table.getColumnIndex("EventKey")}, complexIndexName, false, null);
        }
        this.table.setColumnStructures();
        this.table.compile(session, parentObject);
        this.initializeDataType(session);
        if (this.windowType != null) {
            this.activateWindow(session, internalTableName);
        }
    }

    @Override
    public void activateWindow(Session session, NameManager.ObjectName internalTableName) {
        NameManager.ObjectName windowTriggerName = NameManager.newInfoSchemaObjectName(internalTableName.name + "_window", internalTableName.isNameQuoted, 9);
        switch (this.windowType) {
            case SLIDING_SIZE_WINDOW: {
                this.windowTrigger = new SlidingSizeTableWindowTrigger(windowTriggerName, this, this.windowSize);
                break;
            }
            case SLIDING_TIME_WINDOW: {
                TableSlidingTimeWindowChecker checker = new TableSlidingTimeWindowChecker(this.dataspace, this, SqlUtils.getTimeIntervalInMillis(this.windowSize, this.timeWindowUnit), SqlUtils.getTimeIntervalInMillis(this.windowCheckInterval, this.windowCheckIntervalUnit), this.windowType);
                this.windowCheckThread = FabricThreadManager.getInstance().createThread(this.name.name + "WindowCheck", "Time Window check thread.", checker);
                break;
            }
            case BATCH_SIZE_WINDOW: {
                this.windowTrigger = new BatchSizeTableWindowTrigger(windowTriggerName, this, this.windowSize);
                break;
            }
            case BATCH_TIME_WINDOW: {
                this.windowTrigger = new BatchTimeTableWindowTrigger(windowTriggerName, this, SqlUtils.getTimeIntervalInMillis(this.windowSize, this.timeWindowUnit));
            }
        }
        if (this.windowTrigger != null) {
            this.table.addTrigger(session, this.windowTrigger, windowTriggerName, 0);
            this.windowTrigger.compile(session, this);
        }
    }

    @Override
    public void compileInternalStatements(Session session) {
        String SQL = null;
        SQL = "delete from " + this.name.getSchemaQualifiedStatementName() + " where CorrelationId = ? and EventGroupId = ?";
        this.removeAuditByProcessIdStat = session.compileStatement(SQL, 0);
        SQL = "delete from " + this.name.getSchemaQualifiedStatementName() + " where EventGroupId = ?";
        this.removeAuditByProcessGroupStat = session.compileStatement(SQL, 0);
        SQL = "delete from " + this.name.getSchemaQualifiedStatementName() + " where CorrelationId = ? and EventGroupId = ? and EventKey = ?";
        this.removeElementStat = session.compileStatement(SQL, 0);
        SQL = "purge queue " + this.name.getSchemaQualifiedStatementName();
        this.clearQueueStat = session.compileStatement(SQL);
        SQL = "select count(*) as num from " + this.name.getSchemaQualifiedStatementName();
        this.querySizeStat = session.compileStatement(SQL);
        SQL = "insert into " + this.name.getSchemaQualifiedStatementName() + "(" + this.eventPropertiesMapper.getColumnsNames() + "Source, Message, Created) VALUES(" + this.eventPropertiesMapper.getParamsList() + "?,?,?)";
        this.pushElementStat = session.compileStatement(SQL, 0);
        SQL = "select true from " + this.name.getSchemaQualifiedStatementName() + " where CorrelationId = ? and EventGroupId = ? and EventKey = ?";
        this.containsStat = session.compileStatement(SQL);
        this.storedColumns = "SeqId, Message, " + this.eventPropertiesMapper.getColumnsNames().trim();
        if (this.storedColumns.charAt(this.storedColumns.length() - 1) == ',') {
            this.storedColumns = this.storedColumns.substring(0, this.storedColumns.length() - 1);
        }
        SQL = "select top 1 " + this.storedColumns + " from " + this.name.getSchemaQualifiedStatementName();
        this.getElementStat = session.compileStatement(SQL, 0);
        SQL = "select top 1 " + this.storedColumns + " from " + this.name.getSchemaQualifiedStatementName() + " order by SeqId desc";
        this.getElementLastStat = session.compileStatement(SQL, 0);
        SQL = "select SeqId, CorrelationId, EventKey, EventGroupId from " + this.name.getSchemaQualifiedStatementName();
        this.selectForRetainStat = session.compileStatement(SQL, 0);
        SQL = "delete from " + this.name.getSchemaQualifiedStatementName() + " where SeqId = ?";
        this.removeElementByKeyStat = session.compileStatement(SQL);
        if (this.store.getStoreState().isStarted()) {
            this.open(session);
        }
    }

    @Override
    protected synchronized boolean pushElement(Session session, Object element) {
        if (!(element instanceof AuditEvent)) {
            throw new DataspaceException("Invalid object type, shoud be AuditEvent, but passed: " + (element != null ? element.getClass().getName() : null) + " in pushElement.");
        }
        return this.pushElement(session, (AuditEvent)element);
    }

    @Override
    protected boolean pushElement(Session session, ImmutableEventDatagram element) {
        this.checkIncomingEventMatchesConstraint(element);
        try {
            int systemColumnCount = 3;
            int paramColumnCount = this.eventPropertiesMapper.getColumnsCount();
            Object[] params = new Object[3 + paramColumnCount];
            int index = -1;
            index = this.eventPropertiesMapper.setColumnValues(session, element, params, index, this.dataspace);
            byte[] address = element.getEventSource();
            if (address != null) {
                FabricAddress source = new FabricAddress(address);
                ComponentReference component = this.dataspace.getModerator().lookupComponent(source);
                String sourceName = null;
                sourceName = component != null ? component.getName() : "Unknown";
                params[++index] = sourceName;
            } else {
                params[++index] = null;
            }
            params[++index] = ((AuditEvent)element).getAuditData();
            params[++index] = session.getCurrentSqlTimestamp();
            Result result = session.executeCompiledStatement(this.pushElementStat, params);
            if (result.isError() || result.getUpdateCount() != 1) {
                Trace.logError(AuditQueueCollection.class, "Unable to put new message to the audit queue. " + result.getException().getMessage());
            }
            AuditQueueCollection.checkResultNotError(result);
            AuditQueueCollection.checkUpdateCountIs(result, 1);
            return true;
        }
        catch (Exception error) {
            Trace.logException(AuditQueueCollection.class, error, true);
            throw new DataspaceException(error);
        }
    }

    @Override
    protected AbstractQueueCollection.KeyValue getElement(Session session, boolean isLast) {
        Result result = session.executeCompiledStatement(isLast ? this.getElementLastStat : this.getElementStat, new Object[0]);
        return this.extractEventFromResult(session, result);
    }

    @Override
    protected boolean removeElement(Session session, EventDatagram element) {
        Result result = session.executeCompiledStatement(this.removeElementStat, new Object[]{element.getCorrelationId(), element.getEventGroupId(), element.getEventKey()});
        AuditQueueCollection.checkResultNotError(result);
        return result.getUpdateCount() > 0;
    }

    @Override
    protected AbstractQueueCollection.KeyValue dfetchElement(Session session, String selector, String updater, long timeout, TimeUnit unit, boolean isLast) {
        try {
            session.setAutoCommit(false);
            String dfetchSql = this.makeDfetchSql(this.storedColumns, selector, updater, isLast ? "order by SeqId desc" : null, timeout, unit);
            Statement dfetchStat = session.compileStatement(dfetchSql);
            Result result = session.executeCompiledStatement(dfetchStat, new Object[0]);
            AbstractQueueCollection.KeyValue keyValue = this.extractEventFromResult(session, result);
            return keyValue;
        }
        catch (DataspaceException exception) {
            session.rollback(true);
            throw exception;
        }
        finally {
            session.commit(true);
            session.setAutoCommit(true);
        }
    }

    private AbstractQueueCollection.KeyValue extractEventFromResult(Session session, Result result) {
        AuditQueueCollection.checkResultNotError(result);
        AuditQueueCollection.checkResultIsData(result);
        RowSetNavigator rowSet = result.navigator;
        if (rowSet.next()) {
            return new AbstractQueueCollection.KeyValue(rowSet.getCurrent(0), this.instantiateAuditEvent(rowSet));
        }
        return null;
    }

    @Override
    protected AbstractQueueCollection.KeyValue getElementWithSelector(Session session, String selector, boolean isLast) {
        if (selector == null || selector.length() == 0) {
            return this.getElement(session, isLast);
        }
        Result result = session.executeDirectStatement("select " + this.storedColumns + " from " + this.name.getSchemaQualifiedStatementName() + " where " + selector + (isLast ? " order by SeqId desc" : ""));
        return this.extractEventFromResult(session, result);
    }

    @Override
    public boolean contains(Session session, Object o) {
        this.checkOperationIsSupported(this.containsStat, "contains");
        if (o == null || !(o instanceof AuditEvent)) {
            return false;
        }
        AuditEvent event = (AuditEvent)o;
        Result result = session.executeCompiledStatement(this.containsStat, new Object[]{event.getCorrelationId(), event.getEventGroupId(), event.getEventKey()});
        AuditQueueCollection.checkResultNotError(result);
        if (result.navigator != null && result.navigator.next()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public AbstractIterator iterator(Session session) {
        return new AuditQueueIterator(this, session);
    }

    @Override
    public boolean retainAll(Session session, Collection<?> c) {
        boolean modified = false;
        Result result = session.executeCompiledStatement(this.selectForRetainStat, new Object[0]);
        AuditQueueCollection.checkResultNotError(result);
        AuditQueueCollection.checkResultIsData(result);
        RowSetNavigator rowSet = result.navigator;
        while (rowSet.next()) {
            String CorrelationId = (String)rowSet.getCurrent(1);
            String EventKey = (String)rowSet.getCurrent(2);
            String EventGroupId = (String)rowSet.getCurrent(3);
            for (Object o : c) {
                AuditEvent event;
                if (o == null || !(o instanceof AuditEvent) || (CorrelationId == (event = (AuditEvent)o).getCorrelationId() || CorrelationId != null && CorrelationId.equals(event.getCorrelationId())) && (EventKey == event.getEventKey() || EventKey != null && EventKey.equals(event.getEventKey())) && (EventGroupId == event.getEventGroupId() || EventGroupId != null && EventGroupId.equals(event.getEventGroupId()))) continue;
                modified |= this.removeElementByKey(session, rowSet.getCurrent(0));
            }
        }
        return modified;
    }

    public boolean dropAuditForProcessInstance(Session session, String serviceGroup, String instance) {
        Result result = session.executeCompiledStatement(this.removeAuditByProcessIdStat, new Object[]{instance, serviceGroup});
        AuditQueueCollection.checkResultNotError(result);
        return result.getUpdateCount() > 0;
    }

    public boolean dropAuditForServiceGroup(Session session, String group) {
        Result result = session.executeCompiledStatement(this.removeAuditByProcessGroupStat, new Object[]{group});
        AuditQueueCollection.checkResultNotError(result);
        return result.getUpdateCount() > 0;
    }

    @Override
    public Result getCollectionProperties(Session session) {
        return super.getCollectionProperties(session);
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new AuditQueueProxy();
    }

    protected AuditEvent instantiateAuditEvent(RowSetNavigator rowSet) {
        try {
            AuditEvent event = (AuditEvent)EventDatagramFactory.getInstance().createEvent(this.eventId);
            String str = (String)rowSet.getCurrent(1);
            if (str != null) {
                event.setAuditData(str);
            }
            if ((str = (String)rowSet.getCurrent(2)) != null) {
                event.setCorrelationId(str);
            }
            if ((str = (String)rowSet.getCurrent(3)) != null) {
                event.setEventGroupId(str);
            }
            if ((str = (String)rowSet.getCurrent(4)) != null) {
                event.setEventKey(str);
            }
            if ((str = (String)rowSet.getCurrent(6)) != null) {
                event.setReplyTo(str);
            }
            if ((str = (String)rowSet.getCurrent(7)) != null) {
                event.setForwardTo(str);
            }
            try {
                TimestampData date = (TimestampData)rowSet.getCurrent(8);
                if (date != null) {
                    event.setEventExpiration(date.getMilliseconds());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                str = (String)rowSet.getCurrent(10);
                if (str != null) {
                    event.setSeverity(Severity.valueOf(str));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                str = (String)rowSet.getCurrent(11);
                if (str != null) {
                    event.setContentType(AuditEvent.ContentType.valueOf(str));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return event;
        }
        catch (Exception exception) {
            throw new DataspaceException(exception);
        }
    }
}

