/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.function.FunctionTableFactoryImpl;
import com.streamscape.ds.schema.collection.qspace.QSpaceSysTablesManager;
import com.streamscape.ds.schema.collection.qspace.aqueue.AuditQueueFactoryImpl;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueFactoryImpl;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueFactoryImpl;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueFactoryImpl;
import com.streamscape.ds.schema.collection.stream.SourceStreamFactoryImpl;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.sef.FabricNamingException;
import com.streamscape.sef.enums.EventScope;

public class QSpace
extends AbstractDataspace {
    protected FabricThread<?> expirationThread = null;
    private QSpaceSysTablesManager qspaceSysTablesManager;

    public QSpace(NameManager.ObjectName name, EventScope scope, Grantee owner, DataspaceStore store) throws FabricNamingException {
        super(name, DataspaceType.QSPACE, scope, owner, store);
        this.qspaceSysTablesManager = new QSpaceSysTablesManager(store, this);
        Trace.logDebug(this, "QSpace '" + name.name + "' instance created.");
    }

    @Override
    protected void doInit(Session session) {
        super.doInit(session);
        this.qspaceSysTablesManager.initialize(session);
    }

    @Override
    protected void initializeCollectionFactories() {
        this.collectionFactoryFactories.registerCollectionFactory(BlockingQueueFactoryImpl.class);
        this.collectionFactoryFactories.registerCollectionFactory(EventQueueFactoryImpl.class);
        this.collectionFactoryFactories.registerCollectionFactory(AuditQueueFactoryImpl.class);
        this.collectionFactoryFactories.registerCollectionFactory(ProcessQueueFactoryImpl.class);
        this.collectionFactoryFactories.registerCollectionFactory(SourceStreamFactoryImpl.class);
        this.collectionFactoryFactories.registerCollectionFactory(FunctionTableFactoryImpl.class);
    }

    @Override
    protected void doOpen(Session session) {
        super.doOpen(session);
        final int expirationInterval = this.store.getProperties().getIntegerProperty("qspace.expiration_interval", 60) * 1000;
        if (expirationInterval > 0) {
            Runnable expirationEngine = new Runnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 10[UNCONDITIONALDOLOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            this.expirationThread = FabricThreadManager.getInstance().createThread("DSYS:Expiration.Mechanism", "Looks for expired messages and updates their state.", expirationEngine);
            Trace.logInfo(this, "Expiration thread is scheduled with '" + expirationInterval + "' interval.");
        } else {
            Trace.logInfo(this, "Expiration thread for '" + this.getName() + "' dataspace is disabled.");
        }
        if (this.expirationThread != null) {
            this.expirationThread.start();
        }
    }

    @Override
    protected void doDestroy(Session session) throws DataspaceException {
        if (this.expirationThread != null) {
            this.expirationThread.stop();
        }
        super.doDestroy(session);
    }

    @Override
    protected void doClose(Session session) {
        if (this.expirationThread != null) {
            this.expirationThread.stop();
        }
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 4);
        while (iter.hasNext()) {
            Object schemaObject = iter.next();
            Collection collection = (Collection)schemaObject;
            this.wrapInLoggedClosing("collection", collection, () -> collection.close());
        }
        this.qspaceSysTablesManager.reset();
        super.doClose(session);
    }

    public QSpaceSysTablesManager getQSpaceSysTablesManager() {
        return this.qspaceSysTablesManager;
    }

    static /* synthetic */ DataspaceStore access$000(QSpace x0) {
        return x0.store;
    }
}

