/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.qspace;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.collection.Table;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.AbstractIterator;
import com.streamscape.ds.schema.collection.qspace.AbstractQueueProxy;
import com.streamscape.ds.schema.collection.qspace.QSpace;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueCollection;
import com.streamscape.ds.schema.collection.tspace.map.MapCollection;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;

public abstract class AbstractQueueCollection
extends AbstractCollection
implements AccessibleObject {
    protected long maxDepth = Long.MAX_VALUE;
    protected Statement clearQueueStat = null;
    protected Statement querySizeStat = null;
    protected Statement containsStat = null;
    protected Statement insertStat = null;

    protected AbstractQueueCollection(DataspaceStore store, NameManager.ObjectName name, CollectionType collectionType, MemoryModel memoryModel) {
        super(store, name, collectionType, memoryModel);
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
    }

    @Override
    public void compileInternalStatements(Session session) {
        String SQL = null;
        SQL = "truncate collection " + this.name.getSchemaQualifiedStatementName();
        this.clearQueueStat = session.compileStatement(SQL);
        SQL = "select count(*) as num from " + this.name.getSchemaQualifiedStatementName();
        this.querySizeStat = session.compileStatement(SQL);
    }

    protected void bindProducerFor(String eventId) throws FabricEventDispatcherException {
        this.dataspace.bindProducerFor(eventId);
    }

    protected void unbindProducerFor(String eventId) throws FabricEventDispatcherException {
        this.dataspace.unbindProducerFor(eventId);
    }

    protected boolean isBoundEventId(String eventId) {
        return this.dataspace.isBoundEventId(eventId);
    }

    public long getMaxDepth() {
        return this.maxDepth;
    }

    public String getName() {
        return this.name.name;
    }

    public String getQueueName() throws JMSException {
        return this.name.name;
    }

    public String getSchema() {
        return this.dataspace.getObjectName().getNameString();
    }

    public String getTableName() {
        return this.name.name;
    }

    protected QSpace getQSpace() {
        return (QSpace)this.dataspace;
    }

    protected abstract boolean pushElement(Session var1, Object var2);

    protected abstract KeyValue getElement(Session var1, boolean var2);

    protected abstract boolean removeElement(Session var1, Object var2);

    protected abstract boolean removeElementByKey(Session var1, Object var2);

    protected abstract KeyValue dfetchElement(Session var1, String var2, String var3, long var4, TimeUnit var6, boolean var7);

    protected KeyValue dfetchElement(Session session, String selector, long timeout, TimeUnit unit, boolean isLast) {
        return this.dfetchElement(session, selector, "delete row", timeout, unit, isLast);
    }

    public boolean offer(Session session, Object eventObject) {
        return this.pushElement(session, eventObject);
    }

    public Object remove(Session session) {
        return this.remove(session, false);
    }

    public Object removeLast(Session session) {
        return this.remove(session, true);
    }

    public Object remove(Session session, boolean isLast) {
        KeyValue keyValue = this.dfetchElement(session, null, -1L, TimeUnit.MILLISECONDS, isLast);
        if (keyValue == null) {
            throw new NoSuchElementException();
        }
        return keyValue.value;
    }

    public Object poll(Session session) {
        return this.poll(session, false);
    }

    public Object pollLast(Session session) {
        return this.poll(session, true);
    }

    public Object poll(Session session, boolean isLast) {
        KeyValue keyValue = this.dfetchElement(session, null, -1L, TimeUnit.MILLISECONDS, isLast);
        if (keyValue == null) {
            return null;
        }
        return keyValue.value;
    }

    public Object element(Session session) {
        return this.element(session, false);
    }

    public Object elementLast(Session session) {
        return this.element(session, true);
    }

    public Object element(Session session, boolean isLast) {
        KeyValue result = this.getElement(session, isLast);
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result.value;
    }

    public Object peek(Session session) {
        return this.peek(session, false);
    }

    public Object peekLast(Session session) {
        return this.peek(session, true);
    }

    public Object peek(Session session, boolean isLast) {
        KeyValue result = this.getElement(session, isLast);
        if (result == null) {
            return null;
        }
        return result.value;
    }

    public boolean remove(Session session, Object o) {
        return this.removeElement(session, o);
    }

    public boolean add(Session session, Object object) {
        return this.pushElement(session, object);
    }

    public long size(Session session) {
        this.checkOperationIsSupported(this.querySizeStat, "size");
        Result result = session.executeCompiledStatement(this.querySizeStat, new Object[0]);
        AbstractQueueCollection.checkResultNotError(result);
        AbstractQueueCollection.checkResultIsData(result);
        RowSetNavigator rowSet = result.navigator;
        if (rowSet.next()) {
            return (Long)rowSet.getCurrent(0);
        }
        throw new DataspaceException("Size query doesn't return result.");
    }

    public boolean isEmpty(Session session) {
        return this.size(session) == 0L;
    }

    public void clear(Session session) {
        this.checkOperationIsSupported(this.clearQueueStat, "clear");
        Result result = session.executeCompiledStatement(this.clearQueueStat, new Object[0]);
        AbstractQueueCollection.checkResultNotError(result);
    }

    public boolean contains(Session session, Object o) {
        this.checkOperationIsSupported(this.containsStat, "contains");
        Result result = session.executeCompiledStatement(this.containsStat, new Object[]{o});
        AbstractQueueCollection.checkResultNotError(result);
        if (result.navigator != null && result.navigator.next()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object[] toArray(Session session) {
        ArrayList<Object> result = new ArrayList<Object>();
        AbstractIterator iterator = this.iterator(session);
        while (iterator.hasNext(session)) {
            result.add(iterator.next(session));
        }
        return result.toArray();
    }

    public AbstractIterator iterator(Session session) {
        this.checkOperationIsSupported(null, "toArray");
        return null;
    }

    public boolean addAll(Session session, Collection<? extends Object> c) {
        boolean result = false;
        for (Object object : c) {
            result |= this.add(session, object);
        }
        return result;
    }

    public boolean addAll(final Session session, String nodeName, String componentType, String componentName, String collectionName) {
        AbstractCollection.CollectionDelegate<Boolean, Collection> delegate = new AbstractCollection.CollectionDelegate<Boolean, Collection>(){

            @Override
            public Boolean delegate(Collection collection, DataspaceAccessor accessor) throws DataspaceComponentException {
                return AbstractQueueCollection.this.addAll(session, collection);
            }
        };
        return this.executeWithRemoteCollection(nodeName, componentType, componentName, collectionName, delegate, Collection.class);
    }

    public boolean containsAll(Session session, Collection<?> c) {
        for (Object o : c) {
            if (this.contains(session, o)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(final Session session, String nodeName, String componentType, String componentName, String collectionName) {
        AbstractCollection.CollectionDelegate<Boolean, Collection> delegate = new AbstractCollection.CollectionDelegate<Boolean, Collection>(){

            @Override
            public Boolean delegate(Collection collection, DataspaceAccessor accessor) throws DataspaceComponentException {
                return AbstractQueueCollection.this.containsAll(session, collection);
            }
        };
        return this.executeWithRemoteCollection(nodeName, componentType, componentName, collectionName, delegate, Collection.class);
    }

    public boolean removeAll(Session session, Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(session, o);
        }
        return result;
    }

    public boolean removeAll(final Session session, String nodeName, String componentType, String componentName, String collectionName) {
        AbstractCollection.CollectionDelegate<Boolean, Collection> delegate = new AbstractCollection.CollectionDelegate<Boolean, Collection>(){

            @Override
            public Boolean delegate(Collection collection, DataspaceAccessor accessor) throws DataspaceComponentException {
                return AbstractQueueCollection.this.removeAll(session, collection);
            }
        };
        return this.executeWithRemoteCollection(nodeName, componentType, componentName, collectionName, delegate, Collection.class);
    }

    public boolean retainAll(Session session, Collection<?> c) {
        boolean modified = false;
        AbstractIterator iterator = this.iterator(session);
        while (iterator.hasNext(session)) {
            Object value = iterator.next(session);
            if (c.contains(value)) continue;
            iterator.remove(session);
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(final Session session, String nodeName, String componentType, String componentName, String collectionName) {
        AbstractCollection.CollectionDelegate<Boolean, Collection> delegate = new AbstractCollection.CollectionDelegate<Boolean, Collection>(){

            @Override
            public Boolean delegate(Collection collection, DataspaceAccessor accessor) throws DataspaceComponentException {
                return AbstractQueueCollection.this.retainAll(session, collection);
            }
        };
        return this.executeWithRemoteCollection(nodeName, componentType, componentName, collectionName, delegate, Collection.class);
    }

    protected void checkOperationIsSupported(Object stat, String string) {
        if (stat == null) {
            throw new DataspaceException("Operation " + string + " is not supported for current queue.");
        }
    }

    public <Object> Object[] toArray(Session session, Object[] a) {
        return null;
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new AbstractQueueProxy();
    }

    public RowSet toRowSet(Session session) {
        RowMetaData meta = SqlUtils.getCollectionMeta(this);
        RowSet rowSet = new RowSet(meta);
        Type[] columnTypes = this.table.colTypes;
        int columnCount = this.table.getColumnCount();
        RowIterator it = this.table.rowIteratorClustered(session);
        try {
            while (it.hasNext()) {
                Object[] data = new Object[columnCount];
                Row row = it.getNextRow();
                Object[] currentData = row.getData();
                for (int i = 0; i < columnCount; ++i) {
                    if (columnTypes[i].isLobType()) {
                        if (!(currentData[i] instanceof BlobDataID)) continue;
                        try {
                            data[i] = SqlUtils.extractBlob(session, (BlobDataID)currentData[i]);
                        }
                        catch (Exception error) {
                            Trace.logError(this, "Unable to extract LOB object. " + error.getMessage());
                        }
                        continue;
                    }
                    data[i] = columnTypes[i].convertSQLToJava(session, currentData[i]);
                }
                rowSet.addToRowSet(data);
            }
        }
        catch (SQLException error) {
            throw new DataspaceException("Unable to convert collection to RowSet. " + error.getMessage());
        }
        finally {
            if (it != null) {
                it.release();
            }
        }
        return rowSet;
    }

    public void fromRowSet(Session session, RowSet rowSet) {
        try {
            rowSet.beforeFirst();
        }
        catch (Exception error) {
            throw new DataspaceException("Unable to scroll to the begining of rowset.");
        }
        if (rowSet.getMeta().getColumnCount() != this.table.getColumnCount()) {
            Trace.logError(this, "Number of columns in rowset " + rowSet.getMeta().getColumnCount() + " does not match number of columns " + this.table.getColumnCount() + " in transient table.");
            return;
        }
        Type[] rowSetTypes = new Type[rowSet.getMeta().getColumnCount()];
        for (int i = 0; i < rowSet.getMeta().getColumnCount(); ++i) {
            String columnName = null;
            try {
                columnName = rowSet.getMeta().getColumnName(i + 1);
                rowSetTypes[i] = Types.getParameterSQLType(session, rowSet.getMeta().getColumnTypeClass(i + 1));
            }
            catch (Exception error) {
                throw new DataspaceException("Unable to resolve data type for rowset column " + String.valueOf(columnName == null ? Integer.valueOf(i) : columnName) + ".");
            }
            if (rowSetTypes[i] != null) continue;
            throw new DataspaceException("Unable to resolve data type for rowset column " + String.valueOf(columnName == null ? Integer.valueOf(i) : columnName) + ".");
        }
        PersistentStore store = this.table.getRowStore(session);
        Type[] tableTypes = this.table.getColumnTypes();
        try {
            while (rowSet.next()) {
                Object[] rowData = SqlUtils.getDataForInsert(session, this.table, rowSet.getCurrentRow().getRawData(), tableTypes, rowSetTypes);
                this.table.insertSingleRow(session, store, rowData, null);
            }
        }
        catch (SQLException error) {
            Trace.logError(this, "Unable to load data from rowset into transient table. " + error.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<?> toQueue(Session session) {
        LinkedList<Object> queue = new LinkedList<Object>();
        RowIterator it = null;
        Type[] columnTypes = this.table.colTypes;
        Object[] data = null;
        try {
            it = this.table.rowIteratorClustered(session);
            try {
                while (it.hasNext()) {
                    Row row = it.getNextRow();
                    data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                    queue.add(data[1]);
                }
            }
            catch (Exception error) {
                throw new DataspaceException("Unable to convert collection to Queue. " + error.getMessage());
            }
        }
        finally {
            if (it != null) {
                it.release();
                it = null;
            }
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromQueue(Session session, Queue<?> queue) {
        if (this.table.getColumnCount() > 2) {
            Trace.logError(this, "Table could not be loaded from queue. Number of columns mismatch (one or two columns expected).");
            throw new DataspaceException("Number of columns mismatch. One or two columns expected.");
        }
        if (queue instanceof AbstractQueueCollection) {
            com.streamscape.ds.schema.table.Table table = ((AbstractQueueCollection)((Object)queue)).getBaseTable();
            PersistentStore tableStore = this.table.getRowStore(session);
            RowIterator iter = table.rowIteratorClustered(session);
            try {
                while (iter.hasNext()) {
                    Object[] data = iter.getNext();
                    this.table.insertSingleRow(session, tableStore, data, null);
                }
            }
            finally {
                if (iter != null) {
                    iter.release();
                    iter = null;
                }
            }
        } else {
            int columnCount = this.table.getColumnCount();
            Type[] queueTypes = new Type[columnCount];
            Class<?> elemClass = null;
            PersistentStore store = this.table.getRowStore(session);
            Type[] tableTypes = this.table.getColumnTypes();
            if (columnCount == 2) {
                queueTypes[0] = tableTypes[0];
            }
            int elemIndex = columnCount - 1;
            for (Object element : queue) {
                if (queueTypes[elemIndex] == null || element.getClass() != elemClass) {
                    queueTypes[elemIndex] = this.resolveType(session, element);
                    elemClass = element.getClass();
                }
                Object[] rowData = new Object[columnCount];
                rowData[elemIndex] = element;
                rowData = SqlUtils.getDataForInsert(session, this.table, rowData, tableTypes, queueTypes);
                this.table.insertSingleRow(session, store, rowData, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainFromQueue(Session session, Queue<?> queue) {
        this.fromQueue(session, queue);
        if (queue instanceof AbstractQueueCollection) {
            AbstractQueueCollection queueCollection = (AbstractQueueCollection)((Object)queue);
            PersistentStore store = queueCollection.getBaseTable().getRowStore(session);
            RowIterator it = queueCollection.getBaseTable().getPrimaryIndex().firstRow(store);
            try {
                while (it.hasNext()) {
                    Row row = it.getNextRow();
                    session.addDeleteAction((com.streamscape.ds.schema.table.Table)row.getTable(), row, null);
                }
            }
            finally {
                it.release();
            }
        } else {
            queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<?, ?> toMap(Session session) {
        HashMap<Object, Object> map;
        block15: {
            map = new HashMap<Object, Object>();
            RowIterator it = null;
            int columnCount = this.table.getColumnCount();
            Type[] columnTypes = this.table.colTypes;
            Object[] data = null;
            try {
                it = this.table.rowIteratorClustered(session);
                if (columnCount == 2) {
                    try {
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                            map.put(data[0], data[1]);
                        }
                        break block15;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map. " + error.getMessage());
                    }
                }
                RowMetaData meta = SqlUtils.getCollectionMeta(this);
                if (this.table.getPrimaryKey().length == 1) {
                    Object key = null;
                    try {
                        while (it.hasNext()) {
                            com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                            Row row = it.getNextRow();
                            data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                            newRow.setRawData(data);
                            key = data[this.table.getPrimaryKey()[0]];
                            map.put(key, newRow);
                        }
                        break block15;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map. " + error.getMessage());
                    }
                }
                long sequence = -1L;
                try {
                    while (it.hasNext()) {
                        com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                        Row row = it.getNextRow();
                        data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                        newRow.setRawData(data);
                        map.put(++sequence, newRow);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to convert collection to Map. " + error.getMessage());
                }
            }
            finally {
                if (it != null) {
                    it.release();
                    it = null;
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromMap(Session session, Map<?, ?> map) {
        if (this.table.getColumnCount() != 2) {
            Trace.logError(this, "Table could not be loaded from map. Number of columns mismatch (two columns expected).");
            throw new DataspaceException("Number of columns mismatch. Two columns expected.");
        }
        if (map instanceof MapCollection) {
            com.streamscape.ds.schema.table.Table table = ((MapCollection)((Object)map)).getBaseTable();
            PersistentStore tableStore = this.table.getRowStore(session);
            RowIterator iter = table.rowIteratorClustered(session);
            try {
                while (iter.hasNext()) {
                    Object[] data = iter.getNext();
                    this.table.insertSingleRow(session, tableStore, data, null);
                }
            }
            finally {
                if (iter != null) {
                    iter.release();
                    iter = null;
                }
            }
        } else {
            Type[] mapDsTypes = new Type[2];
            Class[] mapTypes = new Class[2];
            PersistentStore store = this.table.getRowStore(session);
            Type[] tableTypes = this.table.getColumnTypes();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (mapDsTypes[0] == null || entry.getKey().getClass() != mapTypes[0]) {
                    mapDsTypes[0] = this.resolveType(session, entry.getKey());
                    mapTypes[0] = entry.getKey().getClass();
                }
                if (mapDsTypes[1] == null || entry.getValue().getClass() != mapTypes[1]) {
                    mapDsTypes[1] = this.resolveType(session, entry.getValue());
                    mapTypes[1] = entry.getValue().getClass();
                }
                Object[] rowData = SqlUtils.getDataForInsert(session, this.table, new Object[]{entry.getKey(), entry.getValue()}, tableTypes, mapDsTypes);
                this.table.insertSingleRow(session, store, rowData, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCollection toTable(Session session) {
        NameManager.ObjectName name = this.store.nameManager.newObjectName("TEMP_TABLE_" + System.currentTimeMillis(), false, 4);
        name.schema = SqlInvariants.MODULE_NAME;
        TableCollection collection = new TableCollection(this.store, name, MemoryModel.MEMORY, 12);
        com.streamscape.ds.schema.table.Table baseTable = collection.getBaseTable();
        com.streamscape.ds.schema.table.Table newBaseTable = collection.getBaseTable();
        for (int i = 0; i < baseTable.getColumnCount(); ++i) {
            newBaseTable.addColumn(baseTable.getColumn(i));
        }
        newBaseTable.createPrimaryKey();
        session.sessionContext.addSessionCollection(collection);
        collection.compile(session, null);
        collection.compileInternalStatements(session);
        int columnCount = this.table.getColumnCount();
        RowIterator it = this.table.rowIteratorClustered(session);
        PersistentStore tableStore = collection.getBaseTable().getRowStore(session);
        try {
            while (it.hasNext()) {
                Object[] data = new Object[columnCount];
                Row row = it.getNextRow();
                Object[] currentData = row.getData();
                System.arraycopy(currentData, 0, data, 0, columnCount);
                collection.getBaseTable().insertSingleRow(session, tableStore, data, null);
            }
        }
        finally {
            if (it != null) {
                it.release();
            }
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromTable(Session session, TableCollection table) {
        if (table.getBaseTable().getColumnCount() != this.table.getColumnCount()) {
            Trace.logError(this, "Number of columns in provided table " + table.getBaseTable().getColumnCount() + " does not match number of columns " + this.table.getColumnCount() + " in current table.");
            throw new DataspaceException("Number of columns mismatch.");
        }
        PersistentStore tableStore = this.table.getRowStore(session);
        RowIterator iter = table.getBaseTable().rowIteratorClustered(session);
        try {
            while (iter.hasNext()) {
                Object[] data = iter.getNext();
                this.table.insertSingleRow(session, tableStore, data, null);
            }
        }
        finally {
            if (iter != null) {
                iter.release();
                iter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapCollection toMapCollection(Session session) {
        MapCollection collection;
        block17: {
            NameManager.ObjectName name = this.store.nameManager.newObjectName("TEMP_MAP_" + System.currentTimeMillis(), false, 4);
            name.schema = SqlInvariants.MODULE_NAME;
            collection = new MapCollection(session.dataspaceStore, name, MemoryModel.MEMORY);
            session.sessionContext.addSessionCollection(collection);
            RowIterator it = null;
            int columnCount = this.table.getColumnCount();
            Type[] columnTypes = this.table.colTypes;
            Object[] data = null;
            try {
                it = this.table.rowIteratorClustered(session);
                if (columnCount == 2) {
                    collection.defineKeyColumn(columnTypes[0], columnTypes[0].getNameString());
                    collection.defineValueColumn(columnTypes[1], columnTypes[1].getNameString());
                    collection.compile(session, null);
                    collection.compileInternalStatements(session);
                    try {
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            data = SqlUtils.convertRowFromSqlToJava(session, row, columnTypes);
                            collection.getBaseTable().insertSingleRow(session, collection.getBaseTable().getRowStore(session), row.getData(), null);
                        }
                        break block17;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map collection. " + error.getMessage());
                    }
                }
                RowMetaData meta = SqlUtils.getCollectionMeta(this);
                if (this.table.getPrimaryKey().length == 1) {
                    Type columnType = columnTypes[this.table.getPrimaryKey()[0]];
                    collection.defineKeyColumn(columnType, columnType.getNameString());
                } else {
                    collection.defineKeyColumn(Type.LONG, Type.LONG.getNameString());
                }
                Type valueType = Types.getParameterSQLType(session, com.streamscape.sdo.rowset.Row.class);
                collection.defineValueColumn(valueType, valueType.getNameString());
                collection.compile(session, null);
                collection.compileInternalStatements(session);
                if (this.table.getPrimaryKey().length == 1) {
                    Object key = null;
                    try {
                        while (it.hasNext()) {
                            com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                            Row row = it.getNextRow();
                            data = row.getData();
                            newRow.setRawData(data);
                            key = data[this.table.getPrimaryKey()[0]];
                            Object[] currentRow = new Object[]{key, new OtherTypeWrapper(newRow)};
                            collection.getBaseTable().insertSingleRow(session, collection.getBaseTable().getRowStore(session), currentRow, null);
                        }
                        break block17;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Map collection. " + error.getMessage());
                    }
                }
                long sequence = -1L;
                try {
                    while (it.hasNext()) {
                        com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                        Row row = it.getNextRow();
                        data = row.getData();
                        newRow.setRawData(data);
                        Object[] currentRow = new Object[]{++sequence, new OtherTypeWrapper(newRow)};
                        collection.getBaseTable().insertSingleRow(session, collection.getBaseTable().getRowStore(session), currentRow, null);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to convert collection to Map collection. " + error.getMessage());
                }
            }
            finally {
                if (it != null) {
                    it.release();
                    it = null;
                }
            }
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockingQueueCollection toQueueCollection(Session session) {
        BlockingQueueCollection collection;
        block11: {
            NameManager.ObjectName name = this.store.nameManager.newObjectName("TEMP_QUEUE_" + System.currentTimeMillis(), false, 4);
            name.schema = SqlInvariants.MODULE_NAME;
            collection = new BlockingQueueCollection(session.dataspaceStore, name, MemoryModel.MEMORY);
            Type queueElementType = null;
            session.sessionContext.addSessionCollection(collection);
            RowIterator it = null;
            int columnCount = this.table.getColumnCount();
            Type[] columnTypes = this.table.colTypes;
            Object[] data = null;
            queueElementType = columnCount == 1 ? columnTypes[0] : Types.getParameterSQLType(session, com.streamscape.sdo.rowset.Row.class);
            collection.setConstraint(queueElementType);
            collection.compile(session, null);
            collection.compileInternalStatements(session);
            try {
                it = this.table.rowIteratorClustered(session);
                if (columnCount == 1) {
                    try {
                        while (it.hasNext()) {
                            Row row = it.getNextRow();
                            collection.add(session, row.getData()[0]);
                        }
                        break block11;
                    }
                    catch (Exception error) {
                        throw new DataspaceException("Unable to convert collection to Queue collection. " + error.getMessage());
                    }
                }
                RowMetaData meta = SqlUtils.getCollectionMeta(this);
                try {
                    while (it.hasNext()) {
                        com.streamscape.sdo.rowset.Row newRow = new com.streamscape.sdo.rowset.Row(meta);
                        Row row = it.getNextRow();
                        data = row.getData();
                        newRow.setRawData(data);
                        collection.add(session, newRow);
                    }
                }
                catch (Exception error) {
                    throw new DataspaceException("Unable to convert collection to Queue collection. " + error.getMessage());
                }
            }
            finally {
                if (it != null) {
                    it.release();
                    it = null;
                }
            }
        }
        return collection;
    }

    public void drainToMap(Session session, Map<?, ?> map) {
    }

    public void drainToRowSet(Session session, RowSet rowSet) {
    }

    public void drainToTable(Session session, Table table) {
    }

    public void drainToQueue(Session session, Queue<?> queue) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(Session session, Object[] row) {
        if (this.insertStat == null) {
            AbstractQueueCollection abstractQueueCollection = this;
            synchronized (abstractQueueCollection) {
                if (this.insertStat == null) {
                    StringBuilder query = new StringBuilder();
                    query.append("insert into " + this.name.getSchemaQualifiedStatementName() + " values(");
                    for (int i = 0; i < this.table.columnCount; ++i) {
                        if (i > 0) {
                            query.append(",");
                        }
                        query.append("?");
                    }
                    query.append(")");
                    this.insertStat = session.compileStatement(query.toString());
                }
            }
        }
        for (int i = 0; i < row.length; ++i) {
            if (!(row[i] instanceof BlobData)) continue;
            try {
                row[i] = SqlUtils.allocateBlob(session, ((BlobData)row[i]).data);
                continue;
            }
            catch (SQLException exception) {
                Trace.logError(this, "Failed to allocate blob. Cause: " + exception.getMessage());
                throw new DataspaceException("Failed to allocate blob. Cause: " + exception.getMessage());
            }
        }
        Result result = session.executeCompiledStatement(this.insertStat, row);
        AbstractQueueCollection.checkResultNotError(result);
    }

    public void addRows(Session session, Object[][] rows) {
        for (Object[] row : rows) {
            this.addRow(session, row);
        }
    }

    public int drainRowsTo(Session session, AbstractQueueCollection queue, String selector) {
        RowsPoller rowsPoller = new RowsPoller(session, selector);
        boolean isAutoCommit = session.isAutoCommit();
        try {
            session.setAutoCommit(false);
            session.startTransaction();
            Object[][] rows = rowsPoller.readRows();
            if (rows != null) {
                queue.addRows(session, rows);
                rowsPoller.removeRows();
                int n = rows.length;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable error) {
            session.rollback(true);
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new DataspaceException(error);
        }
        finally {
            session.commit(true);
            session.setAutoCommit(isAutoCommit);
        }
    }

    public Object[][] drainRows(Session session, String selector) {
        RowsPoller rowsPoller = new RowsPoller(session, selector);
        Object[][] rows = rowsPoller.readRows();
        rowsPoller.removeRows();
        return rows;
    }

    public int drainRowsTo(final Session session, String nodeName, String componentType, String componentName, String collectionName, final String selector) {
        AbstractCollection.CollectionDelegate<Integer, Collection> delegate = new AbstractCollection.CollectionDelegate<Integer, Collection>(){

            @Override
            public Integer delegate(Collection collection, DataspaceAccessor accessor) throws DataspaceComponentException {
                RowsPoller rowsPoller = new RowsPoller(session, selector);
                boolean isAutoCommit = session.isAutoCommit();
                boolean isAutoCommit1 = accessor.getAutoCommit();
                try {
                    session.setAutoCommit(false);
                    session.startTransaction();
                    accessor.setAutoCommit(false);
                    Object[][] rows = rowsPoller.readRows();
                    if (rows != null) {
                        ((com.streamscape.cli.ds.collection.Queue)collection).addRows(rows);
                        rowsPoller.removeRows();
                        Integer n = rows.length;
                        return n;
                    }
                    Integer n = 0;
                    return n;
                }
                catch (Throwable error) {
                    session.rollback(true);
                    accessor.rollback();
                    if (error instanceof RuntimeException) {
                        throw (RuntimeException)error;
                    }
                    throw new DataspaceException(error);
                }
                finally {
                    session.commit(true);
                    session.setAutoCommit(isAutoCommit);
                    accessor.commit();
                    accessor.setAutoCommit(isAutoCommit1);
                }
            }
        };
        return this.executeWithRemoteCollection(nodeName, componentType, componentName, collectionName, delegate, Collection.class);
    }

    public static class KeyValue {
        public Object key;
        public Object value;

        public KeyValue(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    static class BlobData {
        byte[] data;

        BlobData(byte[] data) {
            this.data = data;
        }
    }

    class RowsPoller {
        private Session session;
        private Statement selectRowsStat;
        private Object[][] rows;

        RowsPoller(Session session, String selector) {
            this.session = session;
            String query = "select * from " + AbstractQueueCollection.this.name.getSchemaQualifiedStatementName();
            if (selector != null && selector.length() > 0) {
                query = query + " " + selector;
            }
            this.selectRowsStat = session.compileStatement(query);
        }

        Object[][] readRows() {
            try {
                Result result = this.session.executeCompiledStatement(this.selectRowsStat, new Object[0]);
                AbstractCollection.checkResultNotError(result);
                AbstractCollection.checkResultIsData(result);
                RowSetNavigator rowSet = result.navigator;
                this.rows = new Object[rowSet.getSize()][];
                int j = 0;
                while (rowSet.next()) {
                    Object[] row = new Object[rowSet.getCurrent().length];
                    for (int i = 0; i < rowSet.getCurrent().length; ++i) {
                        row[i] = rowSet.getCurrent()[i];
                        if (!(row[i] instanceof BlobDataID)) continue;
                        BlobDataID blobId = (BlobDataID)row[i];
                        byte[] eventData = SqlUtils.extractBlob(this.session, blobId);
                        row[i] = new BlobData(eventData);
                    }
                    this.rows[j++] = row;
                }
            }
            catch (Exception error) {
                Trace.logException(this, error, true);
                throw new DataspaceException("Failed to poll row. Cause: " + error.getMessage());
            }
            return this.rows;
        }

        void removeRows() {
            if (this.rows == null || this.rows.length == 0) {
                return;
            }
            StringBuilder query = new StringBuilder();
            query.append("delete from " + AbstractQueueCollection.this.name.getSchemaQualifiedStatementName() + " where SeqId in (");
            for (int i = 0; i < this.rows.length; ++i) {
                if (i > 0) {
                    query.append(",");
                }
                query.append(this.rows[i][0]);
            }
            query.append(")");
            Result result = this.session.executeDirectStatement(query.toString());
            AbstractCollection.checkResultNotError(result);
        }
    }
}

