/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.function;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.function.FunctionTableProxy;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import java.util.ArrayList;
import java.util.List;

public class FunctionTableCollection
extends TableCollection
implements AccessibleObject,
VirtualTable.VirtualTableHelper {
    RplScript routine = null;
    List<String> params = null;
    boolean includeParameters = false;
    protected List<Expression> defaultParams = null;

    public FunctionTableCollection(DataspaceStore database, NameManager.ObjectName name, RplScript routine) {
        super(database, name, CollectionType.FUNCTION_TABLE, MemoryModel.MEMORY, 2);
        this.routine = routine;
    }

    public void setDefaultParameters(List<Expression> exprs) {
        if (this.routine != null && this.routine.getParameterCount() != exprs.size()) {
            throw new DataspaceException("Number of function parameters not match number of default values.");
        }
        this.defaultParams = exprs;
    }

    public void includeParameters(boolean value) {
        this.includeParameters = value;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        NameManager.ObjectName viewName = this.store.nameManager.newObjectName(this.name.name, this.name.isNameQuoted, 3);
        viewName.schema = this.name.schema;
        this.table = TableUtil.newVirtualTable(this.store, viewName, this, 2);
        try {
            ColumnSchema column;
            int i;
            this.params = new ArrayList<String>();
            for (int i2 = 0; i2 < this.routine.getParameterCount(); ++i2) {
                this.params.add(this.routine.getParameter((int)i2).getObjectName().name);
            }
            Table resultTable = this.routine.getTable();
            if (this.includeParameters) {
                for (i = 0; i < this.routine.getParameterCount(); ++i) {
                    column = this.routine.getParameter(i);
                    this.addColumn(this.table, column.getObjectName().name, column.getDataType());
                }
            }
            for (i = 0; i < resultTable.getColumnCount(); ++i) {
                column = resultTable.getColumn(i);
                this.addColumn(this.table, column.getObjectName().name, column.getDataType());
            }
            this.table.createPrimaryKey();
            this.table.setColumnStructures();
        }
        catch (Throwable error) {
            Trace.logException(this, error, true);
            throw new DataspaceException(error.getMessage());
        }
        super.compile(session, parentObject);
        if (this.store.getStoreState().isStarted()) {
            this.open(session);
        }
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new FunctionTableProxy();
    }

    @Override
    public String getSQL() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("EXPORT").append(' ').append("FUNCTION").append(' ');
        buffer.append(this.routine.getObjectName().getSchemaQualifiedStatementName()).append(' ');
        buffer.append("AS").append(' ').append("FUNCTION").append(' ').append("TABLE");
        buffer.append(' ').append(this.name.getSchemaQualifiedStatementName());
        if (this.defaultParams != null) {
            boolean first = true;
            buffer.append(' ').append("DEFAULT").append(' ').append("VALUES").append("(");
            for (Expression value : this.defaultParams) {
                if (!first) {
                    buffer.append(",");
                } else {
                    first = false;
                }
                buffer.append(value.getSQL());
            }
            buffer.append(")");
        }
        if (this.includeParameters) {
            buffer.append(' ').append("INCLUDE").append(' ').append("PARAMETERS");
        }
        return buffer.toString();
    }

    public void checkStatements(Session session) {
        super.compileInternalStatements(session);
    }

    @Override
    public Result getCollectionProperties(Session session) {
        Result result = super.getCollectionProperties(session);
        result.navigator.add(new Object[]{"Function Name", this.routine.getObjectName().name});
        if (this.defaultParams != null) {
            boolean first = true;
            for (Expression param : this.defaultParams) {
                if (first) {
                    result.navigator.add(new Object[]{"Initial Values", param.getSQL()});
                    first = false;
                    continue;
                }
                result.navigator.add(new Object[]{"", param.getSQL()});
            }
        }
        return result;
    }

    @Override
    public void insertIntoExternal(Session session, Object[] data, int[] jdbcTypes) {
    }

    @Override
    public Result executeExternalUpdate(Session session, String sql, Object[] data, int[] jdbcTypes) {
        return Result.updateZeroResult;
    }

    @Override
    public void materialize(Session session) {
        this.table.getRowStore(session).removeAll();
        try {
            Object[] paramValues = new Object[this.params.size()];
            for (int i = 0; i < this.params.size(); ++i) {
                Expression paramValue = session.sessionContext.getVtableParameter(this.getObjectName(), this.params.get(i));
                paramValues[i] = paramValue != null ? paramValue.getValue(session) : (this.defaultParams != null && this.defaultParams.get(i) != null ? this.defaultParams.get(i).getValue(session) : null);
            }
            Result result = this.routine.invoke(session, paramValues, null, true);
            if (result.isError()) {
                throw result.getException();
            }
            if (!result.isData()) {
                throw new DataspaceException("Unable to extract data out of function.");
            }
            RowSetNavigator resultNavigator = result.getNavigator();
            if (resultNavigator == null) {
                throw new DataspaceException("Function execution failure. Incompatible data type returned as a result of function execution.");
            }
            RowSetNavigatorData navigator = new RowSetNavigatorData(session, resultNavigator);
            result.setNavigator(navigator);
            PersistentStore store = this.table.getRowStore(session);
            RowSetNavigator nav = result.initialiseNavigator();
            int columnCount = this.table.getColumnCount();
            while (nav.hasNext()) {
                Object[] data = nav.getNext();
                if (this.includeParameters) {
                    Object[] newData = new Object[columnCount];
                    System.arraycopy(paramValues, 0, newData, 0, paramValues.length);
                    System.arraycopy(data, 0, newData, paramValues.length, data.length);
                    data = newData;
                }
                this.table.insertData(session, store, data);
            }
        }
        catch (Throwable error) {
            Trace.logException(this, error, true);
            throw new DataspaceException(error);
        }
    }

    @Override
    public boolean hasParameter(String name) {
        if (this.params != null) {
            for (String param : this.params) {
                if (!param.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = super.getReferences();
        set.add(this.routine.getObjectName());
        return set;
    }
}

