/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.fspace.table;

import com.streamscape.Trace;
import com.streamscape.ds.schema.collection.fspace.table.LogFileTableCollection;
import com.streamscape.lib.concurrent.worker.MonitorDaemonWorker;
import com.streamscape.sef.FabricException;
import com.streamscape.tools.tailer.impl.FileTailerExecutor;
import com.streamscape.tools.tailer.impl.FileTailerInputStream;
import com.streamscape.tools.tailer.impl.RotationResolver;
import java.nio.file.Path;

public class LogFileTablePoller
extends MonitorDaemonWorker {
    private final LogFileTableCollection logFileTableCollection;
    private Path sourceFile;
    private RotationResolver rotationResolver;
    private FileTailerExecutor executor;
    private volatile boolean suspended = false;

    protected LogFileTablePoller(LogFileTableCollection logFileTableCollection, long checkInterval) throws FabricException {
        super("DSYS:LogFileTablePoller." + logFileTableCollection.getObjectName().getSchemaQualifiedStatementName(), "Polls log file.", checkInterval);
        this.logFileTableCollection = logFileTableCollection;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(Path sourceFile) {
        if (this.isStarted()) {
            throw new IllegalArgumentException("Log file poller is started.");
        }
        this.sourceFile = sourceFile;
    }

    public void setRotationResolver(RotationResolver rotationResolver) {
        if (this.isStarted()) {
            throw new IllegalArgumentException("Log file poller is started.");
        }
        this.rotationResolver = rotationResolver;
    }

    @Override
    public synchronized void start() {
        if (this.sourceFile == null) {
            throw new IllegalArgumentException("Source file is not set.");
        }
        this.initExecutor();
        super.start();
    }

    @Override
    public void stop() {
        super.stop(1000L);
        this.destroyExecutor();
    }

    private void initExecutor() {
        long bytesOffset = this.logFileTableCollection.getLastInsertedRecordOffset();
        if (bytesOffset == -1L) {
            bytesOffset = this.logFileTableCollection.getStartRecordOffset();
        }
        int linesOffset = bytesOffset == -2L ? 0 : 1;
        FileTailerInputStream inputStream = new FileTailerInputStream(this.sourceFile, linesOffset, this.rotationResolver);
        if (bytesOffset > 0L) {
            inputStream.setBytesOffset(bytesOffset);
        }
        this.executor = new FileTailerExecutor(inputStream);
        this.executor.setMaxBlockSize(10240);
        this.executor.setMaxReadOnOneExecute(10240);
        this.executor.addListener(this.logFileTableCollection);
    }

    private void destroyExecutor() {
        if (this.executor != null) {
            this.executor.close();
            this.executor = null;
        }
    }

    @Override
    protected synchronized void doExecute() throws FabricException, InterruptedException {
        while (this.isStarted() && !this.suspended) {
            try {
                int totalRead = this.executor.execute();
                if (totalRead == 0) {
                    this.logFileTableCollection.onNewBlock(null, 0L);
                }
                if (totalRead != 0 && this.isStarted() && !this.suspended) continue;
                break;
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                throw exception;
            }
        }
    }

    public void suspend() {
        this.suspended = true;
    }

    public synchronized void resume() {
        this.destroyExecutor();
        this.initExecutor();
        this.suspended = false;
        this.notifyAll();
    }

    public boolean isSuspended() {
        return this.suspended;
    }
}

