/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.fspace.table;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementCommand;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.collection.fspace.table.LogFileTable;
import com.streamscape.ds.schema.collection.fspace.table.LogFileTablePoller;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.server.FileServerObject;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableWorks;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.EventType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.advisory.LogFileTableStateChangeAdvisory;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.LogEvent;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.trace.record.CommonLogMatcher;
import com.streamscape.sef.trace.record.FragmentParser;
import com.streamscape.sef.trace.record.LogRecordMatcher;
import com.streamscape.sef.trace.record.LogRecordMatcherPattern;
import com.streamscape.sef.trace.record.TimestampResolverUtils;
import com.streamscape.tools.tailer.FileTailerStateListener;
import com.streamscape.tools.tailer.FileTailerStringListener;
import com.streamscape.tools.tailer.impl.RotationFilenameProviderRegexp;
import com.streamscape.tools.tailer.impl.RotationFilesListByFilenameProvider;
import com.streamscape.tools.tailer.impl.SimpleRotationResolver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class LogFileTableCollection
extends TableCollection
implements AccessibleObject,
FileTailerStringListener,
FileTailerStateListener,
SourceEventFlowData {
    private FileServerObject fileServer;
    private LogRecordMatcher logRecordMatcher;
    private CommonLogMatcher commonLogMatcher;
    private LogFileTablePoller poller = null;
    private Session localSession;
    private boolean needToStart;
    private long maxDepth = 1000L;
    private String rotationFileRegexp;
    private String constrainedByEventId;
    private NameManager.ObjectName mapperFunctionName;
    private String mapperFunctionNameName;
    private String mapperFunctionNameSchema;
    private Statement mapperFunctionCallStm;
    private String sourceFileName;
    private boolean createIfNotExist;
    private boolean init;
    private long checkInterval = 60000L;
    private ProcessingStrategy processingStrategy = ProcessingStrategy.DEFAULT;
    private long startRecordOffset = -1L;
    private long startRecordTimestamp = -1L;
    private long lastReadRecordTimestamp = -1L;
    private long lastInsertedRecordOffset = -1L;
    private long lastInsertedRecordTimestamp = -1L;
    private boolean skipFirstRecord = false;
    private boolean suspendOnFail = false;
    private long lastProcessedRecordOffset = -1L;
    private long lastProcessedRecordTimestamp = -1L;
    private long startedAt = 0L;
    private long stoppedAt = 0L;
    private long suspendedAt = 0L;
    private long resumedAt = 0L;
    private long lastBlockAt = 0L;
    private long lastRecordAt = 0L;
    private long lastProcessedRecordAt = 0L;
    private long lastInsertedRecordAt = 0L;
    private long lastFailedRecordAt = 0L;
    private long lastSourceFileNotFoundAt;
    private long lastSourceFileFoundAt;
    private long lastSourceFileRotatedAt;
    private long lastSourceFileTruncatedAt;
    private long unmatchedLogRecords = 0L;
    private long processedRecords = 0L;
    private long failedRecords = 0L;
    private Exception lastException = null;
    private long lastExceptionAt = 0L;
    private List<String> rotatedFilenames = new ArrayList<String>();

    public LogFileTableCollection(DataspaceStore store, NameManager.ObjectName name) {
        super(store, name, CollectionType.LOG_FILE_TABLE, MemoryModel.MEMORY);
    }

    @Override
    protected void doCreateTable(DataspaceStore database, NameManager.ObjectName tableName, int tableType) {
        this.table = new LogFileTable(database, tableName, tableType, this);
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        try {
            this.dataspace.bindProducerForSystem("advisory.log.file.table.StateChange", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
        this.addIdentityColumn(this.table, "id", Type.LONG);
        this.addColumn(this.table, "ts", Type.SQL_TIMESTAMP, false);
        this.addColumn(this.table, "data", Type.STRING, false);
        NameManager.ObjectName internalTableIndexName = NameManager.newInfoSchemaObjectName(this.name.name, this.name.isNameQuoted, 21);
        this.table.createPrimaryKeyConstraint(internalTableIndexName, new int[]{this.table.getColumnIndex("id")}, true);
        if (!session.isProcessingLog()) {
            TableWorks tableWorks = new TableWorks(session, this.table);
            NameManager.ObjectName seqIdUniqueIndexName = this.store.nameManager.newAutoName(this.table.getObjectName().name + "_ts", this.table.getObjectName().schema, this.table.getObjectName(), 21);
            tableWorks.addIndex(new int[]{this.table.getColumnIndex("ts")}, seqIdUniqueIndexName, false, null);
        }
        this.table.setColumnStructures();
        this.table.setDataReadOnly(true);
        super.compile(session, parentObject);
    }

    @Override
    public void open(Session session) {
        this.resolveMapperFunction(session);
        super.open(session);
        this.startRecordOffset = this.lastProcessedRecordOffset;
        this.startRecordTimestamp = this.lastProcessedRecordTimestamp;
        if (this.needToStart) {
            this.needToStart = false;
            try {
                this.start(session);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                this.stop(session);
            }
        }
    }

    private void resolveMapperFunction(Session session) {
        if (this.mapperFunctionName != null) {
            return;
        }
        if (this.mapperFunctionNameName == null) {
            return;
        }
        SchemaObject mapperFunction = null;
        try {
            mapperFunction = session.dataspaceStore.schemaManager.getSchemaObject(this.mapperFunctionNameName, this.mapperFunctionNameSchema, 17);
        }
        catch (Exception exception) {
            try {
                mapperFunction = session.dataspaceStore.schemaManager.getSchemaObject(this.mapperFunctionNameName, this.mapperFunctionNameSchema, 18);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (mapperFunction != null) {
            this.mapperFunctionName = mapperFunction.getObjectName();
            this.mapperFunctionNameName = null;
            this.mapperFunctionNameSchema = null;
            session.dataspaceStore.schemaManager.addReferenceFromTo(this.getObjectName(), this.mapperFunctionName);
        }
    }

    public void setLogFileTableProperties(long lastProcessedLineOffset, long lastProcessedTimestamp, boolean skipFirstLine) {
        this.lastProcessedRecordOffset = lastProcessedLineOffset;
        this.lastProcessedRecordTimestamp = lastProcessedTimestamp;
        this.skipFirstRecord = skipFirstLine;
    }

    public void setFileServer(FileServerObject fileServer) {
        this.checkNotStarted();
        this.fileServer = fileServer;
    }

    public void setDataSource(Session session, String sourceFileName) {
        this.checkNotStarted();
        this.sourceFileName = sourceFileName;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setDataSource(Session session, String sourceFileName, boolean createIfNotExist, boolean init) {
        this.checkNotStarted();
        this.sourceFileName = sourceFileName;
        this.createIfNotExist = createIfNotExist;
        this.init = init;
    }

    public void setNeedToStart(boolean needToStart) {
        this.needToStart = needToStart;
    }

    public void setMaxDepth(long maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setRotationFileRegexp(String rotationFileRegexp) {
        this.rotationFileRegexp = rotationFileRegexp;
    }

    public void setCheckInterval(Session session, long checkInterval) {
        try {
            if (this.poller != null) {
                this.poller.setTimeout(checkInterval);
            }
            this.checkInterval = checkInterval;
        }
        catch (FabricException exception) {
            throw new DataspaceException(exception);
        }
    }

    public void setProcessingStrategy(Session session, ProcessingStrategy processingStrategy, long startRecordOffset, long startRecordTimestamp) {
        this.checkNotStarted();
        this.processingStrategy = processingStrategy;
        this.startRecordOffset = startRecordOffset;
        this.startRecordTimestamp = startRecordTimestamp;
    }

    public void setSuspendOnFail(Session session, Boolean suspendOnFail) {
        this.checkNotStarted();
        this.suspendOnFail = suspendOnFail;
    }

    public void setCreateIfNotExist(boolean createIfNotExist) {
        this.checkNotStarted();
        this.createIfNotExist = createIfNotExist;
    }

    public void setInit(boolean init) {
        this.checkNotStarted();
        this.init = init;
    }

    public void setLogRecordMatcher(LogRecordMatcher logRecordMatcher) {
        this.checkNotStarted();
        this.logRecordMatcher = logRecordMatcher;
    }

    public void setConstrainedByEventId(String constrainedByEventId) {
        this.constrainedByEventId = constrainedByEventId;
    }

    public String getConstrainedByEventId() {
        return this.constrainedByEventId;
    }

    public void setMapperFunctionName(NameManager.ObjectName mapperFunctionName) {
        this.mapperFunctionName = mapperFunctionName;
    }

    public NameManager.ObjectName getMapperFunctionName() {
        return this.mapperFunctionName;
    }

    public void setMapperFunctionNameNameSchema(String mapperFunctionNameName, String mapperFunctionNameSchema) {
        this.mapperFunctionNameName = mapperFunctionNameName;
        this.mapperFunctionNameSchema = mapperFunctionNameSchema;
    }

    public synchronized boolean isSuspended() {
        return this.isStarted() && this.poller.isSuspended();
    }

    public synchronized void resume(Session session) {
        if (this.isStarted() && this.poller.isSuspended()) {
            this.raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState.RESUMED, null, null);
            this.resumedAt = System.currentTimeMillis();
            if (this.lastInsertedRecordOffset >= 0L) {
                this.skipFirstRecord = true;
            }
            this.poller.resume();
        }
    }

    public long getStartRecordOffset() {
        return this.startRecordOffset;
    }

    public long getLastInsertedRecordOffset() {
        return this.lastInsertedRecordOffset;
    }

    public static void checkConstrainedByEventId(String constrainedByEventId) {
        if (constrainedByEventId == null) {
            return;
        }
        if (!EventDatagramFactory.getInstance().existsPrototype(constrainedByEventId)) {
            throw new DataspaceException("Event prototype [" + constrainedByEventId + "] doesn't exist.");
        }
        EventDatagram event = null;
        try {
            event = EventDatagramFactory.getInstance().createEvent(constrainedByEventId);
        }
        catch (Exception exception) {
            throw new DataspaceException("Failed to create event [" + constrainedByEventId + "] prototype.");
        }
        if (!(event instanceof LogEvent)) {
            throw new DataspaceException("Specified event [" + constrainedByEventId + "] is not LogEvent.");
        }
    }

    private void compileMapperFunctionCallStatement(Session session) {
        if (this.mapperFunctionName == null) {
            return;
        }
        LogFileTableCollection.checkMapperFunction(session, this.mapperFunctionName);
        this.mapperFunctionCallStm = session.compileStatement("call " + this.mapperFunctionName.getSchemaQualifiedStatementName() + "(?)");
    }

    public static void checkMapperFunction(Session session, NameManager.ObjectName name) {
        SchemaObject mapperFunction;
        try {
            mapperFunction = session.dataspaceStore.schemaManager.getSchemaObject(name);
        }
        catch (Exception exception) {
            throw new DataspaceException("Mapper function " + name.getSchemaQualifiedStatementName() + " doesn't exist.");
        }
        RplScript rplScript = null;
        if (mapperFunction instanceof RplScript) {
            rplScript = (RplScript)mapperFunction;
        } else if (mapperFunction instanceof RoutineSchema) {
            rplScript = ((RoutineSchema)mapperFunction).routines[0];
        } else {
            throw new DataspaceException("Invalid mapper function specified.");
        }
        if (rplScript.getParameterCount() != 1) {
            throw new DataspaceException("Invalid mapper function specified. Parameter count should be 1.");
        }
        Type parameterType = rplScript.getParameter((int)0).dataType;
        Type returnType = rplScript.getReturnType();
        if (!(parameterType instanceof EventType)) {
            throw new DataspaceException("Invalid mapper function specified. Parameter should be event.");
        }
        if (((EventType)parameterType).getInternalClass(session) != LogEvent.class) {
            throw new DataspaceException("Invalid mapper function specified. Parameter should be LogEvent.");
        }
        if (!(returnType instanceof EventType)) {
            throw new DataspaceException("Invalid mapper function specified. Return type should be event.");
        }
        if (((EventType)returnType).getInternalClass(session) != LogEvent.class) {
            throw new DataspaceException("Invalid mapper function specified. Return type should be LogEvent.");
        }
    }

    public synchronized void start(Session session) {
        if (this.isStarted()) {
            return;
        }
        this.compileMapperFunctionCallStatement(session);
        LogFileTableCollection.checkConstrainedByEventId(this.constrainedByEventId);
        if (this.constrainedByEventId != null) {
            try {
                this.dataspace.bindProducerFor(this.constrainedByEventId);
            }
            catch (FabricEventDispatcherException exception) {
                throw new DataspaceException("Failed to bind producer for [" + this.constrainedByEventId + "].", exception);
            }
        }
        try {
            this.poller = new LogFileTablePoller(this, this.checkInterval);
            this.poller.setSourceFile(this.resolveSourceFilePath(session));
        }
        catch (Exception exception) {
            this.poller = null;
            throw new DataspaceException(exception);
        }
        try {
            if (this.localSession != null) {
                this.localSession.close();
            }
            this.localSession = this.store.getSessionManager().newSession(this.store, session.getUser(), false, true);
            this.localSession.dataspaceStore = this.store;
            this.localSession.setCurrentDataspaceName(this.getObjectName().schema);
            this.initRecordOffset(session);
            this.commonLogMatcher = new CommonLogMatcher(this.logRecordMatcher);
            this.poller.setRotationResolver(this.createRotationResolver(session, this.poller.getSourceFile()));
            this.truncate();
            this.resetStats();
            this.poller.start();
            this.raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState.STARTED, null, null);
        }
        catch (Exception exception) {
            this.poller.stop();
            this.poller = null;
            this.stoppedAt = System.currentTimeMillis();
            this.setLastException(exception);
            throw new DataspaceException(exception);
        }
    }

    private void resetStats() {
        this.unmatchedLogRecords = 0L;
        this.processedRecords = 0L;
        this.failedRecords = 0L;
        this.startedAt = System.currentTimeMillis();
        this.stoppedAt = 0L;
        this.suspendedAt = 0L;
        this.resumedAt = 0L;
        this.lastFailedRecordAt = 0L;
        this.lastProcessedRecordAt = 0L;
        this.lastExceptionAt = 0L;
        this.lastRecordAt = 0L;
        this.lastBlockAt = 0L;
        this.rotatedFilenames = new ArrayList<String>();
        this.lastSourceFileFoundAt = 0L;
        this.lastSourceFileNotFoundAt = 0L;
    }

    private SimpleRotationResolver createRotationResolver(Session session, Path sourceFilePath) throws IOException {
        if (this.rotationFileRegexp != null) {
            RotationFilenameProviderRegexp rotationFilenameProviderRegexp = new RotationFilenameProviderRegexp(sourceFilePath.getFileName().toString(), this.rotationFileRegexp);
            RotationFilesListByFilenameProvider rotationFileList = new RotationFilesListByFilenameProvider(rotationFilenameProviderRegexp);
            SimpleRotationResolver simpleRotationResolver = new SimpleRotationResolver(rotationFileList, sourceFilePath);
            Path rotatedFile = this.findCorrespondingFile(sourceFilePath, rotationFileList);
            simpleRotationResolver.setFirstNotProcessedRotatedFile(rotatedFile);
            return simpleRotationResolver;
        }
        return null;
    }

    private Path findCorrespondingFile(Path sourceFilePath, RotationFilesListByFilenameProvider rotationFileList) throws IOException {
        if (this.startRecordTimestamp <= 0L || this.startRecordOffset < 0L) {
            return null;
        }
        if (this.fileMatches(sourceFilePath, this.startRecordOffset, this.startRecordTimestamp)) {
            return null;
        }
        List<Path> rotationFiles = rotationFileList.list(sourceFilePath);
        for (int i = rotationFiles.size() - 1; i >= 0; --i) {
            Path rotationFile = rotationFiles.get(i);
            if (!this.fileMatches(rotationFile, this.startRecordOffset, this.startRecordTimestamp)) continue;
            return rotationFile;
        }
        this.log(Trace.Level.ERROR, "File that matches position" + this.startRecordOffset + " and timestamp " + this.formatGMTTimestamp(this.startRecordTimestamp) + " not found.");
        return null;
    }

    private Path resolveSourceFilePath(Session session) {
        String sourceFileResolved = SessionData.checkDataspaceFileAccess(session, this.sourceFileName);
        Path sourceFilePath = Paths.get(sourceFileResolved, new String[0]);
        if (sourceFilePath.getParent() == null) {
            sourceFilePath = Paths.get(".", sourceFileResolved);
        }
        if (!Files.exists(sourceFilePath, new LinkOption[0]) && this.createIfNotExist) {
            try {
                Files.createFile(sourceFilePath, new FileAttribute[0]);
            }
            catch (IOException exception) {
                throw new DataspaceException("Cannot create source file '" + sourceFileResolved + "'. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
            }
        }
        if (Files.exists(sourceFilePath, new LinkOption[0]) && this.init) {
            try {
                FileOutputStream stream = new FileOutputStream(sourceFilePath.toFile(), false);
                stream.close();
            }
            catch (IOException exception) {
                throw new DataspaceException("Cannot init source file '" + sourceFileResolved + "'. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
            }
        }
        return sourceFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Session session) {
        if (this.poller != null) {
            this.stoppedAt = System.currentTimeMillis();
            this.poller.stop();
            this.poller = null;
        }
        LogFileTableCollection logFileTableCollection = this;
        synchronized (logFileTableCollection) {
            if (this.constrainedByEventId != null) {
                try {
                    this.dataspace.unbindProducerFor(this.constrainedByEventId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.truncate();
            this.commonLogMatcher = null;
            if (this.localSession != null) {
                this.localSession.close();
                this.localSession = null;
            }
            this.unmatchedLogRecords = 0L;
            this.processedRecords = 0L;
            this.failedRecords = 0L;
            this.raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState.STOPPED, null, null);
        }
    }

    private void truncate() {
        if (this.localSession != null) {
            this.table.getRowStore(this.localSession).removeAll();
        }
    }

    private void setLastException(Exception exception) {
        this.lastException = exception;
        this.lastExceptionAt = System.currentTimeMillis();
    }

    public boolean isStarted() {
        return this.poller != null;
    }

    private void checkNotStarted() {
        if (this.isStarted()) {
            throw new DataspaceException("Log file table is started.");
        }
    }

    public void initRecordOffset(Session session) {
        this.lastInsertedRecordOffset = -1L;
        this.lastInsertedRecordTimestamp = -1L;
        this.lastReadRecordTimestamp = -1L;
        switch (this.processingStrategy.ordinal()) {
            case 0: {
                this.startRecordOffset = this.lastProcessedRecordOffset;
                this.startRecordTimestamp = this.lastProcessedRecordTimestamp;
                if (this.startRecordOffset == -1L) {
                    this.logInfo("Starting LFT from the begin.");
                } else {
                    this.logInfo("Starting LFT in default mode from RecordOffset " + this.startRecordOffset + ", and RecordTimestamp '" + this.formatGMTTimestamp(this.startRecordTimestamp >= 0L ? this.startRecordTimestamp : 0L) + "'.");
                }
                if (this.startRecordOffset >= 0L || this.startRecordTimestamp >= 0L) {
                    this.skipFirstRecord = true;
                    break;
                }
                this.skipFirstRecord = false;
                break;
            }
            case 1: {
                this.startRecordOffset = -2L;
                this.startRecordTimestamp = -2L;
                this.lastProcessedRecordOffset = -2L;
                this.lastProcessedRecordTimestamp = -2L;
                this.skipFirstRecord = false;
                this.logInfo("Starting LFT from the end of source file.");
                break;
            }
            case 2: {
                this.startRecordOffset = -1L;
                this.startRecordTimestamp = -1L;
                this.lastProcessedRecordTimestamp = -1L;
                this.lastProcessedRecordTimestamp = -1L;
                this.skipFirstRecord = false;
                this.logInfo("Starting JFT from the begin.");
                break;
            }
            case 3: {
                this.skipFirstRecord = false;
                this.lastProcessedRecordOffset = this.startRecordOffset;
                this.lastProcessedRecordTimestamp = this.startRecordTimestamp;
                this.logInfo("Starting LFT from RecordOffset " + this.startRecordOffset + ", and RecordTimestamp '" + this.formatGMTTimestamp(this.startRecordTimestamp >= 0L ? this.startRecordTimestamp : 0L) + "'.");
            }
        }
        this.saveLogFileTablePropertiesToRecoveryLog();
    }

    private String formatGMTTimestamp(long timestamp) {
        return timestamp <= 0L ? "n/a" : DataspaceDateTime.getSqlTimestampString(timestamp, TimeZone.getTimeZone(ZoneId.of("GMT")));
    }

    private String formatTimestamp(Session session, long timestamp) {
        return timestamp <= 0L ? "n/a" : DataspaceDateTime.formatTimestamp(session, timestamp);
    }

    @Override
    public Result getCollectionProperties(Session session) {
        Result result = super.getCollectionProperties(session);
        result.navigator.add(new Object[]{"State", this.isSuspended() ? "SUSPENDED" : (this.isStarted() ? "STARTED" : "STOPPED")});
        result.navigator.add(new Object[]{"Source File", this.sourceFileName != null ? this.sourceFileName : "n/a"});
        result.navigator.add(new Object[]{"Rotation File Regexp", this.rotationFileRegexp != null ? this.rotationFileRegexp : "n/a"});
        result.navigator.add(new Object[]{"Init", this.init});
        result.navigator.add(new Object[]{"No Create", !this.createIfNotExist});
        result.navigator.add(new Object[]{"Read Interval", this.checkInterval + " ms"});
        result.navigator.add(new Object[]{"Max Depth", this.maxDepth > 0L ? Long.valueOf(this.maxDepth) : "unlimited"});
        result.navigator.add(new Object[]{"Constrained By EventId", this.constrainedByEventId != null ? this.constrainedByEventId : "n/a"});
        result.navigator.add(new Object[]{"Mapper Function", this.mapperFunctionName != null ? this.mapperFunctionName.getSchemaQualifiedStatementName() : (this.mapperFunctionNameName != null ? this.mapperFunctionNameSchema + "." + this.mapperFunctionNameName : "n/a")});
        result.navigator.add(new Object[]{"Processing Strategy", this.processingStrategy == ProcessingStrategy.DEFAULT ? "First Unprocessed Record" : (this.processingStrategy == ProcessingStrategy.NO_RECOVERY ? "End Of File" : "Begin Of File")});
        String startLineOffsetDescription = "n/a";
        String startTimestampDescription = "n/a";
        if (this.processingStrategy == ProcessingStrategy.DEFAULT || this.processingStrategy == ProcessingStrategy.FROM) {
            startLineOffsetDescription = this.startRecordOffset != -1L ? String.valueOf(this.startRecordOffset) : "Begin Of The File";
            startTimestampDescription = this.startRecordTimestamp != -1L ? this.formatGMTTimestamp(this.startRecordTimestamp) : "Begin Of The File";
        } else if (this.processingStrategy == ProcessingStrategy.NO_RECOVERY) {
            startLineOffsetDescription = "End Of The File";
            startTimestampDescription = "End Of The File";
        } else if (this.processingStrategy == ProcessingStrategy.RECOVERY) {
            startLineOffsetDescription = "Begin Of The File";
            startTimestampDescription = "Begin Of The File";
        }
        result.navigator.add(new Object[]{"Start Record Offset", startLineOffsetDescription});
        result.navigator.add(new Object[]{"Start Record Timestamp", startTimestampDescription});
        result.navigator.add(new Object[]{"Skip First Record", this.skipFirstRecord});
        result.navigator.add(new Object[]{"Last Inserted Record Offset", this.lastInsertedRecordOffset != -1L ? Long.valueOf(this.lastInsertedRecordOffset) : "n/a"});
        result.navigator.add(new Object[]{"Last Inserted Record Timestamp", this.lastInsertedRecordTimestamp != -1L ? this.formatGMTTimestamp(this.lastInsertedRecordTimestamp) : "n/a"});
        result.navigator.add(new Object[]{"Last Processed Record Offset", this.lastProcessedRecordOffset != -1L ? Long.valueOf(this.lastProcessedRecordOffset) : "n/a"});
        result.navigator.add(new Object[]{"Last Processed Record Timestamp", this.lastProcessedRecordTimestamp != -1L ? this.formatGMTTimestamp(this.lastProcessedRecordTimestamp) : "n/a"});
        result.navigator.add(new Object[]{"Suspend On Fail", this.suspendOnFail});
        FragmentParser timestampParser = this.logRecordMatcher.getFragmentParser("timestamp");
        if (this.logRecordMatcher instanceof LogRecordMatcherPattern) {
            result.navigator.add(new Object[]{"Filter Record Start", ((LogRecordMatcherPattern)this.logRecordMatcher).getPatternString()});
            result.navigator.add(new Object[]{"Timestamp Filter", timestampParser != null ? ((TimestampResolverUtils.TimestampFragmentParser)timestampParser).getPattern() : "n/a"});
        }
        if (timestampParser != null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "Timestamp Format";
            objectArray[1] = timestampParser != null ? (timestampParser instanceof TimestampResolverUtils.TimestampFragmentParser ? ((TimestampResolverUtils.TimestampFragmentParser)timestampParser).getJavaFormat() : ((TimestampResolverUtils.TimestampFragmentParserRegexp)timestampParser).getJavaFormat()) : "n/a";
            result.navigator.add(objectArray);
        }
        result.navigator.add(new Object[]{"Regexp Record Start", this.logRecordMatcher.getRecordRegexp()});
        result.navigator.add(new Object[]{"Timestamp Regexp Group Index", timestampParser != null ? Integer.valueOf(timestampParser.getRegexpGroupIndex()) : "n/a"});
        result.navigator.add(new Object[]{"---------------", "-------------"});
        result.navigator.add(new Object[]{"Started At", this.formatTimestamp(session, this.startedAt)});
        result.navigator.add(new Object[]{"Stopped At", this.formatTimestamp(session, this.stoppedAt)});
        result.navigator.add(new Object[]{"Suspended At", this.formatTimestamp(session, this.suspendedAt)});
        result.navigator.add(new Object[]{"Resumed At", this.formatTimestamp(session, this.resumedAt)});
        result.navigator.add(new Object[]{"Last Block At", this.formatTimestamp(session, this.lastBlockAt)});
        result.navigator.add(new Object[]{"Last Record At", this.formatTimestamp(session, this.lastRecordAt)});
        result.navigator.add(new Object[]{"Last Inserted Record At", this.formatTimestamp(session, this.lastInsertedRecordAt)});
        result.navigator.add(new Object[]{"Last Processed Record At", this.formatTimestamp(session, this.lastProcessedRecordAt)});
        result.navigator.add(new Object[]{"Last Failed Record At", this.formatTimestamp(session, this.lastFailedRecordAt)});
        result.navigator.add(new Object[]{"Last Source File Truncated At", this.formatTimestamp(session, this.lastSourceFileTruncatedAt)});
        result.navigator.add(new Object[]{"Last Source File Rotated At", this.formatTimestamp(session, this.lastSourceFileRotatedAt)});
        result.navigator.add(new Object[]{"Last Source File Not Found At", this.formatTimestamp(session, this.lastSourceFileNotFoundAt)});
        result.navigator.add(new Object[]{"Last Source File Found At", this.formatTimestamp(session, this.lastSourceFileFoundAt)});
        result.navigator.add(new Object[]{"Last 10 Rotated Filenames", this.rotatedFilenames});
        File sourceFile = new File(this.sourceFileName);
        result.navigator.add(new Object[]{"Source File Size", sourceFile.exists() ? Long.valueOf(sourceFile.length()) : "n/a"});
        result.navigator.add(new Object[]{"Unmatched Records", this.unmatchedLogRecords});
        result.navigator.add(new Object[]{"Processed Records", this.processedRecords});
        result.navigator.add(new Object[]{"Failed Records", this.failedRecords});
        result.navigator.add(new Object[]{"Last Exception At", this.formatTimestamp(session, this.lastExceptionAt)});
        String error = "";
        if (this.lastException != null) {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            PrintStream writer = new PrintStream(byteOutputStream);
            this.lastException.printStackTrace(writer);
            error = new String(byteOutputStream.toByteArray());
        }
        result.navigator.add(new Object[]{"Last Exception", error});
        return result;
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE").append(' ').append("LOG").append(' ').append("FILE").append(' ').append("TABLE").append(' ');
        builder.append(this.getObjectName().getSchemaQualifiedStatementName()).append(' ');
        if (this.sourceFileName != null) {
            builder.append("SOURCE").append(' ').append("FILE").append(' ').append(" '").append(this.sourceFileName).append("'");
        }
        if (!this.createIfNotExist) {
            builder.append(" NO CREATE");
        }
        if (this.checkInterval != -1L) {
            builder.append(" READ INTERVAL " + this.checkInterval);
        }
        if (this.rotationFileRegexp != null) {
            builder.append(" ROTATION FILE REGEXP '").append(this.rotationFileRegexp.replaceAll("'", "''")).append("'");
        }
        builder.append(" MAX DEPTH " + this.maxDepth);
        if (this.constrainedByEventId != null) {
            builder.append(" CONSTRAINED BY [").append(this.constrainedByEventId).append("]");
        }
        if (this.mapperFunctionName != null) {
            builder.append(" MAPPER FUNCTION ").append(this.mapperFunctionName.getSchemaQualifiedStatementName());
        } else if (this.mapperFunctionNameName != null) {
            builder.append(" MAPPER FUNCTION ").append(NameManager.quoteNameIfNeeded(this.mapperFunctionNameSchema)).append(".").append(NameManager.quoteNameIfNeeded(this.mapperFunctionNameName));
        }
        builder.append(" ").append(LogFileTableCollection.logRecordMatcherToString(this.logRecordMatcher));
        return builder.toString();
    }

    public static String logRecordMatcherToString(LogRecordMatcher matcher) {
        Object syntax = "";
        FragmentParser timestampParser = matcher.getFragmentParser("timestamp");
        if (matcher instanceof LogRecordMatcherPattern) {
            LogRecordMatcherPattern matcherPattern = (LogRecordMatcherPattern)matcher;
            syntax = "using filter record start (" + matcherPattern.getPatternString() + ")";
            if (timestampParser != null) {
                syntax = (String)syntax + " timestamp (" + ((TimestampResolverUtils.TimestampFragmentParser)timestampParser).getPattern() + ")";
            }
        } else {
            syntax = "using regexp record start (" + matcher.getRecordRegexp() + ")";
            if (timestampParser != null) {
                syntax = (String)syntax + " timestamp regexp group index " + timestampParser.getRegexpGroupIndex();
            }
        }
        if (timestampParser != null) {
            syntax = (String)syntax + " timestamp format (" + (timestampParser instanceof TimestampResolverUtils.TimestampFragmentParser ? ((TimestampResolverUtils.TimestampFragmentParser)timestampParser).getJavaFormat() : ((TimestampResolverUtils.TimestampFragmentParserRegexp)timestampParser).getJavaFormat()) + ")";
        }
        return syntax;
    }

    @Override
    public void onFileNotFound(String filename) {
        if (this.lastSourceFileNotFoundAt < this.lastSourceFileFoundAt || this.lastSourceFileNotFoundAt <= 0L) {
            this.raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState.SOURCE_FILE_NOT_EXIST, null, filename);
        }
        this.lastSourceFileNotFoundAt = System.currentTimeMillis();
    }

    @Override
    public void onFileFound(String filename) {
        if (this.lastSourceFileFoundAt < this.lastSourceFileNotFoundAt) {
            this.raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState.SOURCE_FILE_EXIST, null, filename);
        }
        this.lastSourceFileFoundAt = System.currentTimeMillis();
    }

    @Override
    public void onFileRotated(String oldFilename, String newFilename) {
        this.lastSourceFileRotatedAt = System.currentTimeMillis();
        this.rotatedFilenames.add(newFilename);
        while (this.rotatedFilenames.size() > 10) {
            this.rotatedFilenames.remove(0);
        }
        this.raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState.SOURCE_FILE_ROTATED, null, newFilename);
    }

    @Override
    public void onFileTruncated(String filename) {
        this.lastSourceFileTruncatedAt = System.currentTimeMillis();
        this.raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState.SOURCE_FILE_TRUNCATED, null, filename);
    }

    @Override
    public void onException(Exception exception) {
        this.setLastException(exception);
        if (this.poller != null) {
            this.raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState.SUSPENDED, exception, null);
            this.poller.suspend();
            this.commonLogMatcher = new CommonLogMatcher(this.logRecordMatcher);
            this.suspendedAt = System.currentTimeMillis();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fileMatches(Path sourceFilePath, long offset, long timestamp) {
        if (offset < -1L) {
            return false;
        }
        if (offset == -1L) {
            offset = 0L;
        }
        try (RandomAccessFile accessFile = new RandomAccessFile(sourceFilePath.toFile(), "r");){
            if (offset >= accessFile.length()) {
                boolean bl = false;
                return bl;
            }
            accessFile.seek(offset);
            byte[] bytes = new byte[4096];
            int count = accessFile.read(bytes, 0, bytes.length);
            if (count <= 0) {
                boolean bl = false;
                return bl;
            }
            List records = this.commonLogMatcher.match(new String(bytes, 0, count), offset);
            this.commonLogMatcher.match(null, records);
            if (records.size() == 0) {
                boolean bl = false;
                return bl;
            }
            Map record = (Map)records.get(0);
            Timestamp recordTimestamp = (Timestamp)record.get("timestamp");
            if (recordTimestamp == null) {
                boolean bl = false;
                return bl;
            }
            long recordTimestampMillis = DataspaceDateTime.convertMillisFromCalendar(Calendar.getInstance(), recordTimestamp.getTime());
            if (recordTimestampMillis != timestamp) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public synchronized void onNewBlock(String block, long offset) {
        if (!this.isStarted()) {
            return;
        }
        if (block == null && this.isSuspended()) {
            return;
        }
        try {
            this.doOnNewBlock(block, offset);
        }
        catch (Exception exception) {
            if (block != null) {
                throw exception;
            }
            this.onException(exception);
        }
    }

    private void doOnNewBlock(String block, long offset) {
        List<Object> records;
        if (block != null) {
            records = this.commonLogMatcher.match(block, offset);
            this.lastBlockAt = System.currentTimeMillis();
        } else {
            records = this.commonLogMatcher.match(null, new ArrayList());
            if (records.size() == 0) {
                return;
            }
        }
        for (Map record : records) {
            long recordOffset = ((Number)record.get("offset")).longValue();
            Timestamp recordTimestamp = (Timestamp)record.get("timestamp");
            String recordLine = (String)record.get("line");
            if (recordTimestamp == null) {
                if (recordLine == null || recordLine.length() == 0) continue;
                this.logError("Unmatched log record: " + recordLine);
                ++this.unmatchedLogRecords;
                continue;
            }
            long recordTimestampMillis = DataspaceDateTime.convertMillisFromCalendar(Calendar.getInstance(), recordTimestamp.getTime());
            if (recordTimestampMillis < this.lastReadRecordTimestamp) {
                String error = "Invalid source file records sequence. Previous record timestamp is '" + this.formatTimestamp(this.localSession, this.lastReadRecordTimestamp) + "', current record timestamp '" + this.formatTimestamp(this.localSession, recordTimestampMillis);
                if (this.suspendOnFail) {
                    throw new DataspaceException(error);
                }
                ++this.failedRecords;
                this.logError(error);
                this.logError(recordLine);
                this.raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState.EXCEPTION, new DataspaceException(error), null);
                continue;
            }
            this.lastReadRecordTimestamp = recordTimestampMillis;
            if (recordOffset == this.startRecordOffset && recordTimestampMillis == this.startRecordTimestamp && this.skipFirstRecord || recordTimestampMillis < this.startRecordTimestamp || recordOffset == this.lastProcessedRecordOffset && recordTimestampMillis == this.lastProcessedRecordTimestamp || recordTimestampMillis < this.lastProcessedRecordTimestamp) continue;
            this.lastRecordAt = System.currentTimeMillis();
            boolean notFailed = true;
            if ((this.lastInsertedRecordOffset != recordOffset || this.lastInsertedRecordTimestamp != recordTimestampMillis) && (notFailed = this.insertRowAndFireTriggers(recordTimestamp, recordLine))) {
                this.lastInsertedRecordOffset = recordOffset;
                this.lastInsertedRecordTimestamp = recordTimestampMillis;
                this.lastInsertedRecordAt = System.currentTimeMillis();
            }
            if (notFailed && (notFailed = this.raiseLogEvent(this.localSession, recordTimestamp, recordLine))) {
                this.lastProcessedRecordOffset = recordOffset;
                this.lastProcessedRecordTimestamp = recordTimestampMillis;
                this.lastProcessedRecordAt = System.currentTimeMillis();
                ++this.processedRecords;
                this.skipFirstRecord = true;
            }
            if (!notFailed) {
                ++this.failedRecords;
                this.lastFailedRecordAt = System.currentTimeMillis();
            }
            this.saveLogFileTablePropertiesToRecoveryLog();
        }
        this.cleanUpElementsWindow();
    }

    private boolean raiseLogEvent(Session session, Timestamp recordTimestamp, String recordLine) {
        if (this.constrainedByEventId == null) {
            return true;
        }
        try {
            LogEvent event = (LogEvent)EventDatagramFactory.getInstance().createEvent(this.constrainedByEventId);
            event.setLogTimestamp(recordTimestamp);
            event.setLogMessage(recordLine);
            if (this.mapperFunctionCallStm != null) {
                Result result = session.executeCompiledStatement(this.mapperFunctionCallStm, new Object[]{event});
                if (result.isError()) {
                    throw result.getException() != null ? result.getException() : new DataspaceException(result.getMainString());
                }
                RowSetNavigator navigator = result.getNavigator();
                if (navigator.next()) {
                    event = (LogEvent)OtherTypeWrapper.unwrap(navigator.getCurrent()[0]);
                }
            }
            this.dataspace.raiseEvent(event, 0L);
        }
        catch (Exception exception) {
            if (this.suspendOnFail) {
                throw new DataspaceException(exception);
            }
            this.logError("Failed to raise LogEvent for record: " + recordLine);
            this.raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState.EXCEPTION, new DataspaceException("Failed to raise LogEvent for record: " + recordLine, exception), null);
            return false;
        }
        return true;
    }

    private boolean insertRowAndFireTriggers(Timestamp recordTimestamp, String recordLine) {
        try {
            this.localSession.startTransaction();
            try {
                Object[] data = new Object[]{null, DateTimeType.SQL_TIMESTAMP.convertJavaToSQL(this.localSession, recordTimestamp), recordLine};
                if (this.table.triggerLists[Trigger.Type.INSERT_BEFORE_ROW.ordinal()].length > 0) {
                    this.table.fireTriggers(this.localSession, Trigger.Type.INSERT_BEFORE_ROW, null, data, null);
                }
                this.table.insertSingleRow(this.localSession, this.table.getRowStore(this.localSession), data, null);
                if (this.table.triggerLists[Trigger.Type.INSERT_AFTER_ROW.ordinal()].length > 0) {
                    this.table.fireTriggers(this.localSession, Trigger.Type.INSERT_AFTER_ROW, null, Arrays.copyOf(data, data.length), null);
                }
                if (this.table.triggerLists[Trigger.Type.CHANGE_AFTER_ROW.ordinal()].length > 0) {
                    this.table.fireTriggers(this.localSession, Trigger.Type.CHANGE_AFTER_ROW, null, Arrays.copyOf(data, data.length), null);
                }
                if (this.table.triggerLists[Trigger.Type.INSERT_AFTER.ordinal()].length > 0) {
                    this.table.fireTriggers(this.localSession, Trigger.Type.INSERT_AFTER, (RowSetNavigator)null);
                }
                this.localSession.commit(true);
            }
            catch (Exception exception) {
                this.localSession.rollback(true);
                throw exception;
            }
        }
        catch (Exception exception) {
            if (this.suspendOnFail) {
                throw new DataspaceException(exception);
            }
            this.logError("Failed to insert record: " + recordLine);
            this.raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState.EXCEPTION, new DataspaceException("Failed to insert record: " + recordLine, exception), null);
            return false;
        }
        return true;
    }

    private void cleanUpElementsWindow() {
        if (this.maxDepth <= 0L || this.localSession == null) {
            return;
        }
        try {
            long elementsCount = this.table.getRowStore(this.localSession).elementCount();
            long maxDepthMax = (long)((double)this.maxDepth * 1.1);
            if (elementsCount > maxDepthMax) {
                RowIterator iterator = this.table.getRowStore(this.localSession).rowIterator();
                for (long elementsToRemove = elementsCount - maxDepthMax; iterator.hasNext() && elementsToRemove > 0L; --elementsToRemove) {
                    Row row = iterator.getNextRow();
                    this.localSession.addDeleteAction((Table)row.getTable(), row, null);
                }
                this.localSession.commit(true);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            this.localSession.rollback(true);
        }
    }

    private void saveLogFileTablePropertiesToRecoveryLog() {
        StatementCommand statement = new StatementCommand(3275, new Object[]{this, this.lastProcessedRecordOffset, this.lastProcessedRecordTimestamp, this.skipFirstRecord}, null, null);
        statement.sql = this.getSetLogFileTableSQL();
        try {
            Result result = this.localSession.executeCompiledStatement(statement, new Object[0]);
            if (result.isError()) {
                if (result.getException() != null) {
                    throw result.getException();
                }
                throw new DataspaceException(result.getMainString());
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private String getSetLogFileTableSQL() {
        return "SET LOG FILE TABLE PROPERTIES " + this.getObjectName().getSchemaQualifiedStatementName() + " RECORD OFFSET " + this.lastProcessedRecordOffset + " RECORD TIMESTAMP " + this.lastProcessedRecordTimestamp + " SKIP FIRST LINE " + this.skipFirstRecord;
    }

    public String getStartLogFileTableSQL() {
        String sql = "START LOG FILE TABLE " + this.getObjectName().getSchemaQualifiedStatementName() + " ON SOURCE FILE '" + this.sourceFileName + "'";
        if (this.rotationFileRegexp != null) {
            sql = sql + " ROTATION FILE REGEXP '" + this.rotationFileRegexp.replaceAll("'", "''") + "'";
        }
        if (this.suspendOnFail) {
            sql = sql + " SUSPEND ON FAIL";
        }
        return sql;
    }

    public String[] getSQLForLogDDL() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getSetLogFileTableSQL());
        if (this.isStarted() || this.needToStart) {
            result.add(this.getStartLogFileTableSQL());
        }
        return result.toArray(new String[0]);
    }

    public void logInfo(String message) {
        this.log(Trace.Level.INFO, message);
    }

    public void logError(String message) {
        this.log(Trace.Level.ERROR, message);
    }

    public void logDebug(String message) {
        this.log(Trace.Level.DEBUG, message);
    }

    private void log(Trace.Level info, String message) {
        if (this.store != null) {
            LogFileTableCollection.log(info, (AbstractDataspace)this.store.schemaManager.findSchema(this.getObjectName().schema.name), this.getObjectName(), message);
        } else {
            LogFileTableCollection.log(info, null, this.getObjectName(), message);
        }
    }

    public static void log(Trace.Level level, AbstractDataspace dataspace, NameManager.ObjectName objectName, String message) {
        AbstractDataspace.log(FileTable.class, level, dataspace, objectName, message);
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_LFT;
    }

    @Override
    public String getEntityName() {
        return this.name.name;
    }

    @Override
    public EventScope getEntityScope() {
        return null;
    }

    @Override
    public HashMap<String, String> getEntityParameters() {
        return null;
    }

    public void raiseLogFileTableStateChangeAdvisory(LogFileTableStateChangeAdvisory.LFTState state, Exception exception, String filename) {
        try {
            LogFileTableStateChangeAdvisory e = new LogFileTableStateChangeAdvisory();
            e.setLftName(this.getObjectName().name);
            e.setComponentName(this.dataspace.getType() + "." + this.dataspace.getName());
            e.setState(state);
            e.setException(exception);
            e.setFilename(filename);
            this.dataspace.raiseSystemAdvisory(e);
        }
        catch (Exception exception1) {
            this.logError("Failed to raise log file table state change advisory.");
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet references = super.getReferences();
        if (this.mapperFunctionName != null) {
            references.add(this.mapperFunctionName);
        }
        if (this.constrainedByEventId != null && this.constrainedByEventId.length() > 0) {
            references.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetEventPrototypeObjectName(this.constrainedByEventId));
        }
        return references;
    }

    public static enum ProcessingStrategy {
        DEFAULT,
        NO_RECOVERY,
        RECOVERY,
        FROM;

    }
}

