/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.fspace.table;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.collection.fspace.table.JournalFileTableProxy;
import com.streamscape.ds.schema.table.AppendableFileTableReader;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SourceEventFlowData;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sdo.advisory.JournalFileTableStateChangeAdvisory;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class JournalFileTableCollection
extends FileTableCollection
implements SourceEventFlowData {
    private ProcessingStrategy processingStrategy = ProcessingStrategy.DEFAULT;
    private long processingStrategyStartSeqId;
    private long processingStrategyStartTimestamp;
    private long startSeqId = -1L;
    private long startTimestamp = -1L;
    private boolean isPositionAfterStart = false;
    private long lastReadSeqId = -2L;
    private long lastProcessedSeqId = -1L;
    private long lastProcessedTimestamp = -1L;
    private boolean noCreateFile;
    private boolean ignoreMalformedSeqIdOnInsert = false;
    private boolean ignoreMalformedSeqIdOnUpdate = false;
    private boolean ignoreMalformedSeqIdOnDelete = false;
    private List<Object[]> xdata = new ArrayList<Object[]>();
    private List<Object[]> udata = new ArrayList<Object[]>();

    public JournalFileTableCollection(DataspaceStore database, NameManager.ObjectName name) {
        super(database, name, CollectionType.JOURNAL_FILE_TABLE);
    }

    @Override
    protected void doCreateTable(DataspaceStore database, NameManager.ObjectName tableName, int tableType) {
        super.doCreateTable(database, tableName, tableType);
        ((FileTable)this.table).setForAppend(true);
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        super.compile(session, parentObject);
        try {
            this.dataspace.bindProducerForSystem("advisory.journal.file.table.StateChange", this);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
    }

    public void addJftSpecificColumns() {
        JournalFileTableCollection.listSpecificJftColumns().forEach(p -> this.addColumn(this.table, (String)p.first, (Type)p.second));
    }

    public static List<Pair<String, Type>> listSpecificJftColumns() {
        return Arrays.asList(new Pair<String, NumberType>("jft_SeqId", Type.LONG), new Pair<String, DateTimeType>("jft_Timestamp", Type.SQL_TIMESTAMP), new Pair<String, CharacterType>("jft_Operation", Type.SQL_CHAR));
    }

    @Override
    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE").append(' ').append("JOURNAL").append(' ').append("FILE").append(' ').append("TABLE").append(' ');
        builder.append(this.getObjectName().getSchemaQualifiedStatementName()).append(' ');
        builder.append("FROM").append(' ').append("FILE").append(' ').append("DESCRIPTOR").append(" '").append(this.getFileTable().getFileDescriptorName()).append("'");
        if (this.getFileTable().getDataSource() != null) {
            builder.append(" SOURCE FILE '" + this.getFileTable().getDataSource().replace("'", "''") + "' ");
        }
        if (this.isNoCreateFile()) {
            builder.append(" NO CREATE");
        }
        if (this.getFileTable().getCheckInterval() != -1L) {
            builder.append(" JOURNAL READ INTERVAL " + this.getFileTable().getCheckInterval());
        }
        if (this.ignoreMalformedSeqIdOnDelete) {
            builder.append(" IGNORE MALFORMED SEQID ON DELETE ");
        }
        if (this.ignoreMalformedSeqIdOnInsert) {
            builder.append(" IGNORE MALFORMED SEQID ON INSERT ");
        }
        if (this.ignoreMalformedSeqIdOnUpdate) {
            builder.append(" IGNORE MALFORMED SEQID ON UPDATE ");
        }
        return builder.toString();
    }

    public void setDataSource(Session session, String filename) {
        this.getFileTable().setDataSource(session, filename);
    }

    public void setDataSource(Session session, String sourceFileName, boolean createIfNotExist, boolean init) {
        if (sourceFileName != null) {
            String resolvedFileName = this.getFileTable().getFileTableSettings(sourceFileName).getFileName();
            if ((resolvedFileName = resolvedFileName.trim()).length() == 0) {
                throw new DataspaceException("Source file name is empty.");
            }
            String resolvedFileNameSecured = session.dataspaceStore.dataspaceLogger.getSecurePath(resolvedFileName);
            if (resolvedFileNameSecured == null) {
                throw Error.error(471, new Object[]{"Source file '" + resolvedFileName + "' is external"});
            }
            if (!new File(resolvedFileName).exists()) {
                if (createIfNotExist) {
                    try {
                        new File(resolvedFileName).createNewFile();
                    }
                    catch (IOException exception) {
                        if (session.isProcessingLog() || session.isProcessingRecoveryLog()) {
                            Trace.logError(this, "Failed to create empty source '" + resolvedFileName + "' file for JFT '" + this.getObjectName().getSchemaQualifiedStatementName() + "'.");
                            Trace.logException(this, exception, true);
                        }
                        throw new DataspaceException("Failed to create empty source file. Cause: " + exception.getMessage());
                    }
                }
            } else if (init && !session.isProcessingLog() && !session.isProcessingRecoveryLog()) {
                try {
                    FileOutputStream output = new FileOutputStream(resolvedFileName, false);
                    output.close();
                }
                catch (IOException exception) {
                    throw new DataspaceException("Failed to zero-out source file. Cause: " + exception.getMessage());
                }
            }
        }
        this.setDataSource(session, sourceFileName);
    }

    @Override
    public String getDataSource(Session session) {
        return this.getFileTable().getDataSource();
    }

    public long getCheckInterval(Session session) {
        return this.getFileTable().getCheckInterval();
    }

    public boolean isStarted(Session session) {
        return this.getFileTable().isConnected();
    }

    public void setProcessingStrategy(Session session, ProcessingStrategy processingStrategy, long startSeqId, long startTimestamp) {
        this.processingStrategy = processingStrategy;
        this.processingStrategyStartSeqId = startSeqId;
        this.processingStrategyStartTimestamp = startTimestamp;
    }

    public ProcessingStrategy getProcessingStrategy(Session session) {
        return this.getProcessingStrategy();
    }

    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    public void start(Session session) {
        try {
            if (this.getFileTable().getDataSource() == null || this.getFileTable().getDataSource().trim().length() == 0) {
                throw new DataspaceException("Source file not set.");
            }
            if (this.getFileTable().isConnected()) {
                return;
            }
            this.xdata.clear();
            this.udata.clear();
            this.getFileTable().connect(session, true, false, true);
        }
        catch (Exception exception) {
            this.logInfo("Failed to start journal file table. Cause: " + exception.getMessage());
            Trace.logException(this, exception, false);
            throw exception;
        }
    }

    public void stop(Session session) {
        try {
            super.unlink(session);
            if (!this.getFileTable().isConnected() && this.getAppendableStatistics(session) != null && this.getAppendableStatistics(session).getStoppedAt() > 0L) {
                this.raiseJournalFileTableStateChangeAdvisory(JournalFileTableStateChangeAdvisory.JFTState.STOPPED, null);
                this.logInfo("Journal file table has been stopped.");
            }
        }
        catch (Exception exception) {
            this.logInfo("Failed to stop journal file table. Cause: " + exception.getMessage());
            Trace.logException(this, exception, false);
            throw exception;
        }
    }

    public void setCheckInterval(Session session, Long checkInterval) {
        this.getFileTable().setCheckInterval(session, checkInterval);
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new JournalFileTableProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fireNewRowIndexedTrigger(Session session, Object[] data) {
        long seqId;
        String operation;
        block40: {
            block42: {
                block43: {
                    boolean seqIdIndex = false;
                    boolean timestampIndex = true;
                    int operationIndex = 2;
                    if (data == null) {
                        throw Error.error(null, 7200, 0, new Object[]{"row data is null"});
                    }
                    if (data.length < 4) {
                        throw Error.error(null, 7200, 0, new Object[]{"row size is less than 4"});
                    }
                    if (data[2] == null) {
                        throw Error.error(null, 7200, 0, new Object[]{"operation value is null"});
                    }
                    if (!(data[2] instanceof String)) {
                        throw Error.error(null, 7200, 0, new Object[]{"operation value is not string"});
                    }
                    if (data[1] == null) {
                        throw Error.error(null, 7200, 0, new Object[]{"timestamp id value is null"});
                    }
                    if (!(data[1] instanceof TimestampData)) {
                        throw Error.error(null, 7200, 0, new Object[]{"timestamp id value is not TimestampData"});
                    }
                    operation = ((String)data[2]).toUpperCase();
                    if (data[0] != null && data[0] instanceof Long) break block42;
                    if (!operation.equals("I") || this.ignoreMalformedSeqIdOnInsert) break block43;
                    seqId = this.lastReadSeqId + 1L;
                    break block40;
                }
                if (operation.equals("D") && !this.ignoreMalformedSeqIdOnDelete) {
                    seqId = this.lastReadSeqId + 1L;
                    break block40;
                } else if ((operation.equals("X") || operation.equals("U")) && !this.ignoreMalformedSeqIdOnUpdate) {
                    seqId = this.lastReadSeqId + 1L;
                    break block40;
                } else {
                    if (data[0] == null) {
                        throw Error.error(null, 7200, 0, new Object[]{"sequence id value is null"});
                    }
                    throw Error.error(null, 7200, 0, new Object[]{"sequence id value is not long"});
                }
            }
            this.lastReadSeqId = seqId = ((Long)data[0]).longValue();
        }
        long dataTimestamp = ((TimestampData)data[1]).getMilliseconds();
        if (this.startTimestamp != -1L && this.startSeqId == -1L) {
            if (dataTimestamp < this.startTimestamp) return;
        }
        if (this.startTimestamp == -1L && this.startSeqId != -1L) {
            if (seqId <= this.startSeqId) return;
        }
        if (this.startTimestamp != -1L && this.startSeqId != -1L) {
            if (dataTimestamp < this.startTimestamp) return;
            if (dataTimestamp == this.startTimestamp && seqId <= this.startSeqId && seqId >= 0L) {
                return;
            }
        }
        this.isPositionAfterStart = true;
        AppendableFileTableReader.AppendableFileTableReaderReplicationListener listener = this.getFileTable().getAppendableReaderListener();
        if (operation.equals("I")) {
            if (this.xdata.size() > 0) {
                this.logUnhandled(this.xdata, this.udata);
                this.xdata.clear();
                this.udata.clear();
                throw Error.error(null, 7201, 0, new Object[]{"unexpected I row, after X row there should be X or U row"});
            }
            if (listener != null) {
                listener.onJftAppend(session, data, null);
            }
            this.getFileTable().fireTriggers(session, Trigger.Type.INSERT_AFTER_ROW, null, data, null);
        } else if (operation.equals("D")) {
            if (this.xdata.size() > 0) {
                this.logUnhandled(this.xdata, this.udata);
                this.xdata.clear();
                this.udata.clear();
                throw Error.error(null, 7201, 0, new Object[]{"unexpected D row, after X row there should be X or U row"});
            }
            if (listener != null) {
                listener.onJftAppend(session, data, null);
            }
            this.getFileTable().fireTriggers(session, Trigger.Type.DELETE_AFTER_ROW, data, null, null);
        } else {
            if (operation.equals("X")) {
                if (this.udata.size() > 0) {
                    this.logUnhandled(this.xdata, this.udata);
                    this.xdata.clear();
                    this.udata.clear();
                    throw Error.error(null, 7201, 0, new Object[]{"unexpected X row, after U row there should be U row"});
                }
                this.xdata.add(data);
                return;
            }
            if (!operation.equals("U")) {
                throw Error.error(null, 7200, 0, new Object[]{"invalid operation type '" + operation + "'"});
            }
            if (this.xdata.size() == 0) {
                throw Error.error(null, 7201, 0, new Object[]{"unexpected U row, it should be after X row"});
            }
            this.udata.add(data);
            if (this.xdata.size() != this.udata.size()) return;
            try {
                if (listener != null) {
                    Object[] lastUrow = this.udata.get(this.udata.size() - 1);
                    Long groupId = (Long)lastUrow[0];
                    for (int i = 0; i < this.xdata.size(); ++i) {
                        listener.onJftAppend(session, this.xdata.get(i), groupId);
                        listener.onJftAppend(session, this.udata.get(i), groupId);
                    }
                }
                for (int i = 0; i < this.xdata.size(); ++i) {
                    this.getFileTable().fireTriggers(session, Trigger.Type.UPDATE_AFTER_ROW, this.xdata.get(i), this.udata.get(i), null);
                }
            }
            finally {
                this.xdata.clear();
                this.udata.clear();
            }
        }
        if (seqId == this.lastReadSeqId) {
            this.lastProcessedSeqId = seqId;
        }
        this.lastProcessedTimestamp = ((TimestampData)data[1]).getMilliseconds();
        try (Session tempSession = this.dataspace.createSystemSession();){
            this.store.getSysTablesManager().getJftSeqIdTrackManager().updateSeqId(tempSession, this.getObjectName(), this.lastProcessedSeqId, data[1], operation);
            return;
        }
    }

    private void logUnhandled(List<Object[]> xdata, List<Object[]> udata) {
        if (xdata.size() == 0 && udata.size() == 0) {
            return;
        }
        String xdataStrings = xdata.stream().map(d -> Arrays.asList(d).stream().map(String::valueOf).collect(Collectors.joining(","))).collect(Collectors.joining("\n"));
        String udataStrings = udata.stream().map(d -> Arrays.asList(d).stream().map(String::valueOf).collect(Collectors.joining(","))).collect(Collectors.joining("\n"));
        this.log(Trace.Level.ERROR, "Unhandled XU updates due to incorrect sequence:\n" + xdataStrings + udataStrings);
    }

    @Override
    public void destroy(Session session) {
        try {
            this.store.getSysTablesManager().getJftSeqIdTrackManager().deleteSeqId(session, this.getObjectName());
        }
        catch (Exception exception) {
            this.logError("Failed to delete jft seqId track.");
            Trace.logException(this, exception, false);
        }
        super.destroy(session);
    }

    public void initSeqId(Session session) {
        this.lastProcessedSeqId = -1L;
        this.lastProcessedTimestamp = -1L;
        this.lastReadSeqId = -1L;
        this.startSeqId = -1L;
        this.startTimestamp = -1L;
        switch (this.processingStrategy.ordinal()) {
            case 0: {
                Pair pair = this.store.getSysTablesManager().getJftSeqIdTrackManager().getSeqId(session, this.getObjectName());
                if (pair != null) {
                    if (pair.first != null) {
                        this.startSeqId = ((Number)pair.first).longValue();
                    }
                    if (pair.second != null) {
                        this.startTimestamp = ((TimestampData)pair.second).getMilliseconds();
                    }
                    this.logInfo("Starting JFT in default mode from SeqId " + this.startSeqId + ", and timestamp '" + DataspaceDateTime.formatTimestamp(session, DataspaceDateTime.convertMillisToCalendar(session.getCalendar(), this.startTimestamp >= 0L ? this.startTimestamp : 0L)) + "'.");
                    break;
                }
                this.logInfo("Starting JFT from the begin.");
                break;
            }
            case 1: {
                this.startSeqId = -1L;
                this.startTimestamp = -1L;
                this.store.getSysTablesManager().getJftSeqIdTrackManager().updateSeqId(session, this.getObjectName(), -1, null, null);
                this.logInfo("Starting JFT from the end of source file.");
                break;
            }
            case 2: {
                this.startSeqId = -1L;
                this.startTimestamp = -1L;
                this.store.getSysTablesManager().getJftSeqIdTrackManager().updateSeqId(session, this.getObjectName(), -1, null, null);
                this.logInfo("Starting JFT from the begin.");
                break;
            }
            case 3: {
                this.startSeqId = this.processingStrategyStartSeqId >= 0L ? this.processingStrategyStartSeqId - 1L : -1L;
                this.startTimestamp = this.processingStrategyStartTimestamp;
                this.logInfo("Starting JFT from SeqId " + this.startSeqId + ", and timestamp '" + DataspaceDateTime.formatTimestamp(session, DataspaceDateTime.convertMillisToCalendar(session.getCalendar(), this.startTimestamp >= 0L ? this.startTimestamp : 0L)) + "'.");
            }
        }
        if (this.startSeqId == -1L && this.startTimestamp == -1L) {
            this.isPositionAfterStart = true;
        }
    }

    @Override
    public Result getCollectionProperties(Session session) {
        Result result = super.getCollectionProperties(session);
        result.navigator.add(new Object[]{"Processing Strategy", this.processingStrategy == ProcessingStrategy.DEFAULT ? "First Unprocessed Row" : (this.processingStrategy == ProcessingStrategy.NO_RECOVERY ? "End Of File" : "Begin Of File")});
        String startSeqIdDescription = "n/a";
        String startTimestampDescription = "n/a";
        if (this.processingStrategy == ProcessingStrategy.DEFAULT) {
            startSeqIdDescription = this.startSeqId != -1L ? String.valueOf(this.startSeqId) : "Begin Of The File";
            startTimestampDescription = this.startTimestamp != -1L ? DataspaceDateTime.formatTimestamp(session, DataspaceDateTime.convertMillisToCalendar(session.getCalendar(), this.startTimestamp)) : "Begin Of The File";
        } else if (this.processingStrategy == ProcessingStrategy.NO_RECOVERY) {
            startSeqIdDescription = "End Of The File";
            startTimestampDescription = "End Of The File";
        } else if (this.processingStrategy == ProcessingStrategy.RECOVERY) {
            startSeqIdDescription = "Begin Of The File";
            startTimestampDescription = "Begin Of The File";
        }
        result.navigator.add(new Object[]{"Start SeqId", startSeqIdDescription});
        result.navigator.add(new Object[]{"Start Timestamp", startTimestampDescription});
        Object s = "";
        if (this.ignoreMalformedSeqIdOnInsert) {
            s = (String)s + "INSERT";
        }
        if (this.ignoreMalformedSeqIdOnUpdate) {
            s = (String)s + " DELETE";
        }
        if (this.ignoreMalformedSeqIdOnDelete) {
            s = (String)s + " UPDATE";
        }
        if (((String)(s = ((String)s).trim())).length() == 0) {
            s = "none";
        }
        result.navigator.add(new Object[]{"Ignore Malformed SeqId On", s});
        result.navigator.add(new Object[]{"Last Processed SeqId", this.lastProcessedSeqId != -1L ? Long.valueOf(this.lastProcessedSeqId) : "n/a"});
        result.navigator.add(new Object[]{"Last Processed Timestamp", this.lastProcessedTimestamp != -1L ? DataspaceDateTime.formatTimestamp(session, DataspaceDateTime.convertMillisToCalendar(session.getCalendar(), this.lastProcessedTimestamp)) : "n/a"});
        return result;
    }

    public void onTruncate(Session session) {
        this.store.getSysTablesManager().getJftSeqIdTrackManager().updateSeqId(session, this.getObjectName(), -1, null, null);
        this.processingStrategyStartSeqId = -1L;
        this.processingStrategyStartTimestamp = -1L;
        if (this.getFileTable().isConnected() && this.processingStrategy == ProcessingStrategy.DEFAULT) {
            this.initSeqId(session);
        }
    }

    public void raiseJournalFileTableStateChangeAdvisory(JournalFileTableStateChangeAdvisory.JFTState state, Exception exception) {
        try {
            JournalFileTableStateChangeAdvisory e = new JournalFileTableStateChangeAdvisory();
            e.setJftName(this.getObjectName().name);
            e.setComponentName(this.dataspace.getType() + "." + this.dataspace.getName());
            e.setState(state);
            e.setException(exception);
            this.dataspace.raiseSystemAdvisory(e);
        }
        catch (Exception exception1) {
            this.logError("Failed to send journal file table state change advisory.");
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public EventFlowEntity getEntity() {
        return EventFlowEntity.DATASPACE_JFT;
    }

    @Override
    public String getEntityName() {
        return this.name.name;
    }

    @Override
    public EventScope getEntityScope() {
        return null;
    }

    @Override
    public HashMap<String, String> getEntityParameters() {
        return null;
    }

    public boolean isNoCreateFile() {
        return this.noCreateFile;
    }

    public JournalFileTableCollection setNoCreateFile(boolean noCreateFile) {
        this.noCreateFile = noCreateFile;
        return this;
    }

    public boolean isPositionAfterStart() {
        return this.isPositionAfterStart;
    }

    public void setIgnoreMalformedSeqIdOnInsert(boolean ignoreMalformedSeqIdOnInsert) {
        this.ignoreMalformedSeqIdOnInsert = ignoreMalformedSeqIdOnInsert;
    }

    public boolean isIgnoreMalformedSeqIdOnInsert() {
        return this.ignoreMalformedSeqIdOnInsert;
    }

    public void setIgnoreMalformedSeqIdOnUpdate(boolean ignoreMalformedSeqIdOnUpdate) {
        this.ignoreMalformedSeqIdOnUpdate = ignoreMalformedSeqIdOnUpdate;
    }

    public boolean isIgnoreMalformedSeqIdOnUpdate() {
        return this.ignoreMalformedSeqIdOnUpdate;
    }

    public void setIgnoreMalformedSeqIdOnDelete(boolean ignoreMalformedSeqIdOnDelete) {
        this.ignoreMalformedSeqIdOnDelete = ignoreMalformedSeqIdOnDelete;
    }

    public boolean isIgnoreMalformedSeqIdOnDelete() {
        return this.ignoreMalformedSeqIdOnDelete;
    }

    public static enum ProcessingStrategy {
        DEFAULT,
        NO_RECOVERY,
        RECOVERY,
        FROM;

    }
}

