/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.fspace.table;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SysTableManager;
import com.streamscape.ds.SysTablesManager;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.utils.Pair;

public class JftSeqIdTrackManager
extends SysTableManager {
    private Statement updateSeqId;
    private Statement createSeqId;
    private Statement deleteSeqId;
    private Statement getSeqId;

    public JftSeqIdTrackManager(SysTablesManager manager) {
        super(manager, "JFT_SEQID_TRACK");
    }

    @Override
    public void initialize(Session session) {
        Result result;
        if (session.dataspaceStore.schemaManager.findSchemaObject(this.getTableName(), "SDS", 4) == null && (result = session.executeDirectStatement("create persistent table " + this.getFullTableName() + "(SCHEMA_NAME varchar(255), JFT_COLLECTION_NAME varchar(255), SEQ_ID long, TIMESTAMP SqlTimestamp, OPERATION character, PRIMARY KEY(SCHEMA_NAME, JFT_COLLECTION_NAME))")).isError()) {
            throw new DataspaceException(result);
        }
    }

    public void updateSeqId(Session session, final NameManager.ObjectName objectName, final Object seqId, final Object timestamp, final Object operation) {
        this.execute(new SysTableManager.Executor(){

            @Override
            public void execute(Session session) {
                Result result;
                String SQL;
                if (JftSeqIdTrackManager.this.createSeqId == null) {
                    SQL = "insert into " + JftSeqIdTrackManager.this.getFullTableName() + "(  SCHEMA_NAME,   JFT_COLLECTION_NAME,   SEQ_ID,   TIMESTAMP,   OPERATION )values (?, ?, ?, ?, ?)";
                    JftSeqIdTrackManager.this.createSeqId = session.compileStatement(SQL);
                }
                if (JftSeqIdTrackManager.this.updateSeqId == null) {
                    SQL = "update " + JftSeqIdTrackManager.this.getFullTableName() + " SET SEQ_ID = ?, TIMESTAMP = ?, OPERATION = ? WHERE SCHEMA_NAME = ? and JFT_COLLECTION_NAME = ?";
                    JftSeqIdTrackManager.this.updateSeqId = session.compileStatement(SQL);
                }
                if ((result = session.executeCompiledStatement(JftSeqIdTrackManager.this.updateSeqId, new Object[]{seqId, timestamp, operation, objectName.schema.name, objectName.name})).isError()) {
                    JftSeqIdTrackManager.this.logError(result, "Unable to update jft seq id.", objectName);
                } else if (result.getUpdateCount() == 0 && (result = session.executeCompiledStatement(JftSeqIdTrackManager.this.createSeqId, new Object[]{objectName.schema.name, objectName.name, seqId, timestamp, operation})).isError()) {
                    JftSeqIdTrackManager.this.logError(result, "Unable to insert jft seq id.", objectName);
                }
            }
        }, session);
    }

    public void deleteSeqId(Session session, final NameManager.ObjectName objectName) {
        this.execute(new SysTableManager.Executor(){

            @Override
            public void execute(Session session) {
                Result result;
                if (JftSeqIdTrackManager.this.deleteSeqId == null) {
                    String SQL = "delete from " + JftSeqIdTrackManager.this.getFullTableName() + " where SCHEMA_NAME = ? and JFT_COLLECTION_NAME = ?";
                    JftSeqIdTrackManager.this.deleteSeqId = session.compileStatement(SQL);
                }
                if ((result = session.executeCompiledStatement(JftSeqIdTrackManager.this.deleteSeqId, new Object[]{objectName.schema.name, objectName.name})).isError()) {
                    JftSeqIdTrackManager.this.logError(result, "Unable to delete jft seq id.", objectName);
                }
            }
        }, session);
    }

    public Pair getSeqId(Session session, final NameManager.ObjectName objectName) {
        return this.execute(new SysTableManager.ExecutorWithReturn<Pair>(){

            @Override
            public Pair execute(Session session) {
                Result result;
                if (JftSeqIdTrackManager.this.getSeqId == null) {
                    String SQL = "select SEQ_ID, TIMESTAMP from  " + JftSeqIdTrackManager.this.getFullTableName() + " where SCHEMA_NAME = ? and JFT_COLLECTION_NAME = ?";
                    JftSeqIdTrackManager.this.getSeqId = session.compileStatement(SQL);
                }
                if ((result = session.executeCompiledStatement(JftSeqIdTrackManager.this.getSeqId, new Object[]{objectName.schema.name, objectName.name})).isError()) {
                    JftSeqIdTrackManager.this.logError(result, "Unable to get jft seq id.", objectName);
                    return null;
                }
                if (result.navigator.next()) {
                    return new Pair<Object, Object>(result.navigator.getCurrent(0), result.navigator.getCurrent(1));
                }
                return null;
            }
        }, session);
    }

    private void logError(Result result, String message, NameManager.ObjectName objectName) {
        Trace.logError(JftSeqIdTrackManager.class, message + " For JFT collection '" + objectName.schema.name + "." + objectName.name + "'.");
        Trace.logError(JftSeqIdTrackManager.class, result.getMainString());
    }
}

