/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.fspace.table;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.collection.fspace.table.FileTableFactory;
import com.streamscape.ds.schema.collection.tspace.table.TableColumn;
import com.streamscape.ds.schema.collection.tspace.table.TableFactoryImpl;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import java.util.ArrayList;
import java.util.List;

public class FileTableFactoryImpl
extends TableFactoryImpl {
    private String fileDescriptorName;
    private Boolean typesOnly;
    private List<String> recordTypes = new ArrayList<String>();

    public FileTableFactoryImpl() {
        super(CollectionType.FILE_TABLE);
    }

    @Override
    public void addColumn(Session session, TableColumn column) {
        super.addColumn(session, column);
        column.setNullable(true);
    }

    public void setFileDescriptorName(Session session, String fileDescriptorName) {
        this.fileDescriptorName = fileDescriptorName;
    }

    public String getFileDescriptorName(Session session) {
        return this.fileDescriptorName;
    }

    public void setTypesOnly(Session session, boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public boolean getTypesOnly(Session session) {
        return this.typesOnly;
    }

    public void setRecordTypes(Session session, List<String> recordTypes) {
        this.recordTypes = recordTypes;
    }

    public List<String> getRecordTypes(Session session) {
        return this.recordTypes;
    }

    @Override
    public String getCreateSql(Session session, String name) {
        if (this.fileDescriptorName == null) {
            if (this.typesOnly != null) {
                throw new DataspaceException("TYPES ONLY can be specified only with file descriptor.");
            }
            if (this.recordTypes != null && this.recordTypes.size() > 0) {
                throw new DataspaceException("Record types can be specified only with file descriptor.");
            }
            return super.getCreateSql(session, name);
        }
        if (this.primaryKeys != null && this.primaryKeys.size() > 0) {
            throw new DataspaceException("Primary keys cannot be specified with file descriptor.");
        }
        if (this.columns != null && this.columns.size() > 0) {
            throw new DataspaceException("Columns cannot be specified with file descriptor.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("create file table ").append(name);
        if (this.typesOnly != null && this.typesOnly.booleanValue()) {
            builder.append(" types only");
        }
        if (this.recordTypes != null && this.recordTypes.size() > 0) {
            builder.append(" for record types (");
            for (String recordType : this.recordTypes) {
                builder.append("'").append(recordType).append("', ");
            }
            builder.setLength(builder.length() - 2);
            builder.append(")");
        }
        builder.append(" constrained by [").append(this.fileDescriptorName).append("]");
        return builder.toString();
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new FileTableFactory();
    }
}

