/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.fspace.table;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.persist.FileTableCache;
import com.streamscape.ds.persist.FileTableSettings;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.collection.fspace.table.FileTableProxy;
import com.streamscape.ds.schema.collection.stream.SourceStreamProvider;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.server.FileServerObject;
import com.streamscape.ds.schema.table.AppendableFileTableReader;
import com.streamscape.ds.schema.table.FileTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.state.StateHolder;
import com.streamscape.ds.trigger.Trigger;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.file.UntypedRecordTypeDefinition;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.sdrpath.ReferencePathException;
import com.streamscape.sdo.sdrpath.ReferencePathManager;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class FileTableCollection
extends TableCollection
implements AccessibleObject,
SourceStreamProvider {
    public FileTableCollection(DataspaceStore database, NameManager.ObjectName name) {
        this(database, name, CollectionType.FILE_TABLE);
    }

    protected FileTableCollection(DataspaceStore database, NameManager.ObjectName name, CollectionType collectionType) {
        super(database, name, collectionType, MemoryModel.PERSISTENT, 8);
    }

    @Override
    protected void doCreateTable(DataspaceStore database, NameManager.ObjectName tableName, int tableType) {
        this.table = new FileTable(database, tableName, 8, this);
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        FileDescriptor fileDescriptor = this.getFileTable().getFileDescriptor();
        if (fileDescriptor != null) {
            if (this.getFileTable().getTypesOnly()) {
                if (fileDescriptor.hasKey()) {
                    this.addColumn(this.table, "Type", Type.STRING);
                }
                this.addColumn(this.table, "Record", new OtherType());
            } else {
                FileDescriptorRecord record = FileTableCollection.checkFileTableAndGetRecord(this.getFileTable().getTypesOnly(), this.getFileTable().getRecordTypes(), this.getFileTable().getFileDescriptor());
                FileTableCollection.handleRecordTypeDefinition(session, record, (field, type) -> this.addColumn(this.table, field.getFieldName(), (Type)type, field.isNullable()));
            }
            NameManager.ObjectName indexName = session.dataspaceStore.nameManager.newAutoName("IDX", null, this.table.getSchemaName(), this.table.getObjectName(), 21);
            this.table.createPrimaryKey(indexName, null, true);
            this.table.setColumnStructures();
            super.compile(session, parentObject);
        } else {
            if (this.table.getPrimaryConstraint() == null && this.table.getPrimaryKey() == null) {
                NameManager.ObjectName indexName = session.dataspaceStore.nameManager.newAutoName("IDX", null, this.table.getSchemaName(), this.table.getObjectName(), 21);
                this.table.createPrimaryKey(indexName, null, true);
            }
            this.table.setColumnStructures();
            super.compile(session, parentObject);
        }
    }

    public static FileDescriptorRecord checkFileTableAndGetRecord(boolean typesOnly, List<String> recordTypes, FileDescriptor fileDescriptor) {
        if (typesOnly) {
            return null;
        }
        FileDescriptorRecord record = null;
        if (recordTypes == null || recordTypes.size() == 0) {
            if (fileDescriptor.getRecords().size() != 1) {
                throw new DataspaceException("File Descriptor contains Multiple Record Types. Can only be used with TYPE ONLY file tables or with specified record type.");
            }
            record = fileDescriptor.getRecords().get(0);
        } else {
            if (recordTypes.size() != 1) {
                throw new DataspaceException("Multiply record types can only be used with TYPE ONLY file tables.");
            }
            String recordType = recordTypes.get(0);
            record = fileDescriptor.getRecord(recordType);
            if (record == null) {
                throw new DataspaceException("File Descriptor doesn't contain record with type '" + recordType + "'.");
            }
        }
        return record;
    }

    public static void handleRecordTypeDefinition(Session session, FileDescriptorRecord record, BiConsumer<RecordField, Type> onNewColumn) {
        if (!(record instanceof AbstractRecordTypeDefinition)) {
            throw new DataspaceException("File Descriptor record type is not record type definition.");
        }
        if (record instanceof RecordTypeDefinition) {
            RecordTypeDefinition recordTypeDefinition = (RecordTypeDefinition)record;
            SemanticType semanticType = DataspaceStoreManager.getRuntimeContext().getSemanticTypeCache().lookupSemanticType(recordTypeDefinition.getSemanticType());
            if (semanticType == null) {
                throw new DataspaceException("Record semantic type '" + recordTypeDefinition.getSemanticType() + "' doesn't exist.");
            }
            Class<?> typeClass = null;
            try {
                typeClass = DataspaceStoreManager.getRuntimeContext().getSystemClassLoaderChain().loadClass(semanticType.getClassName());
            }
            catch (Exception exception) {
                throw new DataspaceException("Failed to load semantic type class. Cause: " + exception.getMessage());
            }
            ReferencePathManager sdrManager = DataspaceStoreManager.getRuntimeContext().getSDRManagerFactory().createManager();
            for (RecordField field : recordTypeDefinition.getFields()) {
                Class<?> fieldClass;
                if (field.getFieldName() == null || field.getFieldName().trim().length() == 0) {
                    throw new DataspaceException("Field name field '" + field.getFieldName() + "' is null or empty.");
                }
                if (field.getSpaths() == null || field.getSpaths().length == 0) {
                    throw new DataspaceException("Spath not defined for field '" + field.getFieldName() + "'.");
                }
                try {
                    fieldClass = sdrManager.getTypeAtPath(field.getSpaths()[0], typeClass);
                    if (fieldClass == null) {
                        throw new DataspaceException("Failed to resolve type for field '" + field.getFieldName() + "'.");
                    }
                }
                catch (ReferencePathException exception) {
                    throw new DataspaceException("Failed to resolve type for field '" + field.getFieldName() + "'. Cause: " + exception.getMessage());
                }
                Type fieldType = Type.resolveType(session, fieldClass, field.getStart() > 0 ? field.getEnd() - field.getStart() + 1 : -1);
                if (fieldType == null) {
                    throw new DataspaceException("DSQL type corresponding to type '" + fieldClass.getName() + "' of field '" + field.getFieldName() + "' not found.");
                }
                onNewColumn.accept(field, fieldType);
            }
        } else if (record instanceof UntypedRecordTypeDefinition) {
            for (RecordField field : ((UntypedRecordTypeDefinition)record).getFields()) {
                Type fieldType;
                if (field.getFieldName() == null || field.getFieldName().trim().length() == 0) {
                    throw new DataspaceException("Field name field '" + field.getFieldName() + "' is null or empty.");
                }
                if (field.getDataType() == null || field.getDataType().length() == 0) {
                    throw new DataspaceException("Data type not defined for field '" + field.getFieldName() + "'.");
                }
                try {
                    Scanner scanner = new Scanner(field.getDataType());
                    scanner.scanNext();
                    ParserDQL parser = new ParserDQL(session, scanner);
                    fieldType = parser.readTypeDefinition(true, false);
                }
                catch (Exception exception) {
                    throw new DataspaceException("Failed to parse data type '" + field.getDataType() + "' for field '" + field.getFieldName() + "'.", exception);
                }
                if (fieldType == null) {
                    throw new DataspaceException("Failed to parse data type '" + field.getDataType() + "' for field '" + field.getFieldName() + "'.");
                }
                onNewColumn.accept(field, fieldType);
            }
        } else {
            throw new DataspaceException("Unsupported record type '" + String.valueOf(record.getClass()) + "'.");
        }
    }

    public boolean isDescriptorInSync() {
        if (this.getFileTable().getFileDescriptorName() == null) {
            throw new DataspaceException("File descriptor name is not set for file table.");
        }
        FileDescriptor fileDescriptorFromFileTable = this.getFileTable().getFileDescriptorOrig();
        FileDescriptor fileDescriptorFromTfcache = FileTable.getFileDescriptor(this.getFileTable().getFileDescriptorName());
        return Objects.equals(fileDescriptorFromFileTable, fileDescriptorFromTfcache);
    }

    public boolean isTuplesAndDescriptorInSync(Session session) {
        try {
            this.checkTuplesAndDescriptorInSync(session);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void checkTuplesAndDescriptorInSync(Session session) {
        FileDescriptor fileDescriptor = this.getFileTable().getFileDescriptor();
        if (fileDescriptor == null) {
            throw new DataspaceException("File descriptor is not initialized for file table.");
        }
        if (this.getFileTable().getTypesOnly()) {
            int recordColumnIndex = 0;
            if (fileDescriptor.hasKey()) {
                if (this.table.columnCount == 0) {
                    throw new DataspaceException("Columns count is 0.");
                }
                ColumnSchema typeColumn = this.table.getColumn(0);
                if (!typeColumn.getObjectName().name.equals("Type")) {
                    throw new DataspaceException("First column should be with  name 'Type'.");
                }
                if (typeColumn.getDataType() != Type.STRING) {
                    throw new DataspaceException("First column should be of type 'STRING'.");
                }
                ++recordColumnIndex;
            }
            if (this.table.columnCount <= recordColumnIndex) {
                throw new DataspaceException("Columns count is less than required. Expected at least " + (recordColumnIndex + 1) + ", but got " + this.table.columnCount + ".");
            }
            ColumnSchema column = this.table.getColumn(recordColumnIndex);
            if (!column.getObjectName().name.equals("Record")) {
                throw new DataspaceException("Column N" + recordColumnIndex + " should be with  name 'Type', but it is with name '" + column.getObjectName().name + "'.");
            }
            if (!(column.getDataType() instanceof OtherType)) {
                throw new DataspaceException("Column N" + recordColumnIndex + " should be of type 'OTHER', but it is of type " + column.getDataType().getNameString() + ".");
            }
        } else {
            FileDescriptorRecord record = FileTableCollection.checkFileTableAndGetRecord(this.getFileTable().getTypesOnly(), this.getFileTable().getRecordTypes(), fileDescriptor);
            int[] columnIndex = new int[]{0};
            FileTableCollection.handleRecordTypeDefinition(session, record, (field, type) -> {
                if (this.table.columnCount <= columnIndex[0]) {
                    throw new DataspaceException("Columns count is less than required. Expected at least " + (columnIndex[0] + 1) + " but got " + this.table.columnCount + ".");
                }
                ColumnSchema column = this.table.getColumn(columnIndex[0]);
                if (!column.getObjectName().name.equals(field.getFieldName())) {
                    throw new DataspaceException("Column N" + columnIndex[0] + " should be with  name '" + field.getFieldName() + "', but it is with name '" + column.getObjectName().name + "'.");
                }
                if (!column.getDataType().equals(type)) {
                    throw new DataspaceException("Column N" + columnIndex[0] + " should be of type '" + type.getNameString() + "', but it is of type " + column.getDataType().getNameString() + ".");
                }
                columnIndex[0] = columnIndex[0] + 1;
            });
        }
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new FileTableProxy();
    }

    @Override
    public String getSQL() {
        if (this.getFileTable().getFileDescriptorName() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE").append(' ').append("FILE").append(' ').append("TABLE").append(' ');
            builder.append(this.getObjectName().getSchemaQualifiedStatementName()).append(' ');
            if (this.getFileTable().getFileServer() != null) {
                builder.append("AT").append(' ').append(this.getFileTable().getFileServer().getObjectName().getSchemaQualifiedStatementName()).append(' ');
            }
            if (this.getFileTable().getTypesOnly()) {
                builder.append("TYPES").append(' ').append("ONLY").append(' ');
            }
            if (this.getFileTable().getRecordTypes() != null && this.getFileTable().getRecordTypes().size() > 0) {
                builder.append("FOR").append(' ').append("RECORD").append(' ').append("TYPES").append(" (");
                for (String recordType : this.getFileTable().getRecordTypes()) {
                    builder.append(" '").append(recordType).append("', ");
                }
                builder.setLength(builder.length() - 2);
                builder.append(")");
            }
            builder.append("CONSTRAINED").append(' ').append("BY").append(" '").append(this.getFileTable().getFileDescriptorName()).append("'");
            return builder.toString();
        }
        return this.table.getSQL().replaceAll("TEXT\\sTABLE", "FILE TABLE");
    }

    public void startAppendableFileTableReader(Session session) {
        this.getFileTable().startAppendableFileTableReader(session);
    }

    public boolean isLinked() {
        return this.getFileTable().isConnected();
    }

    public boolean isLinked(Session session) {
        return this.isLinked();
    }

    public void link(Session session, Boolean readonly) {
        this.getFileTable().connect(session, readonly);
    }

    public void linkDataSource(Session session, String source, boolean readOnly, boolean forStream, boolean forAppend, long checkInterval) {
        this.getFileTable().setDataSource(session, source);
        this.getFileTable().setDataReadOnly(readOnly);
        this.getFileTable().connect(session, readOnly, forStream, forAppend, checkInterval);
    }

    public String getDataSource(Session session) {
        return this.getFileTable().getDataSource();
    }

    public void setFileServer(FileServerObject fileServer) {
        this.getFileTable().setFileServer(fileServer);
    }

    public void unlink(Session session) {
        this.getFileTable().disconnect();
    }

    public void compress(Session session) {
        this.getFileTable().compress(session);
    }

    public void decompress(Session session) {
        this.getFileTable().decompress(session);
    }

    public void checkStatements(Session session) {
        super.compileInternalStatements(session);
    }

    @Override
    public Result getCollectionProperties(Session session) {
        File sourceFile;
        Result result = super.getCollectionProperties(session);
        if (((FileTable)this.table).getFileServer() != null) {
            result.navigator.add(new Object[]{"File Server", ((FileTable)this.table).getFileServer().getObjectName().name});
        }
        result.navigator.add(new Object[]{"File Type", this.getFileTable().getFileDescriptorName() != null ? "File Descriptor" : "Delimited"});
        if (this.getFileTable().getFileDescriptorName() != null) {
            result.navigator.add(new Object[]{"File Descriptor Name", this.getFileTable().getFileDescriptorName()});
            result.navigator.add(new Object[]{"Types Only", this.getFileTable().getTypesOnly()});
            result.navigator.add(new Object[]{"Record Types", this.getFileTable().getRecordTypes() != null && this.getFileTable().getRecordTypes().size() > 0 ? this.getFileTable().getRecordTypes().stream().map(r -> "'" + r + "'").collect(Collectors.joining(",")) : "*"});
        }
        PersistentStore persistentStore = this.getFileTable().getRowStore(session);
        FileTableSettings settings = null;
        if (persistentStore != null) {
            FileTableCache cache = (FileTableCache)persistentStore.getCache();
            if (cache != null) {
                this.appendLinkedStatus(result, cache.getFileName() != null);
                result.navigator.add(new Object[]{"Source", this.getFileTable().getDataSource()});
                result.navigator.add(new Object[]{"Compressed", cache.isFileCompressed()});
                settings = cache.getTextFileSettings();
            } else {
                this.appendLinkedStatus(result, false);
                result.navigator.add(new Object[]{"Source", this.getFileTable().getDataSource()});
            }
        } else {
            this.appendLinkedStatus(result, false);
        }
        if (settings == null) {
            settings = this.getFileTable().getFileTableSettings(null);
        }
        result.navigator.add(new Object[]{"Compression Block Size", settings.blockSize});
        if (settings.ignoreFirstLines > 0) {
            result.navigator.add(new Object[]{"Ignore First Lines", settings.ignoreFirstLines});
        } else {
            result.navigator.add(new Object[]{"Ignore First", settings.ignoreFirst});
        }
        result.navigator.add(new Object[]{"Cache Rows", settings.maxCacheRows});
        result.navigator.add(new Object[]{"Cache Size", settings.maxCacheBytes});
        result.navigator.add(new Object[]{"Read Buffer Size", settings.readBufferSize});
        result.navigator.add(new Object[]{"File Name", settings.getFileName() != null ? settings.getFileName() : ""});
        result.navigator.add(new Object[]{"Encoding", settings.stringEncoding});
        if (this.getFileTable().getFileDescriptorName() == null) {
            result.navigator.add(new Object[]{"------------", "------------"});
            result.navigator.add(new Object[]{"Field Separator", settings.fs});
            result.navigator.add(new Object[]{"Varchar Separator", settings.vs});
            result.navigator.add(new Object[]{"Long Varchar Separator", settings.lvs});
            result.navigator.add(new Object[]{"Is Quoted", settings.isQuoted});
            result.navigator.add(new Object[]{"Is All Quoted", settings.isAllQuoted});
        }
        String sourceFileSize = "n/a";
        String lastModifiedAt = "n/a";
        if (settings.getFileName() != null && settings.getFileName().length() > 0 && (sourceFile = new File(settings.getFileName())).exists()) {
            sourceFileSize = String.valueOf(sourceFile.length() + " bytes");
            lastModifiedAt = DataspaceDateTime.formatTimestampForResultSet(session, sourceFile.lastModified());
        }
        result.navigator.add(new Object[]{"Source File Size", sourceFileSize});
        result.navigator.add(new Object[]{"Source File Last Modified At", lastModifiedAt});
        result.navigator.add(new Object[]{"------------", "------------"});
        result.navigator.add(new Object[]{"For Append", this.getFileTable().isForAppend()});
        if (this.getFileTable().isForAppend()) {
            AppendableFileTableReader.Statistics statistics = this.getFileTable().getAppendableStatistics();
            if (statistics != null) {
                result.navigator.add(new Object[]{"Started At", DataspaceDateTime.formatTimestampForResultSet(session, statistics.getStartedAt())});
                result.navigator.add(new Object[]{"Stopped At", DataspaceDateTime.formatTimestampForResultSet(session, statistics.getStoppedAt())});
                result.navigator.add(new Object[]{"Suspend On Fail", statistics.isSuspendOnFail()});
                result.navigator.add(new Object[]{"Suspended At", DataspaceDateTime.formatTimestampForResultSet(session, statistics.getSuspendTime())});
                result.navigator.add(new Object[]{"Check Interval", statistics.getCheckInterval() + " ms"});
                result.navigator.add(new Object[]{"Current Position", statistics.getCurrentPosition()});
                result.navigator.add(new Object[]{"Source File Length", statistics.getFileLength() >= 0L ? Long.valueOf(statistics.getFileLength()) : "n/a"});
                if (statistics.isFileNotFound()) {
                    result.navigator.add(new Object[]{"Source File Doesn't Exist Since", DataspaceDateTime.formatTimestampForResultSet(session, statistics.getFileNotFoundSince())});
                } else {
                    result.navigator.add(new Object[]{"Source File Exists Since", DataspaceDateTime.formatTimestampForResultSet(session, statistics.getFileFoundSince())});
                }
                result.navigator.add(new Object[]{"Source File Truncated At", DataspaceDateTime.formatTimestampForResultSet(session, statistics.getFileTruncatedAt())});
                result.navigator.add(new Object[]{"Last Row Read At", DataspaceDateTime.formatTimestampForResultSet(session, statistics.getLastRowReadAt())});
                result.navigator.add(new Object[]{"Last Row Indexed At", DataspaceDateTime.formatTimestampForResultSet(session, statistics.getLastRowIndexedAt())});
                result.navigator.add(new Object[]{"Current Block Reading Since", DataspaceDateTime.formatTimestampForResultSet(session, statistics.getLastContinuousBlockReadSince())});
                result.navigator.add(new Object[]{"Malformed Line Count", statistics.getMalformedLinesCount()});
                String exception = "none";
                if (statistics.getLastException() != null) {
                    StringWriter writer = new StringWriter();
                    statistics.getLastException().printStackTrace(new PrintWriter(writer));
                    exception = writer.toString();
                }
                result.navigator.add(new Object[]{"Last Exception At", DataspaceDateTime.formatTimestampForResultSet(session, statistics.getLastExceptionAt())});
                result.navigator.add(new Object[]{"Last Exception", exception});
                result.navigator.add(new Object[]{"Last Exception Row Text", statistics.getLastExceptionRowText() != null ? statistics.getLastExceptionRowText() : "n/a"});
                result.navigator.add(new Object[]{"Skip Size", statistics.getSkipSize()});
            } else {
                result.navigator.add(new Object[]{"Check Interval", (this.getFileTable().getCheckInterval() != -1L ? this.getFileTable().getCheckInterval() : 500L) + " ms"});
            }
        }
        return result;
    }

    private void appendLinkedStatus(Result result, boolean status) {
        result.navigator.add(new Object[]{"Linked Status", status ? "LINKED" : "UNLINKED"});
    }

    public AppendableFileTableReader.Statistics getAppendableStatistics(Session session) {
        return this.getFileTable().getAppendableStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onAggregateOthers(DataspaceStateHolder holder) {
        String dataSource = this.getFileTable().getDataSource();
        if (this.getFileTable().isConnected()) {
            ConnectionState connectionState = this.getFileTable().getConnectionState();
            if (connectionState == ConnectionState.OPEN) {
                if (dataSource != null && dataSource.length() > 0) {
                    try {
                        if (!this.getFileTable().existsDataSource()) {
                            throw new Exception("Data source doesn't exist or cannot be read.");
                        }
                    }
                    catch (Exception exception) {
                        holder.setSuspectState(DataspaceStateHolder.dataSource, exception.getMessage());
                    }
                }
            } else {
                holder.setSuspectState(DataspaceStateHolder.serverConnection, "server state is '" + String.valueOf((Object)connectionState) + "'");
            }
        }
        if (this.getFileTable().getFileDescriptorName() != null) {
            try {
                if (!FileDescriptorRepositoryUtils.existsFileDescriptor(this.getFileTable().getFileDescriptorName())) {
                    throw new Exception("File descriptor doesn't exist.");
                }
            }
            catch (Exception exception) {
                holder.setSuspectState(DataspaceStateHolder.outOfSync, exception.getMessage());
            }
            if (!this.isDescriptorInSync()) {
                holder.setSuspectState(DataspaceStateHolder.outOfSync, "File descriptor has changed. Execute 'check file table' operation to refresh file descriptor.");
            }
            try (Session session = this.dataspace.createSession();){
                this.checkTuplesAndDescriptorInSync(session);
            }
            catch (Exception exception) {
                holder.setSuspectState(DataspaceStateHolder.outOfSync, "Table columns and file descriptor out of sync. " + exception.getMessage());
            }
        }
    }

    @Override
    protected List<Class<? extends StateHolder.SuspectStateOriginator>> getExposeCollectionClassesOthers() {
        return Arrays.asList(DataspaceStateHolder.DataSourceDataspaceSuspectStateOriginator.class);
    }

    @Override
    public void initForStreaming() {
        this.getFileTable().initForStreaming();
    }

    @Override
    public Object[] materializeRowForStream(Session session, Object rowParser, Object row) {
        return this.getFileTable().materializeRowForStream(session, rowParser, row);
    }

    @Override
    public Object getNextRowForStream() {
        return this.getFileTable().getNextRowForStream();
    }

    @Override
    public void initParserWithRow(Object parser, Object row) {
        this.getFileTable().initParserWithRow(parser, row);
    }

    @Override
    public Object createRowParser() {
        return this.getFileTable().createRowParser();
    }

    public void setFileDescriptorName(String fileDescriptorName) {
        this.getFileTable().setFileDescriptorName(fileDescriptorName);
    }

    public void setTypesOnly(boolean typesOnly) {
        this.getFileTable().setTypesOnly(typesOnly);
    }

    public void setRecordTypes(List<String> recordTypes) {
        this.getFileTable().setRecordTypes(recordTypes);
    }

    public FileTable getFileTable() {
        return (FileTable)this.table;
    }

    public void truncate(Session session, boolean force) {
        this.getFileTable().truncate(session, force);
    }

    public void fireNewRowIndexedTrigger(Session session, Object[] data) {
        this.getFileTable().fireTriggers(session, Trigger.Type.INSERT_AFTER_ROW, null, data, null);
    }

    @Override
    public void close() {
        try {
            this.getFileTable().disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = super.getReferences();
        if (this.getFileTable() != null && this.getFileTable().getFileDescriptorName() != null) {
            set.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetFileDescriptorObjectName(this.getFileTable().getFileDescriptorName()));
        }
        return set;
    }

    public void setSuspendOnFail(Session session, boolean suspendOnFail) {
        this.getFileTable().setSuspendOnFail(suspendOnFail);
    }

    public boolean isSuspendOnFail(Session session) {
        return this.isSuspendOnFail();
    }

    public boolean isSuspendOnFail() {
        return this.getFileTable().isSuspendOnFail();
    }

    public void resume(Session session) {
        this.getFileTable().resume(session);
    }

    public void logInfo(String message) {
        this.log(Trace.Level.INFO, message);
    }

    public void logError(String message) {
        this.log(Trace.Level.ERROR, message);
    }

    public void logDebug(String message) {
        this.log(Trace.Level.DEBUG, message);
    }

    public void log(Trace.Level info, String message) {
        FileTable.log(info, this.dataspace, this.getObjectName(), message);
    }
}

