/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.fspace.hadoop;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.NotLoggable;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.fspace.hadoop.HadoopVirtualTableType;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.server.FileServerObject;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.job.ClusterMetrics;
import com.streamscape.lib.job.JobProviderable;
import com.streamscape.lib.job.JobStatus;
import com.streamscape.lib.job.JobsManager;
import com.streamscape.service.osf.clients.ClientConnection;
import java.util.Locale;

public class HadoopVirtualTableCollection
extends TableCollection
implements VirtualTable.VirtualTableHelper,
NotLoggable {
    private HadoopVirtualTableType hadoopVirtualTableType;

    public HadoopVirtualTableCollection(DataspaceStore database, NameManager.ObjectName name, HadoopVirtualTableType hadoopVirtualTableType) {
        super(database, name, CollectionType.VTABLE, MemoryModel.MEMORY, 2);
        this.hadoopVirtualTableType = hadoopVirtualTableType;
    }

    @Override
    public String getSQL() {
        return "";
    }

    public void checkStatements(Session session) {
        super.compileInternalStatements(session);
    }

    @Override
    public Result getCollectionProperties(Session session) {
        return super.getCollectionProperties(session);
    }

    @Override
    public void insertIntoExternal(Session session, Object[] data, int[] jdbcTypes) {
        throw new DataspaceException("Insertion into '" + this.name.name + "' not allowed.");
    }

    @Override
    public Result executeExternalUpdate(Session session, String sql, Object[] data, int[] jdbcTypes) {
        throw new DataspaceException("Update of '" + this.name.name + "' not allowed.");
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        NameManager.ObjectName viewName = this.store.nameManager.newObjectName(this.name.name, this.name.isNameQuoted, 3);
        viewName.schema = this.name.schema;
        this.table = TableUtil.newVirtualTable(this.store, viewName, this, 2);
        this.addColumn(this.table, "ServerName", Type.STRING);
        switch (this.hadoopVirtualTableType) {
            case HADOOP_APPLICATIONS: {
                this.addColumn(this.table, "JobName", Type.STRING);
                this.addColumn(this.table, "JobId", Type.STRING);
                this.addColumn(this.table, "State", Type.STRING);
                this.addColumn(this.table, "User", Type.STRING);
                this.addColumn(this.table, "StartTime", Type.SQL_TIMESTAMP);
                this.addColumn(this.table, "FinishTime", Type.SQL_TIMESTAMP);
                this.addColumn(this.table, "FailureInfo", Type.STRING);
                this.addColumn(this.table, "Progress", Type.STRING);
                NameManager.ObjectName internalTableIndexName = NameManager.newInfoSchemaObjectName(this.table.getObjectName().name, this.table.getObjectName().isNameQuoted, 21);
                this.table.createPrimaryKeyConstraint(internalTableIndexName, new int[]{0, 1, 2}, true);
                this.table.setColumnStructures();
                break;
            }
            case HADOOP_CLUSTER_METRICS: {
                this.addColumn(this.table, "JobsSubmitted", Type.SQL_INTEGER);
                this.addColumn(this.table, "JobsRunning", Type.SQL_INTEGER);
                this.addColumn(this.table, "JobsCompeted", Type.SQL_INTEGER);
                this.addColumn(this.table, "NodeManagersCount", Type.SQL_INTEGER);
                NameManager.ObjectName internalTableIndexName = NameManager.newInfoSchemaObjectName(this.table.getObjectName().name, this.table.getObjectName().isNameQuoted, 21);
                this.table.createPrimaryKeyConstraint(internalTableIndexName, new int[]{0}, true);
                this.table.setColumnStructures();
            }
        }
        super.compile(session, parentObject);
        if (this.store.getStoreState().isStarted()) {
            this.open(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void materialize(Session session) {
        this.table.getRowStore(session).removeAll();
        try {
            Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(session.getCurrentDataspaceName().name, 27);
            block18: while (it.hasNext()) {
                FileServerObject fileServerObject;
                ServerObject server = (ServerObject)it.next();
                if (!(server instanceof FileServerObject) || !(fileServerObject = (FileServerObject)server).hasConnection()) continue;
                ClientConnection connection = null;
                JobsManager jobsManager = null;
                try {
                    connection = fileServerObject.createConnection("VirtualTableHelperConnection" + session.getId());
                    if (!(connection instanceof JobProviderable)) continue;
                    jobsManager = ((JobProviderable)((Object)connection)).createJobProvider().createJobsManager();
                    jobsManager.init(fileServerObject.getDataspace());
                    switch (this.hadoopVirtualTableType) {
                        case HADOOP_APPLICATIONS: {
                            ClassLoader loader = Thread.currentThread().getContextClassLoader();
                            ClassLoader systemClassLoaderChain = fileServerObject.getDataspace().getPackageManifestManager().getManifestClassLoader();
                            Thread.currentThread().setContextClassLoader(systemClassLoaderChain);
                            JobStatus[] statuses = new JobStatus[]{};
                            try {
                                statuses = jobsManager.listJobsStatus();
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(loader);
                            }
                            for (JobStatus status : statuses) {
                                Object[] temp = new Object[this.table.getColumnCount()];
                                temp[0] = fileServerObject.getObjectName().name;
                                temp[1] = status.getName();
                                temp[2] = status.getJobId().getJobId();
                                temp[3] = status.getState().getStateName();
                                temp[4] = status.getUser();
                                temp[5] = new TimestampData(status.getStartTime());
                                temp[6] = new TimestampData(status.getFinishTime());
                                temp[7] = status.getFailureInfo();
                                temp[8] = status.getProgress() != -1.0f ? String.format(Locale.ENGLISH, "%.0f%%", Float.valueOf(status.getProgress() * 100.0f)) : "N/A";
                                this.table.insertNoCheckFromLog(session, temp);
                            }
                            continue block18;
                        }
                        case HADOOP_CLUSTER_METRICS: {
                            ClassLoader loader = Thread.currentThread().getContextClassLoader();
                            ClassLoader systemClassLoaderChain = fileServerObject.getDataspace().getPackageManifestManager().getManifestClassLoader();
                            Thread.currentThread().setContextClassLoader(systemClassLoaderChain);
                            try {
                                ClusterMetrics metrics = jobsManager.getClusterMetrics();
                                Object[] temp = new Object[this.table.getColumnCount()];
                                temp[0] = fileServerObject.getObjectName().name;
                                temp[1] = metrics.getJobsSubmitted();
                                temp[2] = metrics.getJobsRunning();
                                temp[3] = metrics.getJobsCompleted();
                                temp[4] = metrics.getNodeManagersCount();
                                this.table.insertNoCheckFromLog(session, temp);
                                continue block18;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(loader);
                                continue block18;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    Trace.logError(this, exception.getMessage());
                    Trace.logException(this, exception, true);
                }
                finally {
                    if (connection != null) {
                        fileServerObject.removeConnection(connection);
                    }
                    if (jobsManager == null) continue;
                    jobsManager.close();
                }
            }
            return;
        }
        catch (Throwable error) {
            Trace.logException(this, error, true);
            throw new DataspaceException(error);
        }
    }

    @Override
    public boolean hasParameter(String name) {
        return false;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = super.getReferences();
        return set;
    }
}

