/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.fspace.directory;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.fspace.directory.DirectoryTableProxy;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.procedure.AppendValueToDirectoryTableExpression;
import com.streamscape.ds.schema.server.FileServerObject;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.schema.table.VirtualTable;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.FileSystemClientConnection;
import com.streamscape.lib.fs.client.dropbox.DropBoxFileSystemClientConnection;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dropbox.DropBoxAutoConnectFileSystem;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.service.osf.clients.ClientConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DirectoryTableCollection
extends TableCollection
implements AccessibleObject,
VirtualTable.VirtualTableHelper {
    private FileServerObject fileServer = null;
    private String path = null;
    private boolean recursive = false;
    private ClientConnection connection = null;
    private static final int PERMISSIONS = 0;
    private static final int OWNER = 1;
    private static final int GROUP = 2;
    private static final int SIZE = 3;
    private static final int MODIFICATION_TIME = 4;
    private static final int BLOCK_SIZE = 5;
    private static final int REPLICATION = 6;
    private static final int NAME = 7;
    private static final int DATA = 8;
    public static final String DATA_VALUE = "[File Data]";
    static final char[] units = new char[]{'B', 'K', 'M', 'G', 'T'};

    public DirectoryTableCollection(DataspaceStore database, NameManager.ObjectName name) {
        super(database, name, CollectionType.DIRECTORY_TABLE, MemoryModel.MEMORY, 2);
    }

    public FileServerObject getServer() {
        return this.fileServer;
    }

    public void setServer(FileServerObject fileServer) {
        this.fileServer = fileServer;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getServerType(Session session) {
        if (this.getServer() != null) {
            return this.getServer().getServerType();
        }
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        NameManager.ObjectName viewName = this.store.nameManager.newObjectName(this.name.name, this.name.isNameQuoted, 3);
        viewName.schema = this.name.schema;
        this.table = TableUtil.newVirtualTable(this.store, viewName, this, 2);
        ((VirtualTable)this.table).setCollectionType(CollectionType.DIRECTORY_TABLE);
        try {
            this.addColumn(this.table, "Permissions", Type.STRING);
            this.addColumn(this.table, "Owner", Type.STRING);
            this.addColumn(this.table, "Group", Type.STRING);
            this.addColumn(this.table, "Size", Type.SQL_BIGINT);
            this.addColumn(this.table, "ModificationTime", Type.SQL_TIMESTAMP);
            this.addColumn(this.table, "BlockSize", Type.STRING);
            this.addColumn(this.table, "Replication", Type.SQL_INTEGER);
            this.addColumn(this.table, "Name", Type.STRING);
            this.addColumn(this.table, "Data", Types.getParameterSQLType(session, Object.class));
            NameManager.ObjectName internalTableIndexName = NameManager.newInfoSchemaObjectName(this.table.getObjectName().name, this.table.getObjectName().isNameQuoted, 21);
            this.table.createPrimaryKeyConstraint(internalTableIndexName, new int[]{7}, true);
            this.table.setColumnStructures();
        }
        catch (Throwable exception) {
            Trace.logError(this, "Failed to compile directory table {}", this.getObjectName().getSchemaQualifiedStatementName());
            Trace.logException(this, exception, true);
            throw new DataspaceException(exception.getMessage());
        }
        super.compile(session, parentObject);
        if (this.store.getStoreState().isStarted()) {
            this.open(session);
        }
    }

    @Override
    public void destroy(Session session) {
        super.destroy(session);
        if (this.connection != null) {
            this.fileServer.removeConnection(this.connection);
        }
    }

    public FileSystem getFileSystem(Session session) {
        FileSystemClientConnection c = (FileSystemClientConnection)((Object)this.getConnection());
        if (c instanceof DropBoxFileSystemClientConnection) {
            if (c.getFileSystem() == null) {
                DropBoxAutoConnectFileSystem fileSystem = new DropBoxAutoConnectFileSystem(session);
                ((DropBoxFileSystemClientConnection)c).setFileSystem(fileSystem);
            }
            return c.getFileSystem();
        }
        return ((FileSystemClientConnection)((Object)this.getConnection())).getFileSystem();
    }

    public ClientConnection getConnection() {
        if (this.connection != null && this.connection.getState() == ConnectionState.CLOSED) {
            this.fileServer.removeConnection(this.connection);
            this.connection = null;
        }
        if (this.connection == null) {
            this.connection = this.createAndConnectConnection();
        }
        return this.connection;
    }

    private ClientConnection createAndConnectConnection() {
        ClientConnection connection = this.fileServer.createConnection("Directory$" + this.name.name);
        Trace.logDebug(this, "Connection created.");
        try {
            Trace.logDebug(this, "Opening up a client connection...");
            try {
                this.fileServer.connectConnection(connection);
            }
            catch (Throwable exception) {
                this.fileServer.removeConnection(connection);
                throw exception;
            }
            return connection;
        }
        catch (Throwable exception) {
            Trace.logError(this, "Failed to  get connection for directory table {}", this.getObjectName().getSchemaQualifiedStatementName());
            Trace.logException(this, exception, false);
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            throw new DataspaceException(exception.getMessage());
        }
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new DirectoryTableProxy();
    }

    @Override
    public String getSQL() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE").append(' ').append("DIRECTORY").append(' ').append("TABLE").append(' ');
        buffer.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        buffer.append("AT").append(' ').append(this.fileServer.getObjectName().getSchemaQualifiedStatementName());
        if (this.path != null) {
            buffer.append(' ').append("PATH").append(' ');
            buffer.append('\'').append(this.path).append('\'');
        }
        if (this.recursive) {
            buffer.append(' ').append("RECURSIVE").append(' ');
        }
        return buffer.toString();
    }

    public void checkStatements(Session session) {
        super.compileInternalStatements(session);
    }

    @Override
    public Result getCollectionProperties(Session session) {
        String state;
        Result result;
        block3: {
            result = super.getCollectionProperties(session);
            result.navigator.add(new Object[]{"Server", this.fileServer.getObjectName().name});
            state = "n/a";
            try {
                state = this.getConnection().getState().name();
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed get connection for directory table {}", this.getObjectName().getSchemaQualifiedStatementName());
                Trace.logException(this, exception, false);
                if (!Trace.isDebugEnabled(this.getClass())) break block3;
                Trace.logException(this, exception, true);
            }
        }
        result.navigator.add(new Object[]{"Connection State", state});
        if (this.path != null) {
            result.navigator.add(new Object[]{"Path", this.path});
        }
        return result;
    }

    @Override
    protected void onAggregateOthers(DataspaceStateHolder holder) {
        try {
            this.connection = this.getConnection();
            if (this.connection.getState() != ConnectionState.OPEN && this.connection.getState() != ConnectionState.CONNECTED) {
                throw new Exception("not opened for directory table");
            }
        }
        catch (Exception exception) {
            holder.setSuspectState(DataspaceStateHolder.serverConnection, exception.getMessage());
        }
    }

    @Override
    public void materialize(Session session) {
        this.table.getRowStore(session).removeAll();
        try {
            FileInfo pathDir = this.getFileSystem(session).getInfo(this.addTailingSlashForS3(this.path));
            String sep = this.getFileSystem(session).separator();
            for (FileInfo info : this.getFileSystem(session).list(this.addTailingSlashForS3(this.path), this.recursive)) {
                String name = info.getName();
                name = name.replaceAll("^" + Pattern.quote(sep), "");
                Object[] temp = new Object[this.table.getColumnCount()];
                temp[0] = (info.isDirectory() ? "d" : "-") + info.getPermissions().toString();
                temp[1] = info.getOwner();
                temp[2] = info.getGroup();
                temp[3] = info.getSize();
                temp[4] = session.getSqlTimestamp(info.getModificationTime());
                temp[5] = this.convertSize(info.getBlockSize());
                temp[6] = (int)info.getReplication();
                temp[7] = name;
                temp[8] = DATA_VALUE;
                this.table.insertNoCheckFromLog(session, temp);
            }
        }
        catch (Throwable exception) {
            Trace.logError(this, "Failed to materialize directory table {}", this.getObjectName().getSchemaQualifiedStatementName());
            Trace.logException(this, exception, false);
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            throw new DataspaceException(exception);
        }
    }

    @Override
    public void insertIntoExternal(Session session, Object[] data, int[] jdbcTypes) {
        this.insertIntoExternal(session, data, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertIntoExternal(Session session, Object[] data, boolean overwrite) {
        if (data[1] != null) {
            throw new DataspaceException("Value of 'Owner' column should be null.");
        }
        if (data[2] != null) {
            throw new DataspaceException("Value of 'Group' column should be null.");
        }
        if (data[3] != null) {
            throw new DataspaceException("Value of 'Size' column should be null.");
        }
        if (data[4] != null) {
            throw new DataspaceException("Value of 'ModificationTime' column should be null.");
        }
        FilePermissions permissions = null;
        Long blockSize = null;
        Integer replications = null;
        String filename = null;
        if (data[0] != null) {
            permissions = FilePermissions.parse(String.valueOf(data[0]));
        }
        if (data[5] != null) {
            blockSize = this.convertSize(String.valueOf(data[5]));
        }
        if (data[6] != null) {
            replications = (Integer)data[6];
        }
        if (data[7] != null) {
            filename = String.valueOf(data[7]);
            if (filename.length() == 0) {
                throw new DataspaceException("Filename column 'Name' should be not empty.");
            }
        } else {
            throw new DataspaceException("Filename column 'Name' should be not null.");
        }
        filename = this.buildFilePath(filename);
        this.checkOpened();
        OutputStream outputStream = null;
        try {
            int buffersize = session.getTransferBufferSize();
            try {
                FileSystem fs = this.getFileSystem(session);
                if (!overwrite && fs.exists(filename)) {
                    throw new DataspaceException("File '" + filename + "' already exists.");
                }
                if (replications == null) {
                    replications = fs.getDefaultReplication(this.getPath());
                }
                if (blockSize == null) {
                    blockSize = fs.getDefaultBlockSize(this.getPath());
                }
                outputStream = fs.create(filename, overwrite, permissions, buffersize, replications, blockSize);
            }
            catch (IOException exception) {
                throw new DataspaceException("Failed to create file. Cause: " + exception.getMessage());
            }
            try {
                Object filedata = OtherTypeWrapper.unwrap(data[8]);
                if (filedata != null) {
                    session.sessionData.writeData(outputStream, filedata, null);
                }
            }
            catch (Exception exception) {
                throw new DataspaceException("Failed to write file. Cause: " + exception.getMessage());
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                    outputStream = null;
                }
                catch (Exception exception) {
                    throw new DataspaceException("Failed to write file. Cause: " + exception.getMessage());
                }
            }
        }
    }

    @Override
    public Result executeExternalUpdate(Session session, String sql, Object[] data, int[] jdbcTypes) {
        return Result.updateZeroResult;
    }

    @Override
    public boolean hasParameter(String name) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateDirectoryTable(Session session, Row row, Object[] changedData, int[] changedColumns) {
        this.checkOpened();
        String filename = (String)row.getData()[7];
        String filenamePath = this.buildFilePath(filename);
        List list = IntStream.of(changedColumns).boxed().collect(Collectors.toList());
        List unsupported = list.stream().filter(e -> e != 0 && e != 8 && e != 7).collect(Collectors.toList());
        if (unsupported.size() > 0) {
            String string;
            if (unsupported.size() > 0) {
                string = "s";
                throw new DataspaceException("Cannot update column" + string + " " + unsupported.stream().map(e -> this.table.getColumn((int)e).getNameString()).collect(Collectors.joining(",")) + ". Update of Permissions or Name or Data allowed only.");
            }
            string = "";
            throw new DataspaceException("Cannot update column" + string + " " + unsupported.stream().map(e -> this.table.getColumn((int)e).getNameString()).collect(Collectors.joining(",")) + ". Update of Permissions or Name or Data allowed only.");
        }
        try {
            FileSystem fs;
            block21: {
                fs = this.getFileSystem(session);
                if (list.remove((Object)0)) {
                    FilePermissions permissions = FilePermissions.parse(String.valueOf(changedData[0]));
                    fs.setPermissions(filenamePath, permissions);
                }
                if (list.remove((Object)8)) {
                    if (fs.isDirectory(filenamePath)) {
                        throw new DataspaceException("Cannot set Data for directory.");
                    }
                    Object newData = OtherTypeWrapper.unwrap(changedData[8]);
                    if (newData instanceof AppendValueToDirectoryTableExpression) {
                        newData = ((AppendValueToDirectoryTableExpression)newData).getAppendValue();
                        OutputStream outputStream = null;
                        try {
                            int buffersize = session.getTransferBufferSize();
                            try {
                                outputStream = fs.append(filenamePath, buffersize);
                            }
                            catch (IOException exception) {
                                throw new DataspaceException("Failed to append to file. Cause: " + exception.getMessage());
                            }
                            try {
                                Object filedata = OtherTypeWrapper.unwrap(newData);
                                if (filedata != null) {
                                    session.sessionData.writeData(outputStream, filedata, null);
                                }
                                break block21;
                            }
                            catch (Exception exception) {
                                throw new DataspaceException("Failed to append file. Cause: " + exception.getMessage());
                            }
                        }
                        finally {
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                    outputStream = null;
                                }
                                catch (Exception exception) {
                                    throw new DataspaceException("Failed to append file. Cause: " + exception.getMessage());
                                }
                            }
                        }
                    }
                    Object[] dataDup = Arrays.copyOf(row.getData(), row.getData().length);
                    dataDup[0] = changedData[0];
                    dataDup[1] = null;
                    dataDup[2] = null;
                    dataDup[3] = null;
                    dataDup[4] = null;
                    dataDup[8] = newData;
                    this.insertIntoExternal(session, dataDup, true);
                }
            }
            if (!list.remove((Object)7)) return;
            fs.rename(this.buildFilePath(filename), this.buildFilePath((String)changedData[7]));
            return;
        }
        catch (Exception exception) {
            throw new DataspaceException("Failed to update file '" + filename + "'. Cause: " + exception.getMessage());
        }
    }

    public void deleteFromDirectoryTable(Session session, Row row) {
        Object filename = row.getData()[7];
        if (!(filename instanceof String)) {
            throw new DataspaceException("Invalid filename " + String.valueOf(row));
        }
        this.checkOpened();
        try {
            this.getFileSystem(session).delete(this.buildFilePath((String)filename), true);
        }
        catch (IOException exception) {
            throw new DataspaceException("Failed to delete file '" + String.valueOf(filename) + "'. Cause: " + exception.getMessage());
        }
    }

    private String buildFilePath(String filename) {
        return this.getPath() + "/" + filename;
    }

    private void checkOpened() {
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = super.getReferences();
        set.add(this.fileServer.getObjectName());
        return set;
    }

    public static boolean isDataColumn(Table table, int index) {
        return table instanceof VirtualTable && ((VirtualTable)table).getCollectionType() == CollectionType.DIRECTORY_TABLE && ((VirtualTable)table).getColumn(index).getNameString().equals("Data");
    }

    private String convertSize(long size) {
        int u;
        long usize = size;
        for (u = 0; size >= 1024L && u < units.length; size >>= 10, ++u) {
        }
        usize = u > 0 ? (usize -= size << 10 * u) : 0L;
        return String.valueOf(size) + units[u] + (usize != 0L ? this.convertSize(usize) : "");
    }

    private Long convertSize(String size) {
        if (size.length() > 0) {
            int i = 0;
            char sizeUnit = Character.toUpperCase(size.charAt(size.length() - 1));
            for (i = 0; i < units.length && units[i] != sizeUnit; ++i) {
            }
            if (i < units.length) {
                return Long.valueOf(size.substring(0, size.length() - 1)) << i * 10;
            }
            return Long.valueOf(size);
        }
        return 0L;
    }

    private String addTailingSlashForS3(String path) {
        return this.isS3FileSystem() && !path.endsWith("/") ? path + "/" : path;
    }

    private boolean isS3FileSystem() {
        return DropBoxUtils.isS3Path(this.path);
    }
}

