/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.fspace;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.fspace.hadoop.HadoopVirtualTableCollection;
import com.streamscape.ds.schema.collection.fspace.hadoop.HadoopVirtualTableType;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.collection.fspace.table.FileTableFactoryImpl;
import com.streamscape.ds.schema.collection.function.FunctionTableFactoryImpl;
import com.streamscape.ds.schema.collection.stream.SourceStreamFactoryImpl;
import com.streamscape.ds.session.Session;
import com.streamscape.sef.FabricNamingException;
import com.streamscape.sef.enums.EventScope;

public final class FSpace
extends AbstractDataspace {
    public FSpace(NameManager.ObjectName name, EventScope scope, Grantee owner, DataspaceStore provider) throws FabricNamingException {
        super(name, DataspaceType.FSPACE, scope, owner, provider);
        Trace.logDebug(this, "FSpace '" + name.name + "' instance creating...");
        Trace.logInfo(this, "FSpace '" + name.name + "' instance created.");
    }

    @Override
    protected void initializeCollectionFactories() {
        this.collectionFactoryFactories.registerCollectionFactory(FileTableFactoryImpl.class);
        this.collectionFactoryFactories.registerCollectionFactory(SourceStreamFactoryImpl.class);
        this.collectionFactoryFactories.registerCollectionFactory(FunctionTableFactoryImpl.class);
    }

    @Override
    protected void doInit(Session session) {
        super.doInit(session);
        this.initHadoopVirtualTables(session);
    }

    protected void initHadoopVirtualTables(Session session) {
        this.createHadoopVirtualTable(session, HadoopVirtualTableType.HADOOP_APPLICATIONS);
        this.createHadoopVirtualTable(session, HadoopVirtualTableType.HADOOP_CLUSTER_METRICS);
    }

    protected void createHadoopVirtualTable(Session session, HadoopVirtualTableType hadoopVirtualTableType) {
        try {
            NameManager.ObjectName vtableName = this.store.nameManager.newObjectName(hadoopVirtualTableType.getName(), false, 4);
            vtableName.setSchemaIfNull(this.name);
            if (this.store.schemaManager.findSchemaObject(vtableName) == null) {
                HadoopVirtualTableCollection hadoopVirtualTable = new HadoopVirtualTableCollection(this.store, vtableName, hadoopVirtualTableType);
                hadoopVirtualTable.compile(session, null);
                this.store.schemaManager.addSchemaObject(hadoopVirtualTable);
            }
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to initialize hadoop virtual table '" + hadoopVirtualTableType.getName() + "'.");
            Trace.logException(this, exception, true);
        }
    }

    @Override
    protected void doOpen(Session session) {
        super.doOpen(session);
        Iterator iter = this.store.schemaManager.dataspaceObjectIterator(this.getName(), 4);
        while (iter.hasNext()) {
            Object schemaObject = iter.next();
            if (!(schemaObject instanceof FileTableCollection)) continue;
            this.wrapInLogged("  Starting reader for file table " + ((SchemaObject)schemaObject).getObjectName().name + "...", () -> ((FileTableCollection)schemaObject).startAppendableFileTableReader(session));
        }
    }
}

