/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace.tables;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.cspace.instances.KGraphException;
import com.streamscape.ds.schema.collection.cspace.tables.AbstractCSpaceTableManager;
import com.streamscape.ds.schema.collection.cspace.tables.CSpaceSysTablesManager;
import com.streamscape.ds.schema.collection.cspace.tables.KGraphTableManager;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.schema.table.TableWorks;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KNodeTableManager
extends AbstractCSpaceTableManager {
    public static String TABLE_NAME = "KNODES";
    private Statement createKNodeStat;
    private Statement updateKNodeStat;
    private Statement getKNodeStat;
    private Statement getKNodeBySubjectKeyStat;
    private Statement removeKNodesForGraph;
    private Statement getKNodesByGraphIdStat;

    public KNodeTableManager(CSpaceSysTablesManager manager) {
        super(manager, TABLE_NAME);
    }

    public void initialize(Session session) {
        Collection collection = (Collection)this.manager.getStore().schemaManager.findSchemaObject(this.getTableName(), this.manager.getCSpace().getObjectName().name, 4);
        if (collection == null) {
            NameManager.ObjectName tableName = this.manager.getStore().nameManager.newObjectName(this.getTableName(), false, 4);
            tableName.schema = this.manager.getCSpace().getObjectName();
            collection = new TableCollection(this.manager.getStore(), tableName, MemoryModel.PERSISTENT, 6);
            Table table = collection.getBaseTable();
            TableUtil.addIdentityColumn(table, "KNODE_ID", Type.SQL_INTEGER);
            TableUtil.addColumn(table, "KGRAPH_ID", Type.SQL_INTEGER, false);
            TableUtil.addColumn(table, "KNODE_TYPE_NAME", Type.STRING, false);
            TableUtil.addColumn(table, "SUBJECT_KEY", Type.STRING, false);
            TableUtil.addColumn(table, "KNODE_FACETS", new OtherType("map", Map.class), false);
            NameManager.ObjectName primaryKeyName = NameManager.newInfoSchemaObjectName(tableName.name, tableName.isNameQuoted, 21);
            table.createPrimaryKeyConstraint(primaryKeyName, new int[]{table.getColumnIndex("KNODE_ID")}, true);
            table.setColumnStructures();
            collection.compile(session, null);
            this.manager.getStore().schemaManager.addSchemaObject(collection);
            if (table.getIndexList().length == 1) {
                TableWorks tableWorks = new TableWorks(session, table);
                NameManager.ObjectName typeSubKeyUniqueIndexName = this.manager.getStore().nameManager.newAutoName(table.getObjectName().name + "_KGRAPH_ID_TYPE_SUBJECT_KEY", table.getObjectName().schema, table.getObjectName(), 21);
                tableWorks.addIndex(new int[]{table.getColumnIndex("KGRAPH_ID"), table.getColumnIndex("KNODE_TYPE_NAME"), table.getColumnIndex("SUBJECT_KEY")}, typeSubKeyUniqueIndexName, true, null);
                Table kgraphsTable = (Table)this.manager.getStore().schemaManager.findSchemaObject(KGraphTableManager.TABLE_NAME, this.manager.getCSpace().getObjectName().name, 3);
                NameManager.ObjectName constraintName = this.manager.getStore().nameManager.newAutoName("FK_KNODE_KGRAPH_ID", table.getSchemaName(), table.getObjectName(), 6);
                OrderedHashSet refColSet = new OrderedHashSet();
                refColSet.add("KGRAPH_ID");
                OrderedHashSet mainColSet = new OrderedHashSet();
                mainColSet.add("KGRAPH_ID");
                Constraint constraint = new Constraint(constraintName, table.getObjectName(), refColSet, kgraphsTable.getObjectName(), mainColSet, 0, 0, 3, 59);
                constraint.core.mainTable = kgraphsTable;
                constraint.setColumnsIndexes(table);
                tableWorks.addForeignKey(constraint);
            }
        }
    }

    public synchronized long createKNode(Session session, Long kGraphId, String typeName, String subjectKey, Map<String, Object> facets) {
        if (this.createKNodeStat == null) {
            String SQL = "insert into " + this.getFullTableName() + "(  KGRAPH_ID,   KNODE_TYPE_NAME,   SUBJECT_KEY,   KNODE_FACETS)values (?,?,?,?)";
            this.createKNodeStat = session.compileStatement(SQL);
        }
        Result result = session.executeCompiledStatement(this.createKNodeStat, new Object[]{kGraphId, typeName, subjectKey, facets});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to create KNode '" + typeName + ":" + subjectKey + "'.");
        Number identity = session.getLastIdentity();
        if (identity != null) {
            return identity.longValue();
        }
        return this.getKNodeBySubjectKey(session, kGraphId, typeName, subjectKey).getKNodeId();
    }

    public synchronized void updateKNode(Session session, Long kGraphId, String typeName, String subjectKey, Map<String, Object> facets) {
        if (this.updateKNodeStat == null) {
            String SQL = "update " + this.getFullTableName() + "set KNODE_FACETS = ? where  KGRAPH_ID = ? and   KNODE_TYPE_NAME = ? and   SUBJECT_KEY = ?";
            this.updateKNodeStat = session.compileStatement(SQL);
        }
        Result result = session.executeCompiledStatement(this.updateKNodeStat, new Object[]{facets, kGraphId, typeName, subjectKey});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to create KNode '" + typeName + ":" + subjectKey + "'.");
        if (result.getUpdateCount() != 1) {
            throw new KGraphException("Unable to update KNode '" + typeName + ":" + subjectKey + "', knode doesn't exist.");
        }
    }

    public synchronized KNodeRow getKNode(Session session, String kNodeId) {
        if (this.getKNodeStat == null) {
            this.getKNodeStat = session.compileStatement("select KGRAPH_ID,KNODE_ID,KNODE_TYPE_NAME,SUBJECT_KEY,KNODE_FACETS from " + this.getFullTableName() + " where KNODE_ID = ?");
        }
        Result result = session.executeCompiledStatement(this.getKNodeStat, new Object[]{kNodeId});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to get KNode '" + kNodeId + "'.");
        RowSetNavigator navigator = result.navigator;
        if (navigator.next()) {
            return new KNodeRow(((Number)navigator.getCurrent(0)).longValue(), ((Number)navigator.getCurrent(1)).longValue(), (String)navigator.getCurrent(2), (String)navigator.getCurrent(3), (Map)navigator.getCurrent(4));
        }
        return null;
    }

    public synchronized List<KNodeRow> getKNodesByGraphId(Session session, Long kGraphId) {
        if (this.getKNodesByGraphIdStat == null) {
            this.getKNodesByGraphIdStat = session.compileStatement("select KGRAPH_ID,KNODE_ID,KNODE_TYPE_NAME,SUBJECT_KEY,KNODE_FACETS from " + this.getFullTableName() + " where KGRAPH_ID = ?");
        }
        Result result = session.executeCompiledStatement(this.getKNodesByGraphIdStat, new Object[]{kGraphId});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to get KNodes for kgraph '" + kGraphId + "'.");
        ArrayList<KNodeRow> knodes = new ArrayList<KNodeRow>();
        RowSetNavigator navigator = result.navigator;
        while (navigator.next()) {
            knodes.add(new KNodeRow(((Number)navigator.getCurrent(0)).longValue(), ((Number)navigator.getCurrent(1)).longValue(), (String)navigator.getCurrent(2), (String)navigator.getCurrent(3), (Map)OtherTypeWrapper.unwrap(navigator.getCurrent(4))));
        }
        return knodes;
    }

    public synchronized KNodeRow getKNodeBySubjectKey(Session session, Long kGraphId, String kNodeTypeName, String kNodeSubjectKey) {
        if (this.getKNodeBySubjectKeyStat == null) {
            this.getKNodeBySubjectKeyStat = session.compileStatement("select KGRAPH_ID,KNODE_ID,KNODE_TYPE_NAME,SUBJECT_KEY,KNODE_FACETS from " + this.getFullTableName() + " where KGRAPH_ID = ? && KNODE_TYPE_NAME = ? && SUBJECT_KEY = ?");
        }
        Result result = session.executeCompiledStatement(this.getKNodeBySubjectKeyStat, new Object[]{kGraphId, kNodeTypeName, kNodeSubjectKey});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to get KNode '" + kNodeTypeName + ":" + kNodeSubjectKey + "'.");
        RowSetNavigator navigator = result.navigator;
        if (navigator.next()) {
            return new KNodeRow(((Number)navigator.getCurrent(0)).longValue(), ((Number)navigator.getCurrent(1)).longValue(), (String)navigator.getCurrent(2), (String)navigator.getCurrent(3), (Map)OtherTypeWrapper.unwrap(navigator.getCurrent(4)));
        }
        return null;
    }

    public synchronized long getKNodeIdBySubjectKey(Session session, Long kGraphId, String kNodeTypeName, String kNodeSubjectKey) {
        KNodeRow row = this.getKNodeBySubjectKey(session, kGraphId, kNodeTypeName, kNodeSubjectKey);
        if (row != null) {
            return row.getKNodeId();
        }
        return -1L;
    }

    public synchronized void deleteKNodesByKGraphId(Session session, long kGraphId) {
        if (this.removeKNodesForGraph == null) {
            this.removeKNodesForGraph = session.compileStatement("delete from " + this.getFullTableName() + " where KGRAPH_ID = ?");
        }
        Result result = session.executeCompiledStatement(this.removeKNodesForGraph, new Object[]{kGraphId});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to remove KNodes for graph " + kGraphId + ".");
    }

    public void reset() {
        this.createKNodeStat = null;
        this.updateKNodeStat = null;
        this.getKNodeStat = null;
        this.getKNodeBySubjectKeyStat = null;
        this.removeKNodesForGraph = null;
        this.getKNodesByGraphIdStat = null;
    }

    public static class KNodeRow {
        private long kGraphId;
        private long kNodeId;
        private String typeName;
        private String subjectKey;
        private Map<String, Object> facets;

        public KNodeRow(long kGraphId, long kNodeId, String typeName, String subjectKey, Map<String, Object> facets) {
            this.kGraphId = kGraphId;
            this.kNodeId = kNodeId;
            this.typeName = typeName;
            this.subjectKey = subjectKey;
            this.facets = facets;
        }

        public long getkGraphId() {
            return this.kGraphId;
        }

        public long getKNodeId() {
            return this.kNodeId;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getSubjectKey() {
            return this.subjectKey;
        }

        public Map<String, Object> getFacets() {
            return this.facets;
        }

        public String getCompositeKey() {
            return this.typeName + ":" + this.subjectKey;
        }
    }
}

