/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace.tables;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.cspace.tables.AbstractCSpaceTableManager;
import com.streamscape.ds.schema.collection.cspace.tables.CSpaceSysTablesManager;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.schema.table.TableWorks;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;

public class KGraphTableManager
extends AbstractCSpaceTableManager {
    public static String TABLE_NAME = "KGRAPHS";
    private Statement createKGraphStat;
    private Statement removeKGraphStat;
    private Statement getKGraphStat;

    public KGraphTableManager(CSpaceSysTablesManager manager) {
        super(manager, TABLE_NAME);
    }

    public void initialize(Session session) {
        Collection collection = (Collection)this.manager.getStore().schemaManager.findSchemaObject(this.getTableName(), this.manager.getCSpace().getObjectName().name, 4);
        if (collection == null) {
            NameManager.ObjectName tableName = this.manager.getStore().nameManager.newObjectName(this.getTableName(), false, 4);
            tableName.schema = this.manager.getCSpace().getObjectName();
            collection = new TableCollection(this.manager.getStore(), tableName, MemoryModel.PERSISTENT, 6);
            Table table = collection.getBaseTable();
            TableUtil.addIdentityColumn(table, "KGRAPH_ID", Type.SQL_INTEGER);
            TableUtil.addColumn(table, "KGRAPH_NAME", Type.STRING, false);
            TableUtil.addColumn(table, "KGRAPH_TYPE_NAME", Type.STRING, false);
            TableUtil.addColumn(table, "COMMENT", Type.STRING);
            NameManager.ObjectName primaryKeyName = NameManager.newInfoSchemaObjectName(tableName.name, tableName.isNameQuoted, 21);
            table.createPrimaryKeyConstraint(primaryKeyName, new int[]{table.getColumnIndex("KGRAPH_ID")}, true);
            table.setColumnStructures();
            collection.compile(session, null);
            this.manager.getStore().schemaManager.addSchemaObject(collection);
            TableWorks tableWorks = new TableWorks(session, table);
            if (table.getIndexList().length == 1) {
                NameManager.ObjectName kgraphNameUniqueIndexName = this.manager.getStore().nameManager.newAutoName(table.getObjectName().name + "_KGRAPH_NAME", table.getObjectName().schema, table.getObjectName(), 21);
                tableWorks.addIndex(new int[]{table.getColumnIndex("KGRAPH_NAME")}, kgraphNameUniqueIndexName, true, null);
            }
        }
    }

    public synchronized long createKGraph(Session session, String kgraphName, String typeName, String comment) {
        if (this.createKGraphStat == null) {
            String SQL = "insert into " + this.getFullTableName() + "(  KGRAPH_NAME,   KGRAPH_TYPE_NAME,   COMMENT )values (?,?,?)";
            this.createKGraphStat = session.compileStatement(SQL);
        }
        Result result = session.executeCompiledStatement(this.createKGraphStat, new Object[]{kgraphName, typeName, comment});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to create KGraph '" + kgraphName + "'.");
        Number identity = session.getLastIdentity();
        if (identity != null) {
            return identity.longValue();
        }
        return this.getKGraph(session, kgraphName).getKGraphId();
    }

    public synchronized void deleteKGraph(Session session, String kGraphName) {
        if (this.removeKGraphStat == null) {
            this.removeKGraphStat = session.compileStatement("delete from " + this.getFullTableName() + " where KGRAPH_NAME = ?");
        }
        Result result = session.executeCompiledStatement(this.removeKGraphStat, new Object[]{kGraphName});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to remove KGraph '" + kGraphName + "'.");
    }

    public synchronized KGraphRow getKGraph(Session session, String kGraphName) {
        if (this.getKGraphStat == null) {
            this.getKGraphStat = session.compileStatement("select KGRAPH_ID,KGRAPH_NAME,KGRAPH_TYPE_NAME,COMMENT from " + this.getFullTableName() + " where KGRAPH_NAME = ?");
        }
        Result result = session.executeCompiledStatement(this.getKGraphStat, new Object[]{kGraphName});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to get KGraph '" + kGraphName + "'.");
        RowSetNavigator navigator = result.navigator;
        if (navigator.next()) {
            return new KGraphRow(((Number)navigator.getCurrent(0)).longValue(), (String)navigator.getCurrent(1), (String)navigator.getCurrent(2), (String)navigator.getCurrent(3));
        }
        return null;
    }

    public void reset() {
        this.createKGraphStat = null;
        this.removeKGraphStat = null;
        this.getKGraphStat = null;
    }

    public static class KGraphRow {
        private long kGraphId;
        private String kGraphName;
        private String kGraphTypeName;
        private String comment;

        public KGraphRow(long kGraphId, String kGraphName, String kGraphTypeName, String comment) {
            this.kGraphId = kGraphId;
            this.kGraphName = kGraphName;
            this.kGraphTypeName = kGraphTypeName;
            this.comment = comment;
        }

        public long getKGraphId() {
            return this.kGraphId;
        }

        public String getkGraphName() {
            return this.kGraphName;
        }

        public String getkGraphTypeName() {
            return this.kGraphTypeName;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

