/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace.tables;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.cspace.tables.AbstractCSpaceTableManager;
import com.streamscape.ds.schema.collection.cspace.tables.CSpaceSysTablesManager;
import com.streamscape.ds.schema.collection.cspace.tables.KGraphTableManager;
import com.streamscape.ds.schema.collection.cspace.tables.KNodeTableManager;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableUtil;
import com.streamscape.ds.schema.table.TableWorks;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KAssertionTableManager
extends AbstractCSpaceTableManager {
    public static String TABLE_NAME = "KASSERTIONS";
    private Statement createKAssertionStat;
    private Statement getKAssertionByNodesAndLink;
    private Statement removeKAssertionsForKGraph;
    private Statement getKAssertionsByKGraphIdStat;

    public KAssertionTableManager(CSpaceSysTablesManager manager) {
        super(manager, TABLE_NAME);
    }

    public void initialize(Session session) {
        Collection collection = (Collection)this.manager.getStore().schemaManager.findSchemaObject(this.getTableName(), this.manager.getCSpace().getObjectName().name, 4);
        if (collection == null) {
            NameManager.ObjectName tableName = this.manager.getStore().nameManager.newObjectName(this.getTableName(), false, 4);
            tableName.schema = this.manager.getCSpace().getObjectName();
            collection = new TableCollection(this.manager.getStore(), tableName, MemoryModel.PERSISTENT, 6);
            Table table = collection.getBaseTable();
            TableUtil.addIdentityColumn(table, "KASSERTION_ID", Type.SQL_INTEGER);
            TableUtil.addColumn(table, "KGRAPH_ID", Type.SQL_INTEGER, false);
            TableUtil.addColumn(table, "SUBJECT_KNODE_ID", Type.SQL_INTEGER, false);
            TableUtil.addColumn(table, "OBJECT_KNODE_ID", Type.SQL_INTEGER, false);
            TableUtil.addColumn(table, "KLINK_TYPE_NAME", Type.STRING, false);
            TableUtil.addColumn(table, "KLINK_FACETS", new OtherType("map", Map.class), false);
            NameManager.ObjectName primaryKeyName = NameManager.newInfoSchemaObjectName(tableName.name, tableName.isNameQuoted, 21);
            table.createPrimaryKeyConstraint(primaryKeyName, new int[]{table.getColumnIndex("KASSERTION_ID")}, true);
            table.setColumnStructures();
            collection.compile(session, null);
            this.manager.getStore().schemaManager.addSchemaObject(collection);
            if (table.getIndexList().length == 1) {
                TableWorks tableWorks = new TableWorks(session, table);
                NameManager.ObjectName subjectKNodeIdIndexName = this.manager.getStore().nameManager.newAutoName(table.getObjectName().name + "_SUBJECT_KNODE_ID_INDEX", table.getObjectName().schema, table.getObjectName(), 21);
                tableWorks.addIndex(new int[]{table.getColumnIndex("SUBJECT_KNODE_ID")}, subjectKNodeIdIndexName, false, null);
                NameManager.ObjectName objectKNodeIdIndexName = this.manager.getStore().nameManager.newAutoName(table.getObjectName().name + "_OBJECT_KNODE_ID_INDEX", table.getObjectName().schema, table.getObjectName(), 21);
                tableWorks.addIndex(new int[]{table.getColumnIndex("OBJECT_KNODE_ID")}, objectKNodeIdIndexName, false, null);
                NameManager.ObjectName kgraphIdIndexName = this.manager.getStore().nameManager.newAutoName(table.getObjectName().name + "_KGRAPH_ID_INDEX", table.getObjectName().schema, table.getObjectName(), 21);
                tableWorks.addIndex(new int[]{table.getColumnIndex("KGRAPH_ID")}, kgraphIdIndexName, false, null);
                NameManager.ObjectName assertionUniqueIndexName = this.manager.getStore().nameManager.newAutoName(table.getObjectName().name + "_SUBJECT_OBJECT_TYPE_UNIQUE", table.getObjectName().schema, table.getObjectName(), 21);
                tableWorks.addIndex(new int[]{table.getColumnIndex("KGRAPH_ID"), table.getColumnIndex("SUBJECT_KNODE_ID"), table.getColumnIndex("OBJECT_KNODE_ID"), table.getColumnIndex("KLINK_TYPE_NAME")}, assertionUniqueIndexName, true, null);
                Table kgraphsTable = (Table)this.manager.getStore().schemaManager.findSchemaObject(KGraphTableManager.TABLE_NAME, this.manager.getCSpace().getObjectName().name, 3);
                NameManager.ObjectName constraintName = this.manager.getStore().nameManager.newAutoName("FK_KASSERTION_KGRAPH_ID", table.getSchemaName(), table.getObjectName(), 6);
                OrderedHashSet refColSet = new OrderedHashSet();
                refColSet.add("KGRAPH_ID");
                OrderedHashSet mainColSet = new OrderedHashSet();
                mainColSet.add("KGRAPH_ID");
                Constraint constraint = new Constraint(constraintName, table.getObjectName(), refColSet, kgraphsTable.getObjectName(), mainColSet, 0, 0, 3, 59);
                constraint.core.mainTable = kgraphsTable;
                constraint.setColumnsIndexes(table);
                tableWorks.addForeignKey(constraint);
                kgraphsTable = (Table)this.manager.getStore().schemaManager.findSchemaObject(KNodeTableManager.TABLE_NAME, this.manager.getCSpace().getObjectName().name, 3);
                constraintName = this.manager.getStore().nameManager.newAutoName("FK_KASSERTION_SUBJECT_KNODE_ID", table.getSchemaName(), table.getObjectName(), 6);
                refColSet = new OrderedHashSet();
                refColSet.add("SUBJECT_KNODE_ID");
                mainColSet = new OrderedHashSet();
                mainColSet.add("KNODE_ID");
                constraint = new Constraint(constraintName, table.getObjectName(), refColSet, kgraphsTable.getObjectName(), mainColSet, 0, 0, 3, 59);
                constraint.core.mainTable = kgraphsTable;
                constraint.setColumnsIndexes(table);
                tableWorks.addForeignKey(constraint);
                kgraphsTable = (Table)this.manager.getStore().schemaManager.findSchemaObject(KNodeTableManager.TABLE_NAME, this.manager.getCSpace().getObjectName().name, 3);
                constraintName = this.manager.getStore().nameManager.newAutoName("FK_KASSERTION_OBJECT_KNODE_ID", table.getSchemaName(), table.getObjectName(), 6);
                refColSet = new OrderedHashSet();
                refColSet.add("OBJECT_KNODE_ID");
                mainColSet = new OrderedHashSet();
                mainColSet.add("KNODE_ID");
                constraint = new Constraint(constraintName, table.getObjectName(), refColSet, kgraphsTable.getObjectName(), mainColSet, 0, 0, 3, 59);
                constraint.core.mainTable = kgraphsTable;
                constraint.setColumnsIndexes(table);
                tableWorks.addForeignKey(constraint);
            }
        }
    }

    public synchronized void createKAssertion(Session session, Long kGraphId, long subjectKNodeId, long objectKNodeId, String kLinkTypeName, Map<String, Object> facets) {
        if (this.createKAssertionStat == null) {
            String SQL = "insert into " + this.getFullTableName() + "(  KGRAPH_ID,   SUBJECT_KNODE_ID,   OBJECT_KNODE_ID,   KLINK_TYPE_NAME,   KLINK_FACETS)values (?,?,?,?,?)";
            this.createKAssertionStat = session.compileStatement(SQL);
        }
        Result result = session.executeCompiledStatement(this.createKAssertionStat, new Object[]{kGraphId, subjectKNodeId, objectKNodeId, kLinkTypeName, facets});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to create KAssertion " + subjectKNodeId + "->" + kLinkTypeName + "->" + objectKNodeId + ".");
    }

    public synchronized KAssertionRow getKAssertionByNodesAndLink(Session session, long subjectKNodeId, long objectKNodeId, String typeName) {
        if (this.getKAssertionByNodesAndLink == null) {
            this.getKAssertionByNodesAndLink = session.compileStatement("select KASSERTION_ID, KGRAPH_ID,SUBJECT_KNODE_ID,OBJECT_KNODE_ID,KLINK_TYPE_NAME,KLINK_FACETS from " + this.getFullTableName() + " where SUBJECT_KNODE_ID = ? && OBJECT_KNODE_ID = ? && KLINK_TYPE_NAME = ?");
        }
        Result result = session.executeCompiledStatement(this.getKAssertionByNodesAndLink, new Object[]{subjectKNodeId, objectKNodeId, typeName});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to get KAssertion " + subjectKNodeId + "->" + typeName + "->" + objectKNodeId + ".");
        RowSetNavigator navigator = result.navigator;
        if (navigator.next()) {
            return new KAssertionRow(((Number)navigator.getCurrent(0)).longValue(), ((Number)navigator.getCurrent(1)).longValue(), ((Number)navigator.getCurrent(2)).longValue(), ((Number)navigator.getCurrent(3)).longValue(), (String)navigator.getCurrent(4), (Map)OtherTypeWrapper.unwrap(navigator.getCurrent(5)));
        }
        return null;
    }

    public synchronized List<KAssertionRow> getKAssertionsByGraphId(Session session, long kGraphId) {
        if (this.getKAssertionsByKGraphIdStat == null) {
            this.getKAssertionsByKGraphIdStat = session.compileStatement("select KASSERTION_ID, KGRAPH_ID,SUBJECT_KNODE_ID,OBJECT_KNODE_ID,KLINK_TYPE_NAME,KLINK_FACETS from " + this.getFullTableName() + " where KGRAPH_ID = ?");
        }
        Result result = session.executeCompiledStatement(this.getKAssertionsByKGraphIdStat, new Object[]{kGraphId});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to get KAssertions for kgraph " + kGraphId + ".");
        ArrayList<KAssertionRow> kAssertions = new ArrayList<KAssertionRow>();
        RowSetNavigator navigator = result.navigator;
        while (navigator.next()) {
            kAssertions.add(new KAssertionRow(((Number)navigator.getCurrent(0)).longValue(), ((Number)navigator.getCurrent(1)).longValue(), ((Number)navigator.getCurrent(2)).longValue(), ((Number)navigator.getCurrent(3)).longValue(), (String)navigator.getCurrent(4), (Map)OtherTypeWrapper.unwrap(navigator.getCurrent(5))));
        }
        return kAssertions;
    }

    public synchronized void deleteKAssertionsByKGraphId(Session session, long kGraphId) {
        if (this.removeKAssertionsForKGraph == null) {
            this.removeKAssertionsForKGraph = session.compileStatement("delete from " + this.getFullTableName() + " where KGRAPH_ID = ?");
        }
        Result result = session.executeCompiledStatement(this.removeKAssertionsForKGraph, new Object[]{kGraphId});
        CSpaceSysTablesManager.checkResultNotError(result, "Unable to remove KAssertions for graph " + kGraphId + ".");
    }

    public void reset() {
        this.createKAssertionStat = null;
        this.getKAssertionByNodesAndLink = null;
        this.removeKAssertionsForKGraph = null;
        this.getKAssertionsByKGraphIdStat = null;
    }

    public static class KAssertionRow {
        private long kAssertionId;
        private long kGraphId;
        private long subjectKNodeId;
        private long objectKNodeId;
        private String typeName;
        private Map<String, Object> facets;

        public KAssertionRow(long kAssertionId, long kGraphId, long subjectKNodeId, long objectKNodeId, String typeName, Map<String, Object> facets) {
            this.kAssertionId = kAssertionId;
            this.kGraphId = kGraphId;
            this.subjectKNodeId = subjectKNodeId;
            this.objectKNodeId = objectKNodeId;
            this.typeName = typeName;
            this.facets = facets;
        }

        public long getkAssertionId() {
            return this.kAssertionId;
        }

        public long getkGraphId() {
            return this.kGraphId;
        }

        public long getSubjectKNodeId() {
            return this.subjectKNodeId;
        }

        public long getObjectKNodeId() {
            return this.objectKNodeId;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Map<String, Object> getFacets() {
            return this.facets;
        }
    }
}

