/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace.tables;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.cspace.CSpace;
import com.streamscape.ds.schema.collection.cspace.instances.KAssertion;
import com.streamscape.ds.schema.collection.cspace.instances.KGraph;
import com.streamscape.ds.schema.collection.cspace.instances.KNode;
import com.streamscape.ds.schema.collection.cspace.tables.KAssertionTableManager;
import com.streamscape.ds.schema.collection.cspace.tables.KGraphTableManager;
import com.streamscape.ds.schema.collection.cspace.tables.KNodeTableManager;
import com.streamscape.ds.session.Session;
import java.util.HashMap;

public class CSpaceSysTablesManager {
    private DataspaceStore store;
    private CSpace cspace;
    private KGraphTableManager kGraphTableManager;
    private KNodeTableManager kNodeTableManager;
    private KAssertionTableManager kAssertionTableManager;

    public CSpaceSysTablesManager(DataspaceStore store, CSpace cspace) {
        this.store = store;
        this.cspace = cspace;
        this.kGraphTableManager = new KGraphTableManager(this);
        this.kNodeTableManager = new KNodeTableManager(this);
        this.kAssertionTableManager = new KAssertionTableManager(this);
    }

    public synchronized void initialize(Session session) {
        this.kGraphTableManager.initialize(session);
        this.kNodeTableManager.initialize(session);
        this.kAssertionTableManager.initialize(session);
    }

    public KGraphTableManager getKGraphTableManager() {
        return this.kGraphTableManager;
    }

    public KNodeTableManager getKNodeTableManager() {
        return this.kNodeTableManager;
    }

    public KAssertionTableManager getKAssertionTableManager() {
        return this.kAssertionTableManager;
    }

    public String getCSpaceName() {
        return this.cspace.getName();
    }

    public DataspaceStore getStore() {
        return this.store;
    }

    public CSpace getCSpace() {
        return this.cspace;
    }

    public void reset() {
        this.kGraphTableManager.reset();
        this.kNodeTableManager.reset();
        this.kAssertionTableManager.reset();
    }

    public static void checkResultNotError(Result result, String message) {
        if (result.isError()) {
            DataspaceException exception = new DataspaceException(result);
            Trace.logError(CSpaceSysTablesManager.class, message + " " + exception.toString());
            throw new DataspaceException(message + ": " + exception.toString());
        }
    }

    public void deleteKGraph(Session session, String name) {
        this.getKGraphTableManager().deleteKGraph(session, name);
    }

    public void createKGraph(Session session, KGraph kgraph) {
        long kgraphId = this.getKGraphTableManager().createKGraph(session, kgraph.getName(), kgraph.getTypeName(), kgraph.getComment());
        HashMap<String, Long> kNodeIds = new HashMap<String, Long>();
        for (KNode knode : kgraph.getNodes()) {
            long kNodeId = this.getKNodeTableManager().createKNode(session, kgraphId, knode.getTypeName(), knode.getSubjectKey(), knode.getFacets());
            kNodeIds.put(knode.getCompositeKey(), kNodeId);
        }
        for (KAssertion kAssertion : kgraph.getAssertions()) {
            this.getKAssertionTableManager().createKAssertion(session, kgraphId, (Long)kNodeIds.get(kAssertion.getSubjectCompositeKey()), (Long)kNodeIds.get(kAssertion.getObjectCompositeKey()), kAssertion.getLink().getTypeName(), kAssertion.getLink().getFacets());
        }
    }
}

