/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace.instances;

import com.streamscape.ds.stable.rplmethod.RPLMethod;
import java.util.HashMap;
import java.util.Map;

public class KNode {
    private String typeName;
    private String subjectKeyAlias;
    private Map<String, Object> facets;

    @RPLMethod(description="Create new KNode with specified type.")
    public static KNode create(String typeName, String subjectKeyAlias, Map<String, Object> facets) {
        return new KNode(typeName, subjectKeyAlias, facets);
    }

    public KNode(String typeName, String subjectKeyAlias, Map<String, Object> facets) {
        this.typeName = typeName;
        this.subjectKeyAlias = subjectKeyAlias;
        this.facets = facets != null ? new HashMap<String, Object>(facets) : new HashMap();
    }

    public KNode() {
        this.facets = new HashMap<String, Object>();
    }

    public KNode(KNode kNode) {
        this.typeName = kNode.typeName;
        this.subjectKeyAlias = kNode.subjectKeyAlias;
        this.facets = new HashMap<String, Object>(kNode.getFacets());
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getSubjectKeyAlias() {
        return this.subjectKeyAlias;
    }

    public String getSubjectKey() {
        return (String)this.facets.get(this.subjectKeyAlias);
    }

    public KNode setSubjectKey(String subjectKey) {
        this.facets.put(this.subjectKeyAlias, subjectKey);
        return this;
    }

    public Map<String, Object> getFacets() {
        return this.facets;
    }

    @RPLMethod(description="Sets facet with specified name.")
    public KNode setFacet(String name, Object value) {
        this.facets.put(name, value);
        return this;
    }

    @RPLMethod(description="Replaces facets with specified facets.")
    public KNode setFacets(Map<String, Object> facets) {
        this.facets = facets;
        return this;
    }

    @RPLMethod(description="Adds specified facets.")
    public KNode addFacets(Map<String, Object> facets) {
        this.facets.putAll(facets);
        return this;
    }

    public String getCompositeKey() {
        return this.typeName + ":" + this.getSubjectKey();
    }
}

