/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.schema.collection.cspace.instances;

import com.streamscape.ds.schema.collection.cspace.KGraphJsonSerializer;
import com.streamscape.ds.schema.collection.cspace.instances.KAssertion;
import com.streamscape.ds.schema.collection.cspace.instances.KGraphException;
import com.streamscape.ds.schema.collection.cspace.instances.KGroup;
import com.streamscape.ds.schema.collection.cspace.instances.KLink;
import com.streamscape.ds.schema.collection.cspace.instances.KNode;
import com.streamscape.ds.stable.rplmethod.RPLMethod;
import com.streamscape.ds.stable.rplmethod.RPLMethodHidden;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class KGraph {
    private String typeName;
    private String name;
    private String comment;
    private Map<String, Object> facets;
    private List<KNode> nodes;
    private List<KAssertion> assertions;
    private Map<String, KGroup> groups;

    @RPLMethod(description="Create new KGraph.")
    public static KGraph create(String typeName, String name, String comment, Map<String, Object> facets, List<KNode> nodes, List<KAssertion> assertions) {
        return new KGraph(typeName, name, comment, facets, nodes, assertions);
    }

    public KGraph() {
        this.facets = new HashMap<String, Object>();
        this.nodes = new ArrayList<KNode>();
        this.assertions = new ArrayList<KAssertion>();
        this.groups = new HashMap<String, KGroup>();
    }

    public KGraph(String typeName, String name, String comment, Map<String, Object> facets, List<KNode> nodes, List<KAssertion> assertions) {
        this.typeName = typeName;
        this.name = name;
        this.comment = comment;
        this.facets = facets != null ? facets : new HashMap();
        this.nodes = nodes;
        this.assertions = assertions;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getName() {
        return this.name;
    }

    public KGraph setName(String name) {
        this.name = name;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public KGraph setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Map<String, Object> getFacets() {
        return this.facets;
    }

    @RPLMethod(description="Sets facet with specified name.")
    public KGraph setFacet(String name, Object value) {
        this.facets.put(name, value);
        return this;
    }

    @RPLMethod(description="Replaces facets with specified facets.")
    public KGraph setFacets(Map<String, Object> facets) {
        this.facets.putAll(facets);
        return this;
    }

    @RPLMethod(description="Adds specified facets.")
    public KGraph addFacets(Map<String, Object> facets) {
        this.facets.putAll(facets);
        return this;
    }

    public List<KNode> getNodes() {
        return this.nodes;
    }

    public Set<String> getNodeCompositeKeys() {
        return this.nodes.stream().map(n -> n.getCompositeKey()).collect(Collectors.toSet());
    }

    public KNode getNode(String compositeKey) {
        return this.nodes.stream().filter(o -> o.getCompositeKey().equals(compositeKey)).findFirst().orElse(null);
    }

    @RPLMethod(description="Adds KNode to the graph. KNode schema should be allowed in KGraph schema.")
    public KGraph addNode(KNode node) {
        this.nodes.add(node);
        return this;
    }

    @RPLMethod(description="Removes node if there is no links to or from this node. Throws exception otherwise.")
    public void removeNode(String compositeKey) {
        if (this.assertions.stream().anyMatch(t -> t.getSubjectCompositeKey().equals(compositeKey))) {
            throw new KGraphException("Cannot remove node " + compositeKey + " because it has links from this node.");
        }
        if (this.assertions.stream().anyMatch(t -> t.getObjectCompositeKey().equals(compositeKey))) {
            throw new KGraphException("Cannot remove node " + compositeKey + " because it has links to this node.");
        }
        this.nodes.removeIf(n -> n.getCompositeKey().equals(compositeKey));
    }

    @RPLMethod(description="Removes node and in and out links.")
    public void removeNodeAndLinks(String subjectCompositeKey) {
        this.assertions.removeIf(t -> t.getSubjectCompositeKey().equals(subjectCompositeKey));
        this.assertions.removeIf(t -> t.getObjectCompositeKey().equals(subjectCompositeKey));
        this.nodes.remove(subjectCompositeKey);
    }

    @RPLMethod(description="Create assertion from subjectCompositeKey to objectKey with specified link.")
    public KAssertion addAssertion(String subjectCompositeKey, KLink link, String objectCompositeKey) {
        this.assertNodeExists(subjectCompositeKey);
        this.assertNodeExists(objectCompositeKey);
        KAssertion existingAssertion = this.getAssertion(subjectCompositeKey, objectCompositeKey);
        if (existingAssertion != null) {
            throw new KGraphException("Assertion " + subjectCompositeKey + " - " + objectCompositeKey + " already exists.");
        }
        KAssertion assertion = new KAssertion(subjectCompositeKey, link, objectCompositeKey);
        this.assertions.add(assertion);
        return assertion;
    }

    @RPLMethod(description="Create assertion from subjectCompositeKey to objectKey with specified link.")
    public KAssertion addAssertion(String subjectCompositeKey, String kLinkType, String objectCompositeKey) {
        return this.addAssertion(subjectCompositeKey, new KLink(kLinkType, new HashMap<String, Object>()), objectCompositeKey);
    }

    @RPLMethod(description="Removes assertion between nodes.")
    public boolean removeAssertion(String subjectCompositeKey, String objectCompositeKey) {
        return this.assertions.removeIf(assertion -> assertion.getSubjectCompositeKey().equals(subjectCompositeKey) && assertion.getObjectCompositeKey().equals(objectCompositeKey));
    }

    public boolean hasAssertion(String subjectCompositeKey, String objectCompositeKey) {
        return this.assertions.stream().anyMatch(assertion -> assertion.getSubjectCompositeKey().equals(subjectCompositeKey) && assertion.getObjectCompositeKey().equals(objectCompositeKey));
    }

    @RPLMethod(description="Returns assertion between two nodes. If no assertion exists, returns null.")
    public KAssertion getAssertion(String subjectCompositeKey, String objectCompositeKey) {
        return this.assertions.stream().filter(assertion -> assertion.getSubjectCompositeKey().equals(subjectCompositeKey) && assertion.getObjectCompositeKey().equals(objectCompositeKey)).findAny().orElse(null);
    }

    @RPLMethod(description="Returns link between two nodes. If no link exists, returns null.")
    public KLink getLink(String subjectCompositeKey, String objectCompositeKey) {
        KAssertion assertion = this.getAssertion(subjectCompositeKey, objectCompositeKey);
        return assertion != null ? assertion.getLink() : null;
    }

    @RPLMethod(description="Returns all assertion from node with specified name.")
    public List<KAssertion> getAssertionsFrom(String subjectCompositeKey) {
        return this.assertions.stream().filter(assertion -> assertion.getSubjectCompositeKey().equals(subjectCompositeKey)).collect(Collectors.toList());
    }

    @RPLMethod(description="Returns all assertion to node with specified name.")
    public List<KAssertion> getAssertionsTo(String objectCompositeKey) {
        return this.assertions.stream().filter(assertion -> assertion.getObjectCompositeKey().equals(objectCompositeKey)).collect(Collectors.toList());
    }

    @RPLMethod(description="Returns KGraph under the node with specified name.")
    public KGraph getKGraphUnder(String subjectCompositeKey) {
        return this.getKGraphUnder(subjectCompositeKey, 0);
    }

    @RPLMethod(description="Returns KGraph of specified depth under the node with specified name.")
    public KGraph getKGraphUnder(String subjectCompositeKey, int depth) {
        if (depth <= 0) {
            depth = Integer.MAX_VALUE;
        }
        this.assertNodeExists(subjectCompositeKey);
        KGraph subGraph = new KGraph();
        subGraph.setName(this.name + " under " + subjectCompositeKey);
        subGraph.getFacets().putAll(new HashMap<String, Object>(this.facets));
        this.addNodesUnder(subGraph, subjectCompositeKey, new HashSet<String>(), depth);
        HashSet nodesSet = new HashSet();
        subGraph.assertions.stream().forEach(assertion -> nodesSet.add(assertion.getSubjectCompositeKey()));
        subGraph.assertions.stream().forEach(assertion -> nodesSet.add(assertion.getObjectCompositeKey()));
        nodesSet.forEach(nodeCompositeKey -> subGraph.addNode(new KNode(this.getNode((String)nodeCompositeKey))));
        this.groups.values().forEach(group -> {
            KGroup subGroup = KGroup.create(group.getTypeName(), group.getSubjectKey(), group.getFacets(), group.getNodes().stream().filter(nodesSet::contains).collect(Collectors.toList()));
            if (!subGroup.getNodes().isEmpty()) {
                subGraph.addGroup(subGroup);
            }
        });
        return subGraph;
    }

    @RPLMethod(description="Returns all assertions.")
    public List<KAssertion> getAssertions() {
        return this.assertions;
    }

    @RPLMethod(description="Returns all groups.")
    public Map<String, KGroup> getGroups() {
        return this.groups;
    }

    @RPLMethod(description="Adds group.")
    public void addGroup(KGroup group) {
        if (this.groups == null) {
            this.groups = new HashMap<String, KGroup>();
        }
        this.groups.put(group.getSubjectKey(), group);
    }

    public KGroup getGroupByKey(String key) {
        return this.groups != null ? this.groups.get(key) : null;
    }

    public void removeGroup(String subjectKey) {
        if (this.groups != null) {
            this.groups.remove(subjectKey);
        }
    }

    private void addNodesUnder(KGraph subGraph, String subjectCompositeKey, Set<String> visitedNodes, int depth) {
        if (visitedNodes.contains(subjectCompositeKey)) {
            return;
        }
        visitedNodes.add(subjectCompositeKey);
        subGraph.addNode(new KNode(this.getNode(subjectCompositeKey)));
        if (depth <= 0) {
            return;
        }
        List<KAssertion> assertionsFrom = this.getAssertionsFrom(subjectCompositeKey);
        for (KAssertion assertion : assertionsFrom) {
            subGraph.assertions.add(new KAssertion(assertion));
            this.addNodesUnder(subGraph, assertion.getObjectCompositeKey(), visitedNodes, depth - 1);
        }
    }

    void assertNodeExists(String compositeKey) {
        if (this.getNode(compositeKey) == null) {
            throw new KGraphException("Node " + compositeKey + " doesn't exist");
        }
    }

    public String toJSON() {
        return KGraphJsonSerializer.toJSON(this);
    }

    @RPLMethodHidden
    public static KGraph fromJSON(String json) {
        return KGraphJsonSerializer.fromJSON(KGraph.class, json);
    }

    @RPLMethodHidden
    public static KGraph fromJSON(InputStream inputStream) {
        return KGraphJsonSerializer.fromJSON(KGraph.class, inputStream);
    }
}

